% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_data.R
\name{group_rows}
\alias{group_rows}
\alias{group_data}
\title{Grouping data}
\usage{
group_rows(.data)

group_data(.data)
}
\arguments{
\item{.data}{a tibble}
}
\value{
\code{group_data()} return a tibble with one row per group. The last column, always called \code{.rows}
is a list of integer vectors indicating the rows for each group.
If \code{.data} is a grouped data frame the first columns are the grouping variables.
\code{group_rows()} just returns the list of indices.
}
\description{
Grouping data
}
\examples{
df <- tibble(x = c(1,1,2,2))

# one row
group_data(df)
group_rows(df)

# 2 rows, one for each group
group_by(df,x) \%>\% group_data()
group_by(df,x) \%>\% group_rows()

}
\seealso{
Other grouping functions: \code{\link{group_by_all}},
  \code{\link{group_by}}, \code{\link{group_indices}},
  \code{\link{group_keys}}, \code{\link{group_map}},
  \code{\link{group_nest}}, \code{\link{group_size}},
  \code{\link{group_trim}}, \code{\link{groups}}
}
\concept{grouping functions}
