% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{categorical_pal}
\alias{categorical_pal}
\title{Palette for categories}
\usage{
categorical_pal(n)
}
\arguments{
\item{n}{The number of colors in the palette. We simply take the first
\code{n} colors from the total 8.}
}
\value{
A character vector of RGB color codes.
}
\description{
This is a color blind friendly palette from
\url{http://jfly.iam.u-tokyo.ac.jp/color}. It has 8 colors.
}
\details{
This is the suggested palette for visualizations where vertex colors
mark categories, e.g. community membership.
}
\examples{
\dontrun{
library(igraphdata)
data(karate)
karate <- karate \%>\%
  add_layout_(with_fr()) \%>\%
  set_vertex_attr("size", value = 10)

cl_k <- cluster_optimal(karate)

V(karate)$color <- membership(cl_k)
karate$palette <- categorical_pal(length(cl_k))
plot(karate)
}
}
\seealso{
Other palettes: \code{\link{diverging_pal}},
  \code{\link{r_pal}}, \code{\link{sequential_pal}}
}
