% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{unlist_with_sep}
\alias{unlist_with_sep}
\title{Flattens All List Levels Using Separated Names}
\usage{
unlist_with_sep(x, sep = "/", use.names = TRUE, depth = Inf)
}
\arguments{
\item{x}{a list object, usually containing other lists -- of lists.}

\item{sep}{character string used to separate each component of the final element names.}

\item{use.names}{logical that indicates if the original names of each the sucessive
nested list elements should be used to build the final names of the result list.}

\item{depth}{maximum number of levels to unlist.
Root level is \code{1L}.}
}
\value{
a vector of the same type as the inner vector elements of the input list.
}
\description{
Flattens All List Levels Using Separated Names
}
\examples{

x <- list(X = list(a = 1
                   , b = list(b.1 = 2
                              , b.2 = list(b.2.1 = 4, b.2.2 = data.frame())
                              , b.3 = 3)
                   , c = matrix()))
unlist_with_sep(x)
unlist_with_sep(x, '###')

}
