% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sir.R
\name{sir_exp}
\alias{sir_exp}
\alias{sir_lex}
\alias{sir_ag}
\title{Calculate SMR}
\usage{
sir_exp(
  x,
  obs,
  exp,
  pyrs = NULL,
  print = NULL,
  conf.type = "profile",
  test.type = "homogeneity",
  conf.level = 0.95,
  subset = NULL
)

sir_lex(x, print = NULL, breaks = NULL, ...)

sir_ag(
  x,
  obs = "from0to1",
  print = attr(x, "aggre.meta")$by,
  exp = "d.exp",
  pyrs = "pyrs",
  ...
)
}
\arguments{
\item{x}{Data set e.g. \code{aggre} or \code{Lexis} object 
(see: \code{\link{lexpand}})}

\item{obs}{Variable name of the observed cases in the data set}

\item{exp}{Variable name or expression for expected cases}

\item{pyrs}{Variable name for person-years (optional)}

\item{print}{Variables or expression to stratify the results}

\item{conf.type}{select confidence interval type: (default=) `profile`, `wald`, `univariate`}

\item{test.type}{Test for equal SIRs. Test available are 'homogeneity' and 'trend'}

\item{conf.level}{Level of type-I error in confidence intervals, default 0.05 is 95\% CI}

\item{subset}{a logical vector for subsetting data}

\item{breaks}{a named list to split age group (age), period (per) or follow-up (fot).}

\item{...}{pass arguments to \code{sir_exp}}
}
\value{
A sir object
}
\description{
Calculate Standardized Mortality Ratios (SMRs) using 
a single data set that includes
observed and expected cases and additionally person-years.

\code{sir_lex} solves SMR from a \code{\link{Lexis}} object 
calculated with \code{lexpand}.

\code{sir_ag} solves SMR from a \code{\link{aggre}} object 
calculated using \code{\link{lexpand}}.
}
\details{
These functions are intended to calculate SMRs from a single data set 
that includes both observed and expected number of cases. For example utilizing the
argument \code{pop.haz} of the \code{\link{lexpand}}.

\code{sir_lex} automatically exports the transition \code{fromXtoY} using the first
state in \code{lex.Str} as \code{0} and all other as \code{1}. No missing values
is allowed in observed, pop.haz or person-years.
}
\section{Functions}{
\itemize{
\item \code{sir_lex()}: 

\item \code{sir_ag()}: 

}}
\examples{

\donttest{
BL <- list(fot = 0:5, per = c("2003-01-01","2008-01-01", "2013-01-01"))

## Aggregated data
x1 <- lexpand(sire, breaks = BL, status = status != 0, 
              birth = bi_date, entry = dg_date, exit = ex_date,
              pophaz=popmort,
              aggre=list(sex, period = per, surv.int = fot))
sir_ag(x1, print = 'period')


# no aggreate or breaks
x2 <- lexpand(sire, status = status != 0, 
              birth = bi_date, entry = dg_date, exit = ex_date,
              pophaz=popmort)
sir_lex(x2, breaks = BL, print = 'per')
}

}
\seealso{
\code{\link{lexpand}}
\href{../doc/sir.html}{A SIR calculation vignette}

Other sir functions: 
\code{\link{lines.sirspline}()},
\code{\link{plot.sirspline}()},
\code{\link{sir}()},
\code{\link{sir_ratio}()},
\code{\link{sirspline}()}
}
\author{
Matti Rantanen
}
\concept{sir functions}
