% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tclass.R
\name{tclass}
\alias{tclass}
\alias{tclass.default}
\alias{tclass.xts}
\alias{tclass<-}
\alias{tclass<-.default}
\alias{indexClass}
\alias{indexClass<-}
\alias{tclass<-.xts}
\title{Get or Replace the Class of an xts Object's Index}
\usage{
tclass(x, ...)

\method{tclass}{default}(x, ...)

\method{tclass}{xts}(x, ...)

tclass(x) <- value

\method{tclass}{default}(x) <- value

indexClass(x)

indexClass(x) <- value

\method{tclass}{xts}(x) <- value
}
\arguments{
\item{x}{An xts object.}

\item{\dots}{Arguments passed to other methods.}

\item{value}{The new index class (see Details for valid values).}
}
\value{
A vector containing the class of the object's index.
}
\description{
Generic functions to get or replace the class of an xts object's index.
}
\details{
Internally, an xts object's index is a \emph{numeric} value corresponding to
seconds since the epoch in the UTC timezone. The index class is stored as
the \code{tclass} attribute on the internal index. This is used to convert
the internal index values to the desired class when the \code{index}
function is called.

The \code{tclass} function retrieves the class of the internal index, and
the \verb{tclass<-} function sets it. The specified value for
\verb{tclass<-} must be one of the following character strings:
\code{"Date"}, \code{"POSIXct"}, \code{"chron"}, \code{"yearmon"},
\code{"yearqtr"}, or \code{"timeDate"}.
}
\note{
Both \code{indexClass} and \verb{indexClass<-} are deprecated in favor
of \code{tclass} and \verb{tclass<-}, respectively.

Replacing the \code{tclass} can \emph{potentially change} the values of the internal
index. For example, changing the 'tclass' from POSIXct to Date will
truncate the POSIXct value and convert the timezone to UTC (since the Date
class doesn't have a timezone). See the examples.
}
\examples{

x <- timeBasedSeq('2010-01-01/2010-01-02 12:00')
x <- xts(seq_along(x), x)

y <- timeBasedSeq('2010-01-01/2010-01-03 12:00/H')
y <- xts(seq_along(y), y, tzone = "America/New_York")

# Changing the tclass *changes* the internal index values
head(y)          # the index has times
head(.index(y))
tclass(y) <- "Date"
head(y)          # the index prints as a Date
head(.index(y))  # the internal index is truncated

}
\seealso{
\code{\link[=index]{index()}} has more information on the xts index, \code{\link[=tformat]{tformat()}}
details how the index values are formatted when printed, and \code{\link[=tzone]{tzone()}}
has more information about the index timezone settings.

The following help pages describe the characteristics of the valid index
classes: \code{\link[=POSIXct]{POSIXct()}}, \code{\link[=Date]{Date()}}, \link[chron:chron]{chron()},
\code{\link[zoo:zoo]{yearmon()}}, \code{\link[zoo:zoo]{yearqtr()}},
\code{\link[timeDate:timeDate]{timeDate()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{ts}
\keyword{utilities}
