% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{zip_process}
\alias{zip_process}
\title{Class for an external zip process}
\usage{
zip_process()
}
\value{
A \code{zip_process} R6 class object, a subclass of
\link[processx:process]{processx::process}.
}
\description{
\code{zip_process()} returns an R6 class that represents a zip process.
It is implemented as a subclass of \link[processx:process]{processx::process}.
}
\section{Using the \code{zip_process} class}{
\preformatted{zp <- zip_process()$new(zipfile, files, recurse = TRUE,
                         poll_connection = TRUE,
                         stderr = tempfile(), ...)
}

See \link[processx:process]{processx::process} for the class methods.

Arguments:
\itemize{
\item \code{zipfile}: Path to the zip file to create.
\item \code{files}: List of file to add to the archive. Each specified file
or directory in is created as a top-level entry in the zip archive.
\item \code{recurse}: Whether to add the contents of directories recursively.
\item \code{include_directories}: Whether to explicitly include directories
in the archive. Including directories might confuse MS Office when
reading docx files, so set this to \code{FALSE} for creating them.
\item \code{poll_connection}: passed to the \code{initialize} method of
\link[processx:process]{processx::process}, it allows using \code{\link[processx:poll]{processx::poll()}} or the
\code{poll_io()} method to poll for the completion of the process.
\item \code{stderr}: passed to the \code{initialize} method of \link[processx:process]{processx::process},
by default the standard error is written to a temporary file.
This file can be used to diagnose errors if the process failed.
\item \code{...} passed to the \code{initialize} method of \link[processx:process]{processx::process}.
}
}

\examples{
dir.create(tmp <- tempfile())
write.table(iris, file = file.path(tmp, "iris.ssv"))
zipfile <- tempfile(fileext = ".zip")
zp <- zip_process()$new(zipfile, tmp)
zp$wait()
zp$get_exit_status()
zip_list(zipfile)
}
