# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from ZigbeeDevice.idl.

use strict;

package Raritan::RPC::zigbee::ZigbeeDevice;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "zigbee.ZigbeeDevice:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::zigbee::ZigbeeDevice::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant CLUSTER_BASIC => 0x0;

use constant CLUSTER_POWER_CONFIGURATION => 0x1;

use constant CLUSTER_RSSI => 0xb;

use constant CLUSTER_CONTACT_CLOSURE => 0xf;

use constant CLUSTER_TEMPERATURE => 0x402;

use constant CLUSTER_HUMIDITY => 0x405;

use Raritan::RPC::zigbee::ZigbeeDevice::MetaData;

sub getMetaData($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getMetaData', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::zigbee::ZigbeeDevice::MetaData::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::zigbee::ZigbeeDevice::ClusterValue;

sub getClusterValues($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getClusterValues', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::zigbee::ZigbeeDevice::ClusterValue::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('zigbee.ZigbeeDevice', 1, 0, 0, 'Raritan::RPC::zigbee::ZigbeeDevice');
1;
