#ifndef _RHEO_GEO_VISU_H
#define _RHEO_GEO_VISU_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// geo visualisation main procedure
//
// authors:
//    	Pierre.Saramito@imag.fr
//
// date: 12 may 1997; update 26 january 2006
//
#include "rheolef/iorheo.h"
namespace rheolef { 

// ======================================================================
// geo visu members
// ======================================================================
class geo_visu_option_type {
public:

     geo_visu_option_type (std::ostream& s);
     void dump (std::ostream& os = std::cerr) const;
  
// data:

     iorheo::flag_type format;

     bool execute;
     bool clean;
     bool verbose;

     std::string basename;
     
     bool color;
     bool gray;
     bool black_and_white;
     bool stereo;
     bool fill;
     bool shrink;
     bool tube;
     bool ball;
     bool full;
     bool cut;
     bool split;
     bool lattice;

     point origin;
     point normal;
};
}// namespace rheolef
#endif // _RHEO_GEO_VISU_H
