#ifndef _SKIT_BLAS1_SPARSE_NO_TMPL_H
#define _SKIT_BLAS1_SPARSE_NO_TMPL_H
//
// sparse vectors
// blas 1 expressions without template expression
//
// author: Pierre.Saramito@imag.fr
//
// date: 11 march 1997
//
# include "avec.h"
# include "blas-algorithm.h"
namespace rheolef { 

// unary operators
template <class T>
inline
avec<T>
operator + (const avec<T>& sx)
{
    return sx;
}   
template <class T>
inline
avec<T>
operator - (const avec<T>& sx)
{
    avec<T> sz(sx.n());
    szassignopsx (sz, std::negate<T>(), sx.begin(), sx.end());
    return sz;
}
// unary functions: only f such that f(0) = 0 !


// binary operators + and -
template<class T>
inline
avec<T>
operator + (const avec<T>& sx, const avec<T>& sy)
{
    check_length(sx,sy);
    avec<T> sz(sx.n());
    sxaddopsy_ (sz, add_op<T, T, T>(), sx.begin(), sx.end(), sy.begin(), sy.end());
    return sz;
}
template<class T>
inline
avec<T>
operator - (const avec<T>& sx, const avec<T>& sy)
{
    check_length(sx,sy);
    avec<T> sz(sx.n());
    sxaddopsy_ (sz, sub_op<T, T, T>(), sx.begin(), sx.end(), sy.begin(), sy.end());
    return sz;
}

// binary operators * and /
template<class T>
inline
avec<T>
operator * (const avec<T>& sx, const avec<T>& sy)
{
    check_length(sx,sy);
    avec<T> sz(sx.n());
    sxmulsy (sz, sx.begin(), sx.end(), sy.begin(), sy.end());
    return sz;
}
template<class T>
inline
avec<T>
operator *= (avec<T>& sz, const avec<T>& sx)
{
    check_length(sz, sx);
    szmulassignsx (sz, sx.begin(), sx.end());
    return sz;
}
template<class T>
inline
avec<T>
operator * (const avec<T>& sx, const T& lambda)
{
    avec<T> sz(sx.n());
    szassignopsx (sz, my_bind2nd(mul_op<T, T, T>(), lambda), sx.begin(), sx.end());
    return sz;
}
template<class T>
inline
avec<T>
operator * (const T& lambda, const avec<T>& sy)
{
    avec<T> sz(sy.n());
    szassignopsx (sz, my_bind1st(mul_op<T, T, T>(), lambda), sy.begin(), sy.end());
    return sz;
}
#ifdef TODO /* sx *= lambda; sx /= lambda;  */
template<class T>
inline
avec<T>
operator *= (avec<T>& sz, const & lambda)
{
    szopassignr (sz.begin(), sz.end(), lambda, mul_assign<T,>());
    return sz;
}
#endif // TODO

template<class T>
inline
avec<T>
operator / (const avec<T>& sx, const T& lambda)
{
    avec<T> sz(sx.n());
    szassignopsx (sz, my_bind2nd(div_op<T, T, T>(), lambda), sx.begin(), sx.end());
    return sz;
}
template<class T>
inline
avec<T>
operator / (const T& lambda, const avec<T>& sy)
{
    avec<T> sz(sy.n());
    szassignopsx (sz, my_bind1st(div_op<T, T, T>(), lambda), sy.begin(), sy.end());
    return sz;
}
#ifdef TODO /* sx *= lambda; sx /= lambda;  */
template<class T>
inline
avec<T>
operator /= (avec<T>& sz, const & lambda)
{
    szopassignr (sz.begin(), sz.end(), lambda, div_assign<T,>());
    return sz;
}
#endif // TODO


}// namespace rheolef
#endif // _SKIT_BLAS1_SPARSE_NO_TMPL_H
