//ff_plain.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2014
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "rpld.h"

int ff_plain_pl_export(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl) {
 struct rpld_playlist_entry * cur = rpld_pl_get_first(pl);
 const char * file;

 (void)handle;

 while ( cur != NULL ) {
  file = rpld_ple_get_filename(cur, -1, NULL);
  if ( file )
   roar_vio_printf(vio, "%s\n", file);
  cur = cur->list.next;
 }

 return 0;
}

int ff_plain_pl_import(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl) {
 struct rpld_playlist_entry * plent;
 char buf[1024];
 char * s;
 size_t len;

 (void)handle;

 ROAR_DBG("ff_plain_pl_import(handle=%p, vio=%p, pl=%p) = ?", handle, vio, pl);

 while ((s = roar_vio_fgets(vio, buf, 1024)) != NULL ) {
  len = strlen(s);

  for (s += len - 1; *s == '\r' || *s == '\n'; s--)
   *s = 0;

  if ( !*buf )
   continue;

  ROAR_DBG("ff_plain_pl_import(*): s='%s'", buf);

  if ( (plent = rpld_ple_new()) == NULL )
   return -1;

  rpld_ple_push_filename(plent, buf, RPLD_TYPE_UNKNOWN, 1);

  rpld_pl_push(pl, plent);
 }

 ROAR_DBG("ff_plain_pl_import(handle=%p, vio=%p, pl=%p) = 0", handle, vio, pl);
 return 0;
}

//ll
