
#line 1 "ragel/i18n/pa.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/pa.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_pa/gherkin_lexer_pa.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 13, 21, 22, 23, 24, 
	25, 26, 27, 28, 30, 32, 43, 44, 
	45, 47, 49, 54, 59, 64, 69, 73, 
	77, 79, 80, 81, 82, 83, 84, 85, 
	86, 87, 88, 89, 90, 91, 92, 93, 
	94, 99, 106, 111, 115, 121, 124, 126, 
	132, 143, 144, 145, 146, 147, 148, 149, 
	150, 151, 152, 153, 154, 155, 156, 157, 
	158, 159, 160, 161, 162, 163, 164, 165, 
	166, 167, 174, 176, 180, 182, 184, 186, 
	188, 190, 192, 194, 196, 198, 200, 202, 
	204, 206, 208, 210, 212, 223, 225, 227, 
	229, 231, 233, 235, 237, 239, 241, 243, 
	245, 247, 249, 251, 253, 255, 257, 259, 
	261, 263, 265, 267, 269, 271, 273, 275, 
	277, 279, 281, 283, 285, 287, 289, 291, 
	293, 295, 297, 299, 301, 303, 305, 307, 
	309, 310, 311, 312, 313, 314, 315, 316, 
	317, 318, 319, 320, 321, 322, 323, 324, 
	325, 326, 327, 335, 337, 343, 345, 347, 
	349, 351, 353, 355, 357, 359, 361, 363, 
	365, 367, 369, 371, 373, 375, 377, 379, 
	381, 383, 385, 387, 389, 391, 393, 395, 
	397, 399, 401, 403, 405, 407, 409, 411, 
	413, 415, 417, 419, 421, 423, 425, 427, 
	429, 431, 433, 435, 437, 439, 441, 443, 
	445, 447, 449, 451, 453, 455, 457, 459, 
	461, 463, 465, 468, 470, 472, 474, 476, 
	478, 480, 482, 484, 486, 489, 491, 493, 
	496, 498, 500, 502, 504, 506, 508, 510, 
	512, 514, 516, 518, 520, 522, 524, 526, 
	528, 530, 532, 534, 536, 538, 540, 542, 
	544, 546, 548, 550, 552, 554, 556, 558, 
	560, 562, 564, 566, 568, 570, 572, 574, 
	576, 578, 580, 582, 584, 586, 588, 590, 
	592, 594, 596, 598, 600, 602, 604, 606, 
	608, 610, 612, 614, 616, 618, 620, 622, 
	624, 626, 628, 630, 632, 634, 636, 638, 
	640, 641, 643, 645, 646, 647, 648, 649, 
	650, 651, 652, 653, 654, 655, 656, 657, 
	658, 659, 660, 661, 662, 663, 664, 665, 
	666, 667, 668, 669, 670, 671, 672, 673, 
	674, 675, 676, 677, 678, 679, 680, 681, 
	682, 683, 684, 685, 686, 687, 688, 689, 
	690, 691, 692, 693, 694, 695, 696, 697, 
	698, 699, 700, 701, 704, 705, 706, 707, 
	708, 709, 710, 711, 712, 713, 715, 716, 
	717, 719, 720, 721, 722, 723, 724, 725, 
	726, 727, 728, 729, 730, 731, 732, 733, 
	734, 743, 745, 753, 755, 757, 759, 761, 
	763, 765, 767, 769, 771, 773, 775, 777, 
	779, 781, 783, 785, 787, 789, 791, 793, 
	795, 797, 799, 801, 804, 807, 809, 811, 
	813, 815, 817, 819, 821, 823, 825, 827, 
	829, 831, 833, 835, 837, 839, 841, 843, 
	845, 847, 849, 851, 853, 855, 857, 859, 
	861, 863, 865, 867, 869, 871, 873, 875, 
	877, 879, 881, 883, 885, 887, 889, 891, 
	893, 895, 897, 899, 901, 903, 905, 907, 
	909, 911, 913, 915, 917, 919, 922, 924, 
	926, 928, 930, 932, 934, 936, 938, 940, 
	942, 944, 946, 948, 950, 952, 954, 956, 
	958, 960, 962, 964, 966, 968, 970, 972, 
	974, 976, 978, 980, 982, 984, 986, 988, 
	990, 992, 994, 996, 998, 1000, 1002, 1004, 
	1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 
	1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 
	1021, 1022, 1031, 1033, 1041, 1043, 1045, 1047, 
	1049, 1051, 1053, 1055, 1057, 1059, 1061, 1063, 
	1065, 1067, 1069, 1071, 1073, 1075, 1077, 1079, 
	1081, 1083, 1085, 1087, 1089, 1092, 1095, 1097, 
	1099, 1101, 1103, 1105, 1107, 1109, 1111, 1113, 
	1115, 1117, 1119, 1121, 1123, 1125, 1127, 1129, 
	1131, 1133, 1135, 1137, 1139, 1141, 1143, 1145, 
	1147, 1149, 1151, 1153, 1155, 1157, 1159, 1161, 
	1163, 1165, 1167, 1169, 1171, 1173, 1175, 1177, 
	1179, 1181, 1183, 1185, 1187, 1189, 1191, 1193, 
	1195, 1197, 1199, 1201, 1203, 1205, 1207, 1211, 
	1213, 1215, 1217, 1219, 1221, 1223, 1225, 1227, 
	1229, 1232, 1234, 1236, 1239, 1241, 1243, 1245, 
	1247, 1249, 1251, 1253, 1255, 1257, 1259, 1261, 
	1263, 1265, 1267, 1269, 1271, 1273, 1275, 1277, 
	1279, 1281, 1283, 1285, 1287, 1289, 1291, 1293, 
	1295, 1297, 1299, 1301, 1303, 1305, 1307, 1309, 
	1311, 1313, 1315, 1317, 1319, 1321, 1323, 1325, 
	1327, 1329, 1331, 1333, 1335, 1337, 1339, 1341, 
	1343, 1345, 1347, 1349, 1351, 1353, 1355, 1357, 
	1359, 1361, 1363, 1365, 1367, 1369, 1371, 1373, 
	1375, 1377, 1379, 1381, 1383, 1384, 1385, 1386, 
	1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394, 
	1395, 1396, 1397, 1398, 1407, 1409, 1417, 1419, 
	1421, 1423, 1425, 1427, 1429, 1431, 1433, 1435, 
	1437, 1439, 1441, 1443, 1445, 1447, 1449, 1451, 
	1453, 1455, 1457, 1459, 1461, 1463, 1465, 1468, 
	1471, 1473, 1475, 1477, 1479, 1481, 1483, 1485, 
	1487, 1489, 1491, 1493, 1495, 1497, 1499, 1501, 
	1503, 1505, 1507, 1509, 1511, 1513, 1515, 1517, 
	1519, 1521, 1523, 1525, 1527, 1529, 1531, 1533, 
	1535, 1537, 1539, 1541, 1543, 1545, 1547, 1549, 
	1551, 1553, 1555, 1557, 1559, 1561, 1563, 1565, 
	1567, 1569, 1571, 1573, 1575, 1577, 1579, 1581, 
	1583, 1586, 1588, 1590, 1592, 1594, 1596, 1598, 
	1600, 1602, 1604, 1607, 1609, 1611, 1614, 1616, 
	1618, 1620, 1622, 1624, 1626, 1628, 1630, 1632, 
	1634, 1636, 1638, 1640, 1642, 1644, 1646, 1648, 
	1650, 1652, 1654, 1656, 1658, 1660, 1662, 1664, 
	1666, 1668, 1670, 1672, 1674, 1676, 1678, 1680, 
	1682, 1684, 1686, 1688, 1690, 1692, 1694, 1696, 
	1698, 1700, 1702, 1704, 1706, 1708, 1710, 1712, 
	1714, 1716, 1718, 1720, 1722, 1724, 1726, 1728, 
	1730, 1732, 1734, 1735, 1736, 1737, 1738, 1739, 
	1740, 1741, 1742, 1743, 1744, 1745, 1746, 1747, 
	1748, 1749, 1750, 1751, 1752, 1753, 1754, 1755, 
	1756, 1757
};

static const char _lexer_trans_keys[] = {
	-32, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -88, -123, -119, -106, 
	-100, -92, -88, -86, -82, -32, -88, -92, 
	-32, -87, -121, 32, 10, 13, 10, 13, 
	-32, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, 34, 34, 10, 13, 10, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 9, 
	13, 10, 32, 9, 13, 10, 13, 10, 
	95, 70, 69, 65, 84, 85, 82, 69, 
	95, 69, 78, 68, 95, 37, 13, 32, 
	64, 9, 10, 9, 10, 13, 32, 64, 
	11, 12, 10, 32, 64, 9, 13, 32, 
	124, 9, 13, 10, 32, 92, 124, 9, 
	13, 10, 92, 124, 10, 92, 10, 32, 
	92, 124, 9, 13, -32, 10, 32, 34, 
	35, 37, 42, 64, 124, 9, 13, -32, 
	-88, -90, -32, -88, -66, -32, -88, -71, 
	-32, -88, -80, -32, -88, -88, -32, -88, 
	-66, -32, -88, -126, 58, 10, 10, -32, 
	10, 32, 35, 124, 9, 13, -88, 10, 
	-106, -88, -82, 10, -32, 10, -88, 10, 
	-66, 10, -32, 10, -88, 10, -72, 10, 
	-32, 10, -87, 10, -128, 10, -32, 10, 
	-88, 10, -123, 10, -32, 10, -88, 10, 
	-92, 10, 10, 58, -32, 10, 32, 34, 
	35, 37, 42, 64, 124, 9, 13, -32, 
	10, -88, 10, -107, 10, -32, 10, -88, 
	10, -74, 10, 10, 32, -32, 10, -88, 
	10, -88, 10, -32, 10, -87, 10, -127, 
	10, -32, 10, -88, 10, -71, 10, -32, 
	10, -88, 10, -66, 10, -32, 10, -88, 
	10, -80, 10, -32, 10, -87, 10, -127, 
	10, -32, 10, -88, 10, -71, 10, -32, 
	10, -88, 10, -66, 10, -32, 10, -88, 
	10, -126, 10, -32, 10, -88, 10, -90, 
	10, -32, 10, -88, 10, -80, 10, -32, 
	10, -88, 10, -66, 10, -32, -88, -66, 
	-32, -88, -72, -32, -87, -128, -32, -88, 
	-123, -32, -88, -92, 58, 10, 10, -32, 
	10, 32, 35, 37, 64, 9, 13, -88, 
	10, -119, -106, -88, -86, -82, 10, -32, 
	10, -88, 10, -90, 10, -32, 10, -88, 
	10, -66, 10, -32, 10, -88, 10, -71, 
	10, -32, 10, -88, 10, -80, 10, -32, 
	10, -88, 10, -88, 10, -32, 10, -88, 
	10, -66, 10, -32, 10, -88, 10, -126, 
	10, 10, 58, -32, 10, -88, 10, -66, 
	10, -32, 10, -88, 10, -72, 10, -32, 
	10, -87, 10, -128, 10, -32, 10, -88, 
	10, -123, 10, -32, 10, -88, 10, -92, 
	10, -32, 10, -88, 10, -107, 10, -32, 
	10, -88, 10, -74, 10, 10, 32, -32, 
	10, -88, 10, -88, 10, -32, 10, -87, 
	10, -127, 10, -32, 10, -88, 10, -71, 
	10, -32, 10, -88, 10, -66, 10, -32, 
	10, -88, 10, -80, 10, -32, 10, -88, 
	10, -97, -65, 10, -32, 10, -88, 10, 
	-107, 10, -32, 10, -88, 10, -91, 10, 
	-32, 10, -88, 10, -66, 10, 10, 32, 
	58, -32, 10, -88, 10, -94, -80, 10, 
	-32, 10, -88, 10, -66, 10, -32, 10, 
	-88, 10, -126, 10, -32, 10, -88, 10, 
	-102, 10, -32, 10, -88, 10, -66, 10, 
	-32, 10, -87, 10, -126, 10, -32, 10, 
	-88, 10, -86, 10, 10, 32, -32, 10, 
	-88, 10, -80, 10, -32, 10, -87, 10, 
	-121, 10, -32, 10, -88, 10, -106, 10, 
	-32, 10, -88, 10, -101, 10, -32, 10, 
	-87, 10, -117, 10, -32, 10, -88, 10, 
	-107, 10, -32, 10, -87, 10, -100, 10, 
	-32, 10, -87, 10, -127, 10, -32, 10, 
	-88, 10, -71, 10, -32, 10, -88, 10, 
	-66, 10, -32, 10, -88, 10, -126, 10, 
	-32, 10, -88, 10, -90, 10, -32, 10, 
	-88, 10, -80, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-32, -88, -87, -90, -65, -32, -87, -117, 
	-32, -88, -126, -32, -88, -75, -32, -87, 
	-121, -32, -88, -126, 32, -32, -88, -107, 
	-32, -88, -65, -121, -32, -88, -107, -32, 
	-88, -80, -32, -88, -90, -32, -88, -107, 
	-32, -88, -74, 32, -32, -88, -88, -32, 
	-87, -127, -32, -88, -71, -32, -88, -66, 
	-32, -88, -80, -32, -88, -97, -80, -65, 
	-32, -88, -107, -32, -88, -91, -32, -88, 
	-66, 32, 58, -32, -88, -94, -80, -32, 
	-88, -66, -32, -88, -126, -32, -88, -102, 
	-32, -88, -66, 58, 10, 10, -32, 10, 
	32, 35, 37, 42, 64, 9, 13, -88, 
	10, -123, -106, -100, -92, -88, -86, -82, 
	10, -32, 10, -88, 10, -92, 10, -32, 
	10, -87, 10, -121, 10, 10, 32, -32, 
	10, -88, 10, -66, 10, -32, 10, -88, 
	10, -72, 10, -32, 10, -87, 10, -128, 
	10, -32, 10, -88, 10, -123, 10, -32, 
	10, -88, 10, -92, 10, 10, 58, -32, 
	10, -88, -87, 10, -90, -65, 10, -32, 
	10, -87, 10, -117, 10, -32, 10, -88, 
	10, -126, 10, -32, 10, -88, 10, -75, 
	10, -32, 10, -87, 10, -121, 10, -32, 
	10, -88, 10, -126, 10, 10, 32, -32, 
	10, -88, 10, -107, 10, -32, 10, -88, 
	10, -65, 10, -121, 10, -32, 10, -88, 
	10, -107, 10, -32, 10, -88, 10, -80, 
	10, -32, 10, -88, 10, -90, 10, -32, 
	10, -88, 10, -107, 10, -32, 10, -88, 
	10, -74, 10, 10, 32, -32, 10, -88, 
	10, -88, 10, -32, 10, -87, 10, -127, 
	10, -32, 10, -88, 10, -71, 10, -32, 
	10, -88, 10, -66, 10, -32, 10, -88, 
	10, -80, 10, -32, 10, -88, 10, -97, 
	-80, 10, -32, 10, -88, 10, -107, 10, 
	-32, 10, -88, 10, -91, 10, -32, 10, 
	-88, 10, -66, 10, -32, 10, -87, 10, 
	-127, 10, -32, 10, -88, 10, -71, 10, 
	-32, 10, -88, 10, -66, 10, -32, 10, 
	-88, 10, -126, 10, -32, 10, -88, 10, 
	-90, 10, -32, 10, -88, 10, -80, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -32, -87, -126, -32, 
	-88, -86, 32, -32, -88, -80, -32, -87, 
	-121, -32, -88, -106, 10, 10, -32, 10, 
	32, 35, 37, 42, 64, 9, 13, -88, 
	10, -123, -106, -100, -92, -88, -86, -82, 
	10, -32, 10, -88, 10, -92, 10, -32, 
	10, -87, 10, -121, 10, 10, 32, -32, 
	10, -88, 10, -66, 10, -32, 10, -88, 
	10, -72, 10, -32, 10, -87, 10, -128, 
	10, -32, 10, -88, 10, -123, 10, -32, 
	10, -88, 10, -92, 10, 10, 58, -32, 
	10, -88, -87, 10, -90, -65, 10, -32, 
	10, -87, 10, -117, 10, -32, 10, -88, 
	10, -126, 10, -32, 10, -88, 10, -75, 
	10, -32, 10, -87, 10, -121, 10, -32, 
	10, -88, 10, -126, 10, 10, 32, -32, 
	10, -88, 10, -107, 10, -32, 10, -88, 
	10, -65, 10, -121, 10, -32, 10, -88, 
	10, -107, 10, -32, 10, -88, 10, -80, 
	10, -32, 10, -88, 10, -90, 10, -32, 
	10, -88, 10, -107, 10, -32, 10, -88, 
	10, -74, 10, 10, 32, -32, 10, -88, 
	10, -88, 10, -32, 10, -87, 10, -127, 
	10, -32, 10, -88, 10, -71, 10, -32, 
	10, -88, 10, -66, 10, -32, 10, -88, 
	10, -80, 10, -32, 10, -88, 10, -97, 
	-80, -65, 10, -32, 10, -88, 10, -107, 
	10, -32, 10, -88, 10, -91, 10, -32, 
	10, -88, 10, -66, 10, 10, 32, 58, 
	-32, 10, -88, 10, -94, -80, 10, -32, 
	10, -88, 10, -66, 10, -32, 10, -88, 
	10, -126, 10, -32, 10, -88, 10, -102, 
	10, -32, 10, -88, 10, -66, 10, -32, 
	10, -87, 10, -126, 10, -32, 10, -88, 
	10, -86, 10, 10, 32, -32, 10, -88, 
	10, -80, 10, -32, 10, -87, 10, -121, 
	10, -32, 10, -88, 10, -106, 10, -32, 
	10, -88, 10, -101, 10, -32, 10, -87, 
	10, -117, 10, -32, 10, -88, 10, -107, 
	10, -32, 10, -87, 10, -100, 10, -32, 
	10, -87, 10, -127, 10, -32, 10, -88, 
	10, -71, 10, -32, 10, -88, 10, -66, 
	10, -32, 10, -88, 10, -126, 10, -32, 
	10, -88, 10, -90, 10, -32, 10, -88, 
	10, -80, 10, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, -32, 
	-88, -101, -32, -87, -117, -32, -88, -107, 
	-32, -87, -100, 58, 10, 10, -32, 10, 
	32, 35, 37, 42, 64, 9, 13, -88, 
	10, -123, -106, -100, -92, -88, -86, -82, 
	10, -32, 10, -88, 10, -92, 10, -32, 
	10, -87, 10, -121, 10, 10, 32, -32, 
	10, -88, 10, -66, 10, -32, 10, -88, 
	10, -72, 10, -32, 10, -87, 10, -128, 
	10, -32, 10, -88, 10, -123, 10, -32, 
	10, -88, 10, -92, 10, 10, 58, -32, 
	10, -88, -87, 10, -90, -65, 10, -32, 
	10, -87, 10, -117, 10, -32, 10, -88, 
	10, -126, 10, -32, 10, -88, 10, -75, 
	10, -32, 10, -87, 10, -121, 10, -32, 
	10, -88, 10, -126, 10, 10, 32, -32, 
	10, -88, 10, -107, 10, -32, 10, -88, 
	10, -65, 10, -121, 10, -32, 10, -88, 
	10, -107, 10, -32, 10, -88, 10, -80, 
	10, -32, 10, -88, 10, -90, 10, -32, 
	10, -88, 10, -107, 10, -32, 10, -88, 
	10, -74, 10, 10, 32, -32, 10, -88, 
	10, -88, 10, -32, 10, -87, 10, -127, 
	10, -32, 10, -88, 10, -71, 10, -32, 
	10, -88, 10, -66, 10, -32, 10, -88, 
	10, -80, 10, -32, 10, -88, 10, -97, 
	-80, 10, -32, 10, -88, 10, -107, 10, 
	-32, 10, -88, 10, -91, 10, -32, 10, 
	-88, 10, -66, 10, 10, 32, 58, -32, 
	10, -88, 10, -94, -80, 10, -32, 10, 
	-88, 10, -66, 10, -32, 10, -88, 10, 
	-126, 10, -32, 10, -88, 10, -102, 10, 
	-32, 10, -88, 10, -66, 10, -32, 10, 
	-87, 10, -126, 10, -32, 10, -88, 10, 
	-86, 10, 10, 32, -32, 10, -88, 10, 
	-80, 10, -32, 10, -87, 10, -121, 10, 
	-32, 10, -88, 10, -106, 10, -32, 10, 
	-87, 10, -127, 10, -32, 10, -88, 10, 
	-71, 10, -32, 10, -88, 10, -66, 10, 
	-32, 10, -88, 10, -126, 10, -32, 10, 
	-88, 10, -90, 10, -32, 10, -88, 10, 
	-80, 10, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, -32, -87, 
	-127, -32, -88, -71, -32, -88, -66, -32, 
	-88, -126, -32, -88, -90, -32, -88, -80, 
	-32, -88, -66, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 1, 8, 1, 1, 1, 1, 
	1, 1, 1, 2, 2, 9, 1, 1, 
	2, 2, 3, 3, 3, 3, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	3, 5, 3, 2, 4, 3, 2, 4, 
	9, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 5, 2, 4, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 9, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 6, 2, 6, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 3, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 2, 1, 1, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	7, 2, 8, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 7, 2, 8, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 4, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 7, 2, 8, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 1, 1, 1, 1, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 14, 23, 25, 27, 29, 
	31, 33, 35, 37, 40, 43, 54, 56, 
	58, 61, 64, 69, 74, 79, 84, 88, 
	92, 95, 97, 99, 101, 103, 105, 107, 
	109, 111, 113, 115, 117, 119, 121, 123, 
	125, 130, 137, 142, 146, 152, 156, 159, 
	165, 176, 178, 180, 182, 184, 186, 188, 
	190, 192, 194, 196, 198, 200, 202, 204, 
	206, 208, 210, 212, 214, 216, 218, 220, 
	222, 224, 231, 234, 239, 242, 245, 248, 
	251, 254, 257, 260, 263, 266, 269, 272, 
	275, 278, 281, 284, 287, 298, 301, 304, 
	307, 310, 313, 316, 319, 322, 325, 328, 
	331, 334, 337, 340, 343, 346, 349, 352, 
	355, 358, 361, 364, 367, 370, 373, 376, 
	379, 382, 385, 388, 391, 394, 397, 400, 
	403, 406, 409, 412, 415, 418, 421, 424, 
	427, 429, 431, 433, 435, 437, 439, 441, 
	443, 445, 447, 449, 451, 453, 455, 457, 
	459, 461, 463, 471, 474, 481, 484, 487, 
	490, 493, 496, 499, 502, 505, 508, 511, 
	514, 517, 520, 523, 526, 529, 532, 535, 
	538, 541, 544, 547, 550, 553, 556, 559, 
	562, 565, 568, 571, 574, 577, 580, 583, 
	586, 589, 592, 595, 598, 601, 604, 607, 
	610, 613, 616, 619, 622, 625, 628, 631, 
	634, 637, 640, 643, 646, 649, 652, 655, 
	658, 661, 664, 668, 671, 674, 677, 680, 
	683, 686, 689, 692, 695, 699, 702, 705, 
	709, 712, 715, 718, 721, 724, 727, 730, 
	733, 736, 739, 742, 745, 748, 751, 754, 
	757, 760, 763, 766, 769, 772, 775, 778, 
	781, 784, 787, 790, 793, 796, 799, 802, 
	805, 808, 811, 814, 817, 820, 823, 826, 
	829, 832, 835, 838, 841, 844, 847, 850, 
	853, 856, 859, 862, 865, 868, 871, 874, 
	877, 880, 883, 886, 889, 892, 895, 898, 
	901, 904, 907, 910, 913, 916, 919, 922, 
	925, 927, 930, 933, 935, 937, 939, 941, 
	943, 945, 947, 949, 951, 953, 955, 957, 
	959, 961, 963, 965, 967, 969, 971, 973, 
	975, 977, 979, 981, 983, 985, 987, 989, 
	991, 993, 995, 997, 999, 1001, 1003, 1005, 
	1007, 1009, 1011, 1013, 1015, 1017, 1019, 1021, 
	1023, 1025, 1027, 1029, 1031, 1033, 1035, 1037, 
	1039, 1041, 1043, 1045, 1049, 1051, 1053, 1055, 
	1057, 1059, 1061, 1063, 1065, 1067, 1070, 1072, 
	1074, 1077, 1079, 1081, 1083, 1085, 1087, 1089, 
	1091, 1093, 1095, 1097, 1099, 1101, 1103, 1105, 
	1107, 1116, 1119, 1128, 1131, 1134, 1137, 1140, 
	1143, 1146, 1149, 1152, 1155, 1158, 1161, 1164, 
	1167, 1170, 1173, 1176, 1179, 1182, 1185, 1188, 
	1191, 1194, 1197, 1200, 1204, 1208, 1211, 1214, 
	1217, 1220, 1223, 1226, 1229, 1232, 1235, 1238, 
	1241, 1244, 1247, 1250, 1253, 1256, 1259, 1262, 
	1265, 1268, 1271, 1274, 1277, 1280, 1283, 1286, 
	1289, 1292, 1295, 1298, 1301, 1304, 1307, 1310, 
	1313, 1316, 1319, 1322, 1325, 1328, 1331, 1334, 
	1337, 1340, 1343, 1346, 1349, 1352, 1355, 1358, 
	1361, 1364, 1367, 1370, 1373, 1376, 1380, 1383, 
	1386, 1389, 1392, 1395, 1398, 1401, 1404, 1407, 
	1410, 1413, 1416, 1419, 1422, 1425, 1428, 1431, 
	1434, 1437, 1440, 1443, 1446, 1449, 1452, 1455, 
	1458, 1461, 1464, 1467, 1470, 1473, 1476, 1479, 
	1482, 1485, 1488, 1491, 1494, 1497, 1500, 1503, 
	1505, 1507, 1509, 1511, 1513, 1515, 1517, 1519, 
	1521, 1523, 1525, 1527, 1529, 1531, 1533, 1535, 
	1537, 1539, 1548, 1551, 1560, 1563, 1566, 1569, 
	1572, 1575, 1578, 1581, 1584, 1587, 1590, 1593, 
	1596, 1599, 1602, 1605, 1608, 1611, 1614, 1617, 
	1620, 1623, 1626, 1629, 1632, 1636, 1640, 1643, 
	1646, 1649, 1652, 1655, 1658, 1661, 1664, 1667, 
	1670, 1673, 1676, 1679, 1682, 1685, 1688, 1691, 
	1694, 1697, 1700, 1703, 1706, 1709, 1712, 1715, 
	1718, 1721, 1724, 1727, 1730, 1733, 1736, 1739, 
	1742, 1745, 1748, 1751, 1754, 1757, 1760, 1763, 
	1766, 1769, 1772, 1775, 1778, 1781, 1784, 1787, 
	1790, 1793, 1796, 1799, 1802, 1805, 1808, 1813, 
	1816, 1819, 1822, 1825, 1828, 1831, 1834, 1837, 
	1840, 1844, 1847, 1850, 1854, 1857, 1860, 1863, 
	1866, 1869, 1872, 1875, 1878, 1881, 1884, 1887, 
	1890, 1893, 1896, 1899, 1902, 1905, 1908, 1911, 
	1914, 1917, 1920, 1923, 1926, 1929, 1932, 1935, 
	1938, 1941, 1944, 1947, 1950, 1953, 1956, 1959, 
	1962, 1965, 1968, 1971, 1974, 1977, 1980, 1983, 
	1986, 1989, 1992, 1995, 1998, 2001, 2004, 2007, 
	2010, 2013, 2016, 2019, 2022, 2025, 2028, 2031, 
	2034, 2037, 2040, 2043, 2046, 2049, 2052, 2055, 
	2058, 2061, 2064, 2067, 2070, 2072, 2074, 2076, 
	2078, 2080, 2082, 2084, 2086, 2088, 2090, 2092, 
	2094, 2096, 2098, 2100, 2109, 2112, 2121, 2124, 
	2127, 2130, 2133, 2136, 2139, 2142, 2145, 2148, 
	2151, 2154, 2157, 2160, 2163, 2166, 2169, 2172, 
	2175, 2178, 2181, 2184, 2187, 2190, 2193, 2197, 
	2201, 2204, 2207, 2210, 2213, 2216, 2219, 2222, 
	2225, 2228, 2231, 2234, 2237, 2240, 2243, 2246, 
	2249, 2252, 2255, 2258, 2261, 2264, 2267, 2270, 
	2273, 2276, 2279, 2282, 2285, 2288, 2291, 2294, 
	2297, 2300, 2303, 2306, 2309, 2312, 2315, 2318, 
	2321, 2324, 2327, 2330, 2333, 2336, 2339, 2342, 
	2345, 2348, 2351, 2354, 2357, 2360, 2363, 2366, 
	2369, 2373, 2376, 2379, 2382, 2385, 2388, 2391, 
	2394, 2397, 2400, 2404, 2407, 2410, 2414, 2417, 
	2420, 2423, 2426, 2429, 2432, 2435, 2438, 2441, 
	2444, 2447, 2450, 2453, 2456, 2459, 2462, 2465, 
	2468, 2471, 2474, 2477, 2480, 2483, 2486, 2489, 
	2492, 2495, 2498, 2501, 2504, 2507, 2510, 2513, 
	2516, 2519, 2522, 2525, 2528, 2531, 2534, 2537, 
	2540, 2543, 2546, 2549, 2552, 2555, 2558, 2561, 
	2564, 2567, 2570, 2573, 2576, 2579, 2582, 2585, 
	2588, 2591, 2594, 2596, 2598, 2600, 2602, 2604, 
	2606, 2608, 2610, 2612, 2614, 2616, 2618, 2620, 
	2622, 2624, 2626, 2628, 2630, 2632, 2634, 2636, 
	2638, 2640
};

static const short _lexer_trans_targs[] = {
	2, 903, 13, 13, 14, 24, 26, 10, 
	40, 43, 13, 0, 3, 0, 4, 49, 
	136, 304, 336, 339, 361, 882, 0, 5, 
	0, 6, 0, 7, 0, 8, 0, 9, 
	0, 10, 0, 11, 0, 13, 25, 12, 
	13, 25, 12, 2, 13, 13, 14, 24, 
	26, 10, 40, 43, 13, 0, 15, 0, 
	16, 0, 18, 17, 17, 18, 17, 17, 
	19, 19, 20, 19, 19, 19, 19, 20, 
	19, 19, 19, 19, 21, 19, 19, 19, 
	19, 22, 19, 19, 13, 23, 23, 0, 
	13, 23, 23, 0, 13, 25, 24, 13, 
	0, 27, 0, 28, 0, 29, 0, 30, 
	0, 31, 0, 32, 0, 33, 0, 34, 
	0, 35, 0, 36, 0, 37, 0, 38, 
	0, 39, 0, 905, 0, 0, 0, 0, 
	0, 41, 42, 13, 42, 42, 40, 41, 
	41, 13, 42, 40, 42, 0, 43, 44, 
	43, 0, 48, 47, 46, 44, 47, 45, 
	0, 46, 44, 45, 0, 46, 45, 48, 
	47, 46, 44, 47, 45, 2, 48, 48, 
	14, 24, 26, 10, 40, 43, 48, 0, 
	50, 0, 51, 0, 52, 0, 53, 0, 
	54, 0, 55, 0, 56, 0, 57, 0, 
	58, 0, 59, 0, 60, 0, 61, 0, 
	62, 0, 63, 0, 64, 0, 65, 0, 
	66, 0, 67, 0, 68, 0, 69, 0, 
	70, 0, 71, 0, 73, 72, 73, 72, 
	74, 73, 73, 13, 13, 73, 72, 75, 
	73, 72, 76, 93, 115, 73, 72, 77, 
	73, 72, 78, 73, 72, 79, 73, 72, 
	80, 73, 72, 81, 73, 72, 82, 73, 
	72, 83, 73, 72, 84, 73, 72, 85, 
	73, 72, 86, 73, 72, 87, 73, 72, 
	88, 73, 72, 89, 73, 72, 90, 73, 
	72, 91, 73, 72, 73, 92, 72, 2, 
	13, 13, 14, 24, 26, 10, 40, 43, 
	13, 0, 94, 73, 72, 95, 73, 72, 
	96, 73, 72, 97, 73, 72, 98, 73, 
	72, 99, 73, 72, 73, 100, 72, 101, 
	73, 72, 102, 73, 72, 103, 73, 72, 
	104, 73, 72, 105, 73, 72, 106, 73, 
	72, 107, 73, 72, 108, 73, 72, 109, 
	73, 72, 110, 73, 72, 111, 73, 72, 
	112, 73, 72, 113, 73, 72, 114, 73, 
	72, 91, 73, 72, 116, 73, 72, 117, 
	73, 72, 118, 73, 72, 119, 73, 72, 
	120, 73, 72, 121, 73, 72, 122, 73, 
	72, 123, 73, 72, 124, 73, 72, 125, 
	73, 72, 126, 73, 72, 127, 73, 72, 
	128, 73, 72, 129, 73, 72, 130, 73, 
	72, 131, 73, 72, 132, 73, 72, 133, 
	73, 72, 134, 73, 72, 135, 73, 72, 
	91, 73, 72, 137, 0, 138, 0, 139, 
	0, 140, 0, 141, 0, 142, 0, 143, 
	0, 144, 0, 145, 0, 146, 0, 147, 
	0, 148, 0, 149, 0, 150, 0, 151, 
	0, 152, 0, 154, 153, 154, 153, 155, 
	154, 154, 13, 290, 13, 154, 153, 156, 
	154, 153, 157, 179, 194, 216, 272, 154, 
	153, 158, 154, 153, 159, 154, 153, 160, 
	154, 153, 161, 154, 153, 162, 154, 153, 
	163, 154, 153, 164, 154, 153, 165, 154, 
	153, 166, 154, 153, 167, 154, 153, 168, 
	154, 153, 169, 154, 153, 170, 154, 153, 
	171, 154, 153, 172, 154, 153, 173, 154, 
	153, 174, 154, 153, 175, 154, 153, 176, 
	154, 153, 177, 154, 153, 178, 154, 153, 
	154, 92, 153, 180, 154, 153, 181, 154, 
	153, 182, 154, 153, 183, 154, 153, 184, 
	154, 153, 185, 154, 153, 186, 154, 153, 
	187, 154, 153, 188, 154, 153, 189, 154, 
	153, 190, 154, 153, 191, 154, 153, 192, 
	154, 153, 193, 154, 153, 178, 154, 153, 
	195, 154, 153, 196, 154, 153, 197, 154, 
	153, 198, 154, 153, 199, 154, 153, 200, 
	154, 153, 154, 201, 153, 202, 154, 153, 
	203, 154, 153, 204, 154, 153, 205, 154, 
	153, 206, 154, 153, 207, 154, 153, 208, 
	154, 153, 209, 154, 153, 210, 154, 153, 
	211, 154, 153, 212, 154, 153, 213, 154, 
	153, 214, 154, 153, 215, 154, 153, 178, 
	154, 153, 217, 154, 153, 218, 154, 153, 
	219, 260, 154, 153, 220, 154, 153, 221, 
	154, 153, 222, 154, 153, 223, 154, 153, 
	224, 154, 153, 225, 154, 153, 226, 154, 
	153, 227, 154, 153, 228, 154, 153, 154, 
	229, 92, 153, 230, 154, 153, 231, 154, 
	153, 232, 244, 154, 153, 233, 154, 153, 
	234, 154, 153, 235, 154, 153, 236, 154, 
	153, 237, 154, 153, 238, 154, 153, 239, 
	154, 153, 240, 154, 153, 241, 154, 153, 
	242, 154, 153, 243, 154, 153, 178, 154, 
	153, 245, 154, 153, 246, 154, 153, 247, 
	154, 153, 248, 154, 153, 249, 154, 153, 
	250, 154, 153, 154, 251, 153, 252, 154, 
	153, 253, 154, 153, 254, 154, 153, 255, 
	154, 153, 256, 154, 153, 257, 154, 153, 
	258, 154, 153, 259, 154, 153, 241, 154, 
	153, 261, 154, 153, 262, 154, 153, 263, 
	154, 153, 264, 154, 153, 265, 154, 153, 
	266, 154, 153, 267, 154, 153, 268, 154, 
	153, 269, 154, 153, 270, 154, 153, 271, 
	154, 153, 178, 154, 153, 273, 154, 153, 
	274, 154, 153, 275, 154, 153, 276, 154, 
	153, 277, 154, 153, 278, 154, 153, 279, 
	154, 153, 280, 154, 153, 281, 154, 153, 
	282, 154, 153, 283, 154, 153, 284, 154, 
	153, 285, 154, 153, 286, 154, 153, 287, 
	154, 153, 288, 154, 153, 289, 154, 153, 
	241, 154, 153, 154, 291, 153, 154, 292, 
	153, 154, 293, 153, 154, 294, 153, 154, 
	295, 153, 154, 296, 153, 154, 297, 153, 
	154, 298, 153, 154, 299, 153, 154, 300, 
	153, 154, 301, 153, 154, 302, 153, 154, 
	303, 153, 154, 13, 153, 305, 0, 306, 
	329, 0, 307, 313, 0, 308, 0, 309, 
	0, 310, 0, 311, 0, 312, 0, 10, 
	0, 314, 0, 315, 0, 316, 0, 317, 
	0, 318, 0, 319, 0, 320, 0, 321, 
	0, 322, 0, 323, 0, 324, 0, 325, 
	0, 326, 0, 327, 0, 328, 0, 10, 
	0, 330, 0, 331, 0, 332, 0, 333, 
	0, 334, 0, 335, 0, 10, 0, 337, 
	0, 338, 0, 10, 0, 340, 0, 341, 
	0, 342, 0, 343, 0, 344, 0, 345, 
	0, 346, 0, 347, 0, 348, 0, 349, 
	0, 350, 0, 351, 0, 352, 0, 353, 
	0, 354, 0, 355, 0, 356, 0, 357, 
	0, 358, 0, 359, 0, 360, 0, 151, 
	0, 362, 0, 363, 0, 364, 10, 708, 
	0, 365, 0, 366, 0, 367, 0, 368, 
	0, 369, 0, 370, 0, 371, 0, 372, 
	0, 373, 0, 374, 535, 0, 375, 0, 
	376, 0, 377, 519, 0, 378, 0, 379, 
	0, 380, 0, 381, 0, 382, 0, 383, 
	0, 384, 0, 385, 0, 386, 0, 387, 
	0, 388, 0, 389, 0, 390, 0, 392, 
	391, 392, 391, 393, 392, 392, 13, 505, 
	401, 13, 392, 391, 394, 392, 391, 395, 
	402, 418, 450, 453, 475, 487, 392, 391, 
	396, 392, 391, 397, 392, 391, 398, 392, 
	391, 399, 392, 391, 400, 392, 391, 401, 
	392, 391, 392, 92, 391, 403, 392, 391, 
	404, 392, 391, 405, 392, 391, 406, 392, 
	391, 407, 392, 391, 408, 392, 391, 409, 
	392, 391, 410, 392, 391, 411, 392, 391, 
	412, 392, 391, 413, 392, 391, 414, 392, 
	391, 415, 392, 391, 416, 392, 391, 417, 
	392, 391, 392, 92, 391, 419, 392, 391, 
	420, 443, 392, 391, 421, 427, 392, 391, 
	422, 392, 391, 423, 392, 391, 424, 392, 
	391, 425, 392, 391, 426, 392, 391, 401, 
	392, 391, 428, 392, 391, 429, 392, 391, 
	430, 392, 391, 431, 392, 391, 432, 392, 
	391, 433, 392, 391, 434, 392, 391, 435, 
	392, 391, 436, 392, 391, 392, 437, 391, 
	438, 392, 391, 439, 392, 391, 440, 392, 
	391, 441, 392, 391, 442, 392, 391, 401, 
	392, 391, 444, 392, 391, 445, 392, 391, 
	446, 392, 391, 447, 392, 391, 448, 392, 
	391, 449, 392, 391, 401, 392, 391, 451, 
	392, 391, 452, 392, 391, 401, 392, 391, 
	454, 392, 391, 455, 392, 391, 456, 392, 
	391, 457, 392, 391, 458, 392, 391, 459, 
	392, 391, 392, 460, 391, 461, 392, 391, 
	462, 392, 391, 463, 392, 391, 464, 392, 
	391, 465, 392, 391, 466, 392, 391, 467, 
	392, 391, 468, 392, 391, 469, 392, 391, 
	470, 392, 391, 471, 392, 391, 472, 392, 
	391, 473, 392, 391, 474, 392, 391, 417, 
	392, 391, 476, 392, 391, 477, 392, 391, 
	478, 401, 392, 391, 479, 392, 391, 480, 
	392, 391, 481, 392, 391, 482, 392, 391, 
	483, 392, 391, 484, 392, 391, 485, 392, 
	391, 486, 392, 391, 417, 392, 391, 488, 
	392, 391, 489, 392, 391, 490, 392, 391, 
	491, 392, 391, 492, 392, 391, 493, 392, 
	391, 494, 392, 391, 495, 392, 391, 496, 
	392, 391, 497, 392, 391, 498, 392, 391, 
	499, 392, 391, 500, 392, 391, 501, 392, 
	391, 502, 392, 391, 503, 392, 391, 504, 
	392, 391, 484, 392, 391, 392, 506, 391, 
	392, 507, 391, 392, 508, 391, 392, 509, 
	391, 392, 510, 391, 392, 511, 391, 392, 
	512, 391, 392, 513, 391, 392, 514, 391, 
	392, 515, 391, 392, 516, 391, 392, 517, 
	391, 392, 518, 391, 392, 13, 391, 520, 
	0, 521, 0, 522, 0, 523, 0, 524, 
	0, 525, 0, 526, 0, 527, 0, 528, 
	0, 529, 0, 530, 0, 531, 0, 532, 
	0, 533, 0, 534, 0, 386, 0, 537, 
	536, 537, 536, 538, 537, 537, 13, 694, 
	546, 13, 537, 536, 539, 537, 536, 540, 
	547, 563, 595, 598, 620, 676, 537, 536, 
	541, 537, 536, 542, 537, 536, 543, 537, 
	536, 544, 537, 536, 545, 537, 536, 546, 
	537, 536, 537, 92, 536, 548, 537, 536, 
	549, 537, 536, 550, 537, 536, 551, 537, 
	536, 552, 537, 536, 553, 537, 536, 554, 
	537, 536, 555, 537, 536, 556, 537, 536, 
	557, 537, 536, 558, 537, 536, 559, 537, 
	536, 560, 537, 536, 561, 537, 536, 562, 
	537, 536, 537, 92, 536, 564, 537, 536, 
	565, 588, 537, 536, 566, 572, 537, 536, 
	567, 537, 536, 568, 537, 536, 569, 537, 
	536, 570, 537, 536, 571, 537, 536, 546, 
	537, 536, 573, 537, 536, 574, 537, 536, 
	575, 537, 536, 576, 537, 536, 577, 537, 
	536, 578, 537, 536, 579, 537, 536, 580, 
	537, 536, 581, 537, 536, 537, 582, 536, 
	583, 537, 536, 584, 537, 536, 585, 537, 
	536, 586, 537, 536, 587, 537, 536, 546, 
	537, 536, 589, 537, 536, 590, 537, 536, 
	591, 537, 536, 592, 537, 536, 593, 537, 
	536, 594, 537, 536, 546, 537, 536, 596, 
	537, 536, 597, 537, 536, 546, 537, 536, 
	599, 537, 536, 600, 537, 536, 601, 537, 
	536, 602, 537, 536, 603, 537, 536, 604, 
	537, 536, 537, 605, 536, 606, 537, 536, 
	607, 537, 536, 608, 537, 536, 609, 537, 
	536, 610, 537, 536, 611, 537, 536, 612, 
	537, 536, 613, 537, 536, 614, 537, 536, 
	615, 537, 536, 616, 537, 536, 617, 537, 
	536, 618, 537, 536, 619, 537, 536, 562, 
	537, 536, 621, 537, 536, 622, 537, 536, 
	623, 546, 664, 537, 536, 624, 537, 536, 
	625, 537, 536, 626, 537, 536, 627, 537, 
	536, 628, 537, 536, 629, 537, 536, 630, 
	537, 536, 631, 537, 536, 632, 537, 536, 
	537, 633, 92, 536, 634, 537, 536, 635, 
	537, 536, 636, 648, 537, 536, 637, 537, 
	536, 638, 537, 536, 639, 537, 536, 640, 
	537, 536, 641, 537, 536, 642, 537, 536, 
	643, 537, 536, 644, 537, 536, 645, 537, 
	536, 646, 537, 536, 647, 537, 536, 562, 
	537, 536, 649, 537, 536, 650, 537, 536, 
	651, 537, 536, 652, 537, 536, 653, 537, 
	536, 654, 537, 536, 537, 655, 536, 656, 
	537, 536, 657, 537, 536, 658, 537, 536, 
	659, 537, 536, 660, 537, 536, 661, 537, 
	536, 662, 537, 536, 663, 537, 536, 645, 
	537, 536, 665, 537, 536, 666, 537, 536, 
	667, 537, 536, 668, 537, 536, 669, 537, 
	536, 670, 537, 536, 671, 537, 536, 672, 
	537, 536, 673, 537, 536, 674, 537, 536, 
	675, 537, 536, 562, 537, 536, 677, 537, 
	536, 678, 537, 536, 679, 537, 536, 680, 
	537, 536, 681, 537, 536, 682, 537, 536, 
	683, 537, 536, 684, 537, 536, 685, 537, 
	536, 686, 537, 536, 687, 537, 536, 688, 
	537, 536, 689, 537, 536, 690, 537, 536, 
	691, 537, 536, 692, 537, 536, 693, 537, 
	536, 645, 537, 536, 537, 695, 536, 537, 
	696, 536, 537, 697, 536, 537, 698, 536, 
	537, 699, 536, 537, 700, 536, 537, 701, 
	536, 537, 702, 536, 537, 703, 536, 537, 
	704, 536, 537, 705, 536, 537, 706, 536, 
	537, 707, 536, 537, 13, 536, 709, 0, 
	710, 0, 711, 0, 712, 0, 713, 0, 
	714, 0, 715, 0, 716, 0, 717, 0, 
	718, 0, 719, 0, 720, 0, 721, 0, 
	723, 722, 723, 722, 724, 723, 723, 13, 
	868, 732, 13, 723, 722, 725, 723, 722, 
	726, 733, 749, 781, 784, 806, 850, 723, 
	722, 727, 723, 722, 728, 723, 722, 729, 
	723, 722, 730, 723, 722, 731, 723, 722, 
	732, 723, 722, 723, 92, 722, 734, 723, 
	722, 735, 723, 722, 736, 723, 722, 737, 
	723, 722, 738, 723, 722, 739, 723, 722, 
	740, 723, 722, 741, 723, 722, 742, 723, 
	722, 743, 723, 722, 744, 723, 722, 745, 
	723, 722, 746, 723, 722, 747, 723, 722, 
	748, 723, 722, 723, 92, 722, 750, 723, 
	722, 751, 774, 723, 722, 752, 758, 723, 
	722, 753, 723, 722, 754, 723, 722, 755, 
	723, 722, 756, 723, 722, 757, 723, 722, 
	732, 723, 722, 759, 723, 722, 760, 723, 
	722, 761, 723, 722, 762, 723, 722, 763, 
	723, 722, 764, 723, 722, 765, 723, 722, 
	766, 723, 722, 767, 723, 722, 723, 768, 
	722, 769, 723, 722, 770, 723, 722, 771, 
	723, 722, 772, 723, 722, 773, 723, 722, 
	732, 723, 722, 775, 723, 722, 776, 723, 
	722, 777, 723, 722, 778, 723, 722, 779, 
	723, 722, 780, 723, 722, 732, 723, 722, 
	782, 723, 722, 783, 723, 722, 732, 723, 
	722, 785, 723, 722, 786, 723, 722, 787, 
	723, 722, 788, 723, 722, 789, 723, 722, 
	790, 723, 722, 723, 791, 722, 792, 723, 
	722, 793, 723, 722, 794, 723, 722, 795, 
	723, 722, 796, 723, 722, 797, 723, 722, 
	798, 723, 722, 799, 723, 722, 800, 723, 
	722, 801, 723, 722, 802, 723, 722, 803, 
	723, 722, 804, 723, 722, 805, 723, 722, 
	748, 723, 722, 807, 723, 722, 808, 723, 
	722, 809, 732, 723, 722, 810, 723, 722, 
	811, 723, 722, 812, 723, 722, 813, 723, 
	722, 814, 723, 722, 815, 723, 722, 816, 
	723, 722, 817, 723, 722, 818, 723, 722, 
	723, 819, 92, 722, 820, 723, 722, 821, 
	723, 722, 822, 834, 723, 722, 823, 723, 
	722, 824, 723, 722, 825, 723, 722, 826, 
	723, 722, 827, 723, 722, 828, 723, 722, 
	829, 723, 722, 830, 723, 722, 831, 723, 
	722, 832, 723, 722, 833, 723, 722, 748, 
	723, 722, 835, 723, 722, 836, 723, 722, 
	837, 723, 722, 838, 723, 722, 839, 723, 
	722, 840, 723, 722, 723, 841, 722, 842, 
	723, 722, 843, 723, 722, 844, 723, 722, 
	845, 723, 722, 846, 723, 722, 847, 723, 
	722, 848, 723, 722, 849, 723, 722, 831, 
	723, 722, 851, 723, 722, 852, 723, 722, 
	853, 723, 722, 854, 723, 722, 855, 723, 
	722, 856, 723, 722, 857, 723, 722, 858, 
	723, 722, 859, 723, 722, 860, 723, 722, 
	861, 723, 722, 862, 723, 722, 863, 723, 
	722, 864, 723, 722, 865, 723, 722, 866, 
	723, 722, 867, 723, 722, 831, 723, 722, 
	723, 869, 722, 723, 870, 722, 723, 871, 
	722, 723, 872, 722, 723, 873, 722, 723, 
	874, 722, 723, 875, 722, 723, 876, 722, 
	723, 877, 722, 723, 878, 722, 723, 879, 
	722, 723, 880, 722, 723, 881, 722, 723, 
	13, 722, 883, 0, 884, 0, 885, 0, 
	886, 0, 887, 0, 888, 0, 889, 0, 
	890, 0, 891, 0, 892, 0, 893, 0, 
	894, 0, 895, 0, 896, 0, 897, 0, 
	898, 0, 899, 0, 900, 0, 901, 0, 
	902, 0, 151, 0, 904, 0, 13, 0, 
	0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 43, 0, 0, 
	0, 0, 0, 0, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 149, 126, 57, 
	110, 23, 0, 29, 54, 0, 5, 1, 
	0, 29, 1, 35, 0, 43, 0, 43, 
	0, 43, 139, 48, 9, 106, 11, 0, 
	134, 45, 45, 45, 3, 122, 33, 33, 
	33, 0, 122, 33, 33, 33, 0, 122, 
	33, 0, 33, 0, 102, 7, 7, 43, 
	54, 0, 0, 43, 114, 25, 0, 54, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 43, 43, 43, 
	43, 0, 27, 118, 27, 27, 51, 27, 
	0, 54, 0, 1, 0, 43, 0, 0, 
	0, 43, 54, 37, 37, 87, 37, 37, 
	43, 0, 39, 0, 43, 0, 0, 54, 
	0, 0, 39, 0, 0, 96, 54, 0, 
	93, 90, 41, 96, 90, 99, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 144, 57, 54, 0, 
	84, 54, 0, 81, 81, 0, 0, 0, 
	54, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 21, 0, 63, 
	130, 31, 60, 57, 31, 63, 57, 66, 
	31, 43, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	54, 0, 69, 33, 69, 0, 0, 0, 
	54, 0, 0, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 13, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 13, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 13, 0, 0, 43, 0, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 78, 33, 
	84, 78, 0, 0, 0, 54, 0, 0, 
	0, 0, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 19, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 19, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 19, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 75, 33, 
	84, 75, 0, 0, 0, 54, 0, 0, 
	0, 0, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 17, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 17, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 17, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 17, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 54, 0, 72, 
	33, 84, 72, 0, 0, 0, 54, 0, 
	0, 0, 0, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 15, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 15, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 15, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	15, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 905;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/pa.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1764 "ext/gherkin_lexer_pa/gherkin_lexer_pa.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/pa.c.rl"
    
#line 1771 "ext/gherkin_lexer_pa/gherkin_lexer_pa.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/pa.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/pa.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/pa.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/pa.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/pa.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/pa.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/pa.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/pa.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/pa.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/pa.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/pa.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/pa.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/pa.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/pa.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/pa.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/pa.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/pa.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/pa.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/pa.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/pa.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/pa.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/pa.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/pa.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/pa.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 2061 "ext/gherkin_lexer_pa/gherkin_lexer_pa.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/pa.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 2124 "ext/gherkin_lexer_pa/gherkin_lexer_pa.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/pa.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_pa()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Pa", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

