include!(concat!(env!("OUT_DIR"), "/const.rs"));

/*
Note: The table below has been generated by something like the
following script:

```
#!/bin/sh
set -eu
LINUX=~/src/linux
echo '#include <linux/audit.h>' \
    | cpp -dM -D__LINUX_COMPILER_TYPES_H -I "${LINUX}/include/uapi" -I "${LINUX}/tools/include" \
    | sed -ne '/^#define AUDIT_ARCH_/ { ; s/^.* \(AUDIT_ARCH_[A-Z0-9_]*\) .*$/\1/; p }' \
    | sort -u \
    | ( \
        cat<<EOF
#include <linux/audit.h>
#include <stdio.h>

char* lc(char* s) {
    static char l[64];
    for (int i=0; s[i] != 0; i++) {
        if (s[i] >= 'A' && s[i] <= 'Z')
             l[i] = s[i] | 0x20;
        else
             l[i] = s[i];
        l[i+1] = 0;
    }
    return l;
}
int main() {
EOF
        while read token; do
            echo 'printf("(\"%s\", 0x%08x),\\n", lc("'$token'") + 11, '$token');'
        done
        echo "}"
    ) \
    | gcc -Wall -o print-audit-archs -xc -
./print-audit-archs
rm -f print-audit-archs
```
*/

const ARCHS: &[(&str, u32)] = &[
    ("aarch64", 0xc00000b7),
    ("alpha", 0xc0009026),
    ("arcompact", 0x4000005d),
    ("arcompactbe", 0x0000005d),
    ("arcv2", 0x400000c3),
    ("arcv2be", 0x000000c3),
    ("arm", 0x40000028),
    ("armeb", 0x00000028),
    ("c6x", 0x4000008c),
    ("c6xbe", 0x0000008c),
    ("cris", 0x4000004c),
    ("csky", 0x400000fc),
    ("frv", 0x00005441),
    ("h8300", 0x0000002e),
    ("hexagon", 0x000000a4),
    ("i386", 0x40000003),
    ("ia64", 0xc0000032),
    ("loongarch32", 0x40000102),
    ("loongarch64", 0xc0000102),
    ("m32r", 0x00000058),
    ("m68k", 0x00000004),
    ("microblaze", 0x000000bd),
    ("mips", 0x00000008),
    ("mips64", 0x80000008),
    ("mips64n32", 0xa0000008),
    ("mipsel", 0x40000008),
    ("mipsel64", 0xc0000008),
    ("mipsel64n32", 0xe0000008),
    ("nds32", 0x400000a7),
    ("nds32be", 0x000000a7),
    ("nios2", 0x40000071),
    ("openrisc", 0x0000005c),
    ("parisc", 0x0000000f),
    ("parisc64", 0x8000000f),
    ("ppc", 0x00000014),
    ("ppc64", 0x80000015),
    ("ppc64le", 0xc0000015),
    ("riscv32", 0x400000f3),
    ("riscv64", 0xc00000f3),
    ("s390", 0x00000016),
    ("s390x", 0x80000016),
    ("sh", 0x0000002a),
    ("sh64", 0x8000002a),
    ("shel", 0x4000002a),
    ("shel64", 0xc000002a),
    ("sparc", 0x00000002),
    ("sparc64", 0x8000002b),
    ("tilegx", 0xc00000bf),
    ("tilegx32", 0x400000bf),
    ("tilepro", 0x400000bc),
    ("unicore", 0x4000006e),
    ("x86_64", 0xc000003e),
    ("xtensa", 0x0000005e),
];

lazy_static! {
    pub static ref ARCH_IDS: HashMap<&'static str, u32> = {
        let mut hm = HashMap::with_capacity(ARCHS.len());
        for (name, value) in ARCHS {
            hm.insert(*name, *value);
        }
        hm
    };
    pub static ref ARCH_NAMES: HashMap<u32, &'static str> = {
        let mut hm = HashMap::with_capacity(ARCHS.len());
        for (name, value) in ARCHS {
            hm.insert(*value, *name);
        }
        hm
    };
}

pub fn initialize() {
    lazy_static::initialize(&FIELD_TYPES);
    lazy_static::initialize(&SYSCALL_NAMES);
    lazy_static::initialize(&ARCH_IDS);
}
