// Generated by gir (https://github.com/gtk-rs/gir @ 5223ce91b97a)
// from ../.. (@ 732a661d5840+)
// from ../../gir-files (@ 6cd7b656acd6)
// DO NOT EDIT

#![cfg(unix)]

use phosh_sys::*;
use std::mem::{align_of, size_of};
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::path::Path;
use std::process::{Command, Stdio};
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["libphosh-0.44"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG")
        .unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}


#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in
        RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    ("PhoshActivityClass", Layout {size: size_of::<PhoshActivityClass>(), alignment: align_of::<PhoshActivityClass>()}),
    ("PhoshAmbientClass", Layout {size: size_of::<PhoshAmbientClass>(), alignment: align_of::<PhoshAmbientClass>()}),
    ("PhoshAnimationType", Layout {size: size_of::<PhoshAnimationType>(), alignment: align_of::<PhoshAnimationType>()}),
    ("PhoshAppAuthPromptClass", Layout {size: size_of::<PhoshAppAuthPromptClass>(), alignment: align_of::<PhoshAppAuthPromptClass>()}),
    ("PhoshAppFilterModeFlags", Layout {size: size_of::<PhoshAppFilterModeFlags>(), alignment: align_of::<PhoshAppFilterModeFlags>()}),
    ("PhoshAppGridBaseButtonClass", Layout {size: size_of::<PhoshAppGridBaseButtonClass>(), alignment: align_of::<PhoshAppGridBaseButtonClass>()}),
    ("PhoshAppGridButtonClass", Layout {size: size_of::<PhoshAppGridButtonClass>(), alignment: align_of::<PhoshAppGridButtonClass>()}),
    ("PhoshAppGridButtonMode", Layout {size: size_of::<PhoshAppGridButtonMode>(), alignment: align_of::<PhoshAppGridButtonMode>()}),
    ("PhoshAppGridClass", Layout {size: size_of::<PhoshAppGridClass>(), alignment: align_of::<PhoshAppGridClass>()}),
    ("PhoshAppGridFolderButtonClass", Layout {size: size_of::<PhoshAppGridFolderButtonClass>(), alignment: align_of::<PhoshAppGridFolderButtonClass>()}),
    ("PhoshAppListModelClass", Layout {size: size_of::<PhoshAppListModelClass>(), alignment: align_of::<PhoshAppListModelClass>()}),
    ("PhoshAppTrackerClass", Layout {size: size_of::<PhoshAppTrackerClass>(), alignment: align_of::<PhoshAppTrackerClass>()}),
    ("PhoshArrowClass", Layout {size: size_of::<PhoshArrowClass>(), alignment: align_of::<PhoshArrowClass>()}),
    ("PhoshAudioDeviceClass", Layout {size: size_of::<PhoshAudioDeviceClass>(), alignment: align_of::<PhoshAudioDeviceClass>()}),
    ("PhoshAudioDeviceRowClass", Layout {size: size_of::<PhoshAudioDeviceRowClass>(), alignment: align_of::<PhoshAudioDeviceRowClass>()}),
    ("PhoshAudioSettingsClass", Layout {size: size_of::<PhoshAudioSettingsClass>(), alignment: align_of::<PhoshAudioSettingsClass>()}),
    ("PhoshAuthClass", Layout {size: size_of::<PhoshAuthClass>(), alignment: align_of::<PhoshAuthClass>()}),
    ("PhoshAuthPromptOptionClass", Layout {size: size_of::<PhoshAuthPromptOptionClass>(), alignment: align_of::<PhoshAuthPromptOptionClass>()}),
    ("PhoshBackgroundCacheClass", Layout {size: size_of::<PhoshBackgroundCacheClass>(), alignment: align_of::<PhoshBackgroundCacheClass>()}),
    ("PhoshBackgroundClass", Layout {size: size_of::<PhoshBackgroundClass>(), alignment: align_of::<PhoshBackgroundClass>()}),
    ("PhoshBackgroundImageClass", Layout {size: size_of::<PhoshBackgroundImageClass>(), alignment: align_of::<PhoshBackgroundImageClass>()}),
    ("PhoshBatteryInfoClass", Layout {size: size_of::<PhoshBatteryInfoClass>(), alignment: align_of::<PhoshBatteryInfoClass>()}),
    ("PhoshBtInfoClass", Layout {size: size_of::<PhoshBtInfoClass>(), alignment: align_of::<PhoshBtInfoClass>()}),
    ("PhoshCallClass", Layout {size: size_of::<PhoshCallClass>(), alignment: align_of::<PhoshCallClass>()}),
    ("PhoshCallNotificationClass", Layout {size: size_of::<PhoshCallNotificationClass>(), alignment: align_of::<PhoshCallNotificationClass>()}),
    ("PhoshCallState", Layout {size: size_of::<PhoshCallState>(), alignment: align_of::<PhoshCallState>()}),
    ("PhoshCallsDBusCallsCallIface", Layout {size: size_of::<PhoshCallsDBusCallsCallIface>(), alignment: align_of::<PhoshCallsDBusCallsCallIface>()}),
    ("PhoshCallsDBusCallsCallProxyClass", Layout {size: size_of::<PhoshCallsDBusCallsCallProxyClass>(), alignment: align_of::<PhoshCallsDBusCallsCallProxyClass>()}),
    ("PhoshCallsDBusCallsCallSkeletonClass", Layout {size: size_of::<PhoshCallsDBusCallsCallSkeletonClass>(), alignment: align_of::<PhoshCallsDBusCallsCallSkeletonClass>()}),
    ("PhoshCallsDBusObjectIface", Layout {size: size_of::<PhoshCallsDBusObjectIface>(), alignment: align_of::<PhoshCallsDBusObjectIface>()}),
    ("PhoshCallsDBusObjectManagerClientClass", Layout {size: size_of::<PhoshCallsDBusObjectManagerClientClass>(), alignment: align_of::<PhoshCallsDBusObjectManagerClientClass>()}),
    ("PhoshCallsDBusObjectProxyClass", Layout {size: size_of::<PhoshCallsDBusObjectProxyClass>(), alignment: align_of::<PhoshCallsDBusObjectProxyClass>()}),
    ("PhoshCallsDBusObjectSkeletonClass", Layout {size: size_of::<PhoshCallsDBusObjectSkeletonClass>(), alignment: align_of::<PhoshCallsDBusObjectSkeletonClass>()}),
    ("PhoshClampClass", Layout {size: size_of::<PhoshClampClass>(), alignment: align_of::<PhoshClampClass>()}),
    ("PhoshConnectivityInfoClass", Layout {size: size_of::<PhoshConnectivityInfoClass>(), alignment: align_of::<PhoshConnectivityInfoClass>()}),
    ("PhoshDBusColorIface", Layout {size: size_of::<PhoshDBusColorIface>(), alignment: align_of::<PhoshDBusColorIface>()}),
    ("PhoshDBusColorProxyClass", Layout {size: size_of::<PhoshDBusColorProxyClass>(), alignment: align_of::<PhoshDBusColorProxyClass>()}),
    ("PhoshDBusColorSkeletonClass", Layout {size: size_of::<PhoshDBusColorSkeletonClass>(), alignment: align_of::<PhoshDBusColorSkeletonClass>()}),
    ("PhoshDBusDisplayConfigIface", Layout {size: size_of::<PhoshDBusDisplayConfigIface>(), alignment: align_of::<PhoshDBusDisplayConfigIface>()}),
    ("PhoshDBusDisplayConfigProxyClass", Layout {size: size_of::<PhoshDBusDisplayConfigProxyClass>(), alignment: align_of::<PhoshDBusDisplayConfigProxyClass>()}),
    ("PhoshDBusDisplayConfigSkeletonClass", Layout {size: size_of::<PhoshDBusDisplayConfigSkeletonClass>(), alignment: align_of::<PhoshDBusDisplayConfigSkeletonClass>()}),
    ("PhoshDBusEndSessionDialogIface", Layout {size: size_of::<PhoshDBusEndSessionDialogIface>(), alignment: align_of::<PhoshDBusEndSessionDialogIface>()}),
    ("PhoshDBusEndSessionDialogProxyClass", Layout {size: size_of::<PhoshDBusEndSessionDialogProxyClass>(), alignment: align_of::<PhoshDBusEndSessionDialogProxyClass>()}),
    ("PhoshDBusEndSessionDialogSkeletonClass", Layout {size: size_of::<PhoshDBusEndSessionDialogSkeletonClass>(), alignment: align_of::<PhoshDBusEndSessionDialogSkeletonClass>()}),
    ("PhoshDBusGnomeShellIface", Layout {size: size_of::<PhoshDBusGnomeShellIface>(), alignment: align_of::<PhoshDBusGnomeShellIface>()}),
    ("PhoshDBusGnomeShellProxyClass", Layout {size: size_of::<PhoshDBusGnomeShellProxyClass>(), alignment: align_of::<PhoshDBusGnomeShellProxyClass>()}),
    ("PhoshDBusGnomeShellSkeletonClass", Layout {size: size_of::<PhoshDBusGnomeShellSkeletonClass>(), alignment: align_of::<PhoshDBusGnomeShellSkeletonClass>()}),
    ("PhoshDBusHostname1Iface", Layout {size: size_of::<PhoshDBusHostname1Iface>(), alignment: align_of::<PhoshDBusHostname1Iface>()}),
    ("PhoshDBusHostname1ProxyClass", Layout {size: size_of::<PhoshDBusHostname1ProxyClass>(), alignment: align_of::<PhoshDBusHostname1ProxyClass>()}),
    ("PhoshDBusHostname1SkeletonClass", Layout {size: size_of::<PhoshDBusHostname1SkeletonClass>(), alignment: align_of::<PhoshDBusHostname1SkeletonClass>()}),
    ("PhoshDBusImplPortalAccessIface", Layout {size: size_of::<PhoshDBusImplPortalAccessIface>(), alignment: align_of::<PhoshDBusImplPortalAccessIface>()}),
    ("PhoshDBusImplPortalAccessProxyClass", Layout {size: size_of::<PhoshDBusImplPortalAccessProxyClass>(), alignment: align_of::<PhoshDBusImplPortalAccessProxyClass>()}),
    ("PhoshDBusImplPortalAccessSkeletonClass", Layout {size: size_of::<PhoshDBusImplPortalAccessSkeletonClass>(), alignment: align_of::<PhoshDBusImplPortalAccessSkeletonClass>()}),
    ("PhoshDBusImplPortalRequestIface", Layout {size: size_of::<PhoshDBusImplPortalRequestIface>(), alignment: align_of::<PhoshDBusImplPortalRequestIface>()}),
    ("PhoshDBusImplPortalRequestProxyClass", Layout {size: size_of::<PhoshDBusImplPortalRequestProxyClass>(), alignment: align_of::<PhoshDBusImplPortalRequestProxyClass>()}),
    ("PhoshDBusImplPortalRequestSkeletonClass", Layout {size: size_of::<PhoshDBusImplPortalRequestSkeletonClass>(), alignment: align_of::<PhoshDBusImplPortalRequestSkeletonClass>()}),
    ("PhoshDBusLoginManagerIface", Layout {size: size_of::<PhoshDBusLoginManagerIface>(), alignment: align_of::<PhoshDBusLoginManagerIface>()}),
    ("PhoshDBusLoginManagerProxyClass", Layout {size: size_of::<PhoshDBusLoginManagerProxyClass>(), alignment: align_of::<PhoshDBusLoginManagerProxyClass>()}),
    ("PhoshDBusLoginManagerSkeletonClass", Layout {size: size_of::<PhoshDBusLoginManagerSkeletonClass>(), alignment: align_of::<PhoshDBusLoginManagerSkeletonClass>()}),
    ("PhoshDBusLoginSessionIface", Layout {size: size_of::<PhoshDBusLoginSessionIface>(), alignment: align_of::<PhoshDBusLoginSessionIface>()}),
    ("PhoshDBusLoginSessionProxyClass", Layout {size: size_of::<PhoshDBusLoginSessionProxyClass>(), alignment: align_of::<PhoshDBusLoginSessionProxyClass>()}),
    ("PhoshDBusLoginSessionSkeletonClass", Layout {size: size_of::<PhoshDBusLoginSessionSkeletonClass>(), alignment: align_of::<PhoshDBusLoginSessionSkeletonClass>()}),
    ("PhoshDBusMountOperationHandlerIface", Layout {size: size_of::<PhoshDBusMountOperationHandlerIface>(), alignment: align_of::<PhoshDBusMountOperationHandlerIface>()}),
    ("PhoshDBusMountOperationHandlerProxyClass", Layout {size: size_of::<PhoshDBusMountOperationHandlerProxyClass>(), alignment: align_of::<PhoshDBusMountOperationHandlerProxyClass>()}),
    ("PhoshDBusMountOperationHandlerSkeletonClass", Layout {size: size_of::<PhoshDBusMountOperationHandlerSkeletonClass>(), alignment: align_of::<PhoshDBusMountOperationHandlerSkeletonClass>()}),
    ("PhoshDBusOfonoManagerIface", Layout {size: size_of::<PhoshDBusOfonoManagerIface>(), alignment: align_of::<PhoshDBusOfonoManagerIface>()}),
    ("PhoshDBusOfonoManagerProxy", Layout {size: size_of::<PhoshDBusOfonoManagerProxy>(), alignment: align_of::<PhoshDBusOfonoManagerProxy>()}),
    ("PhoshDBusOfonoManagerProxyClass", Layout {size: size_of::<PhoshDBusOfonoManagerProxyClass>(), alignment: align_of::<PhoshDBusOfonoManagerProxyClass>()}),
    ("PhoshDBusOfonoManagerSkeleton", Layout {size: size_of::<PhoshDBusOfonoManagerSkeleton>(), alignment: align_of::<PhoshDBusOfonoManagerSkeleton>()}),
    ("PhoshDBusOfonoManagerSkeletonClass", Layout {size: size_of::<PhoshDBusOfonoManagerSkeletonClass>(), alignment: align_of::<PhoshDBusOfonoManagerSkeletonClass>()}),
    ("PhoshDBusOfonoNetworkRegistrationIface", Layout {size: size_of::<PhoshDBusOfonoNetworkRegistrationIface>(), alignment: align_of::<PhoshDBusOfonoNetworkRegistrationIface>()}),
    ("PhoshDBusOfonoNetworkRegistrationProxy", Layout {size: size_of::<PhoshDBusOfonoNetworkRegistrationProxy>(), alignment: align_of::<PhoshDBusOfonoNetworkRegistrationProxy>()}),
    ("PhoshDBusOfonoNetworkRegistrationProxyClass", Layout {size: size_of::<PhoshDBusOfonoNetworkRegistrationProxyClass>(), alignment: align_of::<PhoshDBusOfonoNetworkRegistrationProxyClass>()}),
    ("PhoshDBusOfonoNetworkRegistrationSkeleton", Layout {size: size_of::<PhoshDBusOfonoNetworkRegistrationSkeleton>(), alignment: align_of::<PhoshDBusOfonoNetworkRegistrationSkeleton>()}),
    ("PhoshDBusOfonoNetworkRegistrationSkeletonClass", Layout {size: size_of::<PhoshDBusOfonoNetworkRegistrationSkeletonClass>(), alignment: align_of::<PhoshDBusOfonoNetworkRegistrationSkeletonClass>()}),
    ("PhoshDBusOfonoSimManagerIface", Layout {size: size_of::<PhoshDBusOfonoSimManagerIface>(), alignment: align_of::<PhoshDBusOfonoSimManagerIface>()}),
    ("PhoshDBusOfonoSimManagerProxy", Layout {size: size_of::<PhoshDBusOfonoSimManagerProxy>(), alignment: align_of::<PhoshDBusOfonoSimManagerProxy>()}),
    ("PhoshDBusOfonoSimManagerProxyClass", Layout {size: size_of::<PhoshDBusOfonoSimManagerProxyClass>(), alignment: align_of::<PhoshDBusOfonoSimManagerProxyClass>()}),
    ("PhoshDBusOfonoSimManagerSkeleton", Layout {size: size_of::<PhoshDBusOfonoSimManagerSkeleton>(), alignment: align_of::<PhoshDBusOfonoSimManagerSkeleton>()}),
    ("PhoshDBusOfonoSimManagerSkeletonClass", Layout {size: size_of::<PhoshDBusOfonoSimManagerSkeletonClass>(), alignment: align_of::<PhoshDBusOfonoSimManagerSkeletonClass>()}),
    ("PhoshDBusScreenSaverIface", Layout {size: size_of::<PhoshDBusScreenSaverIface>(), alignment: align_of::<PhoshDBusScreenSaverIface>()}),
    ("PhoshDBusScreenSaverProxyClass", Layout {size: size_of::<PhoshDBusScreenSaverProxyClass>(), alignment: align_of::<PhoshDBusScreenSaverProxyClass>()}),
    ("PhoshDBusScreenSaverSkeletonClass", Layout {size: size_of::<PhoshDBusScreenSaverSkeletonClass>(), alignment: align_of::<PhoshDBusScreenSaverSkeletonClass>()}),
    ("PhoshDBusScreenshotIface", Layout {size: size_of::<PhoshDBusScreenshotIface>(), alignment: align_of::<PhoshDBusScreenshotIface>()}),
    ("PhoshDBusScreenshotProxyClass", Layout {size: size_of::<PhoshDBusScreenshotProxyClass>(), alignment: align_of::<PhoshDBusScreenshotProxyClass>()}),
    ("PhoshDBusScreenshotSkeletonClass", Layout {size: size_of::<PhoshDBusScreenshotSkeletonClass>(), alignment: align_of::<PhoshDBusScreenshotSkeletonClass>()}),
    ("PhoshDBusSensorProxyCompassIface", Layout {size: size_of::<PhoshDBusSensorProxyCompassIface>(), alignment: align_of::<PhoshDBusSensorProxyCompassIface>()}),
    ("PhoshDBusSensorProxyCompassProxyClass", Layout {size: size_of::<PhoshDBusSensorProxyCompassProxyClass>(), alignment: align_of::<PhoshDBusSensorProxyCompassProxyClass>()}),
    ("PhoshDBusSensorProxyCompassSkeletonClass", Layout {size: size_of::<PhoshDBusSensorProxyCompassSkeletonClass>(), alignment: align_of::<PhoshDBusSensorProxyCompassSkeletonClass>()}),
    ("PhoshDBusSensorProxyIface", Layout {size: size_of::<PhoshDBusSensorProxyIface>(), alignment: align_of::<PhoshDBusSensorProxyIface>()}),
    ("PhoshDBusSensorProxyProxyClass", Layout {size: size_of::<PhoshDBusSensorProxyProxyClass>(), alignment: align_of::<PhoshDBusSensorProxyProxyClass>()}),
    ("PhoshDBusSensorProxySkeletonClass", Layout {size: size_of::<PhoshDBusSensorProxySkeletonClass>(), alignment: align_of::<PhoshDBusSensorProxySkeletonClass>()}),
    ("PhoshDBusSessionManagerIface", Layout {size: size_of::<PhoshDBusSessionManagerIface>(), alignment: align_of::<PhoshDBusSessionManagerIface>()}),
    ("PhoshDBusSessionManagerProxyClass", Layout {size: size_of::<PhoshDBusSessionManagerProxyClass>(), alignment: align_of::<PhoshDBusSessionManagerProxyClass>()}),
    ("PhoshDBusSessionManagerSkeletonClass", Layout {size: size_of::<PhoshDBusSessionManagerSkeletonClass>(), alignment: align_of::<PhoshDBusSessionManagerSkeletonClass>()}),
    ("PhoshDockedInfoClass", Layout {size: size_of::<PhoshDockedInfoClass>(), alignment: align_of::<PhoshDockedInfoClass>()}),
    ("PhoshDockedManagerClass", Layout {size: size_of::<PhoshDockedManagerClass>(), alignment: align_of::<PhoshDockedManagerClass>()}),
    ("PhoshDragSurfaceDragMode", Layout {size: size_of::<PhoshDragSurfaceDragMode>(), alignment: align_of::<PhoshDragSurfaceDragMode>()}),
    ("PhoshDragSurfaceState", Layout {size: size_of::<PhoshDragSurfaceState>(), alignment: align_of::<PhoshDragSurfaceState>()}),
    ("PhoshEmergencyCallsIface", Layout {size: size_of::<PhoshEmergencyCallsIface>(), alignment: align_of::<PhoshEmergencyCallsIface>()}),
    ("PhoshEmergencyCallsProxyClass", Layout {size: size_of::<PhoshEmergencyCallsProxyClass>(), alignment: align_of::<PhoshEmergencyCallsProxyClass>()}),
    ("PhoshEmergencyCallsSkeletonClass", Layout {size: size_of::<PhoshEmergencyCallsSkeletonClass>(), alignment: align_of::<PhoshEmergencyCallsSkeletonClass>()}),
    ("PhoshEmergencyContactClass", Layout {size: size_of::<PhoshEmergencyContactClass>(), alignment: align_of::<PhoshEmergencyContactClass>()}),
    ("PhoshEmergencyContactRowClass", Layout {size: size_of::<PhoshEmergencyContactRowClass>(), alignment: align_of::<PhoshEmergencyContactRowClass>()}),
    ("PhoshEmergencyMenuClass", Layout {size: size_of::<PhoshEmergencyMenuClass>(), alignment: align_of::<PhoshEmergencyMenuClass>()}),
    ("PhoshEndSessionDialogClass", Layout {size: size_of::<PhoshEndSessionDialogClass>(), alignment: align_of::<PhoshEndSessionDialogClass>()}),
    ("PhoshFaderClass", Layout {size: size_of::<PhoshFaderClass>(), alignment: align_of::<PhoshFaderClass>()}),
    ("PhoshFadingLabelClass", Layout {size: size_of::<PhoshFadingLabelClass>(), alignment: align_of::<PhoshFadingLabelClass>()}),
    ("PhoshFavoriteListModelClass", Layout {size: size_of::<PhoshFavoriteListModelClass>(), alignment: align_of::<PhoshFavoriteListModelClass>()}),
    ("PhoshFeedbackInfoClass", Layout {size: size_of::<PhoshFeedbackInfoClass>(), alignment: align_of::<PhoshFeedbackInfoClass>()}),
    ("PhoshFeedbackManagerClass", Layout {size: size_of::<PhoshFeedbackManagerClass>(), alignment: align_of::<PhoshFeedbackManagerClass>()}),
    ("PhoshFolderInfoClass", Layout {size: size_of::<PhoshFolderInfoClass>(), alignment: align_of::<PhoshFolderInfoClass>()}),
    ("PhoshGeoClueDBusManagerIface", Layout {size: size_of::<PhoshGeoClueDBusManagerIface>(), alignment: align_of::<PhoshGeoClueDBusManagerIface>()}),
    ("PhoshGeoClueDBusManagerProxyClass", Layout {size: size_of::<PhoshGeoClueDBusManagerProxyClass>(), alignment: align_of::<PhoshGeoClueDBusManagerProxyClass>()}),
    ("PhoshGeoClueDBusManagerSkeletonClass", Layout {size: size_of::<PhoshGeoClueDBusManagerSkeletonClass>(), alignment: align_of::<PhoshGeoClueDBusManagerSkeletonClass>()}),
    ("PhoshGeoClueDBusOrgFreedesktopGeoClue2AgentIface", Layout {size: size_of::<PhoshGeoClueDBusOrgFreedesktopGeoClue2AgentIface>(), alignment: align_of::<PhoshGeoClueDBusOrgFreedesktopGeoClue2AgentIface>()}),
    ("PhoshGeoClueDBusOrgFreedesktopGeoClue2AgentProxyClass", Layout {size: size_of::<PhoshGeoClueDBusOrgFreedesktopGeoClue2AgentProxyClass>(), alignment: align_of::<PhoshGeoClueDBusOrgFreedesktopGeoClue2AgentProxyClass>()}),
    ("PhoshGeoClueDBusOrgFreedesktopGeoClue2AgentSkeletonClass", Layout {size: size_of::<PhoshGeoClueDBusOrgFreedesktopGeoClue2AgentSkeletonClass>(), alignment: align_of::<PhoshGeoClueDBusOrgFreedesktopGeoClue2AgentSkeletonClass>()}),
    ("PhoshGnomeShellManagerClass", Layout {size: size_of::<PhoshGnomeShellManagerClass>(), alignment: align_of::<PhoshGnomeShellManagerClass>()}),
    ("PhoshGtkMountManagerClass", Layout {size: size_of::<PhoshGtkMountManagerClass>(), alignment: align_of::<PhoshGtkMountManagerClass>()}),
    ("PhoshGtkMountPromptClass", Layout {size: size_of::<PhoshGtkMountPromptClass>(), alignment: align_of::<PhoshGtkMountPromptClass>()}),
    ("PhoshHeadClass", Layout {size: size_of::<PhoshHeadClass>(), alignment: align_of::<PhoshHeadClass>()}),
    ("PhoshHksDeviceType", Layout {size: size_of::<PhoshHksDeviceType>(), alignment: align_of::<PhoshHksDeviceType>()}),
    ("PhoshHksInfoClass", Layout {size: size_of::<PhoshHksInfoClass>(), alignment: align_of::<PhoshHksInfoClass>()}),
    ("PhoshHksManagerClass", Layout {size: size_of::<PhoshHksManagerClass>(), alignment: align_of::<PhoshHksManagerClass>()}),
    ("PhoshHomeState", Layout {size: size_of::<PhoshHomeState>(), alignment: align_of::<PhoshHomeState>()}),
    ("PhoshIdleDBusIdleMonitorIface", Layout {size: size_of::<PhoshIdleDBusIdleMonitorIface>(), alignment: align_of::<PhoshIdleDBusIdleMonitorIface>()}),
    ("PhoshIdleDBusIdleMonitorProxyClass", Layout {size: size_of::<PhoshIdleDBusIdleMonitorProxyClass>(), alignment: align_of::<PhoshIdleDBusIdleMonitorProxyClass>()}),
    ("PhoshIdleDBusIdleMonitorSkeletonClass", Layout {size: size_of::<PhoshIdleDBusIdleMonitorSkeletonClass>(), alignment: align_of::<PhoshIdleDBusIdleMonitorSkeletonClass>()}),
    ("PhoshIdleDBusObjectIface", Layout {size: size_of::<PhoshIdleDBusObjectIface>(), alignment: align_of::<PhoshIdleDBusObjectIface>()}),
    ("PhoshIdleDBusObjectManagerClientClass", Layout {size: size_of::<PhoshIdleDBusObjectManagerClientClass>(), alignment: align_of::<PhoshIdleDBusObjectManagerClientClass>()}),
    ("PhoshIdleDBusObjectProxyClass", Layout {size: size_of::<PhoshIdleDBusObjectProxyClass>(), alignment: align_of::<PhoshIdleDBusObjectProxyClass>()}),
    ("PhoshIdleDBusObjectSkeletonClass", Layout {size: size_of::<PhoshIdleDBusObjectSkeletonClass>(), alignment: align_of::<PhoshIdleDBusObjectSkeletonClass>()}),
    ("PhoshIdleManagerClass", Layout {size: size_of::<PhoshIdleManagerClass>(), alignment: align_of::<PhoshIdleManagerClass>()}),
    ("PhoshKeyboardEventsClass", Layout {size: size_of::<PhoshKeyboardEventsClass>(), alignment: align_of::<PhoshKeyboardEventsClass>()}),
    ("PhoshKeypadClass", Layout {size: size_of::<PhoshKeypadClass>(), alignment: align_of::<PhoshKeypadClass>()}),
    ("PhoshLayerSurface", Layout {size: size_of::<PhoshLayerSurface>(), alignment: align_of::<PhoshLayerSurface>()}),
    ("PhoshLayerSurfaceClass", Layout {size: size_of::<PhoshLayerSurfaceClass>(), alignment: align_of::<PhoshLayerSurfaceClass>()}),
    ("PhoshLayoutClockPosition", Layout {size: size_of::<PhoshLayoutClockPosition>(), alignment: align_of::<PhoshLayoutClockPosition>()}),
    ("PhoshLayoutManagerClass", Layout {size: size_of::<PhoshLayoutManagerClass>(), alignment: align_of::<PhoshLayoutManagerClass>()}),
    ("PhoshLocationInfoClass", Layout {size: size_of::<PhoshLocationInfoClass>(), alignment: align_of::<PhoshLocationInfoClass>()}),
    ("PhoshLocationManagerClass", Layout {size: size_of::<PhoshLocationManagerClass>(), alignment: align_of::<PhoshLocationManagerClass>()}),
    ("PhoshLockscreen", Layout {size: size_of::<PhoshLockscreen>(), alignment: align_of::<PhoshLockscreen>()}),
    ("PhoshLockscreenClass", Layout {size: size_of::<PhoshLockscreenClass>(), alignment: align_of::<PhoshLockscreenClass>()}),
    ("PhoshLockscreenManagerClass", Layout {size: size_of::<PhoshLockscreenManagerClass>(), alignment: align_of::<PhoshLockscreenManagerClass>()}),
    ("PhoshLockscreenPage", Layout {size: size_of::<PhoshLockscreenPage>(), alignment: align_of::<PhoshLockscreenPage>()}),
    ("PhoshLockshieldClass", Layout {size: size_of::<PhoshLockshieldClass>(), alignment: align_of::<PhoshLockshieldClass>()}),
    ("PhoshLogoutAction", Layout {size: size_of::<PhoshLogoutAction>(), alignment: align_of::<PhoshLogoutAction>()}),
    ("PhoshMediaPlayerClass", Layout {size: size_of::<PhoshMediaPlayerClass>(), alignment: align_of::<PhoshMediaPlayerClass>()}),
    ("PhoshMediaPlayerStatus", Layout {size: size_of::<PhoshMediaPlayerStatus>(), alignment: align_of::<PhoshMediaPlayerStatus>()}),
    ("PhoshModeHwFlags", Layout {size: size_of::<PhoshModeHwFlags>(), alignment: align_of::<PhoshModeHwFlags>()}),
    ("PhoshMonitorClass", Layout {size: size_of::<PhoshMonitorClass>(), alignment: align_of::<PhoshMonitorClass>()}),
    ("PhoshMonitorConnectorType", Layout {size: size_of::<PhoshMonitorConnectorType>(), alignment: align_of::<PhoshMonitorConnectorType>()}),
    ("PhoshMonitorManagerClass", Layout {size: size_of::<PhoshMonitorManagerClass>(), alignment: align_of::<PhoshMonitorManagerClass>()}),
    ("PhoshMonitorManagerConfigMethod", Layout {size: size_of::<PhoshMonitorManagerConfigMethod>(), alignment: align_of::<PhoshMonitorManagerConfigMethod>()}),
    ("PhoshMonitorMode", Layout {size: size_of::<PhoshMonitorMode>(), alignment: align_of::<PhoshMonitorMode>()}),
    ("PhoshMonitorPowerSaveMode", Layout {size: size_of::<PhoshMonitorPowerSaveMode>(), alignment: align_of::<PhoshMonitorPowerSaveMode>()}),
    ("PhoshMonitorTransform", Layout {size: size_of::<PhoshMonitorTransform>(), alignment: align_of::<PhoshMonitorTransform>()}),
    ("PhoshMountManagerClass", Layout {size: size_of::<PhoshMountManagerClass>(), alignment: align_of::<PhoshMountManagerClass>()}),
    ("PhoshMountOperationClass", Layout {size: size_of::<PhoshMountOperationClass>(), alignment: align_of::<PhoshMountOperationClass>()}),
    ("PhoshMprisDBusMediaPlayer2Iface", Layout {size: size_of::<PhoshMprisDBusMediaPlayer2Iface>(), alignment: align_of::<PhoshMprisDBusMediaPlayer2Iface>()}),
    ("PhoshMprisDBusMediaPlayer2PlayerIface", Layout {size: size_of::<PhoshMprisDBusMediaPlayer2PlayerIface>(), alignment: align_of::<PhoshMprisDBusMediaPlayer2PlayerIface>()}),
    ("PhoshMprisDBusMediaPlayer2PlayerProxyClass", Layout {size: size_of::<PhoshMprisDBusMediaPlayer2PlayerProxyClass>(), alignment: align_of::<PhoshMprisDBusMediaPlayer2PlayerProxyClass>()}),
    ("PhoshMprisDBusMediaPlayer2PlayerSkeletonClass", Layout {size: size_of::<PhoshMprisDBusMediaPlayer2PlayerSkeletonClass>(), alignment: align_of::<PhoshMprisDBusMediaPlayer2PlayerSkeletonClass>()}),
    ("PhoshMprisDBusMediaPlayer2ProxyClass", Layout {size: size_of::<PhoshMprisDBusMediaPlayer2ProxyClass>(), alignment: align_of::<PhoshMprisDBusMediaPlayer2ProxyClass>()}),
    ("PhoshMprisDBusMediaPlayer2SkeletonClass", Layout {size: size_of::<PhoshMprisDBusMediaPlayer2SkeletonClass>(), alignment: align_of::<PhoshMprisDBusMediaPlayer2SkeletonClass>()}),
    ("PhoshNetworkAuthManagerClass", Layout {size: size_of::<PhoshNetworkAuthManagerClass>(), alignment: align_of::<PhoshNetworkAuthManagerClass>()}),
    ("PhoshNotificationBannerClass", Layout {size: size_of::<PhoshNotificationBannerClass>(), alignment: align_of::<PhoshNotificationBannerClass>()}),
    ("PhoshNotificationContentClass", Layout {size: size_of::<PhoshNotificationContentClass>(), alignment: align_of::<PhoshNotificationContentClass>()}),
    ("PhoshNotificationFrameClass", Layout {size: size_of::<PhoshNotificationFrameClass>(), alignment: align_of::<PhoshNotificationFrameClass>()}),
    ("PhoshNotificationListClass", Layout {size: size_of::<PhoshNotificationListClass>(), alignment: align_of::<PhoshNotificationListClass>()}),
    ("PhoshNotificationReason", Layout {size: size_of::<PhoshNotificationReason>(), alignment: align_of::<PhoshNotificationReason>()}),
    ("PhoshNotificationSourceClass", Layout {size: size_of::<PhoshNotificationSourceClass>(), alignment: align_of::<PhoshNotificationSourceClass>()}),
    ("PhoshNotificationUrgency", Layout {size: size_of::<PhoshNotificationUrgency>(), alignment: align_of::<PhoshNotificationUrgency>()}),
    ("PhoshNotifyDBusNotificationsIface", Layout {size: size_of::<PhoshNotifyDBusNotificationsIface>(), alignment: align_of::<PhoshNotifyDBusNotificationsIface>()}),
    ("PhoshNotifyDBusNotificationsProxyClass", Layout {size: size_of::<PhoshNotifyDBusNotificationsProxyClass>(), alignment: align_of::<PhoshNotifyDBusNotificationsProxyClass>()}),
    ("PhoshNotifyDBusNotificationsSkeletonClass", Layout {size: size_of::<PhoshNotifyDBusNotificationsSkeletonClass>(), alignment: align_of::<PhoshNotifyDBusNotificationsSkeletonClass>()}),
    ("PhoshNotifyFeedbackClass", Layout {size: size_of::<PhoshNotifyFeedbackClass>(), alignment: align_of::<PhoshNotifyFeedbackClass>()}),
    ("PhoshNotifyManagerClass", Layout {size: size_of::<PhoshNotifyManagerClass>(), alignment: align_of::<PhoshNotifyManagerClass>()}),
    ("PhoshNotifyScreenWakeupFlags", Layout {size: size_of::<PhoshNotifyScreenWakeupFlags>(), alignment: align_of::<PhoshNotifyScreenWakeupFlags>()}),
    ("PhoshOsdWindowClass", Layout {size: size_of::<PhoshOsdWindowClass>(), alignment: align_of::<PhoshOsdWindowClass>()}),
    ("PhoshOsk0SmPuriOSK0Iface", Layout {size: size_of::<PhoshOsk0SmPuriOSK0Iface>(), alignment: align_of::<PhoshOsk0SmPuriOSK0Iface>()}),
    ("PhoshOsk0SmPuriOSK0ProxyClass", Layout {size: size_of::<PhoshOsk0SmPuriOSK0ProxyClass>(), alignment: align_of::<PhoshOsk0SmPuriOSK0ProxyClass>()}),
    ("PhoshOsk0SmPuriOSK0SkeletonClass", Layout {size: size_of::<PhoshOsk0SmPuriOSK0SkeletonClass>(), alignment: align_of::<PhoshOsk0SmPuriOSK0SkeletonClass>()}),
    ("PhoshOskButtonClass", Layout {size: size_of::<PhoshOskButtonClass>(), alignment: align_of::<PhoshOskButtonClass>()}),
    ("PhoshOskManagerClass", Layout {size: size_of::<PhoshOskManagerClass>(), alignment: align_of::<PhoshOskManagerClass>()}),
    ("PhoshOverviewClass", Layout {size: size_of::<PhoshOverviewClass>(), alignment: align_of::<PhoshOverviewClass>()}),
    ("PhoshPasswordEntryClass", Layout {size: size_of::<PhoshPasswordEntryClass>(), alignment: align_of::<PhoshPasswordEntryClass>()}),
    ("PhoshPluginLoaderClass", Layout {size: size_of::<PhoshPluginLoaderClass>(), alignment: align_of::<PhoshPluginLoaderClass>()}),
    ("PhoshPolkitAuthPromptClass", Layout {size: size_of::<PhoshPolkitAuthPromptClass>(), alignment: align_of::<PhoshPolkitAuthPromptClass>()}),
    ("PhoshPortalAccessManagerClass", Layout {size: size_of::<PhoshPortalAccessManagerClass>(), alignment: align_of::<PhoshPortalAccessManagerClass>()}),
    ("PhoshPortalRequestClass", Layout {size: size_of::<PhoshPortalRequestClass>(), alignment: align_of::<PhoshPortalRequestClass>()}),
    ("PhoshPowerMenuClass", Layout {size: size_of::<PhoshPowerMenuClass>(), alignment: align_of::<PhoshPowerMenuClass>()}),
    ("PhoshPowerMenuManagerClass", Layout {size: size_of::<PhoshPowerMenuManagerClass>(), alignment: align_of::<PhoshPowerMenuManagerClass>()}),
    ("PhoshProximityClass", Layout {size: size_of::<PhoshProximityClass>(), alignment: align_of::<PhoshProximityClass>()}),
    ("PhoshQuickSetting", Layout {size: size_of::<PhoshQuickSetting>(), alignment: align_of::<PhoshQuickSetting>()}),
    ("PhoshQuickSettingClass", Layout {size: size_of::<PhoshQuickSettingClass>(), alignment: align_of::<PhoshQuickSettingClass>()}),
    ("PhoshQuickSettingsBoxClass", Layout {size: size_of::<PhoshQuickSettingsBoxClass>(), alignment: align_of::<PhoshQuickSettingsBoxClass>()}),
    ("PhoshQuickSettingsClass", Layout {size: size_of::<PhoshQuickSettingsClass>(), alignment: align_of::<PhoshQuickSettingsClass>()}),
    ("PhoshRevealerClass", Layout {size: size_of::<PhoshRevealerClass>(), alignment: align_of::<PhoshRevealerClass>()}),
    ("PhoshRfkillDBusRfkillIface", Layout {size: size_of::<PhoshRfkillDBusRfkillIface>(), alignment: align_of::<PhoshRfkillDBusRfkillIface>()}),
    ("PhoshRfkillDBusRfkillProxyClass", Layout {size: size_of::<PhoshRfkillDBusRfkillProxyClass>(), alignment: align_of::<PhoshRfkillDBusRfkillProxyClass>()}),
    ("PhoshRfkillDBusRfkillSkeletonClass", Layout {size: size_of::<PhoshRfkillDBusRfkillSkeletonClass>(), alignment: align_of::<PhoshRfkillDBusRfkillSkeletonClass>()}),
    ("PhoshRotateInfoClass", Layout {size: size_of::<PhoshRotateInfoClass>(), alignment: align_of::<PhoshRotateInfoClass>()}),
    ("PhoshRotateInfoMode", Layout {size: size_of::<PhoshRotateInfoMode>(), alignment: align_of::<PhoshRotateInfoMode>()}),
    ("PhoshRotationManagerClass", Layout {size: size_of::<PhoshRotationManagerClass>(), alignment: align_of::<PhoshRotationManagerClass>()}),
    ("PhoshRotationManagerMode", Layout {size: size_of::<PhoshRotationManagerMode>(), alignment: align_of::<PhoshRotationManagerMode>()}),
    ("PhoshRunCommandDialogClass", Layout {size: size_of::<PhoshRunCommandDialogClass>(), alignment: align_of::<PhoshRunCommandDialogClass>()}),
    ("PhoshRunCommandManagerClass", Layout {size: size_of::<PhoshRunCommandManagerClass>(), alignment: align_of::<PhoshRunCommandManagerClass>()}),
    ("PhoshScreenSaverManagerClass", Layout {size: size_of::<PhoshScreenSaverManagerClass>(), alignment: align_of::<PhoshScreenSaverManagerClass>()}),
    ("PhoshScreenshotManagerClass", Layout {size: size_of::<PhoshScreenshotManagerClass>(), alignment: align_of::<PhoshScreenshotManagerClass>()}),
    ("PhoshSensorProxyManagerClass", Layout {size: size_of::<PhoshSensorProxyManagerClass>(), alignment: align_of::<PhoshSensorProxyManagerClass>()}),
    ("PhoshSessionClientPrivateDBusClientPrivateIface", Layout {size: size_of::<PhoshSessionClientPrivateDBusClientPrivateIface>(), alignment: align_of::<PhoshSessionClientPrivateDBusClientPrivateIface>()}),
    ("PhoshSessionClientPrivateDBusClientPrivateProxyClass", Layout {size: size_of::<PhoshSessionClientPrivateDBusClientPrivateProxyClass>(), alignment: align_of::<PhoshSessionClientPrivateDBusClientPrivateProxyClass>()}),
    ("PhoshSessionClientPrivateDBusClientPrivateSkeletonClass", Layout {size: size_of::<PhoshSessionClientPrivateDBusClientPrivateSkeletonClass>(), alignment: align_of::<PhoshSessionClientPrivateDBusClientPrivateSkeletonClass>()}),
    ("PhoshSessionManagerClass", Layout {size: size_of::<PhoshSessionManagerClass>(), alignment: align_of::<PhoshSessionManagerClass>()}),
    ("PhoshSessionManagerFlags", Layout {size: size_of::<PhoshSessionManagerFlags>(), alignment: align_of::<PhoshSessionManagerFlags>()}),
    ("PhoshSessionPresenceClass", Layout {size: size_of::<PhoshSessionPresenceClass>(), alignment: align_of::<PhoshSessionPresenceClass>()}),
    ("PhoshSessionPresenceDBusPresenceIface", Layout {size: size_of::<PhoshSessionPresenceDBusPresenceIface>(), alignment: align_of::<PhoshSessionPresenceDBusPresenceIface>()}),
    ("PhoshSessionPresenceDBusPresenceProxyClass", Layout {size: size_of::<PhoshSessionPresenceDBusPresenceProxyClass>(), alignment: align_of::<PhoshSessionPresenceDBusPresenceProxyClass>()}),
    ("PhoshSessionPresenceDBusPresenceSkeletonClass", Layout {size: size_of::<PhoshSessionPresenceDBusPresenceSkeletonClass>(), alignment: align_of::<PhoshSessionPresenceDBusPresenceSkeletonClass>()}),
    ("PhoshSessionPresenceStatus", Layout {size: size_of::<PhoshSessionPresenceStatus>(), alignment: align_of::<PhoshSessionPresenceStatus>()}),
    ("PhoshShell", Layout {size: size_of::<PhoshShell>(), alignment: align_of::<PhoshShell>()}),
    ("PhoshShellActionMode", Layout {size: size_of::<PhoshShellActionMode>(), alignment: align_of::<PhoshShellActionMode>()}),
    ("PhoshShellClass", Layout {size: size_of::<PhoshShellClass>(), alignment: align_of::<PhoshShellClass>()}),
    ("PhoshShellDebugFlags", Layout {size: size_of::<PhoshShellDebugFlags>(), alignment: align_of::<PhoshShellDebugFlags>()}),
    ("PhoshShellKeyBindingFlags", Layout {size: size_of::<PhoshShellKeyBindingFlags>(), alignment: align_of::<PhoshShellKeyBindingFlags>()}),
    ("PhoshShellLayout", Layout {size: size_of::<PhoshShellLayout>(), alignment: align_of::<PhoshShellLayout>()}),
    ("PhoshShellStateFlags", Layout {size: size_of::<PhoshShellStateFlags>(), alignment: align_of::<PhoshShellStateFlags>()}),
    ("PhoshSplashClass", Layout {size: size_of::<PhoshSplashClass>(), alignment: align_of::<PhoshSplashClass>()}),
    ("PhoshSplashManagerClass", Layout {size: size_of::<PhoshSplashManagerClass>(), alignment: align_of::<PhoshSplashManagerClass>()}),
    ("PhoshStatusIcon", Layout {size: size_of::<PhoshStatusIcon>(), alignment: align_of::<PhoshStatusIcon>()}),
    ("PhoshStatusIconClass", Layout {size: size_of::<PhoshStatusIconClass>(), alignment: align_of::<PhoshStatusIconClass>()}),
    ("PhoshStatusPage", Layout {size: size_of::<PhoshStatusPage>(), alignment: align_of::<PhoshStatusPage>()}),
    ("PhoshStatusPageClass", Layout {size: size_of::<PhoshStatusPageClass>(), alignment: align_of::<PhoshStatusPageClass>()}),
    ("PhoshStatusPagePlaceholderClass", Layout {size: size_of::<PhoshStatusPagePlaceholderClass>(), alignment: align_of::<PhoshStatusPagePlaceholderClass>()}),
    ("PhoshStyleManagerClass", Layout {size: size_of::<PhoshStyleManagerClass>(), alignment: align_of::<PhoshStyleManagerClass>()}),
    ("PhoshSwipeAwayBinClass", Layout {size: size_of::<PhoshSwipeAwayBinClass>(), alignment: align_of::<PhoshSwipeAwayBinClass>()}),
    ("PhoshSystemModalClass", Layout {size: size_of::<PhoshSystemModalClass>(), alignment: align_of::<PhoshSystemModalClass>()}),
    ("PhoshSystemModalDialogClass", Layout {size: size_of::<PhoshSystemModalDialogClass>(), alignment: align_of::<PhoshSystemModalDialogClass>()}),
    ("PhoshTimestampLabelClass", Layout {size: size_of::<PhoshTimestampLabelClass>(), alignment: align_of::<PhoshTimestampLabelClass>()}),
    ("PhoshTopPanelBgClass", Layout {size: size_of::<PhoshTopPanelBgClass>(), alignment: align_of::<PhoshTopPanelBgClass>()}),
    ("PhoshTopPanelState", Layout {size: size_of::<PhoshTopPanelState>(), alignment: align_of::<PhoshTopPanelState>()}),
    ("PhoshToplevelClass", Layout {size: size_of::<PhoshToplevelClass>(), alignment: align_of::<PhoshToplevelClass>()}),
    ("PhoshToplevelManagerClass", Layout {size: size_of::<PhoshToplevelManagerClass>(), alignment: align_of::<PhoshToplevelManagerClass>()}),
    ("PhoshTorchInfoClass", Layout {size: size_of::<PhoshTorchInfoClass>(), alignment: align_of::<PhoshTorchInfoClass>()}),
    ("PhoshVpnInfoClass", Layout {size: size_of::<PhoshVpnInfoClass>(), alignment: align_of::<PhoshVpnInfoClass>()}),
    ("PhoshVpnManagerClass", Layout {size: size_of::<PhoshVpnManagerClass>(), alignment: align_of::<PhoshVpnManagerClass>()}),
    ("PhoshWWanBackend", Layout {size: size_of::<PhoshWWanBackend>(), alignment: align_of::<PhoshWWanBackend>()}),
    ("PhoshWWanInfoClass", Layout {size: size_of::<PhoshWWanInfoClass>(), alignment: align_of::<PhoshWWanInfoClass>()}),
    ("PhoshWWanInterface", Layout {size: size_of::<PhoshWWanInterface>(), alignment: align_of::<PhoshWWanInterface>()}),
    ("PhoshWWanMMClass", Layout {size: size_of::<PhoshWWanMMClass>(), alignment: align_of::<PhoshWWanMMClass>()}),
    ("PhoshWWanManagerClass", Layout {size: size_of::<PhoshWWanManagerClass>(), alignment: align_of::<PhoshWWanManagerClass>()}),
    ("PhoshWWanOfonoClass", Layout {size: size_of::<PhoshWWanOfonoClass>(), alignment: align_of::<PhoshWWanOfonoClass>()}),
    ("PhoshWallClock", Layout {size: size_of::<PhoshWallClock>(), alignment: align_of::<PhoshWallClock>()}),
    ("PhoshWallClockClass", Layout {size: size_of::<PhoshWallClockClass>(), alignment: align_of::<PhoshWallClockClass>()}),
    ("PhoshWaylandClass", Layout {size: size_of::<PhoshWaylandClass>(), alignment: align_of::<PhoshWaylandClass>()}),
    ("PhoshWaylandSeatCapabilities", Layout {size: size_of::<PhoshWaylandSeatCapabilities>(), alignment: align_of::<PhoshWaylandSeatCapabilities>()}),
    ("PhoshWidgetBoxClass", Layout {size: size_of::<PhoshWidgetBoxClass>(), alignment: align_of::<PhoshWidgetBoxClass>()}),
    ("PhoshWifiInfoClass", Layout {size: size_of::<PhoshWifiInfoClass>(), alignment: align_of::<PhoshWifiInfoClass>()}),
    ("PhoshWifiManagerClass", Layout {size: size_of::<PhoshWifiManagerClass>(), alignment: align_of::<PhoshWifiManagerClass>()}),
    ("PhoshWifiNetworkClass", Layout {size: size_of::<PhoshWifiNetworkClass>(), alignment: align_of::<PhoshWifiNetworkClass>()}),
    ("PhoshWifiNetworkRowClass", Layout {size: size_of::<PhoshWifiNetworkRowClass>(), alignment: align_of::<PhoshWifiNetworkRowClass>()}),
    ("PhoshWifiStatusPageClass", Layout {size: size_of::<PhoshWifiStatusPageClass>(), alignment: align_of::<PhoshWifiStatusPageClass>()}),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) PHOSH_ANIMATION_TYPE_EASE_IN_QUINTIC", "1"),
    ("(gint) PHOSH_ANIMATION_TYPE_EASE_OUT_BOUNCE", "3"),
    ("(gint) PHOSH_ANIMATION_TYPE_EASE_OUT_CUBIC", "0"),
    ("(gint) PHOSH_ANIMATION_TYPE_EASE_OUT_QUINTIC", "2"),
    ("PHOSH_APP_AUTH_PROMPT_CHOICES_FORMAT", "a(ssa(ss)s)"),
    ("(guint) PHOSH_APP_FILTER_MODE_FLAGS_ADAPTIVE", "1"),
    ("(guint) PHOSH_APP_FILTER_MODE_FLAGS_NONE", "0"),
    ("(gint) PHOSH_APP_GRID_BUTTON_FAVORITES", "1"),
    ("(gint) PHOSH_APP_GRID_BUTTON_LAUNCHER", "0"),
    ("PHOSH_APP_UNKNOWN_ICON", "app-icon-unknown"),
    ("(gint) PHOSH_DRAG_SURFACE_DRAG_MODE_FULL", "0"),
    ("(gint) PHOSH_DRAG_SURFACE_DRAG_MODE_HANDLE", "1"),
    ("(gint) PHOSH_DRAG_SURFACE_DRAG_MODE_NONE", "2"),
    ("(gint) PHOSH_DRAG_SURFACE_STATE_DRAGGED", "2"),
    ("(gint) PHOSH_DRAG_SURFACE_STATE_FOLDED", "0"),
    ("(gint) PHOSH_DRAG_SURFACE_STATE_UNFOLDED", "1"),
    ("(gint) PHOSH_END_SESSION_ACTION_LOGOUT", "0"),
    ("(gint) PHOSH_END_SESSION_ACTION_REBOOT", "2"),
    ("(gint) PHOSH_END_SESSION_ACTION_SHUTDOWN", "1"),
    ("PHOSH_EXTENSION_POINT_LOCKSCREEN_WIDGET", "phosh-lockscreen-widget"),
    ("PHOSH_EXTENSION_POINT_QUICK_SETTING_WIDGET", "phosh-quick-setting-widget"),
    ("PHOSH_FOLDERS_SCHEMA_ID", "org.gnome.desktop.app-folders"),
    ("(gint) PHOSH_HKS_TYPE_MIC", "10"),
    ("PHOSH_HOME_BAR_HEIGHT", "15"),
    ("(gint) PHOSH_HOME_STATE_FOLDED", "0"),
    ("(gint) PHOSH_HOME_STATE_UNFOLDED", "1"),
    ("(gint) PHOSH_LAYOUT_CLOCK_POS_CENTER", "0"),
    ("(gint) PHOSH_LAYOUT_CLOCK_POS_LEFT", "1"),
    ("(gint) PHOSH_LAYOUT_CLOCK_POS_RIGHT", "2"),
    ("(gint) PHOSH_LOCKSCREEN_PAGE_EXTRA", "1"),
    ("(gint) PHOSH_LOCKSCREEN_PAGE_INFO", "0"),
    ("(gint) PHOSH_LOCKSCREEN_PAGE_UNLOCK", "2"),
    ("(gint) PHOSH_MEDIA_PLAYER_STATUS_PAUSED", "1"),
    ("(gint) PHOSH_MEDIA_PLAYER_STATUS_PLAYING", "2"),
    ("(gint) PHOSH_MEDIA_PLAYER_STATUS_STOPPED", "0"),
    ("PHOSH_MODE_DOCKED_PHONE_MASK", "10"),
    ("(guint) PHOSH_MODE_HW_EXT_DISPLAY", "2"),
    ("(guint) PHOSH_MODE_HW_KEYBOARD", "4"),
    ("(guint) PHOSH_MODE_HW_NONE", "0"),
    ("(guint) PHOSH_MODE_HW_POINTER", "8"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_9PinDIN", "9"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_Component", "8"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_Composite", "5"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_DSI", "16"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_DVIA", "4"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_DVID", "3"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_DVII", "2"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_DisplayPort", "10"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_HDMIA", "11"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_HDMIB", "12"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_LVDS", "7"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_SVIDEO", "6"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_TV", "13"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_Unknown", "0"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_VGA", "1"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_VIRTUAL", "15"),
    ("(gint) PHOSH_MONITOR_CONNECTOR_TYPE_eDP", "14"),
    ("(gint) PHOSH_MONITOR_MANAGER_CONFIG_METHOD_PERSISTENT", "2"),
    ("(gint) PHOSH_MONITOR_MANAGER_CONFIG_METHOD_TEMPORARY", "1"),
    ("(gint) PHOSH_MONITOR_MANAGER_CONFIG_METHOD_VERIFY", "0"),
    ("(gint) PHOSH_MONITOR_POWER_SAVE_MODE_OFF", "0"),
    ("(gint) PHOSH_MONITOR_POWER_SAVE_MODE_ON", "1"),
    ("(gint) PHOSH_MONITOR_TRANSFORM_180", "2"),
    ("(gint) PHOSH_MONITOR_TRANSFORM_270", "3"),
    ("(gint) PHOSH_MONITOR_TRANSFORM_90", "1"),
    ("(gint) PHOSH_MONITOR_TRANSFORM_FLIPPED", "4"),
    ("(gint) PHOSH_MONITOR_TRANSFORM_FLIPPED_180", "6"),
    ("(gint) PHOSH_MONITOR_TRANSFORM_FLIPPED_270", "7"),
    ("(gint) PHOSH_MONITOR_TRANSFORM_FLIPPED_90", "5"),
    ("(gint) PHOSH_MONITOR_TRANSFORM_NORMAL", "0"),
    ("PHOSH_NOTIFICATIONS_SCHEMA_ID", "org.gnome.desktop.notifications"),
    ("PHOSH_NOTIFICATION_DEFAULT_ACTION", "default"),
    ("PHOSH_NOTIFICATION_DEFAULT_TIMEOUT", "5000"),
    ("(gint) PHOSH_NOTIFICATION_REASON_CLOSED", "3"),
    ("(gint) PHOSH_NOTIFICATION_REASON_DISMISSED", "2"),
    ("(gint) PHOSH_NOTIFICATION_REASON_EXPIRED", "1"),
    ("(gint) PHOSH_NOTIFICATION_REASON_UNDEFINED", "4"),
    ("(gint) PHOSH_NOTIFICATION_URGENCY_CRITICAL", "2"),
    ("(gint) PHOSH_NOTIFICATION_URGENCY_LOW", "0"),
    ("(gint) PHOSH_NOTIFICATION_URGENCY_NORMAL", "1"),
    ("(guint) PHOSH_NOTIFY_SCREEN_WAKEUP_FLAG_ANY", "1"),
    ("(guint) PHOSH_NOTIFY_SCREEN_WAKEUP_FLAG_CATEGORY", "4"),
    ("(guint) PHOSH_NOTIFY_SCREEN_WAKEUP_FLAG_URGENCY", "2"),
    ("(gint) PHOSH_ROTATE_INFO_MODE_LOCK", "0"),
    ("(gint) PHOSH_ROTATE_INFO_MODE_TOGGLE", "1"),
    ("(gint) PHOSH_ROTATION_MANAGER_MODE_OFF", "0"),
    ("(gint) PHOSH_ROTATION_MANAGER_MODE_SENSOR", "1"),
    ("(guint) PHOSH_SESSION_INHIBIT_AUTOMOUNT", "16"),
    ("(guint) PHOSH_SESSION_INHIBIT_IDLE", "8"),
    ("(guint) PHOSH_SESSION_INHIBIT_LOGOUT", "1"),
    ("(guint) PHOSH_SESSION_INHIBIT_SUSPEND", "4"),
    ("(guint) PHOSH_SESSION_INHIBIT_USER_SWITCH", "2"),
    ("(guint) PHOSH_SHELL_ACTION_MODE_ALL", "4294967295"),
    ("(guint) PHOSH_SHELL_ACTION_MODE_LOCK_SCREEN", "4"),
    ("(guint) PHOSH_SHELL_ACTION_MODE_LOGIN_SCREEN", "16"),
    ("(guint) PHOSH_SHELL_ACTION_MODE_LOOKING_GLASS", "64"),
    ("(guint) PHOSH_SHELL_ACTION_MODE_NONE", "0"),
    ("(guint) PHOSH_SHELL_ACTION_MODE_NORMAL", "1"),
    ("(guint) PHOSH_SHELL_ACTION_MODE_OVERVIEW", "2"),
    ("(guint) PHOSH_SHELL_ACTION_MODE_POPUP", "128"),
    ("(guint) PHOSH_SHELL_ACTION_MODE_SYSTEM_MODAL", "32"),
    ("(guint) PHOSH_SHELL_ACTION_MODE_UNLOCK_SCREEN", "8"),
    ("(guint) PHOSH_SHELL_DEBUG_FLAG_ALWAYS_SPLASH", "1"),
    ("(guint) PHOSH_SHELL_DEBUG_FLAG_FAKE_BUILTIN", "2"),
    ("(guint) PHOSH_SHELL_DEBUG_FLAG_NONE", "0"),
    ("(guint) PHOSH_SHELL_KEY_BINDING_BUILTIN", "2"),
    ("(guint) PHOSH_SHELL_KEY_BINDING_IGNORE_AUTOREPEAT", "16"),
    ("(guint) PHOSH_SHELL_KEY_BINDING_IS_REVERSED", "4"),
    ("(guint) PHOSH_SHELL_KEY_BINDING_NONE", "0"),
    ("(guint) PHOSH_SHELL_KEY_BINDING_NON_MASKABLE", "8"),
    ("(guint) PHOSH_SHELL_KEY_BINDING_NO_AUTO_GRAB", "32"),
    ("(guint) PHOSH_SHELL_KEY_BINDING_PER_WINDOW", "1"),
    ("(gint) PHOSH_SHELL_LAYOUT_DEVICE", "1"),
    ("(gint) PHOSH_SHELL_LAYOUT_NONE", "0"),
    ("(guint) PHOSH_STATE_BLANKED", "2"),
    ("(guint) PHOSH_STATE_LOCKED", "4"),
    ("(guint) PHOSH_STATE_MODAL_SYSTEM_PROMPT", "1"),
    ("(guint) PHOSH_STATE_NONE", "0"),
    ("(guint) PHOSH_STATE_OVERVIEW", "16"),
    ("(guint) PHOSH_STATE_SETTINGS", "8"),
    ("PHOSH_TOP_BAR_HEIGHT", "32"),
    ("PHOSH_TOP_BAR_MIN_PADDING", "9"),
    ("(gint) PHOSH_TOP_PANEL_STATE_FOLDED", "0"),
    ("(gint) PHOSH_TOP_PANEL_STATE_UNFOLDED", "1"),
    ("(guint) PHOSH_WAYLAND_SEAT_CAPABILITY_KEYBOARD", "2"),
    ("(guint) PHOSH_WAYLAND_SEAT_CAPABILITY_LID_SWITCH", "512"),
    ("(guint) PHOSH_WAYLAND_SEAT_CAPABILITY_NONE", "0"),
    ("(guint) PHOSH_WAYLAND_SEAT_CAPABILITY_POINTER", "1"),
    ("(guint) PHOSH_WAYLAND_SEAT_CAPABILITY_TABLET_MODE_SWITCH", "256"),
    ("(guint) PHOSH_WAYLAND_SEAT_CAPABILITY_TOUCH", "4"),
    ("(gint) PHOSH_WWAN_BACKEND_MM", "0"),
    ("(gint) PHOSH_WWAN_BACKEND_OFONO", "1"),
];


