# Find the LMGC includes and libraries.
# The following variables are set if LMGC is found.  If LMGC is not
# found, LMGC_FOUND is set to false.
#  LMGC_FOUND        - True when the LMGC include directory is found.
#  LMGC_INCLUDE_DIRS - the path to where the Siconos LMGC include files are.
#  LMGC_LIBRARY_DIRS - The path to where the Siconos library files are.
#  LMGC_LIBRARIES    - The libraries to link against Siconos LMGC

# One may want to use a specific LMGC Library by setting
# LMGC_LIBRARY_DIRECTORY before FIND_PACKAGE(LMGC)
INCLUDE(FindPackageHandleStandardArgs)

IF(LMGC_LIBRARY_DIRECTORY)
  FIND_LIBRARY(LMGC_LIBRARY lmgc PATHS "${LMGC_LIBRARY_DIRECTORY}")
ELSE(LMGC_LIBRARY_DIRECTORY)
  FIND_LIBRARY(LMGC_LIBRARY lmgc)
ENDIF(LMGC_LIBRARY_DIRECTORY)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(LMGC
  REQUIRED_VARS LMGC_LIBRARY)

IF(LMGC_LIBRARY)
  GET_FILENAME_COMPONENT(LMGC_LIBRARY_DIRS ${LMGC_LIBRARY} PATH)
  SET(LMGC_LIBRARIES ${LMGC_LIBRARY})
  GET_FILENAME_COMPONENT(LMGC_LIBRARY_DIRS_DIR ${LMGC_LIBRARY_DIRS} PATH)
  SET(LMGC_INCLUDE_DIRS ${LMGC_LIBRARY_DIRS_DIR}/include/LMGC90)
  MESSAGE(STATUS "LMGC found")
  MESSAGE(STATUS "LMGC_INCLUDE_DIRS : ${LMGC_INCLUDE_DIRS}")
  MESSAGE(STATUS "LMGC_LIBRARY_DIRS : ${LMGC_LIBRARY_DIRS}")
  MESSAGE(STATUS "LMGC_LIBRARIES : ${LMGC_LIBRARIES}")
ELSE(LMGC_LIBRARY)
  IF(LMGC_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR
      "Required LMGC library not found. Please specify library location in LMGC_LIBRARY_DIRECTORY")
  ENDIF(LMGC_FIND_REQUIRED)
ENDIF(LMGC_LIBRARY)
