#include <string>
#include <tr1/memory>
#include <gtkmm.h>
#include <sigx/sigx.h>
#include "resolver.h"


class TheGUI: public Gtk::Window, public sigx::glib_auto_dispatchable
{
private:
	/*	An info dialog that gets displayed if the resolver does not
	 *	stop in a timely fashion
	 */
	class InfoDialog: public Gtk::Dialog
	{
	public:
		typedef std::tr1::shared_ptr<InfoDialog> threadsafe_type;

	public:
		InfoDialog(Gtk::Window& parent);
	};


public:
	TheGUI();


private:
	// virtuals from Gtk::Widget
	virtual bool on_delete_event(GdkEventAny*);

	void on_gui_ready();
	void on_resolve();
	void on_resolved(const std::string& strHost, guint32 nIP, int nErr);
	void on_resolving_stopped(InfoDialog::threadsafe_type pDlg);
	void on_display_infomessage(InfoDialog::threadsafe_type pDlg);


private:	
	IPResolverThread m_resolver;
	sigx::connection_wrapper m_connResolved;
	sigx::connection_wrapper m_connResolvingStopped;
	Gtk::Entry* m_pentryIP;
	Gtk::Entry* m_pentryHostname;
	Gtk::TextView* m_ptvError;
};
