5.1 ブロック

# ブロック

Sonic Piでよく見る構造はブロック(`block`)といいます。ブロックは沢山のコードを
ひとかたまりとして、便利に扱うことができます。

たとえば`synth`や`sample`では、その後ろのパラメータによって音を変えることができました。
しかし、場合によってはコード数行に同じ変更内容を反映させたい時などが出てきます。

たとえばループする時に、5回のうち1回だけリバーブを加えたい場合を考えてみます。

```
play 50
sleep 0.5
sample :elec_plip
sleep 0.5
play 62
```

コードのまとまりを使って何かをしようとするときに、コードのブロックの始まりと終わりをSonic Piに伝える必要があります。その際に`do`を*始まり*に、`end`を*終わり*として使用します。

```
do
 play 50
 sleep 0.5
 sample :elec_plip
 sleep 0.5
 play 62
end
```

しかし、これではまだ完璧ではないので、実行されません。（動かしてみてもエラーメッセージが出るだけです）。
実行したい*始まり*と*終わり*のブロックをSonic Piへ伝達が完了していないからです。`do`の前に特別なコードをすこし書くことによってこのブロックをSonic Piに教えることができます。
このチュートリアルの後半でこれらの特別なコードを使ったいくつかの事例を紹介していきます。

ひとまず、みなさんが特別なコードを使ってSonic Piを動かしたい場合、`do`と`end`でコードをまとめることが重要であることを覚えておいてください。
