; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=7 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

@G1 = constant i32 0
@G2 = constant i32* @G1

;.
; CHECK: @[[G1:[a-zA-Z0-9_$"\\.-]+]] = constant i32 0
; CHECK: @[[G2:[a-zA-Z0-9_$"\\.-]+]] = constant i32* @G1
;.
define internal i32 @test(i32** %x) {
;
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@test
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[Z:%.*]] = load i32, i32* @G1, align 4
; CHECK-NEXT:    ret i32 [[Z]]
;
entry:
  %y = load i32*, i32** %x
  %z = load i32, i32* %y
  ret i32 %z
}

define i32 @caller() {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; TUNIT-LABEL: define {{[^@]+}}@caller
; TUNIT-SAME: () #[[ATTR0]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[X:%.*]] = call i32 @test() #[[ATTR1:[0-9]+]]
; TUNIT-NEXT:    ret i32 [[X]]
;
; CGSCC: Function Attrs: nofree nosync nounwind readnone willreturn
; CGSCC-LABEL: define {{[^@]+}}@caller
; CGSCC-SAME: () #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[X:%.*]] = call i32 @test() #[[ATTR2:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[X]]
;
entry:
  %x = call i32 @test(i32** @G2)
  ret i32 %x
}

;.
; TUNIT: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind readnone willreturn }
; TUNIT: attributes #[[ATTR1]] = { nofree nosync nounwind readnone willreturn }
;.
; CGSCC: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind readnone willreturn }
; CGSCC: attributes #[[ATTR1]] = { nofree nosync nounwind readnone willreturn }
; CGSCC: attributes #[[ATTR2]] = { readnone willreturn }
;.
