; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=2 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

declare void @sink(i32)

define internal void @test(i32** %X) !dbg !2 {
; CHECK-LABEL: define {{[^@]+}}@test
; CHECK-SAME: (i32** nocapture nofree noundef nonnull readonly align 8 dereferenceable(8) [[X:%.*]]) !dbg [[DBG3:![0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[X]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 8
; CHECK-NEXT:    call void @sink(i32 [[TMP2]])
; CHECK-NEXT:    ret void
;
  %1 = load i32*, i32** %X, align 8
  %2 = load i32, i32* %1, align 8
  call void @sink(i32 %2)
  ret void
}

%struct.pair = type { i32, i32 }

define internal void @test_byval(%struct.pair* byval(%struct.pair) %P) {
; CHECK-LABEL: define {{[^@]+}}@test_byval() {
; CHECK-NEXT:    call void @sink(i32 noundef 0)
; CHECK-NEXT:    ret void
;
  call void @sink(i32 0)
  ret void
}

define void @caller(i32** %Y, %struct.pair* %P) {
; TUNIT-LABEL: define {{[^@]+}}@caller
; TUNIT-SAME: (i32** nocapture nofree readonly [[Y:%.*]], %struct.pair* nocapture nofree readnone [[P:%.*]]) {
; TUNIT-NEXT:    call void @test(i32** nocapture nofree readonly align 8 [[Y]]), !dbg [[DBG4:![0-9]+]]
; TUNIT-NEXT:    call void @test_byval(), !dbg [[DBG5:![0-9]+]]
; TUNIT-NEXT:    ret void
;
; CGSCC-LABEL: define {{[^@]+}}@caller
; CGSCC-SAME: (i32** nocapture nofree noundef nonnull readonly align 8 dereferenceable(8) [[Y:%.*]], %struct.pair* nocapture nofree readnone [[P:%.*]]) {
; CGSCC-NEXT:    call void @test(i32** nocapture nofree noundef nonnull readonly align 8 dereferenceable(8) [[Y]]), !dbg [[DBG4:![0-9]+]]
; CGSCC-NEXT:    call void @test_byval(), !dbg [[DBG5:![0-9]+]]
; CGSCC-NEXT:    ret void
;
  call void @test(i32** %Y), !dbg !1

  call void @test_byval(%struct.pair* byval(%struct.pair) %P), !dbg !6
  ret void
}


!llvm.module.flags = !{!0}
!llvm.dbg.cu = !{!3}

!0 = !{i32 2, !"Debug Info Version", i32 3}
!1 = !DILocation(line: 8, scope: !2)
!2 = distinct !DISubprogram(name: "test", file: !5, line: 3, isLocal: true, isDefinition: true, virtualIndex: 6, flags: DIFlagPrototyped, isOptimized: false, unit: !3, scopeLine: 3, scope: null)
!3 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, producer: "clang version 3.5.0 ", isOptimized: false, emissionKind: LineTablesOnly, file: !5)
!5 = !DIFile(filename: "test.c", directory: "")
!6 = !DILocation(line: 9, scope: !2)
;.
; CHECK: [[META0:![0-9]+]] = !{i32 2, !"Debug Info Version", i32 3}
; CHECK: [[META1:![0-9]+]] = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: !2, producer: "clang version 3.5.0 ", isOptimized: false, runtimeVersion: 0, emissionKind: LineTablesOnly)
; CHECK: [[META2:![0-9]+]] = !DIFile(filename: "test.c", directory: "")
; CHECK: [[DBG3]] = distinct !DISubprogram(name: "test", scope: null, file: !2, line: 3, scopeLine: 3, virtualIndex: 6, flags: DIFlagPrototyped, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition, unit: !1)
; CHECK: [[META4:![0-9]+]] = !DILocation(line: 8, scope: !3)
; CHECK: [[META5:![0-9]+]] = !DILocation(line: 9, scope: !3)
;.
