; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=6 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

; Test cases specifically designed for "align" attribute.
; We use FIXME's to indicate problems and missing attributes.


; TEST 1
;;
;.
; CHECK: @[[A1:[a-zA-Z0-9_$"\\.-]+]] = common global i8 0, align 8
; CHECK: @[[A2:[a-zA-Z0-9_$"\\.-]+]] = common global i8 0, align 16
; CHECK: @[[CND:[a-zA-Z0-9_$"\\.-]+]] = external global i1
; CHECK: @[[G:[a-zA-Z0-9_$"\\.-]+]] = global i8 0, align 32
;.
define i32* @test1(i32* align 8 %0) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@test1
; CHECK-SAME: (i32* nofree readnone returned align 8 "no-capture-maybe-returned" [[TMP0:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    ret i32* [[TMP0]]
;
  ret i32* %0
}

; TEST 2
define i32* @test2(i32* %0) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@test2
; CHECK-SAME: (i32* nofree readnone returned "no-capture-maybe-returned" [[TMP0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    ret i32* [[TMP0]]
;
  ret i32* %0
}

; TEST 3
define i32* @test3(i32* align 8 %0, i32* align 4 %1, i1 %2) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@test3
; CHECK-SAME: (i32* nofree readnone align 8 "no-capture-maybe-returned" [[TMP0:%.*]], i32* nofree readnone align 4 "no-capture-maybe-returned" [[TMP1:%.*]], i1 [[TMP2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[RET:%.*]] = select i1 [[TMP2]], i32* [[TMP0]], i32* [[TMP1]]
; CHECK-NEXT:    ret i32* [[RET]]
;
  %ret = select i1 %2, i32* %0, i32* %1
  ret i32* %ret
}

; TEST 4
define i32* @test4(i32* align 32 %0, i32* align 32 %1, i1 %2) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@test4
; CHECK-SAME: (i32* nofree readnone align 32 "no-capture-maybe-returned" [[TMP0:%.*]], i32* nofree readnone align 32 "no-capture-maybe-returned" [[TMP1:%.*]], i1 [[TMP2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[RET:%.*]] = select i1 [[TMP2]], i32* [[TMP0]], i32* [[TMP1]]
; CHECK-NEXT:    ret i32* [[RET]]
;
  %ret = select i1 %2, i32* %0, i32* %1
  ret i32* %ret
}

; TEST 5
declare i32* @unknown()
declare align 8 i32* @align8()


define i32* @test5_1() {
; CHECK-LABEL: define {{[^@]+}}@test5_1() {
; CHECK-NEXT:    [[RET:%.*]] = tail call align 8 i32* @unknown()
; CHECK-NEXT:    ret i32* [[RET]]
;
  %ret = tail call align 8 i32* @unknown()
  ret i32* %ret
}

define i32* @test5_2() {
; CHECK-LABEL: define {{[^@]+}}@test5_2() {
; CHECK-NEXT:    [[RET:%.*]] = tail call align 8 i32* @align8()
; CHECK-NEXT:    ret i32* [[RET]]
;
  %ret = tail call i32* @align8()
  ret i32* %ret
}

; TEST 6
; SCC
define i32* @test6_1() #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind readnone willreturn uwtable
; TUNIT-LABEL: define {{[^@]+}}@test6_1
; TUNIT-SAME: () #[[ATTR1:[0-9]+]] {
; TUNIT-NEXT:    ret i32* undef
;
; CGSCC: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CGSCC-LABEL: define {{[^@]+}}@test6_1
; CGSCC-SAME: () #[[ATTR0]] {
; CGSCC-NEXT:    ret i32* undef
;
  %ret = tail call i32* @test6_2()
  ret i32* %ret
}

define i32* @test6_2() #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind readnone willreturn uwtable
; TUNIT-LABEL: define {{[^@]+}}@test6_2
; TUNIT-SAME: () #[[ATTR1]] {
; TUNIT-NEXT:    ret i32* undef
;
; CGSCC: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CGSCC-LABEL: define {{[^@]+}}@test6_2
; CGSCC-SAME: () #[[ATTR0]] {
; CGSCC-NEXT:    ret i32* undef
;
  %ret = tail call i32* @test6_1()
  ret i32* %ret
}


; char a1 __attribute__((aligned(8)));
; char a2 __attribute__((aligned(16)));
;
; char* f1(char* a ){
;     return a?a:f2(&a1);
; }
; char* f2(char* a){
;     return a?f1(a):f3(&a2);
; }
;
; char* f3(char* a){
;     return a?&a1: f1(&a2);
; }

@a1 = common global i8 0, align 8
@a2 = common global i8 0, align 16

; Function Attrs: nounwind readnone ssp uwtable
define internal i8* @f1(i8* readnone %0) local_unnamed_addr #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@f1
; CHECK-SAME: (i8* noalias nofree nonnull readnone align 8 dereferenceable(1) "no-capture-maybe-returned" [[TMP0:%.*]]) local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    br label [[TMP3:%.*]]
; CHECK:       2:
; CHECK-NEXT:    unreachable
; CHECK:       3:
; CHECK-NEXT:    ret i8* [[TMP0]]
;
  %2 = icmp eq i8* %0, null
  br i1 %2, label %3, label %5

; <label>:3:                                      ; preds = %1
  %4 = tail call i8* @f2(i8* nonnull @a1)
  %l = load i8, i8* %4
  br label %5

; <label>:5:                                      ; preds = %1, %3
  %6 = phi i8* [ %4, %3 ], [ %0, %1 ]
  ret i8* %6
}

; Function Attrs: nounwind readnone ssp uwtable
define internal i8* @f2(i8* readnone %0) local_unnamed_addr #0 {
; CGSCC: Function Attrs: noinline nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@f2
; CGSCC-SAME: (i8* readnone [[TMP0:%.*]]) local_unnamed_addr #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:    [[TMP2:%.*]] = icmp eq i8* undef, null
; CGSCC-NEXT:    br i1 [[TMP2]], label [[TMP5:%.*]], label [[TMP3:%.*]]
; CGSCC:       3:
; CGSCC-NEXT:    [[TMP4:%.*]] = tail call i8* @f1(i8* noalias nonnull readnone align 4294967296 dereferenceable(4294967295) undef)
; CGSCC-NEXT:    br label [[TMP7:%.*]]
; CGSCC:       5:
; CGSCC-NEXT:    [[TMP6:%.*]] = tail call i8* @f3()
; CGSCC-NEXT:    br label [[TMP7]]
; CGSCC:       7:
; CGSCC-NEXT:    [[TMP8:%.*]] = phi i8* [ [[TMP4]], [[TMP3]] ], [ [[TMP6]], [[TMP5]] ]
; CGSCC-NEXT:    ret i8* [[TMP8]]
;
  %2 = icmp eq i8* %0, null
  br i1 %2, label %5, label %3

; <label>:3:                                      ; preds = %1

  %4 = tail call i8* @f1(i8* nonnull %0)
  br label %7

; <label>:5:                                      ; preds = %1
  %6 = tail call i8* @f3(i8* nonnull @a2)
  br label %7

; <label>:7:                                      ; preds = %5, %3
  %8 = phi i8* [ %4, %3 ], [ %6, %5 ]
  ret i8* %8
}

; Function Attrs: nounwind readnone ssp uwtable
define internal i8* @f3(i8* readnone %0) local_unnamed_addr #0 {
; CGSCC: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CGSCC-LABEL: define {{[^@]+}}@f3
; CGSCC-SAME: () local_unnamed_addr #[[ATTR0]] {
; CGSCC-NEXT:    br label [[TMP2:%.*]]
; CGSCC:       1:
; CGSCC-NEXT:    unreachable
; CGSCC:       2:
; CGSCC-NEXT:    ret i8* @a1
;
  %2 = icmp eq i8* %0, null
  br i1 %2, label %3, label %5

; <label>:3:                                      ; preds = %1
  %4 = tail call i8* @f1(i8* nonnull @a2)
  br label %5

; <label>:5:                                      ; preds = %1, %3
  %6 = phi i8* [ %4, %3 ], [ @a1, %1 ]
  ret i8* %6
}

; TEST 7
; Better than IR information
define align 4 i8* @test7() #0 {
; TUNIT: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; TUNIT-LABEL: define {{[^@]+}}@test7
; TUNIT-SAME: () #[[ATTR0]] {
; TUNIT-NEXT:    [[C:%.*]] = tail call i8* @f1(i8* noalias nofree noundef nonnull readnone align 8 dereferenceable(1) "no-capture-maybe-returned" @a1) #[[ATTR9:[0-9]+]]
; TUNIT-NEXT:    ret i8* [[C]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind readnone willreturn uwtable
; CGSCC-LABEL: define {{[^@]+}}@test7
; CGSCC-SAME: () #[[ATTR2:[0-9]+]] {
; CGSCC-NEXT:    [[C:%.*]] = tail call noundef nonnull align 8 dereferenceable(1) i8* @f1(i8* noalias nofree noundef nonnull readnone align 8 dereferenceable(1) @a1) #[[ATTR13:[0-9]+]]
; CGSCC-NEXT:    ret i8* [[C]]
;
  %c = tail call i8* @f1(i8* align 8 dereferenceable(1) @a1)
  ret i8* %c
}

; TEST 7b
; Function Attrs: nounwind readnone ssp uwtable
define internal i8* @f1b(i8* readnone %0) local_unnamed_addr #0 {
; CGSCC: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CGSCC-LABEL: define {{[^@]+}}@f1b
; CGSCC-SAME: (i8* noalias nofree nonnull readnone align 8 dereferenceable(1) "no-capture-maybe-returned" [[TMP0:%.*]]) local_unnamed_addr #[[ATTR0]] {
; CGSCC-NEXT:    br label [[TMP3:%.*]]
; CGSCC:       2:
; CGSCC-NEXT:    unreachable
; CGSCC:       3:
; CGSCC-NEXT:    ret i8* [[TMP0]]
;
  %2 = icmp eq i8* %0, null
  br i1 %2, label %3, label %5

; <label>:3:                                      ; preds = %1
  %4 = tail call i8* @f2b(i8* nonnull @a1)
  %l = load i8, i8* %4
  store i8 %l, i8* @a1
  br label %5

; <label>:5:                                      ; preds = %1, %3
  %6 = phi i8* [ %4, %3 ], [ %0, %1 ]
  ret i8* %6
}

; Function Attrs: nounwind readnone ssp uwtable
define internal i8* @f2b(i8* readnone %0) local_unnamed_addr #0 {
;
; CGSCC: Function Attrs: noinline nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@f2b
; CGSCC-SAME: (i8* readnone [[TMP0:%.*]]) local_unnamed_addr #[[ATTR1]] {
; CGSCC-NEXT:    [[TMP2:%.*]] = icmp eq i8* undef, null
; CGSCC-NEXT:    br i1 [[TMP2]], label [[TMP5:%.*]], label [[TMP3:%.*]]
; CGSCC:       3:
; CGSCC-NEXT:    [[TMP4:%.*]] = tail call i8* @f1b(i8* noalias nonnull readnone align 4294967296 dereferenceable(4294967295) undef)
; CGSCC-NEXT:    br label [[TMP7:%.*]]
; CGSCC:       5:
; CGSCC-NEXT:    [[TMP6:%.*]] = tail call i8* @f3b()
; CGSCC-NEXT:    br label [[TMP7]]
; CGSCC:       7:
; CGSCC-NEXT:    [[TMP8:%.*]] = phi i8* [ [[TMP4]], [[TMP3]] ], [ [[TMP6]], [[TMP5]] ]
; CGSCC-NEXT:    ret i8* [[TMP8]]
;
  %2 = icmp eq i8* %0, null
  br i1 %2, label %5, label %3

; <label>:3:                                      ; preds = %1

  %4 = tail call i8* @f1b(i8* nonnull %0)
  br label %7

; <label>:5:                                      ; preds = %1
  %6 = tail call i8* @f3b(i8* nonnull @a2)
  br label %7

; <label>:7:                                      ; preds = %5, %3
  %8 = phi i8* [ %4, %3 ], [ %6, %5 ]
  ret i8* %8
}

; Function Attrs: nounwind readnone ssp uwtable
define internal i8* @f3b(i8* readnone %0) local_unnamed_addr #0 {
;
; CGSCC: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CGSCC-LABEL: define {{[^@]+}}@f3b
; CGSCC-SAME: () local_unnamed_addr #[[ATTR0]] {
; CGSCC-NEXT:    br label [[TMP2:%.*]]
; CGSCC:       1:
; CGSCC-NEXT:    unreachable
; CGSCC:       2:
; CGSCC-NEXT:    ret i8* @a1
;
  %2 = icmp eq i8* %0, null
  br i1 %2, label %3, label %5

; <label>:3:                                      ; preds = %1
  %4 = tail call i8* @f1b(i8* nonnull @a2)
  br label %5

; <label>:5:                                      ; preds = %1, %3
  %6 = phi i8* [ %4, %3 ], [ @a1, %1 ]
  ret i8* %6
}

define align 4 i32* @test7b(i32* align 32 %p) #0 {
; TUNIT: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; TUNIT-LABEL: define {{[^@]+}}@test7b
; TUNIT-SAME: (i32* nofree readnone returned align 32 "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:    ret i32* [[P]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind readnone willreturn uwtable
; CGSCC-LABEL: define {{[^@]+}}@test7b
; CGSCC-SAME: (i32* nofree readnone returned align 32 "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR2]] {
; CGSCC-NEXT:    ret i32* [[P]]
;
  tail call i8* @f1b(i8* align 8 dereferenceable(1) @a1)
  ret i32* %p
}

; TEST 8
define void @test8_helper() {
; TUNIT-LABEL: define {{[^@]+}}@test8_helper() {
; TUNIT-NEXT:    [[PTR0:%.*]] = tail call i32* @unknown()
; TUNIT-NEXT:    [[PTR1:%.*]] = tail call align 4 i32* @unknown()
; TUNIT-NEXT:    [[PTR2:%.*]] = tail call align 8 i32* @unknown()
; TUNIT-NEXT:    tail call void @test8(i32* noalias nocapture readnone align 4 [[PTR1]], i32* noalias nocapture readnone align 4 [[PTR1]], i32* noalias nocapture readnone [[PTR0]]) #[[ATTR2:[0-9]+]]
; TUNIT-NEXT:    tail call void @test8(i32* noalias nocapture readnone align 8 [[PTR2]], i32* noalias nocapture readnone align 4 [[PTR1]], i32* noalias nocapture readnone align 4 [[PTR1]]) #[[ATTR2]]
; TUNIT-NEXT:    tail call void @test8(i32* noalias nocapture readnone align 8 [[PTR2]], i32* noalias nocapture readnone align 4 [[PTR1]], i32* noalias nocapture readnone align 4 [[PTR1]]) #[[ATTR2]]
; TUNIT-NEXT:    ret void
;
; CGSCC-LABEL: define {{[^@]+}}@test8_helper() {
; CGSCC-NEXT:    [[PTR0:%.*]] = tail call i32* @unknown()
; CGSCC-NEXT:    [[PTR1:%.*]] = tail call align 4 i32* @unknown()
; CGSCC-NEXT:    [[PTR2:%.*]] = tail call align 8 i32* @unknown()
; CGSCC-NEXT:    tail call void @test8(i32* noalias nocapture readnone align 4 [[PTR1]], i32* noalias nocapture readnone align 4 [[PTR1]], i32* noalias nocapture readnone [[PTR0]]) #[[ATTR3:[0-9]+]]
; CGSCC-NEXT:    tail call void @test8(i32* noalias nocapture readnone align 8 [[PTR2]], i32* noalias nocapture readnone align 4 [[PTR1]], i32* noalias nocapture readnone align 4 [[PTR1]]) #[[ATTR3]]
; CGSCC-NEXT:    tail call void @test8(i32* noalias nocapture readnone align 8 [[PTR2]], i32* noalias nocapture readnone align 4 [[PTR1]], i32* noalias nocapture readnone align 4 [[PTR1]]) #[[ATTR3]]
; CGSCC-NEXT:    ret void
;
  %ptr0 = tail call i32* @unknown()
  %ptr1 = tail call align 4 i32* @unknown()
  %ptr2 = tail call align 8 i32* @unknown()

  tail call void @test8(i32* %ptr1, i32* %ptr1, i32* %ptr0)
  tail call void @test8(i32* %ptr2, i32* %ptr1, i32* %ptr1)
  tail call void @test8(i32* %ptr2, i32* %ptr1, i32* %ptr1)
  ret void
}

declare void @user_i32_ptr(i32* nocapture readnone) nounwind
define internal void @test8(i32* %a, i32* %b, i32* %c) {
; TUNIT: Function Attrs: nounwind
; TUNIT-LABEL: define {{[^@]+}}@test8
; TUNIT-SAME: (i32* noalias nocapture readnone align 4 [[A:%.*]], i32* noalias nocapture readnone align 4 [[B:%.*]], i32* noalias nocapture readnone [[C:%.*]]) #[[ATTR2]] {
; TUNIT-NEXT:    call void @user_i32_ptr(i32* noalias nocapture readnone align 4 [[A]]) #[[ATTR2]]
; TUNIT-NEXT:    call void @user_i32_ptr(i32* noalias nocapture readnone align 4 [[B]]) #[[ATTR2]]
; TUNIT-NEXT:    call void @user_i32_ptr(i32* noalias nocapture readnone [[C]]) #[[ATTR2]]
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nounwind
; CGSCC-LABEL: define {{[^@]+}}@test8
; CGSCC-SAME: (i32* noalias nocapture readnone align 4 [[A:%.*]], i32* noalias nocapture readnone align 4 [[B:%.*]], i32* noalias nocapture readnone [[C:%.*]]) #[[ATTR3]] {
; CGSCC-NEXT:    call void @user_i32_ptr(i32* noalias nocapture readnone align 4 [[A]]) #[[ATTR3]]
; CGSCC-NEXT:    call void @user_i32_ptr(i32* noalias nocapture readnone align 4 [[B]]) #[[ATTR3]]
; CGSCC-NEXT:    call void @user_i32_ptr(i32* noalias nocapture readnone [[C]]) #[[ATTR3]]
; CGSCC-NEXT:    ret void
;
  call void @user_i32_ptr(i32* %a)
  call void @user_i32_ptr(i32* %b)
  call void @user_i32_ptr(i32* %c)
  ret void
}

declare void @test9_helper(i32* %A)
define void @test9_traversal(i1 %cnd, i32* align 4 %B, i32* align 8 %C) {
; CHECK-LABEL: define {{[^@]+}}@test9_traversal
; CHECK-SAME: (i1 [[CND:%.*]], i32* align 4 [[B:%.*]], i32* align 8 [[C:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CND]], i32* [[B]], i32* [[C]]
; CHECK-NEXT:    call void @test9_helper(i32* align 4 [[SEL]])
; CHECK-NEXT:    ret void
;
  %sel = select i1 %cnd, i32* %B, i32* %C
  call void @test9_helper(i32* %sel)
  ret void
}

; FIXME: This will work with an upcoming patch (D66618 or similar)
;             define align 32 i32* @test10a(i32* align 32 "no-capture-maybe-returned" %p)
; FIXME: This will work with an upcoming patch (D66618 or similar)
;             store i32 1, i32* %r, align 32
; FIXME: This will work with an upcoming patch (D66618 or similar)
;             store i32 -1, i32* %g1, align 32
define i32* @test10a(i32* align 32 %p) {
; TUNIT: Function Attrs: nofree nosync nounwind
; TUNIT-LABEL: define {{[^@]+}}@test10a
; TUNIT-SAME: (i32* nofree noundef nonnull align 32 dereferenceable(4) "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR3:[0-9]+]] {
; TUNIT-NEXT:    [[L:%.*]] = load i32, i32* [[P]], align 32
; TUNIT-NEXT:    [[C:%.*]] = icmp eq i32 [[L]], 0
; TUNIT-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; TUNIT:       t:
; TUNIT-NEXT:    [[R:%.*]] = call align 32 i32* @test10a(i32* nofree noundef nonnull align 32 dereferenceable(4) "no-capture-maybe-returned" [[P]]) #[[ATTR3]]
; TUNIT-NEXT:    store i32 1, i32* [[R]], align 32
; TUNIT-NEXT:    [[G0:%.*]] = getelementptr i32, i32* [[P]], i32 8
; TUNIT-NEXT:    br label [[E:%.*]]
; TUNIT:       f:
; TUNIT-NEXT:    [[G1:%.*]] = getelementptr i32, i32* [[P]], i32 8
; TUNIT-NEXT:    store i32 -1, i32* [[G1]], align 32
; TUNIT-NEXT:    br label [[E]]
; TUNIT:       e:
; TUNIT-NEXT:    [[PHI:%.*]] = phi i32* [ [[G0]], [[T]] ], [ [[G1]], [[F]] ]
; TUNIT-NEXT:    ret i32* [[PHI]]
;
; CGSCC: Function Attrs: nofree nosync nounwind
; CGSCC-LABEL: define {{[^@]+}}@test10a
; CGSCC-SAME: (i32* nofree noundef nonnull align 32 dereferenceable(4) "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR4:[0-9]+]] {
; CGSCC-NEXT:    [[L:%.*]] = load i32, i32* [[P]], align 32
; CGSCC-NEXT:    [[C:%.*]] = icmp eq i32 [[L]], 0
; CGSCC-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; CGSCC:       t:
; CGSCC-NEXT:    [[R:%.*]] = call align 32 i32* @test10a(i32* nofree noundef nonnull align 32 dereferenceable(4) "no-capture-maybe-returned" [[P]]) #[[ATTR4]]
; CGSCC-NEXT:    store i32 1, i32* [[R]], align 32
; CGSCC-NEXT:    [[G0:%.*]] = getelementptr i32, i32* [[P]], i32 8
; CGSCC-NEXT:    br label [[E:%.*]]
; CGSCC:       f:
; CGSCC-NEXT:    [[G1:%.*]] = getelementptr i32, i32* [[P]], i32 8
; CGSCC-NEXT:    store i32 -1, i32* [[G1]], align 32
; CGSCC-NEXT:    br label [[E]]
; CGSCC:       e:
; CGSCC-NEXT:    [[PHI:%.*]] = phi i32* [ [[G0]], [[T]] ], [ [[G1]], [[F]] ]
; CGSCC-NEXT:    ret i32* [[PHI]]
;
  %l = load i32, i32* %p
  %c = icmp eq i32 %l, 0
  br i1 %c, label %t, label %f
t:
  %r = call i32* @test10a(i32* %p)
  store i32 1, i32* %r
  %g0 = getelementptr i32, i32* %p, i32 8
  br label %e
f:
  %g1 = getelementptr i32, i32* %p, i32 8
  store i32 -1, i32* %g1
  br label %e
e:
  %phi = phi i32* [%g0, %t], [%g1, %f]
  ret i32* %phi
}

; FIXME: This will work with an upcoming patch (D66618 or similar)
;             define align 32 i32* @test10b(i32* align 32 "no-capture-maybe-returned" %p)
; FIXME: This will work with an upcoming patch (D66618 or similar)
;             store i32 1, i32* %r, align 32
; FIXME: This will work with an upcoming patch (D66618 or similar)
;             store i32 -1, i32* %g1, align 32
define i32* @test10b(i32* align 32 %p) {
; TUNIT: Function Attrs: nofree nosync nounwind
; TUNIT-LABEL: define {{[^@]+}}@test10b
; TUNIT-SAME: (i32* nofree noundef nonnull align 32 dereferenceable(4) "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR3]] {
; TUNIT-NEXT:    [[L:%.*]] = load i32, i32* [[P]], align 32
; TUNIT-NEXT:    [[C:%.*]] = icmp eq i32 [[L]], 0
; TUNIT-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; TUNIT:       t:
; TUNIT-NEXT:    [[R:%.*]] = call align 32 i32* @test10b(i32* nofree noundef nonnull align 32 dereferenceable(4) "no-capture-maybe-returned" [[P]]) #[[ATTR3]]
; TUNIT-NEXT:    store i32 1, i32* [[R]], align 32
; TUNIT-NEXT:    [[G0:%.*]] = getelementptr i32, i32* [[P]], i32 8
; TUNIT-NEXT:    br label [[E:%.*]]
; TUNIT:       f:
; TUNIT-NEXT:    [[G1:%.*]] = getelementptr i32, i32* [[P]], i32 -8
; TUNIT-NEXT:    store i32 -1, i32* [[G1]], align 32
; TUNIT-NEXT:    br label [[E]]
; TUNIT:       e:
; TUNIT-NEXT:    [[PHI:%.*]] = phi i32* [ [[G0]], [[T]] ], [ [[G1]], [[F]] ]
; TUNIT-NEXT:    ret i32* [[PHI]]
;
; CGSCC: Function Attrs: nofree nosync nounwind
; CGSCC-LABEL: define {{[^@]+}}@test10b
; CGSCC-SAME: (i32* nofree noundef nonnull align 32 dereferenceable(4) "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR4]] {
; CGSCC-NEXT:    [[L:%.*]] = load i32, i32* [[P]], align 32
; CGSCC-NEXT:    [[C:%.*]] = icmp eq i32 [[L]], 0
; CGSCC-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; CGSCC:       t:
; CGSCC-NEXT:    [[R:%.*]] = call align 32 i32* @test10b(i32* nofree noundef nonnull align 32 dereferenceable(4) "no-capture-maybe-returned" [[P]]) #[[ATTR4]]
; CGSCC-NEXT:    store i32 1, i32* [[R]], align 32
; CGSCC-NEXT:    [[G0:%.*]] = getelementptr i32, i32* [[P]], i32 8
; CGSCC-NEXT:    br label [[E:%.*]]
; CGSCC:       f:
; CGSCC-NEXT:    [[G1:%.*]] = getelementptr i32, i32* [[P]], i32 -8
; CGSCC-NEXT:    store i32 -1, i32* [[G1]], align 32
; CGSCC-NEXT:    br label [[E]]
; CGSCC:       e:
; CGSCC-NEXT:    [[PHI:%.*]] = phi i32* [ [[G0]], [[T]] ], [ [[G1]], [[F]] ]
; CGSCC-NEXT:    ret i32* [[PHI]]
;
  %l = load i32, i32* %p
  %c = icmp eq i32 %l, 0
  br i1 %c, label %t, label %f
t:
  %r = call i32* @test10b(i32* %p)
  store i32 1, i32* %r
  %g0 = getelementptr i32, i32* %p, i32 8
  br label %e
f:
  %g1 = getelementptr i32, i32* %p, i32 -8
  store i32 -1, i32* %g1
  br label %e
e:
  %phi = phi i32* [%g0, %t], [%g1, %f]
  ret i32* %phi
}


define i64 @test11(i32* %p) {
; TUNIT: Function Attrs: argmemonly nofree norecurse nosync nounwind readonly willreturn
; TUNIT-LABEL: define {{[^@]+}}@test11
; TUNIT-SAME: (i32* nocapture nofree nonnull readonly align 8 dereferenceable(8) [[P:%.*]]) #[[ATTR4:[0-9]+]] {
; TUNIT-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; TUNIT-NEXT:    [[RET:%.*]] = load i64, i64* [[P_CAST]], align 8
; TUNIT-NEXT:    ret i64 [[RET]]
;
; CGSCC: Function Attrs: argmemonly nofree norecurse nosync nounwind readonly willreturn
; CGSCC-LABEL: define {{[^@]+}}@test11
; CGSCC-SAME: (i32* nocapture nofree nonnull readonly align 8 dereferenceable(8) [[P:%.*]]) #[[ATTR5:[0-9]+]] {
; CGSCC-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; CGSCC-NEXT:    [[RET:%.*]] = load i64, i64* [[P_CAST]], align 8
; CGSCC-NEXT:    ret i64 [[RET]]
;
  %p-cast = bitcast i32* %p to i64*
  %ret = load i64, i64* %p-cast, align 8
  ret i64 %ret
}

; TEST 12
; Test for deduction using must-be-executed-context and GEP instruction

; FXIME: %p should have nonnull
define i64 @test12-1(i32* align 4 %p) {
; TUNIT: Function Attrs: argmemonly nofree norecurse nosync nounwind readonly willreturn
; TUNIT-LABEL: define {{[^@]+}}@test12-1
; TUNIT-SAME: (i32* nocapture nofree readonly align 16 [[P:%.*]]) #[[ATTR4]] {
; TUNIT-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; TUNIT-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 1
; TUNIT-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr i64, i64* [[ARRAYIDX0]], i64 3
; TUNIT-NEXT:    [[RET:%.*]] = load i64, i64* [[ARRAYIDX1]], align 16
; TUNIT-NEXT:    ret i64 [[RET]]
;
; CGSCC: Function Attrs: argmemonly nofree norecurse nosync nounwind readonly willreturn
; CGSCC-LABEL: define {{[^@]+}}@test12-1
; CGSCC-SAME: (i32* nocapture nofree readonly align 16 [[P:%.*]]) #[[ATTR5]] {
; CGSCC-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; CGSCC-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 1
; CGSCC-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr i64, i64* [[ARRAYIDX0]], i64 3
; CGSCC-NEXT:    [[RET:%.*]] = load i64, i64* [[ARRAYIDX1]], align 16
; CGSCC-NEXT:    ret i64 [[RET]]
;
  %p-cast = bitcast i32* %p to i64*
  %arrayidx0 = getelementptr i64, i64* %p-cast, i64 1
  %arrayidx1 = getelementptr i64, i64* %arrayidx0, i64 3
  %ret = load i64, i64* %arrayidx1, align 16
  ret i64 %ret
}

define i64 @test12-2(i32* align 4 %p) {
; TUNIT: Function Attrs: argmemonly nofree norecurse nosync nounwind readonly willreturn
; TUNIT-LABEL: define {{[^@]+}}@test12-2
; TUNIT-SAME: (i32* nocapture nofree nonnull readonly align 16 dereferenceable(8) [[P:%.*]]) #[[ATTR4]] {
; TUNIT-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; TUNIT-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 0
; TUNIT-NEXT:    [[RET:%.*]] = load i64, i64* [[ARRAYIDX0]], align 16
; TUNIT-NEXT:    ret i64 [[RET]]
;
; CGSCC: Function Attrs: argmemonly nofree norecurse nosync nounwind readonly willreturn
; CGSCC-LABEL: define {{[^@]+}}@test12-2
; CGSCC-SAME: (i32* nocapture nofree nonnull readonly align 16 dereferenceable(8) [[P:%.*]]) #[[ATTR5]] {
; CGSCC-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; CGSCC-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 0
; CGSCC-NEXT:    [[RET:%.*]] = load i64, i64* [[ARRAYIDX0]], align 16
; CGSCC-NEXT:    ret i64 [[RET]]
;
  %p-cast = bitcast i32* %p to i64*
  %arrayidx0 = getelementptr i64, i64* %p-cast, i64 0
  %ret = load i64, i64* %arrayidx0, align 16
  ret i64 %ret
}

; FXIME: %p should have nonnull
define void @test12-3(i32* align 4 %p) {
; TUNIT: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@test12-3
; TUNIT-SAME: (i32* nocapture nofree writeonly align 16 [[P:%.*]]) #[[ATTR5:[0-9]+]] {
; TUNIT-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; TUNIT-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 1
; TUNIT-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr i64, i64* [[ARRAYIDX0]], i64 3
; TUNIT-NEXT:    store i64 0, i64* [[ARRAYIDX1]], align 16
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@test12-3
; CGSCC-SAME: (i32* nocapture nofree writeonly align 16 [[P:%.*]]) #[[ATTR6:[0-9]+]] {
; CGSCC-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; CGSCC-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 1
; CGSCC-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr i64, i64* [[ARRAYIDX0]], i64 3
; CGSCC-NEXT:    store i64 0, i64* [[ARRAYIDX1]], align 16
; CGSCC-NEXT:    ret void
;
  %p-cast = bitcast i32* %p to i64*
  %arrayidx0 = getelementptr i64, i64* %p-cast, i64 1
  %arrayidx1 = getelementptr i64, i64* %arrayidx0, i64 3
  store i64 0, i64* %arrayidx1, align 16
  ret void
}

define void @test12-4(i32* align 4 %p) {
; TUNIT: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@test12-4
; TUNIT-SAME: (i32* nocapture nofree nonnull writeonly align 16 dereferenceable(8) [[P:%.*]]) #[[ATTR5]] {
; TUNIT-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; TUNIT-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 0
; TUNIT-NEXT:    store i64 0, i64* [[ARRAYIDX0]], align 16
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@test12-4
; CGSCC-SAME: (i32* nocapture nofree nonnull writeonly align 16 dereferenceable(8) [[P:%.*]]) #[[ATTR6]] {
; CGSCC-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; CGSCC-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 0
; CGSCC-NEXT:    store i64 0, i64* [[ARRAYIDX0]], align 16
; CGSCC-NEXT:    ret void
;
  %p-cast = bitcast i32* %p to i64*
  %arrayidx0 = getelementptr i64, i64* %p-cast, i64 0
  store i64 0, i64* %arrayidx0, align 16
  ret void
}

declare void @use(i64*) willreturn nounwind

define void @test12-5(i32* align 4 %p) {
; TUNIT: Function Attrs: nounwind willreturn
; TUNIT-LABEL: define {{[^@]+}}@test12-5
; TUNIT-SAME: (i32* align 16 [[P:%.*]]) #[[ATTR6:[0-9]+]] {
; TUNIT-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; TUNIT-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 1
; TUNIT-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr i64, i64* [[ARRAYIDX0]], i64 3
; TUNIT-NEXT:    tail call void @use(i64* align 16 [[ARRAYIDX1]]) #[[ATTR6]]
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nounwind willreturn
; CGSCC-LABEL: define {{[^@]+}}@test12-5
; CGSCC-SAME: (i32* align 16 [[P:%.*]]) #[[ATTR7:[0-9]+]] {
; CGSCC-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; CGSCC-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 1
; CGSCC-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr i64, i64* [[ARRAYIDX0]], i64 3
; CGSCC-NEXT:    tail call void @use(i64* align 16 [[ARRAYIDX1]]) #[[ATTR7]]
; CGSCC-NEXT:    ret void
;
  %p-cast = bitcast i32* %p to i64*
  %arrayidx0 = getelementptr i64, i64* %p-cast, i64 1
  %arrayidx1 = getelementptr i64, i64* %arrayidx0, i64 3
  tail call void @use(i64* align 16 %arrayidx1)
  ret void
}

define void @test12-6(i32* align 4 %p) {
; TUNIT: Function Attrs: nounwind willreturn
; TUNIT-LABEL: define {{[^@]+}}@test12-6
; TUNIT-SAME: (i32* align 16 [[P:%.*]]) #[[ATTR6]] {
; TUNIT-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; TUNIT-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 0
; TUNIT-NEXT:    tail call void @use(i64* align 16 [[ARRAYIDX0]]) #[[ATTR6]]
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nounwind willreturn
; CGSCC-LABEL: define {{[^@]+}}@test12-6
; CGSCC-SAME: (i32* align 16 [[P:%.*]]) #[[ATTR7]] {
; CGSCC-NEXT:    [[P_CAST:%.*]] = bitcast i32* [[P]] to i64*
; CGSCC-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr i64, i64* [[P_CAST]], i64 0
; CGSCC-NEXT:    tail call void @use(i64* align 16 [[ARRAYIDX0]]) #[[ATTR7]]
; CGSCC-NEXT:    ret void
;
  %p-cast = bitcast i32* %p to i64*
  %arrayidx0 = getelementptr i64, i64* %p-cast, i64 0
  tail call void @use(i64* align 16 %arrayidx0)
  ret void
}

define void @test13(i1 %c, i32* align 32 %dst) #0 {
; TUNIT: Function Attrs: argmemonly nofree noinline norecurse nosync nounwind willreturn writeonly uwtable
; TUNIT-LABEL: define {{[^@]+}}@test13
; TUNIT-SAME: (i1 [[C:%.*]], i32* nocapture nofree writeonly align 32 [[DST:%.*]]) #[[ATTR7:[0-9]+]] {
; TUNIT-NEXT:    br i1 [[C]], label [[TRUEBB:%.*]], label [[FALSEBB:%.*]]
; TUNIT:       truebb:
; TUNIT-NEXT:    br label [[END:%.*]]
; TUNIT:       falsebb:
; TUNIT-NEXT:    br label [[END]]
; TUNIT:       end:
; TUNIT-NEXT:    [[PTR:%.*]] = phi i32* [ [[DST]], [[TRUEBB]] ], [ null, [[FALSEBB]] ]
; TUNIT-NEXT:    store i32 0, i32* [[PTR]], align 32
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: argmemonly nofree noinline norecurse nosync nounwind willreturn writeonly uwtable
; CGSCC-LABEL: define {{[^@]+}}@test13
; CGSCC-SAME: (i1 [[C:%.*]], i32* nocapture nofree writeonly align 32 [[DST:%.*]]) #[[ATTR8:[0-9]+]] {
; CGSCC-NEXT:    br i1 [[C]], label [[TRUEBB:%.*]], label [[FALSEBB:%.*]]
; CGSCC:       truebb:
; CGSCC-NEXT:    br label [[END:%.*]]
; CGSCC:       falsebb:
; CGSCC-NEXT:    br label [[END]]
; CGSCC:       end:
; CGSCC-NEXT:    [[PTR:%.*]] = phi i32* [ [[DST]], [[TRUEBB]] ], [ null, [[FALSEBB]] ]
; CGSCC-NEXT:    store i32 0, i32* [[PTR]], align 32
; CGSCC-NEXT:    ret void
;
  br i1 %c, label %truebb, label %falsebb
truebb:
  br label %end
falsebb:
  br label %end
end:
  %ptr = phi i32* [ %dst, %truebb ], [ null, %falsebb ]
  store i32 0, i32* %ptr
  ret void
}

define void @test13-1(i1 %c, i32* align 32 %dst) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@test13-1
; TUNIT-SAME: (i1 [[C:%.*]], i32* nocapture nofree writeonly align 32 [[DST:%.*]]) #[[ATTR8:[0-9]+]] {
; TUNIT-NEXT:    br i1 [[C]], label [[TRUEBB:%.*]], label [[FALSEBB:%.*]]
; TUNIT:       truebb:
; TUNIT-NEXT:    br label [[END:%.*]]
; TUNIT:       falsebb:
; TUNIT-NEXT:    br label [[END]]
; TUNIT:       end:
; TUNIT-NEXT:    [[PTR:%.*]] = phi i32* [ [[DST]], [[TRUEBB]] ], [ inttoptr (i64 48 to i32*), [[FALSEBB]] ]
; TUNIT-NEXT:    store i32 0, i32* [[PTR]], align 16
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@test13-1
; CGSCC-SAME: (i1 [[C:%.*]], i32* nocapture nofree writeonly align 32 [[DST:%.*]]) #[[ATTR9:[0-9]+]] {
; CGSCC-NEXT:    br i1 [[C]], label [[TRUEBB:%.*]], label [[FALSEBB:%.*]]
; CGSCC:       truebb:
; CGSCC-NEXT:    br label [[END:%.*]]
; CGSCC:       falsebb:
; CGSCC-NEXT:    br label [[END]]
; CGSCC:       end:
; CGSCC-NEXT:    [[PTR:%.*]] = phi i32* [ [[DST]], [[TRUEBB]] ], [ inttoptr (i64 48 to i32*), [[FALSEBB]] ]
; CGSCC-NEXT:    store i32 0, i32* [[PTR]], align 16
; CGSCC-NEXT:    ret void
;
  br i1 %c, label %truebb, label %falsebb
truebb:
  br label %end
falsebb:
  br label %end
end:
  %ptr = phi i32* [ %dst, %truebb ], [ inttoptr (i64 48 to i32*), %falsebb ]
  store i32 0, i32* %ptr
  ret void
}

define void @test13-2(i1 %c, i32* align 32 %dst) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@test13-2
; TUNIT-SAME: (i1 [[C:%.*]], i32* nocapture nofree writeonly align 32 [[DST:%.*]]) #[[ATTR8]] {
; TUNIT-NEXT:    br i1 [[C]], label [[TRUEBB:%.*]], label [[FALSEBB:%.*]]
; TUNIT:       truebb:
; TUNIT-NEXT:    br label [[END:%.*]]
; TUNIT:       falsebb:
; TUNIT-NEXT:    br label [[END]]
; TUNIT:       end:
; TUNIT-NEXT:    [[PTR:%.*]] = phi i32* [ [[DST]], [[TRUEBB]] ], [ inttoptr (i64 160 to i32*), [[FALSEBB]] ]
; TUNIT-NEXT:    store i32 0, i32* [[PTR]], align 32
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@test13-2
; CGSCC-SAME: (i1 [[C:%.*]], i32* nocapture nofree writeonly align 32 [[DST:%.*]]) #[[ATTR9]] {
; CGSCC-NEXT:    br i1 [[C]], label [[TRUEBB:%.*]], label [[FALSEBB:%.*]]
; CGSCC:       truebb:
; CGSCC-NEXT:    br label [[END:%.*]]
; CGSCC:       falsebb:
; CGSCC-NEXT:    br label [[END]]
; CGSCC:       end:
; CGSCC-NEXT:    [[PTR:%.*]] = phi i32* [ [[DST]], [[TRUEBB]] ], [ inttoptr (i64 160 to i32*), [[FALSEBB]] ]
; CGSCC-NEXT:    store i32 0, i32* [[PTR]], align 32
; CGSCC-NEXT:    ret void
;
  br i1 %c, label %truebb, label %falsebb
truebb:
  br label %end
falsebb:
  br label %end
end:
  %ptr = phi i32* [ %dst, %truebb ], [ inttoptr (i64 160 to i32*), %falsebb ]
  store i32 0, i32* %ptr
  ret void
}

define void @test13-3(i1 %c, i32* align 32 %dst) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@test13-3
; TUNIT-SAME: (i1 [[C:%.*]], i32* nocapture nofree writeonly align 32 [[DST:%.*]]) #[[ATTR8]] {
; TUNIT-NEXT:    br i1 [[C]], label [[TRUEBB:%.*]], label [[FALSEBB:%.*]]
; TUNIT:       truebb:
; TUNIT-NEXT:    br label [[END:%.*]]
; TUNIT:       falsebb:
; TUNIT-NEXT:    br label [[END]]
; TUNIT:       end:
; TUNIT-NEXT:    [[PTR:%.*]] = phi i32* [ [[DST]], [[TRUEBB]] ], [ inttoptr (i64 128 to i32*), [[FALSEBB]] ]
; TUNIT-NEXT:    store i32 0, i32* [[PTR]], align 32
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@test13-3
; CGSCC-SAME: (i1 [[C:%.*]], i32* nocapture nofree writeonly align 32 [[DST:%.*]]) #[[ATTR9]] {
; CGSCC-NEXT:    br i1 [[C]], label [[TRUEBB:%.*]], label [[FALSEBB:%.*]]
; CGSCC:       truebb:
; CGSCC-NEXT:    br label [[END:%.*]]
; CGSCC:       falsebb:
; CGSCC-NEXT:    br label [[END]]
; CGSCC:       end:
; CGSCC-NEXT:    [[PTR:%.*]] = phi i32* [ [[DST]], [[TRUEBB]] ], [ inttoptr (i64 128 to i32*), [[FALSEBB]] ]
; CGSCC-NEXT:    store i32 0, i32* [[PTR]], align 32
; CGSCC-NEXT:    ret void
;
  br i1 %c, label %truebb, label %falsebb
truebb:
  br label %end
falsebb:
  br label %end
end:
  %ptr = phi i32* [ %dst, %truebb ], [ inttoptr (i64 128 to i32*), %falsebb ]
  store i32 0, i32* %ptr
  ret void
}

; Don't crash on ptr2int/int2ptr uses.
define i64 @ptr2int(i32* %p) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; TUNIT-LABEL: define {{[^@]+}}@ptr2int
; TUNIT-SAME: (i32* nofree readnone [[P:%.*]]) #[[ATTR9]] {
; TUNIT-NEXT:    [[P2I:%.*]] = ptrtoint i32* [[P]] to i64
; TUNIT-NEXT:    ret i64 [[P2I]]
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CGSCC-LABEL: define {{[^@]+}}@ptr2int
; CGSCC-SAME: (i32* nofree readnone [[P:%.*]]) #[[ATTR10:[0-9]+]] {
; CGSCC-NEXT:    [[P2I:%.*]] = ptrtoint i32* [[P]] to i64
; CGSCC-NEXT:    ret i64 [[P2I]]
;
  %p2i = ptrtoint i32* %p to i64
  ret i64 %p2i
}
define i64* @int2ptr(i64 %i) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; TUNIT-LABEL: define {{[^@]+}}@int2ptr
; TUNIT-SAME: (i64 [[I:%.*]]) #[[ATTR9]] {
; TUNIT-NEXT:    [[I2P:%.*]] = inttoptr i64 [[I]] to i64*
; TUNIT-NEXT:    ret i64* [[I2P]]
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CGSCC-LABEL: define {{[^@]+}}@int2ptr
; CGSCC-SAME: (i64 [[I:%.*]]) #[[ATTR10]] {
; CGSCC-NEXT:    [[I2P:%.*]] = inttoptr i64 [[I]] to i64*
; CGSCC-NEXT:    ret i64* [[I2P]]
;
  %i2p = inttoptr i64 %i to i64*
  ret i64* %i2p
}

; Use the store alignment only for the pointer operand.
define void @aligned_store(i8* %Value, i8** %Ptr) {
; TUNIT: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@aligned_store
; TUNIT-SAME: (i8* nofree writeonly [[VALUE:%.*]], i8** nocapture nofree noundef nonnull writeonly align 32 dereferenceable(8) [[PTR:%.*]]) #[[ATTR5]] {
; TUNIT-NEXT:    store i8* [[VALUE]], i8** [[PTR]], align 32
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@aligned_store
; CGSCC-SAME: (i8* nofree writeonly [[VALUE:%.*]], i8** nocapture nofree noundef nonnull writeonly align 32 dereferenceable(8) [[PTR:%.*]]) #[[ATTR6]] {
; CGSCC-NEXT:    store i8* [[VALUE]], i8** [[PTR]], align 32
; CGSCC-NEXT:    ret void
;
  store i8* %Value, i8** %Ptr, align 32
  ret void
}

declare i8* @some_func(i8*)
define void @align_call_op_not_store(i8* align 2048 %arg) {
; CHECK-LABEL: define {{[^@]+}}@align_call_op_not_store
; CHECK-SAME: (i8* align 2048 [[ARG:%.*]]) {
; CHECK-NEXT:    [[UNKNOWN:%.*]] = call i8* @some_func(i8* align 2048 [[ARG]])
; CHECK-NEXT:    store i8 0, i8* [[UNKNOWN]], align 1
; CHECK-NEXT:    ret void
;
  %unknown = call i8* @some_func(i8* %arg)
  store i8 0, i8* %unknown
  ret void
}
define void @align_store_after_bc(i32* align 2048 %arg) {
;
; TUNIT: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@align_store_after_bc
; TUNIT-SAME: (i32* nocapture nofree nonnull writeonly align 2048 dereferenceable(1) [[ARG:%.*]]) #[[ATTR5]] {
; TUNIT-NEXT:    [[BC:%.*]] = bitcast i32* [[ARG]] to i8*
; TUNIT-NEXT:    store i8 0, i8* [[BC]], align 2048
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@align_store_after_bc
; CGSCC-SAME: (i32* nocapture nofree nonnull writeonly align 2048 dereferenceable(1) [[ARG:%.*]]) #[[ATTR6]] {
; CGSCC-NEXT:    [[BC:%.*]] = bitcast i32* [[ARG]] to i8*
; CGSCC-NEXT:    store i8 0, i8* [[BC]], align 2048
; CGSCC-NEXT:    ret void
;
  %bc = bitcast i32* %arg to i8*
  store i8 0, i8* %bc
  ret void
}

; Make sure we do not annotate the callee of a must-tail call with an alignment
; we cannot also put on the caller.
@cnd = external global i1
define i32 @musttail_callee_1(i32* %p) {
; TUNIT: Function Attrs: argmemonly nofree norecurse nosync nounwind readonly willreturn
; TUNIT-LABEL: define {{[^@]+}}@musttail_callee_1
; TUNIT-SAME: (i32* nocapture nofree noundef nonnull readonly dereferenceable(4) [[P:%.*]]) #[[ATTR4]] {
; TUNIT-NEXT:    [[V:%.*]] = load i32, i32* [[P]], align 32
; TUNIT-NEXT:    ret i32 [[V]]
;
; CGSCC: Function Attrs: argmemonly nofree norecurse nosync nounwind readonly willreturn
; CGSCC-LABEL: define {{[^@]+}}@musttail_callee_1
; CGSCC-SAME: (i32* nocapture nofree noundef nonnull readonly dereferenceable(4) [[P:%.*]]) #[[ATTR5]] {
; CGSCC-NEXT:    [[V:%.*]] = load i32, i32* [[P]], align 32
; CGSCC-NEXT:    ret i32 [[V]]
;
  %v = load i32, i32* %p, align 32
  ret i32 %v
}
define i32 @musttail_caller_1(i32* %p) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind readonly willreturn
; TUNIT-LABEL: define {{[^@]+}}@musttail_caller_1
; TUNIT-SAME: (i32* nocapture nofree readonly [[P:%.*]]) #[[ATTR10:[0-9]+]] {
; TUNIT-NEXT:    [[C:%.*]] = load i1, i1* @cnd, align 1
; TUNIT-NEXT:    br i1 [[C]], label [[MT:%.*]], label [[EXIT:%.*]]
; TUNIT:       mt:
; TUNIT-NEXT:    [[V:%.*]] = musttail call i32 @musttail_callee_1(i32* nocapture nofree readonly [[P]]) #[[ATTR11:[0-9]+]]
; TUNIT-NEXT:    ret i32 [[V]]
; TUNIT:       exit:
; TUNIT-NEXT:    ret i32 0
;
; CGSCC: Function Attrs: nofree nosync nounwind readonly willreturn
; CGSCC-LABEL: define {{[^@]+}}@musttail_caller_1
; CGSCC-SAME: (i32* nocapture nofree readonly [[P:%.*]]) #[[ATTR11:[0-9]+]] {
; CGSCC-NEXT:    [[C:%.*]] = load i1, i1* @cnd, align 1
; CGSCC-NEXT:    br i1 [[C]], label [[MT:%.*]], label [[EXIT:%.*]]
; CGSCC:       mt:
; CGSCC-NEXT:    [[V:%.*]] = musttail call i32 @musttail_callee_1(i32* nocapture nofree noundef nonnull readonly dereferenceable(4) [[P]]) #[[ATTR14:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[V]]
; CGSCC:       exit:
; CGSCC-NEXT:    ret i32 0
;
  %c = load i1, i1* @cnd
  br i1 %c, label %mt, label %exit
mt:
  %v = musttail call i32 @musttail_callee_1(i32* %p)
  ret i32 %v
exit:
  ret i32 0
}

define i32* @checkAndAdvance(i32* align(16) %p) {
; TUNIT: Function Attrs: nounwind
; TUNIT-LABEL: define {{[^@]+}}@checkAndAdvance
; TUNIT-SAME: (i32* noundef nonnull readonly align 16 dereferenceable(4) "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR2]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[TMP0:%.*]] = load i32, i32* [[P]], align 16
; TUNIT-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP0]], 0
; TUNIT-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[RETURN:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i32, i32* [[P]], i64 4
; TUNIT-NEXT:    [[CALL:%.*]] = call i32* @checkAndAdvance(i32* nonnull readonly align 16 "no-capture-maybe-returned" [[ADD_PTR]]) #[[ATTR2]]
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       return:
; TUNIT-NEXT:    [[RETVAL_0:%.*]] = phi i32* [ [[ADD_PTR]], [[IF_THEN]] ], [ [[P]], [[ENTRY:%.*]] ]
; TUNIT-NEXT:    call void @user_i32_ptr(i32* noalias nocapture nonnull readnone align 16 [[RETVAL_0]]) #[[ATTR2]]
; TUNIT-NEXT:    ret i32* [[RETVAL_0]]
;
; CGSCC: Function Attrs: nounwind
; CGSCC-LABEL: define {{[^@]+}}@checkAndAdvance
; CGSCC-SAME: (i32* noundef nonnull readonly align 16 dereferenceable(4) "no-capture-maybe-returned" [[P:%.*]]) #[[ATTR3]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[TMP0:%.*]] = load i32, i32* [[P]], align 16
; CGSCC-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP0]], 0
; CGSCC-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[RETURN:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i32, i32* [[P]], i64 4
; CGSCC-NEXT:    [[CALL:%.*]] = call i32* @checkAndAdvance(i32* nonnull readonly align 16 "no-capture-maybe-returned" [[ADD_PTR]]) #[[ATTR3]]
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       return:
; CGSCC-NEXT:    [[RETVAL_0:%.*]] = phi i32* [ [[ADD_PTR]], [[IF_THEN]] ], [ [[P]], [[ENTRY:%.*]] ]
; CGSCC-NEXT:    call void @user_i32_ptr(i32* noalias nocapture nonnull readnone align 16 [[RETVAL_0]]) #[[ATTR3]]
; CGSCC-NEXT:    ret i32* [[RETVAL_0]]
;
entry:
  %0 = load i32, i32* %p, align 4
  %cmp = icmp eq i32 %0, 0
  br i1 %cmp, label %if.then, label %return

if.then:                                          ; preds = %entry
  %add.ptr = getelementptr inbounds i32, i32* %p, i64 4
  %call = call i32* @checkAndAdvance(i32* nonnull %add.ptr)
  br label %return

return:                                           ; preds = %entry, %if.then
  %retval.0 = phi i32* [ %call, %if.then ], [ %p, %entry ]
  call void @user_i32_ptr(i32* %retval.0)
  ret i32* %retval.0
}

; FIXME: align 4 should not be propagated to the caller's p unless there is noundef
define void @align4_caller(i8* %p) {
; CHECK-LABEL: define {{[^@]+}}@align4_caller
; CHECK-SAME: (i8* align 4 [[P:%.*]]) {
; CHECK-NEXT:    call void @align4_callee(i8* align 4 [[P]])
; CHECK-NEXT:    ret void
;
  call void @align4_callee(i8* %p)
  ret void
}

declare void @align4_callee(i8* align(4) %p)

@G = global i8 0, align 32

define internal i8* @aligned_8_return(i8* %a, i1 %c1, i1 %c2) norecurse {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; TUNIT-LABEL: define {{[^@]+}}@aligned_8_return
; TUNIT-SAME: (i8* noalias nofree readnone align 16 "no-capture-maybe-returned" [[A:%.*]], i1 [[C1:%.*]], i1 [[C2:%.*]]) #[[ATTR9]] {
; TUNIT-NEXT:    [[STACK:%.*]] = alloca i8*, align 8
; TUNIT-NEXT:    br i1 [[C1]], label [[T:%.*]], label [[F:%.*]]
; TUNIT:       t:
; TUNIT-NEXT:    [[GEP:%.*]] = getelementptr i8, i8* @G, i32 8
; TUNIT-NEXT:    [[SEL:%.*]] = select i1 [[C2]], i8* [[A]], i8* [[GEP]]
; TUNIT-NEXT:    store i8* [[SEL]], i8** [[STACK]], align 8
; TUNIT-NEXT:    br label [[END:%.*]]
; TUNIT:       f:
; TUNIT-NEXT:    store i8* @G, i8** [[STACK]], align 8
; TUNIT-NEXT:    br label [[END]]
; TUNIT:       end:
; TUNIT-NEXT:    [[L:%.*]] = load i8*, i8** [[STACK]], align 8
; TUNIT-NEXT:    ret i8* [[L]]
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CGSCC-LABEL: define {{[^@]+}}@aligned_8_return
; CGSCC-SAME: (i8* noalias nofree readnone align 16 "no-capture-maybe-returned" [[A:%.*]], i1 [[C1:%.*]], i1 [[C2:%.*]]) #[[ATTR10]] {
; CGSCC-NEXT:    [[STACK:%.*]] = alloca i8*, align 8
; CGSCC-NEXT:    br i1 [[C1]], label [[T:%.*]], label [[F:%.*]]
; CGSCC:       t:
; CGSCC-NEXT:    [[GEP:%.*]] = getelementptr i8, i8* @G, i32 8
; CGSCC-NEXT:    [[SEL:%.*]] = select i1 [[C2]], i8* [[A]], i8* [[GEP]]
; CGSCC-NEXT:    store i8* [[SEL]], i8** [[STACK]], align 8
; CGSCC-NEXT:    br label [[END:%.*]]
; CGSCC:       f:
; CGSCC-NEXT:    store i8* @G, i8** [[STACK]], align 8
; CGSCC-NEXT:    br label [[END]]
; CGSCC:       end:
; CGSCC-NEXT:    [[L:%.*]] = load i8*, i8** [[STACK]], align 8
; CGSCC-NEXT:    ret i8* [[L]]
;
  %stack = alloca i8*
  br i1 %c1, label %t, label %f
t:
  %gep = getelementptr i8, i8* @G, i32 8
  %sel = select i1 %c2, i8* %a, i8* %gep
  store i8* %sel, i8** %stack
  br label %end
f:
  store i8* @G, i8** %stack
  br label %end
end:
  %l = load i8*, i8** %stack
  ret i8* %l
}

define i8* @aligned_8_return_caller(i8* align(16) %a, i1 %c1, i1 %c2) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; TUNIT-LABEL: define {{[^@]+}}@aligned_8_return_caller
; TUNIT-SAME: (i8* nofree readnone align 16 "no-capture-maybe-returned" [[A:%.*]], i1 [[C1:%.*]], i1 [[C2:%.*]]) #[[ATTR9]] {
; TUNIT-NEXT:    [[R:%.*]] = call align 8 i8* @aligned_8_return(i8* noalias nofree readnone align 16 "no-capture-maybe-returned" [[A]], i1 [[C1]], i1 [[C2]]) #[[ATTR12:[0-9]+]]
; TUNIT-NEXT:    ret i8* [[R]]
;
; CGSCC: Function Attrs: nofree nosync nounwind readnone willreturn
; CGSCC-LABEL: define {{[^@]+}}@aligned_8_return_caller
; CGSCC-SAME: (i8* nofree readnone align 16 [[A:%.*]], i1 [[C1:%.*]], i1 [[C2:%.*]]) #[[ATTR12:[0-9]+]] {
; CGSCC-NEXT:    [[R:%.*]] = call align 8 i8* @aligned_8_return(i8* noalias nofree readnone align 16 [[A]], i1 [[C1]], i1 [[C2]]) #[[ATTR13]]
; CGSCC-NEXT:    ret i8* [[R]]
;
  %r = call i8* @aligned_8_return(i8* %a, i1 %c1, i1 %c2)
  ret i8* %r
}

attributes #0 = { nounwind uwtable noinline }
attributes #1 = { uwtable noinline }
attributes #2 = { null_pointer_is_valid }
;.
; TUNIT: attributes #[[ATTR0]] = { nofree noinline norecurse nosync nounwind readnone willreturn uwtable }
; TUNIT: attributes #[[ATTR1]] = { nofree noinline nosync nounwind readnone willreturn uwtable }
; TUNIT: attributes #[[ATTR2]] = { nounwind }
; TUNIT: attributes #[[ATTR3]] = { nofree nosync nounwind }
; TUNIT: attributes #[[ATTR4]] = { argmemonly nofree norecurse nosync nounwind readonly willreturn }
; TUNIT: attributes #[[ATTR5]] = { argmemonly nofree norecurse nosync nounwind willreturn writeonly }
; TUNIT: attributes #[[ATTR6]] = { nounwind willreturn }
; TUNIT: attributes #[[ATTR7]] = { argmemonly nofree noinline norecurse nosync nounwind willreturn writeonly uwtable }
; TUNIT: attributes #[[ATTR8]] = { nofree norecurse nosync nounwind willreturn writeonly }
; TUNIT: attributes #[[ATTR9]] = { nofree norecurse nosync nounwind readnone willreturn }
; TUNIT: attributes #[[ATTR10]] = { nofree norecurse nosync nounwind readonly willreturn }
; TUNIT: attributes #[[ATTR11]] = { nofree nosync nounwind readonly willreturn }
; TUNIT: attributes #[[ATTR12]] = { nofree nosync nounwind readnone willreturn }
;.
; CGSCC: attributes #[[ATTR0]] = { nofree noinline norecurse nosync nounwind readnone willreturn uwtable }
; CGSCC: attributes #[[ATTR1]] = { noinline nounwind uwtable }
; CGSCC: attributes #[[ATTR2]] = { nofree noinline nosync nounwind readnone willreturn uwtable }
; CGSCC: attributes #[[ATTR3]] = { nounwind }
; CGSCC: attributes #[[ATTR4]] = { nofree nosync nounwind }
; CGSCC: attributes #[[ATTR5]] = { argmemonly nofree norecurse nosync nounwind readonly willreturn }
; CGSCC: attributes #[[ATTR6]] = { argmemonly nofree norecurse nosync nounwind willreturn writeonly }
; CGSCC: attributes #[[ATTR7]] = { nounwind willreturn }
; CGSCC: attributes #[[ATTR8]] = { argmemonly nofree noinline norecurse nosync nounwind willreturn writeonly uwtable }
; CGSCC: attributes #[[ATTR9]] = { nofree norecurse nosync nounwind willreturn writeonly }
; CGSCC: attributes #[[ATTR10]] = { nofree norecurse nosync nounwind readnone willreturn }
; CGSCC: attributes #[[ATTR11]] = { nofree nosync nounwind readonly willreturn }
; CGSCC: attributes #[[ATTR12]] = { nofree nosync nounwind readnone willreturn }
; CGSCC: attributes #[[ATTR13]] = { readnone willreturn }
; CGSCC: attributes #[[ATTR14]] = { readonly willreturn }
;.
