; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=8 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

declare noalias i8* @malloc(i64) allockind("alloc,uninitialized") allocsize(0)

declare void @nocapture_func_frees_pointer(i8* nocapture)

declare void @func_throws(...)

declare void @sync_func(i8* %p)

declare void @sync_will_return(i8* %p) willreturn nounwind

declare void @no_sync_func(i8* nocapture %p) nofree nosync willreturn

declare void @nofree_func(i8* nocapture %p) nofree  nosync willreturn

declare void @foo(i32* %p)

declare void @foo_nounw(i32* %p) nounwind nofree

declare void @usei8(i8)

declare i32 @no_return_call() noreturn

declare void @free(i8* nocapture) allockind("free")

declare void @llvm.lifetime.start.p0i8(i64, i8* nocapture) nounwind

define void @h2s_value_simplify_interaction(i1 %c, i8* %A) {
; CHECK-LABEL: define {{[^@]+}}@h2s_value_simplify_interaction
; CHECK-SAME: (i1 [[C:%.*]], i8* nocapture nofree readnone [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add i64 2, 2
; CHECK-NEXT:    [[M:%.*]] = tail call noalias align 16 i8* @malloc(i64 noundef [[ADD]])
; CHECK-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    br i1 false, label [[DEAD:%.*]], label [[F2:%.*]]
; CHECK:       f:
; CHECK-NEXT:    br label [[J:%.*]]
; CHECK:       f2:
; CHECK-NEXT:    [[L:%.*]] = load i8, i8* [[M]], align 16
; CHECK-NEXT:    call void @usei8(i8 [[L]])
; CHECK-NEXT:    call void @no_sync_func(i8* nocapture nofree noundef align 16 [[M]]) #[[ATTR10:[0-9]+]]
; CHECK-NEXT:    br label [[J]]
; CHECK:       dead:
; CHECK-NEXT:    unreachable
; CHECK:       j:
; CHECK-NEXT:    [[PHI:%.*]] = phi i8* [ [[M]], [[F]] ], [ null, [[F2]] ]
; CHECK-NEXT:    tail call void @no_sync_func(i8* nocapture nofree noundef align 16 [[PHI]]) #[[ATTR10]]
; CHECK-NEXT:    ret void
;
entry:
  %add = add i64 2, 2
  %m = tail call align 16 noalias i8* @malloc(i64 %add)
  br i1 %c, label %t, label %f
t:
  br i1 false, label %dead, label %f2
f:
  br label %j
f2:
  %c1 = bitcast i8* %m to i32*
  %c2 = bitcast i32* %c1 to i8*
  %l = load i8, i8* %c2
  call void @usei8(i8 %l)
  call void @no_sync_func(i8* noundef %c2) nounwind
  br label %j
dead:
  br label %j
j:
  %phi = phi i8* [ %m, %f ], [ null, %f2 ], [ %A, %dead ]
  tail call void @no_sync_func(i8* noundef %phi) nounwind
  ;tail call void @free(i8* %m)
  ret void
}

define void @nofree_arg_only(i8* %p1, i8* %p2) {
; CHECK-LABEL: define {{[^@]+}}@nofree_arg_only
; CHECK-SAME: (i8* nocapture nofree [[P1:%.*]], i8* nocapture [[P2:%.*]]) {
; CHECK-NEXT:    tail call void @free(i8* nocapture [[P2]])
; CHECK-NEXT:    tail call void @nofree_func(i8* nocapture nofree [[P1]])
; CHECK-NEXT:    ret void
;
  tail call void @free(i8* %p2)
  tail call void @nofree_func(i8* %p1)
  ret void
}

; TEST 1 - negative, pointer freed in another function.

define void @test1() {
; CHECK-LABEL: define {{[^@]+}}@test1() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    tail call void @nocapture_func_frees_pointer(i8* noalias nocapture [[TMP1]])
; CHECK-NEXT:    tail call void (...) @func_throws()
; CHECK-NEXT:    tail call void @free(i8* noalias nocapture [[TMP1]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call void @nocapture_func_frees_pointer(i8* %1)
  tail call void (...) @func_throws()
  tail call void @free(i8* %1)
  ret void
}

; TEST 2 - negative, call to a sync function.

define void @test2() {
; CHECK-LABEL: define {{[^@]+}}@test2() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    tail call void @sync_func(i8* [[TMP1]])
; CHECK-NEXT:    tail call void @free(i8* nocapture [[TMP1]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call void @sync_func(i8* %1)
  tail call void @free(i8* %1)
  ret void
}

; TEST 3 - 1 malloc, 1 free

define void @test3() {
; CHECK-LABEL: define {{[^@]+}}@test3() {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    tail call void @no_sync_func(i8* noalias nocapture nofree [[DOTH2S]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call void @no_sync_func(i8* %1)
  tail call void @free(i8* %1)
  ret void
}

define void @test3a(i8* %p) {
; CHECK-LABEL: define {{[^@]+}}@test3a
; CHECK-SAME: (i8* nocapture [[P:%.*]]) {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    tail call void @nofree_arg_only(i8* noalias nocapture nofree [[DOTH2S]], i8* nocapture [[P]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call void @nofree_arg_only(i8* %1, i8* %p)
  tail call void @free(i8* %1)
  ret void
}

declare noalias i8* @aligned_alloc(i64 allocalign, i64) allockind("alloc,uninitialized,aligned") allocsize(1)

define void @test3b(i8* %p) {
; CHECK-LABEL: define {{[^@]+}}@test3b
; CHECK-SAME: (i8* nocapture [[P:%.*]]) {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 128, align 32
; CHECK-NEXT:    tail call void @nofree_arg_only(i8* noalias nocapture nofree [[DOTH2S]], i8* nocapture [[P]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @aligned_alloc(i64 32, i64 128)
  tail call void @nofree_arg_only(i8* %1, i8* %p)
  tail call void @free(i8* %1)
  ret void
}

; leave alone non-constant alignments.
define void @test3c(i64 %alignment) {
; CHECK-LABEL: define {{[^@]+}}@test3c
; CHECK-SAME: (i64 [[ALIGNMENT:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @aligned_alloc(i64 [[ALIGNMENT]], i64 noundef 128)
; CHECK-NEXT:    tail call void @free(i8* noalias nocapture [[TMP1]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @aligned_alloc(i64 %alignment, i64 128)
  tail call void @free(i8* %1)
  ret void
}

; leave alone a constant-but-invalid alignment
define void @test3d(i8* %p) {
; CHECK-LABEL: define {{[^@]+}}@test3d
; CHECK-SAME: (i8* nocapture [[P:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @aligned_alloc(i64 noundef 33, i64 noundef 128)
; CHECK-NEXT:    tail call void @nofree_arg_only(i8* noalias nocapture nofree [[TMP1]], i8* nocapture [[P]])
; CHECK-NEXT:    tail call void @free(i8* noalias nocapture [[TMP1]])
; CHECK-NEXT:    ret void
;
; CHECK-SAME; (i8* nocapture [[P:%.*]]) {
  %1 = tail call noalias i8* @aligned_alloc(i64 33, i64 128)
  tail call void @nofree_arg_only(i8* %1, i8* %p)
  tail call void @free(i8* %1)
  ret void
}

declare noalias i8* @calloc(i64, i64) allockind("alloc,zeroed") allocsize(0,1)

define void @test0() {
; CHECK-LABEL: define {{[^@]+}}@test0() {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 8, align 1
; CHECK-NEXT:    call void @llvm.memset.p0i8.i64(i8* [[DOTH2S]], i8 0, i64 8, i1 false)
; CHECK-NEXT:    tail call void @no_sync_func(i8* noalias nocapture nofree [[DOTH2S]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @calloc(i64 2, i64 4)
  tail call void @no_sync_func(i8* %1)
  tail call void @free(i8* %1)
  ret void
}

; TEST 4
define void @test4() {
; CHECK-LABEL: define {{[^@]+}}@test4() {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    tail call void @nofree_func(i8* noalias nocapture nofree [[DOTH2S]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call void @nofree_func(i8* %1)
  ret void
}

; TEST 5 - not all exit paths have a call to free, but all uses of malloc
; are in nofree functions and are not captured

define void @test5(i32, i8* %p) {
; CHECK-LABEL: define {{[^@]+}}@test5
; CHECK-SAME: (i32 [[TMP0:%.*]], i8* nocapture [[P:%.*]]) {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[TMP4:%.*]], label [[TMP3:%.*]]
; CHECK:       3:
; CHECK-NEXT:    tail call void @nofree_func(i8* noalias nocapture nofree [[DOTH2S]])
; CHECK-NEXT:    br label [[TMP5:%.*]]
; CHECK:       4:
; CHECK-NEXT:    tail call void @nofree_arg_only(i8* noalias nocapture nofree [[DOTH2S]], i8* nocapture [[P]])
; CHECK-NEXT:    br label [[TMP5]]
; CHECK:       5:
; CHECK-NEXT:    ret void
;
  %2 = tail call noalias i8* @malloc(i64 4)
  %3 = icmp eq i32 %0, 0
  br i1 %3, label %5, label %4

4:                                                ; preds = %1
  tail call void @nofree_func(i8* %2)
  br label %6

5:                                                ; preds = %1
  tail call void @nofree_arg_only(i8* %2, i8* %p)
  tail call void @free(i8* %2)
  br label %6

6:                                                ; preds = %5, %4
  ret void
}

; TEST 6 - all exit paths have a call to free

define void @test6(i32) {
; CHECK-LABEL: define {{[^@]+}}@test6
; CHECK-SAME: (i32 [[TMP0:%.*]]) {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[TMP4:%.*]], label [[TMP3:%.*]]
; CHECK:       3:
; CHECK-NEXT:    tail call void @nofree_func(i8* noalias nocapture nofree [[DOTH2S]])
; CHECK-NEXT:    br label [[TMP5:%.*]]
; CHECK:       4:
; CHECK-NEXT:    br label [[TMP5]]
; CHECK:       5:
; CHECK-NEXT:    ret void
;
  %2 = tail call noalias i8* @malloc(i64 4)
  %3 = icmp eq i32 %0, 0
  br i1 %3, label %5, label %4

4:                                                ; preds = %1
  tail call void @nofree_func(i8* %2)
  tail call void @free(i8* %2)
  br label %6

5:                                                ; preds = %1
  tail call void @free(i8* %2)
  br label %6

6:                                                ; preds = %5, %4
  ret void
}

; TEST 7 - free is dead.

define void @test7() {
; CHECK-LABEL: define {{[^@]+}}@test7() {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    [[TMP1:%.*]] = tail call i32 @no_return_call() #[[ATTR4:[0-9]+]]
; CHECK-NEXT:    unreachable
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call i32 @no_return_call()
  tail call void @free(i8* %1)
  ret void
}

; TEST 8 - Negative: bitcast pointer used in capture function

define void @test8() {
; CHECK-LABEL: define {{[^@]+}}@test8() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    tail call void @no_sync_func(i8* nocapture nofree [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i8* [[TMP1]] to i32*
; CHECK-NEXT:    store i32 10, i32* [[TMP2]], align 4
; CHECK-NEXT:    tail call void @foo(i32* noundef align 4 [[TMP2]])
; CHECK-NEXT:    tail call void @free(i8* nocapture noundef nonnull align 4 dereferenceable(4) [[TMP1]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call void @no_sync_func(i8* %1)
  %2 = bitcast i8* %1 to i32*
  store i32 10, i32* %2
  %3 = load i32, i32* %2
  tail call void @foo(i32* %2)
  tail call void @free(i8* %1)
  ret void
}

; TEST 9 - FIXME: malloc should be converted.
define void @test9() {
; CHECK-LABEL: define {{[^@]+}}@test9() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    tail call void @no_sync_func(i8* nocapture nofree [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i8* [[TMP1]] to i32*
; CHECK-NEXT:    store i32 10, i32* [[TMP2]], align 4
; CHECK-NEXT:    tail call void @foo_nounw(i32* nofree noundef align 4 [[TMP2]]) #[[ATTR10]]
; CHECK-NEXT:    tail call void @free(i8* nocapture noundef nonnull align 4 dereferenceable(4) [[TMP1]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call void @no_sync_func(i8* %1)
  %2 = bitcast i8* %1 to i32*
  store i32 10, i32* %2
  %3 = load i32, i32* %2
  tail call void @foo_nounw(i32* %2)
  tail call void @free(i8* %1)
  ret void
}

; TEST 10 - 1 malloc, 1 free

define i32 @test10() {
; CHECK-LABEL: define {{[^@]+}}@test10() {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    tail call void @no_sync_func(i8* noalias nocapture nofree [[DOTH2S]])
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i8* [[DOTH2S]] to i32*
; CHECK-NEXT:    store i32 10, i32* [[TMP1]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
; CHECK-NEXT:    ret i32 [[TMP2]]
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call void @no_sync_func(i8* %1)
  %2 = bitcast i8* %1 to i32*
  store i32 10, i32* %2
  %3 = load i32, i32* %2
  tail call void @free(i8* %1)
  ret i32 %3
}

define i32 @test_lifetime() {
; CHECK-LABEL: define {{[^@]+}}@test_lifetime() {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    tail call void @no_sync_func(i8* noalias nocapture nofree [[DOTH2S]])
; CHECK-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* noalias nocapture nofree noundef nonnull align 4 dereferenceable(4) [[DOTH2S]])
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i8* [[DOTH2S]] to i32*
; CHECK-NEXT:    store i32 10, i32* [[TMP1]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
; CHECK-NEXT:    ret i32 [[TMP2]]
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call void @no_sync_func(i8* %1)
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %1)
  %2 = bitcast i8* %1 to i32*
  store i32 10, i32* %2
  %3 = load i32, i32* %2
  tail call void @free(i8* %1)
  ret i32 %3
}

; TEST 11

define void @test11() {
; CHECK-LABEL: define {{[^@]+}}@test11() {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    tail call void @sync_will_return(i8* [[DOTH2S]]) #[[ATTR10]]
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  tail call void @sync_will_return(i8* %1)
  tail call void @free(i8* %1)
  ret void
}

; TEST 12
define i32 @irreducible_cfg(i32 %0) {
; CHECK-LABEL: define {{[^@]+}}@irreducible_cfg
; CHECK-SAME: (i32 [[TMP0:%.*]]) {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i8* [[DOTH2S]] to i32*
; CHECK-NEXT:    store i32 10, i32* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[TMP0]], 1
; CHECK-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP6:%.*]]
; CHECK:       4:
; CHECK-NEXT:    [[TMP5:%.*]] = add nsw i32 [[TMP0]], 5
; CHECK-NEXT:    br label [[TMP12:%.*]]
; CHECK:       6:
; CHECK-NEXT:    br label [[TMP7:%.*]]
; CHECK:       7:
; CHECK-NEXT:    [[DOT0:%.*]] = phi i32 [ [[TMP13:%.*]], [[TMP12]] ], [ 1, [[TMP6]] ]
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP9:%.*]] = add nsw i32 [[TMP8]], -1
; CHECK-NEXT:    store i32 [[TMP9]], i32* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP8]], 0
; CHECK-NEXT:    br i1 [[TMP10]], label [[TMP11:%.*]], label [[TMP14:%.*]]
; CHECK:       11:
; CHECK-NEXT:    br label [[TMP12]]
; CHECK:       12:
; CHECK-NEXT:    [[DOT1:%.*]] = phi i32 [ [[TMP5]], [[TMP4]] ], [ [[DOT0]], [[TMP11]] ]
; CHECK-NEXT:    [[TMP13]] = add nsw i32 [[DOT1]], 1
; CHECK-NEXT:    br label [[TMP7]]
; CHECK:       14:
; CHECK-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP2]], align 4
; CHECK-NEXT:    ret i32 [[TMP15]]
;
  %2 = call noalias i8* @malloc(i64 4)
  %3 = bitcast i8* %2 to i32*
  store i32 10, i32* %3, align 4
  %4 = icmp eq i32 %0, 1
  br i1 %4, label %5, label %7

5:                                                ; preds = %1
  %6 = add nsw i32 %0, 5
  br label %13

7:                                                ; preds = %1
  br label %8

8:                                                ; preds = %13, %7
  %.0 = phi i32 [ %14, %13 ], [ 1, %7 ]
  %9 = load i32, i32* %3, align 4
  %10 = add nsw i32 %9, -1
  store i32 %10, i32* %3, align 4
  %11 = icmp ne i32 %9, 0
  br i1 %11, label %12, label %15

12:                                               ; preds = %8
  br label %13

13:                                               ; preds = %12, %5
  %.1 = phi i32 [ %6, %5 ], [ %.0, %12 ]
  %14 = add nsw i32 %.1, 1
  br label %8

15:                                               ; preds = %8
  %16 = load i32, i32* %3, align 4
  %17 = bitcast i32* %3 to i8*
  call void @free(i8* %17)
  %18 = load i32, i32* %3, align 4
  ret i32 %18
}


define i32 @malloc_in_loop(i32 %0) {
; CHECK-LABEL: define {{[^@]+}}@malloc_in_loop
; CHECK-SAME: (i32 [[TMP0:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[TMP3:%.*]] = alloca i32*, align 8
; CHECK-NEXT:    store i32 [[TMP0]], i32* [[TMP2]], align 4
; CHECK-NEXT:    br label [[TMP4:%.*]]
; CHECK:       4:
; CHECK-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP6:%.*]] = add nsw i32 [[TMP5]], -1
; CHECK-NEXT:    store i32 [[TMP6]], i32* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = icmp sgt i32 [[TMP6]], 0
; CHECK-NEXT:    br i1 [[TMP7]], label [[TMP8:%.*]], label [[TMP10:%.*]]
; CHECK:       8:
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast i8* [[DOTH2S]] to i32*
; CHECK-NEXT:    br label [[TMP4]]
; CHECK:       10:
; CHECK-NEXT:    ret i32 5
;
  %2 = alloca i32, align 4
  %3 = alloca i32*, align 8
  store i32 %0, i32* %2, align 4
  br label %4

4:                                                ; preds = %8, %1
  %5 = load i32, i32* %2, align 4
  %6 = add nsw i32 %5, -1
  store i32 %6, i32* %2, align 4
  %7 = icmp sgt i32 %6, 0
  br i1 %7, label %8, label %11

8:                                                ; preds = %4
  %9 = call noalias i8* @malloc(i64 4)
  %10 = bitcast i8* %9 to i32*
  store i32 1, i32* %10, align 8
  br label %4

11:                                               ; preds = %4
  ret i32 5
}

; Malloc/Calloc too large
define i32 @test13() {
; CHECK-LABEL: define {{[^@]+}}@test13() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 256)
; CHECK-NEXT:    tail call void @no_sync_func(i8* noalias nocapture nofree [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i8* [[TMP1]] to i32*
; CHECK-NEXT:    store i32 10, i32* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
; CHECK-NEXT:    tail call void @free(i8* noalias nocapture noundef nonnull align 4 dereferenceable(4) [[TMP1]])
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %1 = tail call noalias i8* @malloc(i64 256)
  tail call void @no_sync_func(i8* %1)
  %2 = bitcast i8* %1 to i32*
  store i32 10, i32* %2
  %3 = load i32, i32* %2
  tail call void @free(i8* %1)
  ret i32 %3
}

define i32 @test_sle() {
; CHECK-LABEL: define {{[^@]+}}@test_sle() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef -1)
; CHECK-NEXT:    tail call void @no_sync_func(i8* noalias nocapture nofree [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i8* [[TMP1]] to i32*
; CHECK-NEXT:    store i32 10, i32* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
; CHECK-NEXT:    tail call void @free(i8* noalias nocapture noundef nonnull align 4 dereferenceable(4) [[TMP1]])
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %1 = tail call noalias i8* @malloc(i64 -1)
  tail call void @no_sync_func(i8* %1)
  %2 = bitcast i8* %1 to i32*
  store i32 10, i32* %2
  %3 = load i32, i32* %2
  tail call void @free(i8* %1)
  ret i32 %3
}

define i32 @test_overflow() {
; CHECK-LABEL: define {{[^@]+}}@test_overflow() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @calloc(i64 noundef 65537, i64 noundef 65537)
; CHECK-NEXT:    tail call void @no_sync_func(i8* noalias nocapture nofree [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i8* [[TMP1]] to i32*
; CHECK-NEXT:    store i32 10, i32* [[TMP2]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
; CHECK-NEXT:    tail call void @free(i8* noalias nocapture noundef nonnull align 4 dereferenceable(4) [[TMP1]])
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %1 = tail call noalias i8* @calloc(i64 65537, i64 65537)
  tail call void @no_sync_func(i8* %1)
  %2 = bitcast i8* %1 to i32*
  store i32 10, i32* %2
  %3 = load i32, i32* %2
  tail call void @free(i8* %1)
  ret i32 %3
}

define void @test14() {
; CHECK-LABEL: define {{[^@]+}}@test14() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @calloc(i64 noundef 64, i64 noundef 4)
; CHECK-NEXT:    tail call void @no_sync_func(i8* noalias nocapture nofree [[TMP1]])
; CHECK-NEXT:    tail call void @free(i8* noalias nocapture [[TMP1]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @calloc(i64 64, i64 4)
  tail call void @no_sync_func(i8* %1)
  tail call void @free(i8* %1)
  ret void
}

define void @test15(i64 %S) {
; CHECK-LABEL: define {{[^@]+}}@test15
; CHECK-SAME: (i64 [[S:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 [[S]])
; CHECK-NEXT:    tail call void @no_sync_func(i8* noalias nocapture nofree [[TMP1]])
; CHECK-NEXT:    tail call void @free(i8* noalias nocapture [[TMP1]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 %S)
  tail call void @no_sync_func(i8* %1)
  tail call void @free(i8* %1)
  ret void
}

define void @test16a(i8 %v, i8** %P) {
; CHECK-LABEL: define {{[^@]+}}@test16a
; CHECK-SAME: (i8 [[V:%.*]], i8** nocapture nofree readnone [[P:%.*]]) {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    store i8 [[V]], i8* [[DOTH2S]], align 1
; CHECK-NEXT:    tail call void @no_sync_func(i8* noalias nocapture nofree noundef nonnull dereferenceable(1) [[DOTH2S]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  store i8 %v, i8* %1
  tail call void @no_sync_func(i8* %1)
  tail call void @free(i8* nonnull dereferenceable(1) %1)
  ret void
}

define void @test16b(i8 %v, i8** %P) {
; CHECK-LABEL: define {{[^@]+}}@test16b
; CHECK-SAME: (i8 [[V:%.*]], i8** nocapture nofree writeonly [[P:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    store i8* [[TMP1]], i8** [[P]], align 8
; CHECK-NEXT:    tail call void @no_sync_func(i8* nocapture nofree [[TMP1]])
; CHECK-NEXT:    tail call void @free(i8* nocapture [[TMP1]])
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  store i8* %1, i8** %P
  tail call void @no_sync_func(i8* %1)
  tail call void @free(i8* %1)
  ret void
}

define void @test16c(i8 %v, i8** %P) {
; CHECK-LABEL: define {{[^@]+}}@test16c
; CHECK-SAME: (i8 [[V:%.*]], i8** nocapture nofree writeonly [[P:%.*]]) {
; CHECK-NEXT:    [[DOTH2S:%.*]] = alloca i8, i64 4, align 1
; CHECK-NEXT:    store i8* [[DOTH2S]], i8** [[P]], align 8
; CHECK-NEXT:    tail call void @no_sync_func(i8* nocapture nofree [[DOTH2S]]) #[[ATTR10]]
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  store i8* %1, i8** %P
  tail call void @no_sync_func(i8* %1) nounwind
  tail call void @free(i8* %1)
  ret void
}

define void @test16d(i8 %v, i8** %P) {
; CHECK-LABEL: define {{[^@]+}}@test16d
; CHECK-SAME: (i8 [[V:%.*]], i8** nocapture nofree writeonly [[P:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    store i8* [[TMP1]], i8** [[P]], align 8
; CHECK-NEXT:    ret void
;
  %1 = tail call noalias i8* @malloc(i64 4)
  store i8* %1, i8** %P
  ret void
}
;.
; CHECK: attributes #[[ATTR0:[0-9]+]] = { allockind("alloc,uninitialized") allocsize(0) }
; CHECK: attributes #[[ATTR1:[0-9]+]] = { nounwind willreturn }
; CHECK: attributes #[[ATTR2:[0-9]+]] = { nofree nosync willreturn }
; CHECK: attributes #[[ATTR3:[0-9]+]] = { nofree nounwind }
; CHECK: attributes #[[ATTR4]] = { noreturn }
; CHECK: attributes #[[ATTR5:[0-9]+]] = { allockind("free") }
; CHECK: attributes #[[ATTR6:[0-9]+]] = { argmemonly nocallback nofree nosync nounwind willreturn }
; CHECK: attributes #[[ATTR7:[0-9]+]] = { allockind("alloc,uninitialized,aligned") allocsize(1) }
; CHECK: attributes #[[ATTR8:[0-9]+]] = { allockind("alloc,zeroed") allocsize(0,1) }
; CHECK: attributes #[[ATTR9:[0-9]+]] = { argmemonly nocallback nofree nounwind willreturn writeonly }
; CHECK: attributes #[[ATTR10]] = { nounwind }
;.
