; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=2 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

; TEST 1 - negative.

; void *G;
; void *foo(){
;   void *V = malloc(4);
;   G = V;
;   return V;
; }

@G = external global i8*

;.
; CHECK: @[[G:[a-zA-Z0-9_$"\\.-]+]] = external global i8*
; CHECK: @[[ALIAS_OF_P:[a-zA-Z0-9_$"\\.-]+]] = external global i32*
;.
define i8* @foo() {
; CHECK-LABEL: define {{[^@]+}}@foo() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    store i8* [[TMP1]], i8** @G, align 8
; CHECK-NEXT:    ret i8* [[TMP1]]
;
  %1 = tail call noalias i8* @malloc(i64 4)
  store i8* %1, i8** @G, align 8
  ret i8* %1
}

declare noalias i8* @malloc(i64)

; TEST 2
; call noalias function in return instruction.

define i8* @return_noalias(){
; CHECK-LABEL: define {{[^@]+}}@return_noalias() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    ret i8* [[TMP1]]
;
  %1 = tail call noalias i8* @malloc(i64 4)
  ret i8* %1
}

define void @nocapture(i8* %a){
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@nocapture
; CHECK-SAME: (i8* nocapture nofree readnone [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    ret void
;
  ret void
}

define i8* @return_noalias_looks_like_capture(){
; CHECK-LABEL: define {{[^@]+}}@return_noalias_looks_like_capture() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    ret i8* [[TMP1]]
;
  %1 = tail call noalias i8* @malloc(i64 4)
  call void @nocapture(i8* %1)
  ret i8* %1
}

define i16* @return_noalias_casted(){
; CHECK-LABEL: define {{[^@]+}}@return_noalias_casted() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    [[C:%.*]] = bitcast i8* [[TMP1]] to i16*
; CHECK-NEXT:    ret i16* [[C]]
;
  %1 = tail call noalias i8* @malloc(i64 4)
  %c = bitcast i8* %1 to i16*
  ret i16* %c
}

declare i8* @alias()

; TEST 3
define i8* @call_alias(){
; CHECK-LABEL: define {{[^@]+}}@call_alias() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call i8* @alias()
; CHECK-NEXT:    ret i8* [[TMP1]]
;
  %1 = tail call i8* @alias()
  ret i8* %1
}

; TEST 4
; void *baz();
; void *foo(int a);
;
; void *bar()  {
;   foo(0);
;    return baz();
; }
;
; void *foo(int a)  {
;   if (a)
;   bar();
;   return malloc(4);
; }

define i8* @bar() nounwind uwtable {
; TUNIT: Function Attrs: nounwind uwtable
; TUNIT-LABEL: define {{[^@]+}}@bar
; TUNIT-SAME: () #[[ATTR1:[0-9]+]] {
; TUNIT-NEXT:    [[TMP1:%.*]] = tail call i8* (...) @baz() #[[ATTR2:[0-9]+]]
; TUNIT-NEXT:    ret i8* [[TMP1]]
;
; CGSCC: Function Attrs: nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@bar
; CGSCC-SAME: () #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:    [[TMP1:%.*]] = tail call i8* (...) @baz() #[[ATTR3:[0-9]+]]
; CGSCC-NEXT:    ret i8* [[TMP1]]
;
  %1 = tail call i8* (...) @baz()
  ret i8* %1
}

define i8* @foo1(i32 %0) nounwind uwtable {
; TUNIT: Function Attrs: nounwind uwtable
; TUNIT-LABEL: define {{[^@]+}}@foo1
; TUNIT-SAME: (i32 [[TMP0:%.*]]) #[[ATTR1]] {
; TUNIT-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[TMP0]], 0
; TUNIT-NEXT:    br i1 [[TMP2]], label [[TMP5:%.*]], label [[TMP3:%.*]]
; TUNIT:       3:
; TUNIT-NEXT:    [[TMP4:%.*]] = tail call i8* (...) @baz() #[[ATTR2]]
; TUNIT-NEXT:    br label [[TMP5]]
; TUNIT:       5:
; TUNIT-NEXT:    [[TMP6:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; TUNIT-NEXT:    ret i8* [[TMP6]]
;
; CGSCC: Function Attrs: nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@foo1
; CGSCC-SAME: (i32 [[TMP0:%.*]]) #[[ATTR1]] {
; CGSCC-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[TMP0]], 0
; CGSCC-NEXT:    br i1 [[TMP2]], label [[TMP5:%.*]], label [[TMP3:%.*]]
; CGSCC:       3:
; CGSCC-NEXT:    [[TMP4:%.*]] = tail call i8* (...) @baz() #[[ATTR3]]
; CGSCC-NEXT:    br label [[TMP5]]
; CGSCC:       5:
; CGSCC-NEXT:    [[TMP6:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CGSCC-NEXT:    ret i8* [[TMP6]]
;
  %2 = icmp eq i32 %0, 0
  br i1 %2, label %5, label %3

3:                                                ; preds = %1
  %4 = tail call i8* (...) @baz()
  br label %5

5:                                                ; preds = %1, %3
  %6 = tail call noalias i8* @malloc(i64 4)
  ret i8* %6
}

declare i8* @baz(...) nounwind uwtable

; TEST 5

; Returning global pointer. Should not be noalias.
define i8** @getter() {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@getter
; CHECK-SAME: () #[[ATTR0]] {
; CHECK-NEXT:    ret i8** @G
;
  ret i8** @G
}

; Returning global pointer. Should not be noalias.
define i8** @calle1(){
; TUNIT: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; TUNIT-LABEL: define {{[^@]+}}@calle1
; TUNIT-SAME: () #[[ATTR0]] {
; TUNIT-NEXT:    ret i8** @G
;
; CGSCC: Function Attrs: nofree nosync nounwind readnone willreturn
; CGSCC-LABEL: define {{[^@]+}}@calle1
; CGSCC-SAME: () #[[ATTR2:[0-9]+]] {
; CGSCC-NEXT:    [[TMP1:%.*]] = call noundef nonnull align 8 dereferenceable(8) i8** @getter() #[[ATTR11:[0-9]+]]
; CGSCC-NEXT:    ret i8** [[TMP1]]
;
  %1 = call i8** @getter()
  ret i8** %1
}

; TEST 6
declare noalias i8* @strdup(i8* nocapture) nounwind

define i8* @test6() nounwind uwtable ssp {
; TUNIT: Function Attrs: nounwind ssp uwtable
; TUNIT-LABEL: define {{[^@]+}}@test6
; TUNIT-SAME: () #[[ATTR3:[0-9]+]] {
; TUNIT-NEXT:    [[X:%.*]] = alloca [2 x i8], align 1
; TUNIT-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i8], [2 x i8]* [[X]], i64 0, i64 0
; TUNIT-NEXT:    store i8 97, i8* [[ARRAYIDX]], align 1
; TUNIT-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds [2 x i8], [2 x i8]* [[X]], i64 0, i64 1
; TUNIT-NEXT:    store i8 0, i8* [[ARRAYIDX1]], align 1
; TUNIT-NEXT:    [[CALL:%.*]] = call noalias i8* @strdup(i8* nocapture noundef nonnull dereferenceable(2) [[ARRAYIDX]]) #[[ATTR2]]
; TUNIT-NEXT:    ret i8* [[CALL]]
;
; CGSCC: Function Attrs: nounwind ssp uwtable
; CGSCC-LABEL: define {{[^@]+}}@test6
; CGSCC-SAME: () #[[ATTR4:[0-9]+]] {
; CGSCC-NEXT:    [[X:%.*]] = alloca [2 x i8], align 1
; CGSCC-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i8], [2 x i8]* [[X]], i64 0, i64 0
; CGSCC-NEXT:    store i8 97, i8* [[ARRAYIDX]], align 1
; CGSCC-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds [2 x i8], [2 x i8]* [[X]], i64 0, i64 1
; CGSCC-NEXT:    store i8 0, i8* [[ARRAYIDX1]], align 1
; CGSCC-NEXT:    [[CALL:%.*]] = call noalias i8* @strdup(i8* nocapture noundef nonnull dereferenceable(2) [[ARRAYIDX]]) #[[ATTR3]]
; CGSCC-NEXT:    ret i8* [[CALL]]
;
  %x = alloca [2 x i8], align 1
  %arrayidx = getelementptr inbounds [2 x i8], [2 x i8]* %x, i64 0, i64 0
  store i8 97, i8* %arrayidx, align 1
  %arrayidx1 = getelementptr inbounds [2 x i8], [2 x i8]* %x, i64 0, i64 1
  store i8 0, i8* %arrayidx1, align 1
  %call = call noalias i8* @strdup(i8* %arrayidx) nounwind
  ret i8* %call
}

; TEST 7

define i8* @test7() nounwind {
; TUNIT: Function Attrs: nounwind
; TUNIT-LABEL: define {{[^@]+}}@test7
; TUNIT-SAME: () #[[ATTR2]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[A:%.*]] = call noalias i8* @malloc(i64 noundef 4) #[[ATTR2]]
; TUNIT-NEXT:    [[TOBOOL:%.*]] = icmp eq i8* [[A]], null
; TUNIT-NEXT:    br i1 [[TOBOOL]], label [[RETURN:%.*]], label [[IF_END:%.*]]
; TUNIT:       if.end:
; TUNIT-NEXT:    store i8 7, i8* [[A]], align 1
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       return:
; TUNIT-NEXT:    [[RETVAL_0:%.*]] = phi i8* [ [[A]], [[IF_END]] ], [ null, [[ENTRY:%.*]] ]
; TUNIT-NEXT:    ret i8* [[RETVAL_0]]
;
; CGSCC: Function Attrs: nounwind
; CGSCC-LABEL: define {{[^@]+}}@test7
; CGSCC-SAME: () #[[ATTR3]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[A:%.*]] = call noalias i8* @malloc(i64 noundef 4) #[[ATTR3]]
; CGSCC-NEXT:    [[TOBOOL:%.*]] = icmp eq i8* [[A]], null
; CGSCC-NEXT:    br i1 [[TOBOOL]], label [[RETURN:%.*]], label [[IF_END:%.*]]
; CGSCC:       if.end:
; CGSCC-NEXT:    store i8 7, i8* [[A]], align 1
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       return:
; CGSCC-NEXT:    [[RETVAL_0:%.*]] = phi i8* [ [[A]], [[IF_END]] ], [ null, [[ENTRY:%.*]] ]
; CGSCC-NEXT:    ret i8* [[RETVAL_0]]
;
entry:
  %A = call noalias i8* @malloc(i64 4) nounwind
  %tobool = icmp eq i8* %A, null
  br i1 %tobool, label %return, label %if.end

if.end:
  store i8 7, i8* %A
  br label %return

return:
  %retval.0 = phi i8* [ %A, %if.end ], [ null, %entry ]
  ret i8* %retval.0
}

; TEST 8

define i8* @test8(i32* %0) nounwind uwtable {
; CHECK: Function Attrs: nounwind uwtable
; CHECK-LABEL: define {{[^@]+}}@test8
; CHECK-SAME: (i32* [[TMP0:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[TMP2:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ne i32* [[TMP0]], null
; CHECK-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP5:%.*]]
; CHECK:       4:
; CHECK-NEXT:    store i8 10, i8* [[TMP2]], align 1
; CHECK-NEXT:    br label [[TMP5]]
; CHECK:       5:
; CHECK-NEXT:    ret i8* [[TMP2]]
;
  %2 = tail call noalias i8* @malloc(i64 4)
  %3 = icmp ne i32* %0, null
  br i1 %3, label %4, label %5

4:                                                ; preds = %1
  store i8 10, i8* %2
  br label %5

5:                                                ; preds = %1, %4
  ret i8* %2
}

; TEST 9
; Simple Argument Test
declare void @use_i8(i8* nocapture)
define internal void @test9a(i8* %a, i8* %b) {
; CHECK-LABEL: define {{[^@]+}}@test9a() {
; CHECK-NEXT:    call void @use_i8(i8* noalias nocapture noundef align 4294967296 null)
; CHECK-NEXT:    ret void
;
  call void @use_i8(i8* null)
  ret void
}
define internal void @test9b(i8* %a, i8* %b) {
; FIXME: %b should be noalias
; CHECK-LABEL: define {{[^@]+}}@test9b
; CHECK-SAME: (i8* noalias nocapture [[A:%.*]], i8* nocapture [[B:%.*]]) {
; CHECK-NEXT:    call void @use_i8(i8* noalias nocapture [[A]])
; CHECK-NEXT:    call void @use_i8(i8* nocapture [[B]])
; CHECK-NEXT:    ret void
;
  call void @use_i8(i8* %a)
  call void @use_i8(i8* %b)
  ret void
}
define internal void @test9c(i8* %a, i8* %b, i8* %c) {
; CHECK-LABEL: define {{[^@]+}}@test9c
; CHECK-SAME: (i8* noalias nocapture [[A:%.*]], i8* nocapture [[B:%.*]], i8* nocapture [[C:%.*]]) {
; CHECK-NEXT:    call void @use_i8(i8* noalias nocapture [[A]])
; CHECK-NEXT:    call void @use_i8(i8* nocapture [[B]])
; CHECK-NEXT:    call void @use_i8(i8* nocapture [[C]])
; CHECK-NEXT:    ret void
;
  call void @use_i8(i8* %a)
  call void @use_i8(i8* %b)
  call void @use_i8(i8* %c)
  ret void
}
define void @test9_helper(i8* %a, i8* %b) {
; CHECK-LABEL: define {{[^@]+}}@test9_helper
; CHECK-SAME: (i8* nocapture [[A:%.*]], i8* nocapture [[B:%.*]]) {
; CHECK-NEXT:    tail call void @test9a()
; CHECK-NEXT:    tail call void @test9a()
; CHECK-NEXT:    tail call void @test9b(i8* noalias nocapture [[A]], i8* nocapture [[B]])
; CHECK-NEXT:    tail call void @test9b(i8* noalias nocapture [[B]], i8* noalias nocapture [[A]])
; CHECK-NEXT:    tail call void @test9c(i8* noalias nocapture [[A]], i8* nocapture [[B]], i8* nocapture [[B]])
; CHECK-NEXT:    tail call void @test9c(i8* noalias nocapture [[B]], i8* noalias nocapture [[A]], i8* noalias nocapture [[A]])
; CHECK-NEXT:    ret void
;
  tail call void @test9a(i8* noalias %a, i8* %b)
  tail call void @test9a(i8* noalias %b, i8* noalias %a)
  tail call void @test9b(i8* noalias %a, i8* %b)
  tail call void @test9b(i8* noalias %b, i8* noalias %a)
  tail call void @test9c(i8* noalias %a, i8* %b, i8* %b)
  tail call void @test9c(i8* noalias %b, i8* noalias %a, i8* noalias %a)
  ret void
}


; TEST 10
; Simple CallSite Test

declare void @test10_helper_1(i8* %a)
define void @test10_helper_2(i8* noalias %a) {
; CHECK-LABEL: define {{[^@]+}}@test10_helper_2
; CHECK-SAME: (i8* noalias [[A:%.*]]) {
; CHECK-NEXT:    tail call void @test10_helper_1(i8* [[A]])
; CHECK-NEXT:    ret void
;
  tail call void @test10_helper_1(i8* %a)
  ret void
}
define void @test10(i8* noalias %a) {
; CHECK-LABEL: define {{[^@]+}}@test10
; CHECK-SAME: (i8* noalias [[A:%.*]]) {
; CHECK-NEXT:    tail call void @test10_helper_1(i8* [[A]])
; CHECK-NEXT:    tail call void @test10_helper_2(i8* noalias [[A]])
; CHECK-NEXT:    ret void
;
; FIXME: missing noalias
  tail call void @test10_helper_1(i8* %a)

  tail call void @test10_helper_2(i8* %a)
  ret void
}

; TEST 11
; CallSite Test

declare void @test11_helper(i8* %a, i8 *%b)
define void @test11(i8* noalias %a) {
; CHECK-LABEL: define {{[^@]+}}@test11
; CHECK-SAME: (i8* noalias [[A:%.*]]) {
; CHECK-NEXT:    tail call void @test11_helper(i8* [[A]], i8* [[A]])
; CHECK-NEXT:    ret void
;
  tail call void @test11_helper(i8* %a, i8* %a)
  ret void
}


; TEST 12
; CallSite Argument
declare void @use_nocapture(i8* nocapture)
declare void @use(i8*)
define void @test12_1() {
; CHECK-LABEL: define {{[^@]+}}@test12_1() {
; CHECK-NEXT:    [[A:%.*]] = alloca i8, align 4
; CHECK-NEXT:    [[B:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    tail call void @use_nocapture(i8* noalias nocapture noundef nonnull align 4 dereferenceable(1) [[A]])
; CHECK-NEXT:    tail call void @use_nocapture(i8* noalias nocapture noundef nonnull align 4 dereferenceable(1) [[A]])
; CHECK-NEXT:    tail call void @use_nocapture(i8* noalias nocapture [[B]])
; CHECK-NEXT:    tail call void @use_nocapture(i8* noalias nocapture [[B]])
; CHECK-NEXT:    ret void
;
  %A = alloca i8, align 4
  %B = tail call noalias i8* @malloc(i64 4)
  tail call void @use_nocapture(i8* %A)
  tail call void @use_nocapture(i8* %A)
  tail call void @use_nocapture(i8* %B)
  tail call void @use_nocapture(i8* %B)
  ret void
}

define void @test12_2(){
; CHECK-LABEL: define {{[^@]+}}@test12_2() {
; CHECK-NEXT:    [[A:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    tail call void @use_nocapture(i8* nocapture [[A]])
; CHECK-NEXT:    tail call void @use_nocapture(i8* nocapture [[A]])
; CHECK-NEXT:    tail call void @use(i8* [[A]])
; CHECK-NEXT:    tail call void @use_nocapture(i8* nocapture [[A]])
; CHECK-NEXT:    ret void
;
; FIXME: This should be @use_nocapture(i8* noalias [[A]])
; FIXME: This should be @use_nocapture(i8* noalias nocapture [[A]])
  %A = tail call noalias i8* @malloc(i64 4)
  tail call void @use_nocapture(i8* %A)
  tail call void @use_nocapture(i8* %A)
  tail call void @use(i8* %A)
  tail call void @use_nocapture(i8* %A)
  ret void
}

declare void @two_args(i8* nocapture , i8* nocapture)
define void @test12_3(){
; CHECK-LABEL: define {{[^@]+}}@test12_3() {
; CHECK-NEXT:    [[A:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    tail call void @two_args(i8* nocapture [[A]], i8* nocapture [[A]])
; CHECK-NEXT:    ret void
;
  %A = tail call noalias i8* @malloc(i64 4)
  tail call void @two_args(i8* %A, i8* %A)
  ret void
}

define void @test12_4(){
; CHECK-LABEL: define {{[^@]+}}@test12_4() {
; CHECK-NEXT:    [[A:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    [[B:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    [[A_1:%.*]] = getelementptr i8, i8* [[A]], i64 1
; CHECK-NEXT:    tail call void @two_args(i8* noalias nocapture [[A]], i8* noalias nocapture [[B]])
; CHECK-NEXT:    tail call void @two_args(i8* nocapture [[A]], i8* nocapture [[A]])
; CHECK-NEXT:    tail call void @two_args(i8* nocapture [[A]], i8* nocapture [[A_1]])
; CHECK-NEXT:    tail call void @two_args(i8* nocapture [[A]], i8* nocapture [[B]])
; CHECK-NEXT:    ret void
;
  %A = tail call noalias i8* @malloc(i64 4)
  %B = tail call noalias i8* @malloc(i64 4)
  %A_0 = getelementptr i8, i8* %A, i64 0
  %A_1 = getelementptr i8, i8* %A, i64 1
  %B_0 = getelementptr i8, i8* %B, i64 0

  tail call void @two_args(i8* %A, i8* %B)

  tail call void @two_args(i8* %A, i8* %A_0)

  tail call void @two_args(i8* %A, i8* %A_1)

; FIXME: This should be @two_args(i8* noalias nocapture %A_0, i8* noalias nocapture %B_0)
  tail call void @two_args(i8* %A_0, i8* %B_0)
  ret void
}

; TEST 13
define void @use_i8_internal(i8* %a) {
; CHECK-LABEL: define {{[^@]+}}@use_i8_internal
; CHECK-SAME: (i8* nocapture [[A:%.*]]) {
; CHECK-NEXT:    call void @use_i8(i8* nocapture [[A]])
; CHECK-NEXT:    ret void
;
  call void @use_i8(i8* %a)
  ret void
}

define void @test13_use_noalias(){
; CHECK-LABEL: define {{[^@]+}}@test13_use_noalias() {
; CHECK-NEXT:    [[M1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    call void @use_i8_internal(i8* noalias nocapture [[M1]])
; CHECK-NEXT:    ret void
;
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@test13_use_noalias()
; IS__CGSCC_OPM-NEXT:    [[M1:%.*]] = tail call noalias i8* @malloc(i64 4)
; IS__CGSCC_OPM-NEXT:    [[C1:%.*]] = bitcast i8* [[M1]] to i16*
; IS__CGSCC_OPM-NEXT:    [[C2:%.*]] = bitcast i16* [[C1]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @use_i8_internal(i8* noalias [[C2]])
; IS__CGSCC_OPM-NEXT:    ret void
  %m1 = tail call noalias i8* @malloc(i64 4)
  %c1 = bitcast i8* %m1 to i16*
  %c2 = bitcast i16* %c1 to i8*
  call void @use_i8_internal(i8* %c2)
  ret void
}

define void @test13_use_alias(){
; CHECK-LABEL: define {{[^@]+}}@test13_use_alias() {
; CHECK-NEXT:    [[M1:%.*]] = tail call noalias i8* @malloc(i64 noundef 4)
; CHECK-NEXT:    call void @use_i8_internal(i8* nocapture [[M1]])
; CHECK-NEXT:    call void @use_i8_internal(i8* nocapture [[M1]])
; CHECK-NEXT:    ret void
;
  %m1 = tail call noalias i8* @malloc(i64 4)
  %c1 = bitcast i8* %m1 to i16*
  %c2a = bitcast i16* %c1 to i8*
  %c2b = bitcast i16* %c1 to i8*
  call void @use_i8_internal(i8* %c2a)
  call void @use_i8_internal(i8* %c2b)
  ret void
}

; TEST 14 i2p casts
define internal i32 @p2i(i32* %arg) {
; CHECK: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; CHECK-LABEL: define {{[^@]+}}@p2i
; CHECK-SAME: (i32* noalias nofree readnone [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[P2I:%.*]] = ptrtoint i32* [[ARG]] to i32
; CHECK-NEXT:    ret i32 [[P2I]]
;
  %p2i = ptrtoint i32* %arg to i32
  ret i32 %p2i
}

define i32 @i2p(i32* %arg) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind readonly willreturn
; TUNIT-LABEL: define {{[^@]+}}@i2p
; TUNIT-SAME: (i32* nofree readonly [[ARG:%.*]]) #[[ATTR4:[0-9]+]] {
; TUNIT-NEXT:    [[C:%.*]] = call i32 @p2i(i32* noalias nofree readnone [[ARG]]) #[[ATTR9:[0-9]+]]
; TUNIT-NEXT:    [[I2P:%.*]] = inttoptr i32 [[C]] to i8*
; TUNIT-NEXT:    [[BC:%.*]] = bitcast i8* [[I2P]] to i32*
; TUNIT-NEXT:    [[CALL:%.*]] = call i32 @ret(i32* nocapture nofree readonly align 4 [[BC]]) #[[ATTR10:[0-9]+]]
; TUNIT-NEXT:    ret i32 [[CALL]]
;
; CGSCC: Function Attrs: nofree nosync nounwind readonly willreturn
; CGSCC-LABEL: define {{[^@]+}}@i2p
; CGSCC-SAME: (i32* nofree readonly [[ARG:%.*]]) #[[ATTR5:[0-9]+]] {
; CGSCC-NEXT:    [[C:%.*]] = call i32 @p2i(i32* noalias nofree readnone [[ARG]]) #[[ATTR11]]
; CGSCC-NEXT:    [[I2P:%.*]] = inttoptr i32 [[C]] to i8*
; CGSCC-NEXT:    [[BC:%.*]] = bitcast i8* [[I2P]] to i32*
; CGSCC-NEXT:    [[CALL:%.*]] = call i32 @ret(i32* nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[BC]]) #[[ATTR12:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[CALL]]
;
  %c = call i32 @p2i(i32* %arg)
  %i2p = inttoptr i32 %c to i8*
  %bc = bitcast i8* %i2p to i32*
  %call = call i32 @ret(i32* %bc)
  ret i32 %call
}
define internal i32 @ret(i32* %arg) {
; TUNIT: Function Attrs: argmemonly nofree norecurse nosync nounwind readonly willreturn
; TUNIT-LABEL: define {{[^@]+}}@ret
; TUNIT-SAME: (i32* nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[ARG:%.*]]) #[[ATTR5:[0-9]+]] {
; TUNIT-NEXT:    [[L:%.*]] = load i32, i32* [[ARG]], align 4
; TUNIT-NEXT:    ret i32 [[L]]
;
; CGSCC: Function Attrs: argmemonly nofree norecurse nosync nounwind readonly willreturn
; CGSCC-LABEL: define {{[^@]+}}@ret
; CGSCC-SAME: (i32* nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[ARG:%.*]]) #[[ATTR6:[0-9]+]] {
; CGSCC-NEXT:    [[L:%.*]] = load i32, i32* [[ARG]], align 4
; CGSCC-NEXT:    ret i32 [[L]]
;
  %l = load i32, i32* %arg
  ret i32 %l
}

; Test to propagate noalias where value is assumed to be no-capture in all the
; uses possibly executed before this callsite.
; IR referred from musl/src/strtod.c file

%struct._IO_FILE = type { i32, i8*, i8*, i32 (%struct._IO_FILE*)*, i8*, i8*, i8*, i8*, i32 (%struct._IO_FILE*, i8*, i32)*, i32 (%struct._IO_FILE*, i8*, i32)*, i64 (%struct._IO_FILE*, i64, i32)*, i8*, i32, %struct._IO_FILE*, %struct._IO_FILE*, i32, i32, i32, i16, i8, i8, i32, i32, i8*, i64, i8*, i8*, i8*, [4 x i8], i64, i64, %struct._IO_FILE*, %struct._IO_FILE*, %struct.__locale_struct*, [4 x i8] }
%struct.__locale_struct = type { [6 x %struct.__locale_map*] }
%struct.__locale_map = type opaque

; Function Attrs: nounwind optsize
define internal fastcc double @strtox(i8* %s, i8** %p, i32 %prec) unnamed_addr {
; TUNIT-LABEL: define {{[^@]+}}@strtox
; TUNIT-SAME: (i8* [[S:%.*]]) unnamed_addr {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[F:%.*]] = alloca [[STRUCT__IO_FILE:%.*]], align 8
; TUNIT-NEXT:    [[TMP0:%.*]] = bitcast %struct._IO_FILE* [[F]] to i8*
; TUNIT-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 144, i8* nocapture nofree noundef nonnull align 8 dereferenceable(240) [[TMP0]]) #[[ATTR11:[0-9]+]]
; TUNIT-NEXT:    [[CALL:%.*]] = call i32 bitcast (i32 (...)* @sh_fromstring to i32 (%struct._IO_FILE*, i8*)*)(%struct._IO_FILE* nonnull align 8 dereferenceable(240) [[F]], i8* [[S]])
; TUNIT-NEXT:    call void @__shlim(%struct._IO_FILE* noundef nonnull align 8 dereferenceable(240) [[F]], i64 noundef 0)
; TUNIT-NEXT:    [[CALL1:%.*]] = call double @__floatscan(%struct._IO_FILE* noundef nonnull align 8 dereferenceable(240) [[F]], i32 noundef 1, i32 noundef 1)
; TUNIT-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 144, i8* nocapture nofree noundef nonnull align 8 dereferenceable(240) [[TMP0]])
; TUNIT-NEXT:    ret double [[CALL1]]
;
; CGSCC-LABEL: define {{[^@]+}}@strtox
; CGSCC-SAME: (i8* [[S:%.*]]) unnamed_addr {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[F:%.*]] = alloca [[STRUCT__IO_FILE:%.*]], align 8
; CGSCC-NEXT:    [[TMP0:%.*]] = bitcast %struct._IO_FILE* [[F]] to i8*
; CGSCC-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 144, i8* nocapture nofree noundef nonnull align 8 dereferenceable(240) [[TMP0]]) #[[ATTR13:[0-9]+]]
; CGSCC-NEXT:    [[CALL:%.*]] = call i32 bitcast (i32 (...)* @sh_fromstring to i32 (%struct._IO_FILE*, i8*)*)(%struct._IO_FILE* nonnull align 8 dereferenceable(240) [[F]], i8* [[S]])
; CGSCC-NEXT:    call void @__shlim(%struct._IO_FILE* noundef nonnull align 8 dereferenceable(240) [[F]], i64 noundef 0)
; CGSCC-NEXT:    [[CALL1:%.*]] = call double @__floatscan(%struct._IO_FILE* noundef nonnull align 8 dereferenceable(240) [[F]], i32 noundef 1, i32 noundef 1)
; CGSCC-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 144, i8* nocapture nofree noundef nonnull align 8 dereferenceable(240) [[TMP0]])
; CGSCC-NEXT:    ret double [[CALL1]]
;
entry:
  %f = alloca %struct._IO_FILE, align 8
  %0 = bitcast %struct._IO_FILE* %f to i8*
  call void @llvm.lifetime.start.p0i8(i64 144, i8* nonnull %0)
  %call = call i32 bitcast (i32 (...)* @sh_fromstring to i32 (%struct._IO_FILE*, i8*)*)(%struct._IO_FILE* nonnull %f, i8* %s)
  call void @__shlim(%struct._IO_FILE* nonnull %f, i64 0)
  %call1 = call double @__floatscan(%struct._IO_FILE* nonnull %f, i32 %prec, i32 1)
  call void @llvm.lifetime.end.p0i8(i64 144, i8* nonnull %0)

  ret double %call1
}

; Function Attrs: nounwind optsize
define dso_local double @strtod(i8* noalias %s, i8** noalias %p) {
; CHECK-LABEL: define {{[^@]+}}@strtod
; CHECK-SAME: (i8* noalias [[S:%.*]], i8** noalias nocapture nofree readnone [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call fastcc double @strtox(i8* [[S]])
; CHECK-NEXT:    ret double [[CALL]]
;
entry:
  %call = tail call fastcc double @strtox(i8* %s, i8** %p, i32 1)
  ret double %call
}

; Function Attrs: argmemonly nounwind willreturn
declare void @llvm.lifetime.start.p0i8(i64 immarg, i8* nocapture)

; Function Attrs: optsize
declare dso_local i32 @sh_fromstring(...) local_unnamed_addr

; Function Attrs: optsize
declare dso_local void @__shlim(%struct._IO_FILE*, i64) local_unnamed_addr

; Function Attrs: optsize
declare dso_local double @__floatscan(%struct._IO_FILE*, i32, i32) local_unnamed_addr

; Function Attrs: argmemonly nounwind willreturn
declare void @llvm.lifetime.end.p0i8(i64 immarg, i8* nocapture)

; Test 15
; propagate noalias to some callsite arguments that there is no possibly reachable capture before it

@alias_of_p = external global i32*

define void @make_alias(i32* %p) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@make_alias
; TUNIT-SAME: (i32* nofree writeonly [[P:%.*]]) #[[ATTR7:[0-9]+]] {
; TUNIT-NEXT:    store i32* [[P]], i32** @alias_of_p, align 8
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@make_alias
; CGSCC-SAME: (i32* nofree writeonly [[P:%.*]]) #[[ATTR8:[0-9]+]] {
; CGSCC-NEXT:    store i32* [[P]], i32** @alias_of_p, align 8
; CGSCC-NEXT:    ret void
;
  store i32* %p, i32** @alias_of_p
  ret void
}

define void @only_store(i32* %p) {
; TUNIT: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@only_store
; TUNIT-SAME: (i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[P:%.*]]) #[[ATTR8:[0-9]+]] {
; TUNIT-NEXT:    store i32 0, i32* [[P]], align 4
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@only_store
; CGSCC-SAME: (i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[P:%.*]]) #[[ATTR9:[0-9]+]] {
; CGSCC-NEXT:    store i32 0, i32* [[P]], align 4
; CGSCC-NEXT:    ret void
;
  store i32 0, i32* %p
  ret void
}

define void @test15_caller(i32* noalias %p, i32 %c) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@test15_caller
; TUNIT-SAME: (i32* noalias nofree writeonly [[P:%.*]], i32 [[C:%.*]]) #[[ATTR7]] {
; TUNIT-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[C]], 0
; TUNIT-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    tail call void @only_store(i32* noalias nocapture nofree writeonly align 4 [[P]]) #[[ATTR12:[0-9]+]]
; TUNIT-NEXT:    br label [[IF_END]]
; TUNIT:       if.end:
; TUNIT-NEXT:    tail call void @make_alias(i32* nofree writeonly [[P]]) #[[ATTR12]]
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@test15_caller
; CGSCC-SAME: (i32* noalias nofree writeonly [[P:%.*]], i32 [[C:%.*]]) #[[ATTR10:[0-9]+]] {
; CGSCC-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[C]], 0
; CGSCC-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    tail call void @only_store(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[P]]) #[[ATTR14:[0-9]+]]
; CGSCC-NEXT:    br label [[IF_END]]
; CGSCC:       if.end:
; CGSCC-NEXT:    tail call void @make_alias(i32* nofree writeonly [[P]]) #[[ATTR14]]
; CGSCC-NEXT:    ret void
;
  %tobool = icmp eq i32 %c, 0
  br i1 %tobool, label %if.end, label %if.then


if.then:
  tail call void @only_store(i32* %p)
  br label %if.end

if.end:
  tail call void @make_alias(i32* %p)
  ret void
}

; Test 16
;
; __attribute__((noinline)) static void test16_sub(int * restrict p, int c1, int c2) {
;   if (c1) {
;     only_store(p);
;     make_alias(p);
;   }
;   if (!c2) {
;     only_store(p);
;   }
; }
; void test16_caller(int * restrict p, int c) {
;   test16_sub(p, c, c);
; }
;
; FIXME: this should be tail @only_store(i32* noalias %p)
;        when test16_caller is called, c1 always equals to c2. (Note that linkage is internal)
;        Therefore, only one of the two conditions of if statementes will be fulfilled.

define internal void @test16_sub(i32* noalias %p, i32 %c1, i32 %c2) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@test16_sub
; TUNIT-SAME: (i32* noalias nofree writeonly [[P:%.*]], i32 [[C1:%.*]], i32 [[C2:%.*]]) #[[ATTR7]] {
; TUNIT-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[C1]], 0
; TUNIT-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    tail call void @only_store(i32* noalias nocapture nofree writeonly align 4 [[P]]) #[[ATTR12]]
; TUNIT-NEXT:    tail call void @make_alias(i32* nofree writeonly align 4 [[P]]) #[[ATTR12]]
; TUNIT-NEXT:    br label [[IF_END]]
; TUNIT:       if.end:
; TUNIT-NEXT:    [[TOBOOL1:%.*]] = icmp eq i32 [[C2]], 0
; TUNIT-NEXT:    br i1 [[TOBOOL1]], label [[IF_THEN2:%.*]], label [[IF_END3:%.*]]
; TUNIT:       if.then2:
; TUNIT-NEXT:    tail call void @only_store(i32* nocapture nofree writeonly align 4 [[P]]) #[[ATTR12]]
; TUNIT-NEXT:    br label [[IF_END3]]
; TUNIT:       if.end3:
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@test16_sub
; CGSCC-SAME: (i32* noalias nofree writeonly [[P:%.*]], i32 [[C1:%.*]], i32 [[C2:%.*]]) #[[ATTR10]] {
; CGSCC-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[C1]], 0
; CGSCC-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    tail call void @only_store(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[P]]) #[[ATTR14]]
; CGSCC-NEXT:    tail call void @make_alias(i32* nofree nonnull writeonly align 4 dereferenceable(4) [[P]]) #[[ATTR14]]
; CGSCC-NEXT:    br label [[IF_END]]
; CGSCC:       if.end:
; CGSCC-NEXT:    [[TOBOOL1:%.*]] = icmp eq i32 [[C2]], 0
; CGSCC-NEXT:    br i1 [[TOBOOL1]], label [[IF_THEN2:%.*]], label [[IF_END3:%.*]]
; CGSCC:       if.then2:
; CGSCC-NEXT:    tail call void @only_store(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[P]]) #[[ATTR14]]
; CGSCC-NEXT:    br label [[IF_END3]]
; CGSCC:       if.end3:
; CGSCC-NEXT:    ret void
;
  %tobool = icmp eq i32 %c1, 0
  br i1 %tobool, label %if.end, label %if.then

if.then:
  tail call void @only_store(i32* %p)
  tail call void @make_alias(i32* %p)
  br label %if.end
if.end:

  %tobool1 = icmp eq i32 %c2, 0
  br i1 %tobool1, label %if.then2, label %if.end3

if.then2:
  tail call void @only_store(i32* %p)
  br label %if.end3
if.end3:

  ret void
}

define void @test16_caller(i32* %p, i32 %c) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@test16_caller
; TUNIT-SAME: (i32* nofree writeonly [[P:%.*]], i32 [[C:%.*]]) #[[ATTR7]] {
; TUNIT-NEXT:    tail call void @test16_sub(i32* noalias nofree writeonly [[P]], i32 [[C]], i32 [[C]]) #[[ATTR12]]
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@test16_caller
; CGSCC-SAME: (i32* nofree writeonly [[P:%.*]], i32 [[C:%.*]]) #[[ATTR10]] {
; CGSCC-NEXT:    tail call void @test16_sub(i32* noalias nofree writeonly [[P]], i32 [[C]], i32 [[C]]) #[[ATTR14]]
; CGSCC-NEXT:    ret void
;
  tail call void @test16_sub(i32* %p, i32 %c, i32 %c)
  ret void
}

; test 17
;
; only_store is not called after make_alias is called.
;
; void test17_caller(int* p, int c) {
;   if(c) {
;     make_alias(p);
;     if(0 == 0) {
;       goto l3;
;     } else {
;       goto l2;
;     }
;   }
;   l2:
;     only_store(p);
;   l3:
;   return;
; }

define void @test17_caller(i32* noalias %p, i32 %c) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@test17_caller
; TUNIT-SAME: (i32* noalias nofree writeonly [[P:%.*]], i32 [[C:%.*]]) #[[ATTR7]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[C]], 0
; TUNIT-NEXT:    br i1 [[TOBOOL]], label [[L1:%.*]], label [[L2:%.*]]
; TUNIT:       l1:
; TUNIT-NEXT:    tail call void @make_alias(i32* nofree writeonly [[P]]) #[[ATTR12]]
; TUNIT-NEXT:    br label [[L3:%.*]]
; TUNIT:       l2:
; TUNIT-NEXT:    tail call void @only_store(i32* nocapture nofree writeonly align 4 [[P]]) #[[ATTR12]]
; TUNIT-NEXT:    br label [[L3]]
; TUNIT:       l3:
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@test17_caller
; CGSCC-SAME: (i32* noalias nofree writeonly [[P:%.*]], i32 [[C:%.*]]) #[[ATTR10]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[C]], 0
; CGSCC-NEXT:    br i1 [[TOBOOL]], label [[L1:%.*]], label [[L2:%.*]]
; CGSCC:       l1:
; CGSCC-NEXT:    tail call void @make_alias(i32* nofree writeonly [[P]]) #[[ATTR14]]
; CGSCC-NEXT:    br label [[L3:%.*]]
; CGSCC:       l2:
; CGSCC-NEXT:    tail call void @only_store(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[P]]) #[[ATTR14]]
; CGSCC-NEXT:    br label [[L3]]
; CGSCC:       l3:
; CGSCC-NEXT:    ret void
;
entry:
  %tobool = icmp eq i32 %c, 0
  br i1 %tobool, label %l1, label %l2

l1:
  tail call void @make_alias(i32* %p)
  %tobool2 = icmp eq i32 0, 0
  br i1 %tobool2, label %l3, label %l2

l2:
  tail call void @only_store(i32* %p)
  br label %l3

l3:
  ret void
}

; test 18
; void test18_caller(int* p, int c) {
;   if(c) {
;     make_alias(p);
;     noreturn();
;   }
;   only_store(p);
;   return;
; }

define void @noreturn() {
; TUNIT: Function Attrs: nofree nosync nounwind readnone willreturn
; TUNIT-LABEL: define {{[^@]+}}@noreturn
; TUNIT-SAME: () #[[ATTR9]] {
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree nosync nounwind readnone willreturn
; CGSCC-LABEL: define {{[^@]+}}@noreturn
; CGSCC-SAME: () #[[ATTR2]] {
; CGSCC-NEXT:    ret void
;
  call void @noreturn()
  ret void
}

define void @test18_caller(i32* noalias %p, i32 %c) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; TUNIT-LABEL: define {{[^@]+}}@test18_caller
; TUNIT-SAME: (i32* noalias nofree writeonly [[P:%.*]], i32 [[C:%.*]]) #[[ATTR7]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[C]], 0
; TUNIT-NEXT:    br i1 [[TOBOOL]], label [[L1:%.*]], label [[L2:%.*]]
; TUNIT:       l1:
; TUNIT-NEXT:    tail call void @make_alias(i32* nofree writeonly [[P]]) #[[ATTR12]]
; TUNIT-NEXT:    br label [[L2]]
; TUNIT:       l2:
; TUNIT-NEXT:    tail call void @only_store(i32* nocapture nofree writeonly align 4 [[P]]) #[[ATTR12]]
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: nofree nosync nounwind willreturn writeonly
; CGSCC-LABEL: define {{[^@]+}}@test18_caller
; CGSCC-SAME: (i32* noalias nofree nonnull writeonly align 4 dereferenceable(4) [[P:%.*]], i32 [[C:%.*]]) #[[ATTR10]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[C]], 0
; CGSCC-NEXT:    br i1 [[TOBOOL]], label [[L1:%.*]], label [[L2:%.*]]
; CGSCC:       l1:
; CGSCC-NEXT:    tail call void @make_alias(i32* nofree nonnull writeonly align 4 dereferenceable(4) [[P]]) #[[ATTR14]]
; CGSCC-NEXT:    br label [[L2]]
; CGSCC:       l2:
; CGSCC-NEXT:    tail call void @only_store(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[P]]) #[[ATTR14]]
; CGSCC-NEXT:    ret void
;
entry:
  %tobool = icmp eq i32 %c, 0
  br i1 %tobool, label %l1, label %l2

l1:
  tail call void @make_alias(i32* %p)
  tail call void @noreturn()
  br label %l2

l2:
  tail call void @only_store(i32* %p)
  ret void
}
;.
; TUNIT: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind readnone willreturn }
; TUNIT: attributes #[[ATTR1]] = { nounwind uwtable }
; TUNIT: attributes #[[ATTR2]] = { nounwind }
; TUNIT: attributes #[[ATTR3]] = { nounwind ssp uwtable }
; TUNIT: attributes #[[ATTR4]] = { nofree norecurse nosync nounwind readonly willreturn }
; TUNIT: attributes #[[ATTR5]] = { argmemonly nofree norecurse nosync nounwind readonly willreturn }
; TUNIT: attributes #[[ATTR6:[0-9]+]] = { argmemonly nocallback nofree nosync nounwind willreturn }
; TUNIT: attributes #[[ATTR7]] = { nofree norecurse nosync nounwind willreturn writeonly }
; TUNIT: attributes #[[ATTR8]] = { argmemonly nofree norecurse nosync nounwind willreturn writeonly }
; TUNIT: attributes #[[ATTR9]] = { nofree nosync nounwind readnone willreturn }
; TUNIT: attributes #[[ATTR10]] = { nofree nosync nounwind readonly willreturn }
; TUNIT: attributes #[[ATTR11]] = { willreturn }
; TUNIT: attributes #[[ATTR12]] = { nofree nosync nounwind willreturn writeonly }
;.
; CGSCC: attributes #[[ATTR0]] = { nofree norecurse nosync nounwind readnone willreturn }
; CGSCC: attributes #[[ATTR1]] = { nounwind uwtable }
; CGSCC: attributes #[[ATTR2]] = { nofree nosync nounwind readnone willreturn }
; CGSCC: attributes #[[ATTR3]] = { nounwind }
; CGSCC: attributes #[[ATTR4]] = { nounwind ssp uwtable }
; CGSCC: attributes #[[ATTR5]] = { nofree nosync nounwind readonly willreturn }
; CGSCC: attributes #[[ATTR6]] = { argmemonly nofree norecurse nosync nounwind readonly willreturn }
; CGSCC: attributes #[[ATTR7:[0-9]+]] = { argmemonly nocallback nofree nosync nounwind willreturn }
; CGSCC: attributes #[[ATTR8]] = { nofree norecurse nosync nounwind willreturn writeonly }
; CGSCC: attributes #[[ATTR9]] = { argmemonly nofree norecurse nosync nounwind willreturn writeonly }
; CGSCC: attributes #[[ATTR10]] = { nofree nosync nounwind willreturn writeonly }
; CGSCC: attributes #[[ATTR11]] = { readnone willreturn }
; CGSCC: attributes #[[ATTR12]] = { readonly willreturn }
; CGSCC: attributes #[[ATTR13]] = { willreturn }
; CGSCC: attributes #[[ATTR14]] = { nounwind willreturn writeonly }
;.
