; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;RUN: opt < %s -jump-threading -S | FileCheck %s


declare void @bar(...)
declare void @baz(...)

; Make sure we thread the end of the bar block to the end of the function.
define void @test1(i32 %x) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X:%.*]], 9
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_END_THREAD:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end.thread:
; CHECK-NEXT:    call void (...) @bar()
; CHECK-NEXT:    br label [[IF_END4:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[X_OFF:%.*]] = add i32 [[X]], -3
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[X_OFF]], 5
; CHECK-NEXT:    br i1 [[TMP0]], label [[IF_THEN3:%.*]], label [[IF_END4]]
; CHECK:       if.then3:
; CHECK-NEXT:    call void (...) @baz()
; CHECK-NEXT:    br label [[IF_END4]]
; CHECK:       if.end4:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp sgt i32 %x, 9
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  call void (...) @bar()
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  %x.off = add i32 %x, -3
  %0 = icmp ult i32 %x.off, 5
  br i1 %0, label %if.then3, label %if.end4

if.then3:                                         ; preds = %if.end
  call void (...) @baz()
  br label %if.end4

if.end4:                                          ; preds = %if.then3, %if.end
  ret void
}

; Make sure we thread the false side of the first if to the end of the function.
define void @test2(i32 %x) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[X:%.*]], 9
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_END:%.*]], label [[IF_END4:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    call void (...) @bar()
; CHECK-NEXT:    [[X_OFF:%.*]] = add i32 [[X]], -3
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[X_OFF]], 5
; CHECK-NEXT:    br i1 [[TMP0]], label [[IF_THEN3:%.*]], label [[IF_END4]]
; CHECK:       if.then3:
; CHECK-NEXT:    call void (...) @baz()
; CHECK-NEXT:    br label [[IF_END4]]
; CHECK:       if.end4:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp slt i32 %x, 9
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  call void (...) @bar()
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  %x.off = add i32 %x, -3
  %0 = icmp ult i32 %x.off, 5
  br i1 %0, label %if.then3, label %if.end4

if.then3:                                         ; preds = %if.end
  call void (...) @baz()
  br label %if.end4

if.end4:                                          ; preds = %if.then3, %if.end
  ret void
}

; Negative test to make sure we don't thread when the ranges overlap.
define void @test3(i32 %x) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X:%.*]], 6
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    call void (...) @bar()
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[X_OFF:%.*]] = add i32 [[X]], -3
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[X_OFF]], 5
; CHECK-NEXT:    br i1 [[TMP0]], label [[IF_THEN3:%.*]], label [[IF_END4:%.*]]
; CHECK:       if.then3:
; CHECK-NEXT:    call void (...) @baz()
; CHECK-NEXT:    br label [[IF_END4]]
; CHECK:       if.end4:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp sgt i32 %x, 6
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  call void (...) @bar()
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  %x.off = add i32 %x, -3
  %0 = icmp ult i32 %x.off, 5
  br i1 %0, label %if.then3, label %if.end4

if.then3:                                         ; preds = %if.end
  call void (...) @baz()
  br label %if.end4

if.end4:                                          ; preds = %if.then3, %if.end
  ret void
}

; Make sure we thread the false side of the first if to the end of the function
; (case with non-local comparisions).
define void @test4(i32 %x) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[X:%.*]], 9
; CHECK-NEXT:    [[X_OFF:%.*]] = add i32 [[X]], -3
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ult i32 [[X_OFF]], 5
; CHECK-NEXT:    br i1 [[CMP1]], label [[IF_END:%.*]], label [[IF_END4:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    call void (...) @bar()
; CHECK-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END4]]
; CHECK:       if.then3:
; CHECK-NEXT:    call void (...) @baz()
; CHECK-NEXT:    br label [[IF_END4]]
; CHECK:       if.end4:
; CHECK-NEXT:    ret void
;
entry:
  %cmp1 = icmp slt i32 %x, 9
  %x.off = add i32 %x, -3
  %cmp2 = icmp ult i32 %x.off, 5
  br i1 %cmp1, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  call void (...) @bar()
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  br i1 %cmp2, label %if.then3, label %if.end4

if.then3:                                         ; preds = %if.end
  call void (...) @baz()
  br label %if.end4

if.end4:                                          ; preds = %if.then3, %if.end
  ret void
}

