; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -licm < %s | FileCheck %s

; FIXME: The %val.ptr load might alias the %pos.ptr load/stores, but it's still
; fine to promote the load as long as the store is retained.
define i32 @test(ptr %ary, i64 %len) {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[POS_PTR:%.*]] = getelementptr i8, ptr [[ARY:%.*]], i64 32
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[ACCUM:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[ACCUM_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[POS:%.*]] = load i64, ptr [[POS_PTR]], align 4
; CHECK-NEXT:    [[POS_NEXT:%.*]] = add i64 [[POS]], 1
; CHECK-NEXT:    store i64 [[POS_NEXT]], ptr [[POS_PTR]], align 4
; CHECK-NEXT:    [[VAL_PTR:%.*]] = getelementptr i32, ptr [[ARY]], i64 [[POS]]
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[VAL_PTR]], align 4
; CHECK-NEXT:    [[ACCUM_NEXT]] = add i32 [[ACCUM]], [[VAL]]
; CHECK-NEXT:    [[EXIT_COND:%.*]] = icmp ult i64 [[POS]], [[LEN:%.*]]
; CHECK-NEXT:    br i1 [[EXIT_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[ACCUM_LCSSA:%.*]] = phi i32 [ [[ACCUM]], [[LOOP]] ]
; CHECK-NEXT:    ret i32 [[ACCUM_LCSSA]]
;
entry:
  %pos.ptr = getelementptr i8, ptr %ary, i64 32
  br label %loop

loop:
  %accum = phi i32 [ 0, %entry ], [ %accum.next, %loop ]
  %pos = load i64, ptr %pos.ptr
  %pos.next = add i64 %pos, 1
  store i64 %pos.next, ptr %pos.ptr
  %val.ptr = getelementptr i32, ptr %ary, i64 %pos
  %val = load i32, ptr %val.ptr
  %accum.next = add i32 %accum, %val
  %exit.cond = icmp ult i64 %pos, %len
  br i1 %exit.cond, label %loop, label %exit

exit:
  ret i32 %accum
}
