; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -memcpyopt -verify-memoryssa | FileCheck %s
target datalayout = "E-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64"

declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1) nounwind
declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i1) nounwind

; The resulting memset is only 4-byte aligned, despite containing
; a 16-byte aligned store in the middle.

define void @foo(ptr %p) {
; CHECK-LABEL: @foo(
; CHECK-NEXT:    [[A1:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 1
; CHECK-NEXT:    [[A2:%.*]] = getelementptr i32, ptr [[P]], i64 2
; CHECK-NEXT:    [[A3:%.*]] = getelementptr i32, ptr [[P]], i64 3
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[P]], i8 0, i64 16, i1 false)
; CHECK-NEXT:    ret void
;
  store i32 0, ptr %p, align 4
  %a1 = getelementptr i32, ptr %p, i64 1
  store i32 0, ptr %a1, align 16
  %a2 = getelementptr i32, ptr %p, i64 2
  store i32 0, ptr %a2, align 4
  %a3 = getelementptr i32, ptr %p, i64 3
  store i32 0, ptr %a3, align 4
  ret void
}

; Replacing %a8 with %a4 in the memset requires boosting the alignment of %a4.

define void @bar() {
; CHECK-LABEL: @bar(
; CHECK-NEXT:    [[A4:%.*]] = alloca i32, align 8
; CHECK-NEXT:    [[A8:%.*]] = alloca i32, align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[A4]], i8 0, i64 4, i1 false)
; CHECK-NEXT:    ret void
;
  %a4 = alloca i32, align 4
  %a8 = alloca i32, align 8
  call void @llvm.memset.p0.i64(ptr align 8 %a8, i8 0, i64 4, i1 false)
  call void @llvm.memcpy.p0.p0.i64(ptr align 4 %a4, ptr align 4 %a8, i64 4, i1 false)
  ret void
}
