; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -O2 -S -verify-memoryssa | FileCheck %s

; performCallSlotOptzn in MemCpy should not exchange the calls to
; @llvm.lifetime.start and @llvm.memcpy.

declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture readonly, i64, i1) #1
declare void @llvm.lifetime.start.p0(i64, ptr nocapture) #1
declare void @llvm.lifetime.end.p0(i64, ptr nocapture) #1

define void @call_slot(ptr nocapture dereferenceable(16) %arg1) {
; CHECK-LABEL: @call_slot(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP_SROA_3_0_ARG1_SROA_RAW_IDX:%.*]] = getelementptr inbounds i8, ptr [[ARG1:%.*]], i64 7
; CHECK-NEXT:    store i8 0, ptr [[TMP_SROA_3_0_ARG1_SROA_RAW_IDX]], align 1
; CHECK-NEXT:    ret void
;
bb:
  %tmp = alloca [8 x i8], align 8
  call void @llvm.lifetime.start.p0(i64 16, ptr %tmp)
  %tmp10 = getelementptr inbounds i8, ptr %tmp, i64 7
  store i8 0, ptr %tmp10, align 1
  call void @llvm.memcpy.p0.p0.i64(ptr align 8 %arg1, ptr align 8 %tmp, i64 16, i1 false)
  call void @llvm.lifetime.end.p0(i64 16, ptr %tmp)
  ret void
}

define void @memcpy_memcpy_across_lifetime(ptr noalias %p1, ptr noalias %p2, ptr noalias %p3) {
; CHECK-LABEL: @memcpy_memcpy_across_lifetime(
; CHECK-NEXT:    [[A:%.*]] = alloca [16 x i8], align 1
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr nonnull [[A]])
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(16) [[A]], ptr noundef nonnull align 1 dereferenceable(16) [[P1:%.*]], i64 16, i1 false)
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(16) [[P1]], ptr noundef nonnull align 1 dereferenceable(16) [[P2:%.*]], i64 16, i1 false)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(16) [[P2]], ptr noundef nonnull align 1 dereferenceable(16) [[A]], i64 16, i1 false)
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 16, ptr nonnull [[A]])
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(16) [[P3:%.*]], ptr noundef nonnull align 1 dereferenceable(16) [[P2]], i64 16, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca [16 x i8]
  call void @llvm.lifetime.start.p0(i64 16, ptr %a)
  call void @llvm.memcpy.p0.p0.i64(ptr %a, ptr %p1, i64 16, i1 false)
  call void @llvm.memcpy.p0.p0.i64(ptr %p1, ptr %p2, i64 16, i1 false)
  call void @llvm.memcpy.p0.p0.i64(ptr %p2, ptr %a, i64 16, i1 false)
  call void @llvm.lifetime.end.p0(i64 16, ptr %a)
  call void @llvm.memcpy.p0.p0.i64(ptr %p3, ptr %p2, i64 16, i1 false)
  ret void
}

attributes #1 = { argmemonly nounwind }
