; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -memcpyopt -S < %s -verify-memoryssa | FileCheck %s
; RUN: opt -passes=memcpyopt -S < %s -verify-memoryssa | FileCheck %s
; rdar://8875553

; Memcpyopt shouldn't optimize the second memcpy using the first
; because the first has a smaller size.

target datalayout = "e-p:32:32:32"

%struct.s = type { [11 x i8], i32 }

@.str = private constant [11 x i8] c"0123456789\00"
@cell = external global %struct.s

declare void @check(ptr byval(%struct.s) %p) nounwind
declare void @llvm.memcpy.p0.p0.i32(ptr nocapture, ptr nocapture, i32, i1) nounwind

define void @foo() nounwind {
; CHECK-LABEL: @foo(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[AGG_TMP:%.*]] = alloca [[STRUCT_S:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr getelementptr inbounds (%struct.s, ptr @cell, i32 0, i32 1), align 4
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 @cell, ptr align 1 @.str, i32 11, i1 false)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[AGG_TMP]], ptr align 4 @cell, i32 16, i1 false)
; CHECK-NEXT:    call void @check(ptr byval(%struct.s) [[AGG_TMP]])
; CHECK-NEXT:    ret void
;
entry:
  %agg.tmp = alloca %struct.s, align 4
  store i32 99, ptr getelementptr inbounds (%struct.s, ptr @cell, i32 0, i32 1), align 4
  call void @llvm.memcpy.p0.p0.i32(ptr align 1 @cell, ptr align 1 @.str, i32 11, i1 false)
  call void @llvm.memcpy.p0.p0.i32(ptr align 4 %agg.tmp, ptr align 4 @cell, i32 16, i1 false)
  call void @check(ptr byval(%struct.s) %agg.tmp)
  ret void
}
