# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=znver1 -timeline -register-file-stats -iterations=1 < %s | FileCheck %s

subl  %eax, %eax
subq  %rax, %rax
xorl  %eax, %eax
xorq  %rax, %rax

pcmpgtb   %mm2, %mm2
pcmpgtd   %mm2, %mm2
# pcmpgtq   %mm2, %mm2 # invalid operand for instruction
pcmpgtw   %mm2, %mm2

pcmpgtb   %xmm2, %xmm2
pcmpgtd   %xmm2, %xmm2
pcmpgtq   %xmm2, %xmm2
pcmpgtw   %xmm2, %xmm2

vpcmpgtb  %xmm3, %xmm3, %xmm3
vpcmpgtd  %xmm3, %xmm3, %xmm3
vpcmpgtq  %xmm3, %xmm3, %xmm3
vpcmpgtw  %xmm3, %xmm3, %xmm3

vpcmpgtb  %xmm3, %xmm3, %xmm5
vpcmpgtd  %xmm3, %xmm3, %xmm5
vpcmpgtq  %xmm3, %xmm3, %xmm5
vpcmpgtw  %xmm3, %xmm3, %xmm5

vpcmpgtb  %ymm3, %ymm3, %ymm3
vpcmpgtd  %ymm3, %ymm3, %ymm3
vpcmpgtq  %ymm3, %ymm3, %ymm3
vpcmpgtw  %ymm3, %ymm3, %ymm3

vpcmpgtb  %ymm3, %ymm3, %ymm5
vpcmpgtd  %ymm3, %ymm3, %ymm5
vpcmpgtq  %ymm3, %ymm3, %ymm5
vpcmpgtw  %ymm3, %ymm3, %ymm5

psubb   %mm2, %mm2
psubd   %mm2, %mm2
psubq   %mm2, %mm2
psubw   %mm2, %mm2
psubb   %xmm2, %xmm2
psubd   %xmm2, %xmm2
psubq   %xmm2, %xmm2
psubw   %xmm2, %xmm2
vpsubb  %xmm3, %xmm3, %xmm3
vpsubd  %xmm3, %xmm3, %xmm3
vpsubq  %xmm3, %xmm3, %xmm3
vpsubw  %xmm3, %xmm3, %xmm3
vpsubb  %ymm3, %ymm3, %ymm3
vpsubd  %ymm3, %ymm3, %ymm3
vpsubq  %ymm3, %ymm3, %ymm3
vpsubw  %ymm3, %ymm3, %ymm3

vpsubb  %xmm3, %xmm3, %xmm5
vpsubd  %xmm3, %xmm3, %xmm5
vpsubq  %xmm3, %xmm3, %xmm5
vpsubw  %xmm3, %xmm3, %xmm5
vpsubb  %ymm3, %ymm3, %ymm5
vpsubd  %ymm3, %ymm3, %ymm5
vpsubq  %ymm3, %ymm3, %ymm5
vpsubw  %ymm3, %ymm3, %ymm5

andnps  %xmm0, %xmm0
andnpd  %xmm1, %xmm1
vandnps %xmm2, %xmm2, %xmm2
vandnpd %xmm1, %xmm1, %xmm1
vandnps %ymm2, %ymm2, %ymm2
vandnpd %ymm1, %ymm1, %ymm1
pandn   %mm2, %mm2
pandn   %xmm2, %xmm2
vpandn  %xmm3, %xmm3, %xmm3
vpandn  %ymm3, %ymm3, %ymm3

vandnps %xmm2, %xmm2, %xmm5
vandnpd %xmm1, %xmm1, %xmm5
vpandn  %xmm3, %xmm3, %xmm5
vandnps %ymm2, %ymm2, %ymm5
vandnpd %ymm1, %ymm1, %ymm5
vpandn  %ymm3, %ymm3, %ymm5

xorps  %xmm0, %xmm0
xorpd  %xmm1, %xmm1
vxorps %xmm2, %xmm2, %xmm2
vxorpd %xmm1, %xmm1, %xmm1
vxorps %ymm2, %ymm2, %ymm2
vxorpd %ymm1, %ymm1, %ymm1
pxor   %mm2, %mm2
pxor   %xmm2, %xmm2
vpxor  %xmm3, %xmm3, %xmm3
vpxor  %ymm3, %ymm3, %ymm3

vxorps %xmm4, %xmm4, %xmm5
vxorpd %xmm1, %xmm1, %xmm3
vxorps %ymm4, %ymm4, %ymm5
vxorpd %ymm1, %ymm1, %ymm3
vpxor  %xmm3, %xmm3, %xmm5
vpxor  %ymm3, %ymm3, %ymm5

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      83
# CHECK-NEXT: Total Cycles:      32
# CHECK-NEXT: Total uOps:        109

# CHECK:      Dispatch Width:    4
# CHECK-NEXT: uOps Per Cycle:    3.41
# CHECK-NEXT: IPC:               2.59
# CHECK-NEXT: Block RThroughput: 27.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        subl	%eax, %eax
# CHECK-NEXT:  1      1     0.25                        subq	%rax, %rax
# CHECK-NEXT:  1      1     0.25                        xorl	%eax, %eax
# CHECK-NEXT:  1      1     0.25                        xorq	%rax, %rax
# CHECK-NEXT:  1      1     0.25                        pcmpgtb	%mm2, %mm2
# CHECK-NEXT:  1      1     0.25                        pcmpgtd	%mm2, %mm2
# CHECK-NEXT:  1      1     0.25                        pcmpgtw	%mm2, %mm2
# CHECK-NEXT:  1      1     0.25                        pcmpgtb	%xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        pcmpgtd	%xmm2, %xmm2
# CHECK-NEXT:  1      1     0.50                        pcmpgtq	%xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        pcmpgtw	%xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpcmpgtb	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  1      1     0.25                        vpcmpgtd	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  1      1     0.50                        vpcmpgtq	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  1      1     0.25                        vpcmpgtw	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  1      1     0.25                        vpcmpgtb	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  1      1     0.25                        vpcmpgtd	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  1      1     0.50                        vpcmpgtq	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  1      1     0.25                        vpcmpgtw	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  2      1     0.50                        vpcmpgtb	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  2      1     0.50                        vpcmpgtd	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  1      1     0.50                        vpcmpgtq	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  2      1     0.50                        vpcmpgtw	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  2      1     0.50                        vpcmpgtb	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  2      1     0.50                        vpcmpgtd	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  1      1     0.50                        vpcmpgtq	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  2      1     0.50                        vpcmpgtw	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  1      1     0.25                        psubb	%mm2, %mm2
# CHECK-NEXT:  1      1     0.25                        psubd	%mm2, %mm2
# CHECK-NEXT:  1      1     0.25                        psubq	%mm2, %mm2
# CHECK-NEXT:  1      1     0.25                        psubw	%mm2, %mm2
# CHECK-NEXT:  1      1     0.25                        psubb	%xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        psubd	%xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        psubq	%xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        psubw	%xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpsubb	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  1      1     0.25                        vpsubd	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  1      1     0.25                        vpsubq	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  1      1     0.25                        vpsubw	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  2      1     0.50                        vpsubb	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  2      1     0.50                        vpsubd	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  2      1     0.50                        vpsubq	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  2      1     0.50                        vpsubw	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  1      1     0.25                        vpsubb	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  1      1     0.25                        vpsubd	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  1      1     0.25                        vpsubq	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  1      1     0.25                        vpsubw	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  2      1     0.50                        vpsubb	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  2      1     0.50                        vpsubd	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  2      1     0.50                        vpsubq	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  2      1     0.50                        vpsubw	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  1      1     0.25                        andnps	%xmm0, %xmm0
# CHECK-NEXT:  1      1     0.25                        andnpd	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        vandnps	%xmm2, %xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        vandnpd	%xmm1, %xmm1, %xmm1
# CHECK-NEXT:  2      1     0.50                        vandnps	%ymm2, %ymm2, %ymm2
# CHECK-NEXT:  2      1     0.50                        vandnpd	%ymm1, %ymm1, %ymm1
# CHECK-NEXT:  1      1     0.25                        pandn	%mm2, %mm2
# CHECK-NEXT:  1      1     0.25                        pandn	%xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpandn	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  2      1     0.50                        vpandn	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  1      1     0.25                        vandnps	%xmm2, %xmm2, %xmm5
# CHECK-NEXT:  1      1     0.25                        vandnpd	%xmm1, %xmm1, %xmm5
# CHECK-NEXT:  1      1     0.25                        vpandn	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  2      1     0.50                        vandnps	%ymm2, %ymm2, %ymm5
# CHECK-NEXT:  2      1     0.50                        vandnpd	%ymm1, %ymm1, %ymm5
# CHECK-NEXT:  2      1     0.50                        vpandn	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  1      1     0.25                        xorps	%xmm0, %xmm0
# CHECK-NEXT:  1      1     0.25                        xorpd	%xmm1, %xmm1
# CHECK-NEXT:  1      1     0.25                        vxorps	%xmm2, %xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        vxorpd	%xmm1, %xmm1, %xmm1
# CHECK-NEXT:  2      1     0.50                        vxorps	%ymm2, %ymm2, %ymm2
# CHECK-NEXT:  2      1     0.50                        vxorpd	%ymm1, %ymm1, %ymm1
# CHECK-NEXT:  1      1     0.25                        pxor	%mm2, %mm2
# CHECK-NEXT:  1      1     0.25                        pxor	%xmm2, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpxor	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  2      1     0.50                        vpxor	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  1      1     0.25                        vxorps	%xmm4, %xmm4, %xmm5
# CHECK-NEXT:  1      1     0.25                        vxorpd	%xmm1, %xmm1, %xmm3
# CHECK-NEXT:  2      1     0.50                        vxorps	%ymm4, %ymm4, %ymm5
# CHECK-NEXT:  2      1     0.50                        vxorpd	%ymm1, %ymm1, %ymm3
# CHECK-NEXT:  1      1     0.25                        vpxor	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  2      1     0.50                        vpxor	%ymm3, %ymm3, %ymm5

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    0
# CHECK-NEXT: Max number of mappings used:         0

# CHECK:      *  Register File #1 -- ZnFpuPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      *  Register File #2 -- ZnIntegerPRF:
# CHECK-NEXT:    Number of physical registers:     168
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - ZnAGU0
# CHECK-NEXT: [1]   - ZnAGU1
# CHECK-NEXT: [2]   - ZnALU0
# CHECK-NEXT: [3]   - ZnALU1
# CHECK-NEXT: [4]   - ZnALU2
# CHECK-NEXT: [5]   - ZnALU3
# CHECK-NEXT: [6]   - ZnDivider
# CHECK-NEXT: [7]   - ZnFPU0
# CHECK-NEXT: [8]   - ZnFPU1
# CHECK-NEXT: [9]   - ZnFPU2
# CHECK-NEXT: [10]  - ZnFPU3
# CHECK-NEXT: [11]  - ZnMultiplier

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]
# CHECK-NEXT:  -      -     1.00   1.00   1.00   1.00    -     26.00  26.00  26.00  27.00   -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   Instructions:
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -     subl	%eax, %eax
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -     subq	%rax, %rax
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -      -      -      -      -     xorl	%eax, %eax
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -     xorq	%rax, %rax
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     pcmpgtb	%mm2, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     pcmpgtd	%mm2, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -     pcmpgtw	%mm2, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     pcmpgtb	%xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     pcmpgtd	%xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     pcmpgtq	%xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     pcmpgtw	%xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -     vpcmpgtb	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vpcmpgtd	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpcmpgtq	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpcmpgtw	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -     vpcmpgtb	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vpcmpgtd	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpcmpgtq	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpcmpgtw	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00    -      -      -     vpcmpgtb	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     2.00    -     vpcmpgtd	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpcmpgtq	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     vpcmpgtw	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00    -      -      -     vpcmpgtb	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     2.00    -     vpcmpgtd	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpcmpgtq	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     vpcmpgtw	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -     psubb	%mm2, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     psubd	%mm2, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     psubq	%mm2, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     psubw	%mm2, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     psubb	%xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -     psubd	%xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     psubq	%xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     psubw	%xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsubb	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -     vpsubd	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpsubq	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vpsubw	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     vpsubb	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00    -      -      -     vpsubd	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -     2.00    -      -      -      -     vpsubq	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     2.00    -     vpsubw	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsubb	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -     vpsubd	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpsubq	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vpsubw	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     vpsubb	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00    -      -      -     vpsubd	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -     2.00    -      -      -      -     vpsubq	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     2.00    -     vpsubw	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     andnps	%xmm0, %xmm0
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -     andnpd	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vandnps	%xmm2, %xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vandnpd	%xmm1, %xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     vandnps	%ymm2, %ymm2, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00    -      -      -     vandnpd	%ymm1, %ymm1, %ymm1
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     pandn	%mm2, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     pandn	%xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpandn	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00    -      -      -     vpandn	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vandnps	%xmm2, %xmm2, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vandnpd	%xmm1, %xmm1, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpandn	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -     2.00    -      -      -      -     vandnps	%ymm2, %ymm2, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     2.00    -     vandnpd	%ymm1, %ymm1, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     vpandn	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -     xorps	%xmm0, %xmm0
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     xorpd	%xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vxorps	%xmm2, %xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vxorpd	%xmm1, %xmm1, %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00    -      -      -     vxorps	%ymm2, %ymm2, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     2.00    -      -      -      -     vxorpd	%ymm1, %ymm1, %ymm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     pxor	%mm2, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     pxor	%xmm2, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -     vpxor	%xmm3, %xmm3, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -     2.00    -      -      -      -     vpxor	%ymm3, %ymm3, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vxorps	%xmm4, %xmm4, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vxorpd	%xmm1, %xmm1, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00    -      -      -     vxorps	%ymm4, %ymm4, %ymm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     2.00    -     vxorpd	%ymm1, %ymm1, %ymm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpxor	%xmm3, %xmm3, %xmm5
# CHECK-NEXT:  -      -      -      -      -      -      -     2.00    -      -      -      -     vpxor	%ymm3, %ymm3, %ymm5

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          01
# CHECK-NEXT: Index     0123456789          0123456789

# CHECK:      [0,0]     DeER .    .    .    .    .    ..   subl	%eax, %eax
# CHECK-NEXT: [0,1]     DeER .    .    .    .    .    ..   subq	%rax, %rax
# CHECK-NEXT: [0,2]     DeER .    .    .    .    .    ..   xorl	%eax, %eax
# CHECK-NEXT: [0,3]     DeER .    .    .    .    .    ..   xorq	%rax, %rax
# CHECK-NEXT: [0,4]     .DeER.    .    .    .    .    ..   pcmpgtb	%mm2, %mm2
# CHECK-NEXT: [0,5]     .DeER.    .    .    .    .    ..   pcmpgtd	%mm2, %mm2
# CHECK-NEXT: [0,6]     .DeER.    .    .    .    .    ..   pcmpgtw	%mm2, %mm2
# CHECK-NEXT: [0,7]     .DeER.    .    .    .    .    ..   pcmpgtb	%xmm2, %xmm2
# CHECK-NEXT: [0,8]     . DeER    .    .    .    .    ..   pcmpgtd	%xmm2, %xmm2
# CHECK-NEXT: [0,9]     . DeER    .    .    .    .    ..   pcmpgtq	%xmm2, %xmm2
# CHECK-NEXT: [0,10]    . DeER    .    .    .    .    ..   pcmpgtw	%xmm2, %xmm2
# CHECK-NEXT: [0,11]    . DeER    .    .    .    .    ..   vpcmpgtb	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: [0,12]    .  DeER   .    .    .    .    ..   vpcmpgtd	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: [0,13]    .  DeER   .    .    .    .    ..   vpcmpgtq	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: [0,14]    .  DeER   .    .    .    .    ..   vpcmpgtw	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: [0,15]    .  DeER   .    .    .    .    ..   vpcmpgtb	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: [0,16]    .   DeER  .    .    .    .    ..   vpcmpgtd	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: [0,17]    .   DeER  .    .    .    .    ..   vpcmpgtq	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: [0,18]    .   DeER  .    .    .    .    ..   vpcmpgtw	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: [0,19]    .    DeER .    .    .    .    ..   vpcmpgtb	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: [0,20]    .    DeER .    .    .    .    ..   vpcmpgtd	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: [0,21]    .    .DeER.    .    .    .    ..   vpcmpgtq	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: [0,22]    .    .DeER.    .    .    .    ..   vpcmpgtw	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: [0,23]    .    . DeER    .    .    .    ..   vpcmpgtb	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: [0,24]    .    . DeER    .    .    .    ..   vpcmpgtd	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: [0,25]    .    .  DeER   .    .    .    ..   vpcmpgtq	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: [0,26]    .    .  DeER   .    .    .    ..   vpcmpgtw	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: [0,27]    .    .  D=eER  .    .    .    ..   psubb	%mm2, %mm2
# CHECK-NEXT: [0,28]    .    .   DeER  .    .    .    ..   psubd	%mm2, %mm2
# CHECK-NEXT: [0,29]    .    .   DeER  .    .    .    ..   psubq	%mm2, %mm2
# CHECK-NEXT: [0,30]    .    .   D=eER .    .    .    ..   psubw	%mm2, %mm2
# CHECK-NEXT: [0,31]    .    .   D=eER .    .    .    ..   psubb	%xmm2, %xmm2
# CHECK-NEXT: [0,32]    .    .    DeER .    .    .    ..   psubd	%xmm2, %xmm2
# CHECK-NEXT: [0,33]    .    .    DeER .    .    .    ..   psubq	%xmm2, %xmm2
# CHECK-NEXT: [0,34]    .    .    D=eER.    .    .    ..   psubw	%xmm2, %xmm2
# CHECK-NEXT: [0,35]    .    .    D=eER.    .    .    ..   vpsubb	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: [0,36]    .    .    .DeER.    .    .    ..   vpsubd	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: [0,37]    .    .    .DeER.    .    .    ..   vpsubq	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: [0,38]    .    .    .D=eER    .    .    ..   vpsubw	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: [0,39]    .    .    . DeER    .    .    ..   vpsubb	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: [0,40]    .    .    . DeER    .    .    ..   vpsubd	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: [0,41]    .    .    .  DeER   .    .    ..   vpsubq	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: [0,42]    .    .    .  DeER   .    .    ..   vpsubw	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: [0,43]    .    .    .   DeER  .    .    ..   vpsubb	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: [0,44]    .    .    .   DeER  .    .    ..   vpsubd	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: [0,45]    .    .    .   D=eER .    .    ..   vpsubq	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: [0,46]    .    .    .   D=eER .    .    ..   vpsubw	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: [0,47]    .    .    .    DeER .    .    ..   vpsubb	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: [0,48]    .    .    .    DeER .    .    ..   vpsubd	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: [0,49]    .    .    .    .DeER.    .    ..   vpsubq	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: [0,50]    .    .    .    .DeER.    .    ..   vpsubw	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: [0,51]    .    .    .    . DeER    .    ..   andnps	%xmm0, %xmm0
# CHECK-NEXT: [0,52]    .    .    .    . DeER    .    ..   andnpd	%xmm1, %xmm1
# CHECK-NEXT: [0,53]    .    .    .    . D=eER   .    ..   vandnps	%xmm2, %xmm2, %xmm2
# CHECK-NEXT: [0,54]    .    .    .    . D=eER   .    ..   vandnpd	%xmm1, %xmm1, %xmm1
# CHECK-NEXT: [0,55]    .    .    .    .  DeER   .    ..   vandnps	%ymm2, %ymm2, %ymm2
# CHECK-NEXT: [0,56]    .    .    .    .  DeER   .    ..   vandnpd	%ymm1, %ymm1, %ymm1
# CHECK-NEXT: [0,57]    .    .    .    .   DeER  .    ..   pandn	%mm2, %mm2
# CHECK-NEXT: [0,58]    .    .    .    .   DeER  .    ..   pandn	%xmm2, %xmm2
# CHECK-NEXT: [0,59]    .    .    .    .   D=eER .    ..   vpandn	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: [0,60]    .    .    .    .    DeER .    ..   vpandn	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: [0,61]    .    .    .    .    DeER .    ..   vandnps	%xmm2, %xmm2, %xmm5
# CHECK-NEXT: [0,62]    .    .    .    .    DeER .    ..   vandnpd	%xmm1, %xmm1, %xmm5
# CHECK-NEXT: [0,63]    .    .    .    .    .DeER.    ..   vpandn	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: [0,64]    .    .    .    .    .DeER.    ..   vandnps	%ymm2, %ymm2, %ymm5
# CHECK-NEXT: [0,65]    .    .    .    .    . DeER    ..   vandnpd	%ymm1, %ymm1, %ymm5
# CHECK-NEXT: [0,66]    .    .    .    .    . DeER    ..   vpandn	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: [0,67]    .    .    .    .    .  DeER   ..   xorps	%xmm0, %xmm0
# CHECK-NEXT: [0,68]    .    .    .    .    .  DeER   ..   xorpd	%xmm1, %xmm1
# CHECK-NEXT: [0,69]    .    .    .    .    .  D=eER  ..   vxorps	%xmm2, %xmm2, %xmm2
# CHECK-NEXT: [0,70]    .    .    .    .    .  D=eER  ..   vxorpd	%xmm1, %xmm1, %xmm1
# CHECK-NEXT: [0,71]    .    .    .    .    .   DeER  ..   vxorps	%ymm2, %ymm2, %ymm2
# CHECK-NEXT: [0,72]    .    .    .    .    .   DeER  ..   vxorpd	%ymm1, %ymm1, %ymm1
# CHECK-NEXT: [0,73]    .    .    .    .    .    DeER ..   pxor	%mm2, %mm2
# CHECK-NEXT: [0,74]    .    .    .    .    .    DeER ..   pxor	%xmm2, %xmm2
# CHECK-NEXT: [0,75]    .    .    .    .    .    D=eER..   vpxor	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: [0,76]    .    .    .    .    .    .DeER..   vpxor	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: [0,77]    .    .    .    .    .    .DeER..   vxorps	%xmm4, %xmm4, %xmm5
# CHECK-NEXT: [0,78]    .    .    .    .    .    .DeER..   vxorpd	%xmm1, %xmm1, %xmm3
# CHECK-NEXT: [0,79]    .    .    .    .    .    . DeER.   vxorps	%ymm4, %ymm4, %ymm5
# CHECK-NEXT: [0,80]    .    .    .    .    .    . DeER.   vxorpd	%ymm1, %ymm1, %ymm3
# CHECK-NEXT: [0,81]    .    .    .    .    .    .  DeER   vpxor	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: [0,82]    .    .    .    .    .    .  DeER   vpxor	%ymm3, %ymm3, %ymm5

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     1.0    1.0    0.0       subl	%eax, %eax
# CHECK-NEXT: 1.     1     1.0    1.0    0.0       subq	%rax, %rax
# CHECK-NEXT: 2.     1     1.0    1.0    0.0       xorl	%eax, %eax
# CHECK-NEXT: 3.     1     1.0    1.0    0.0       xorq	%rax, %rax
# CHECK-NEXT: 4.     1     1.0    1.0    0.0       pcmpgtb	%mm2, %mm2
# CHECK-NEXT: 5.     1     1.0    1.0    0.0       pcmpgtd	%mm2, %mm2
# CHECK-NEXT: 6.     1     1.0    1.0    0.0       pcmpgtw	%mm2, %mm2
# CHECK-NEXT: 7.     1     1.0    1.0    0.0       pcmpgtb	%xmm2, %xmm2
# CHECK-NEXT: 8.     1     1.0    1.0    0.0       pcmpgtd	%xmm2, %xmm2
# CHECK-NEXT: 9.     1     1.0    1.0    0.0       pcmpgtq	%xmm2, %xmm2
# CHECK-NEXT: 10.    1     1.0    1.0    0.0       pcmpgtw	%xmm2, %xmm2
# CHECK-NEXT: 11.    1     1.0    1.0    0.0       vpcmpgtb	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: 12.    1     1.0    1.0    0.0       vpcmpgtd	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: 13.    1     1.0    1.0    0.0       vpcmpgtq	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: 14.    1     1.0    1.0    0.0       vpcmpgtw	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: 15.    1     1.0    1.0    0.0       vpcmpgtb	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: 16.    1     1.0    1.0    0.0       vpcmpgtd	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: 17.    1     1.0    1.0    0.0       vpcmpgtq	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: 18.    1     1.0    1.0    0.0       vpcmpgtw	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: 19.    1     1.0    1.0    0.0       vpcmpgtb	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: 20.    1     1.0    1.0    0.0       vpcmpgtd	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: 21.    1     1.0    1.0    0.0       vpcmpgtq	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: 22.    1     1.0    1.0    0.0       vpcmpgtw	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: 23.    1     1.0    1.0    0.0       vpcmpgtb	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: 24.    1     1.0    1.0    0.0       vpcmpgtd	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: 25.    1     1.0    1.0    0.0       vpcmpgtq	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: 26.    1     1.0    1.0    0.0       vpcmpgtw	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: 27.    1     2.0    2.0    0.0       psubb	%mm2, %mm2
# CHECK-NEXT: 28.    1     1.0    1.0    0.0       psubd	%mm2, %mm2
# CHECK-NEXT: 29.    1     1.0    1.0    0.0       psubq	%mm2, %mm2
# CHECK-NEXT: 30.    1     2.0    2.0    0.0       psubw	%mm2, %mm2
# CHECK-NEXT: 31.    1     2.0    2.0    0.0       psubb	%xmm2, %xmm2
# CHECK-NEXT: 32.    1     1.0    1.0    0.0       psubd	%xmm2, %xmm2
# CHECK-NEXT: 33.    1     1.0    1.0    0.0       psubq	%xmm2, %xmm2
# CHECK-NEXT: 34.    1     2.0    2.0    0.0       psubw	%xmm2, %xmm2
# CHECK-NEXT: 35.    1     2.0    2.0    0.0       vpsubb	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: 36.    1     1.0    1.0    0.0       vpsubd	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: 37.    1     1.0    1.0    0.0       vpsubq	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: 38.    1     2.0    2.0    0.0       vpsubw	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: 39.    1     1.0    1.0    0.0       vpsubb	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: 40.    1     1.0    1.0    0.0       vpsubd	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: 41.    1     1.0    1.0    0.0       vpsubq	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: 42.    1     1.0    1.0    0.0       vpsubw	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: 43.    1     1.0    1.0    0.0       vpsubb	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: 44.    1     1.0    1.0    0.0       vpsubd	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: 45.    1     2.0    2.0    0.0       vpsubq	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: 46.    1     2.0    2.0    0.0       vpsubw	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: 47.    1     1.0    1.0    0.0       vpsubb	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: 48.    1     1.0    1.0    0.0       vpsubd	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: 49.    1     1.0    1.0    0.0       vpsubq	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: 50.    1     1.0    1.0    0.0       vpsubw	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: 51.    1     1.0    1.0    0.0       andnps	%xmm0, %xmm0
# CHECK-NEXT: 52.    1     1.0    1.0    0.0       andnpd	%xmm1, %xmm1
# CHECK-NEXT: 53.    1     2.0    2.0    0.0       vandnps	%xmm2, %xmm2, %xmm2
# CHECK-NEXT: 54.    1     2.0    2.0    0.0       vandnpd	%xmm1, %xmm1, %xmm1
# CHECK-NEXT: 55.    1     1.0    1.0    0.0       vandnps	%ymm2, %ymm2, %ymm2
# CHECK-NEXT: 56.    1     1.0    1.0    0.0       vandnpd	%ymm1, %ymm1, %ymm1
# CHECK-NEXT: 57.    1     1.0    1.0    0.0       pandn	%mm2, %mm2
# CHECK-NEXT: 58.    1     1.0    1.0    0.0       pandn	%xmm2, %xmm2
# CHECK-NEXT: 59.    1     2.0    2.0    0.0       vpandn	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: 60.    1     1.0    1.0    0.0       vpandn	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: 61.    1     1.0    1.0    0.0       vandnps	%xmm2, %xmm2, %xmm5
# CHECK-NEXT: 62.    1     1.0    1.0    0.0       vandnpd	%xmm1, %xmm1, %xmm5
# CHECK-NEXT: 63.    1     1.0    1.0    0.0       vpandn	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: 64.    1     1.0    1.0    0.0       vandnps	%ymm2, %ymm2, %ymm5
# CHECK-NEXT: 65.    1     1.0    1.0    0.0       vandnpd	%ymm1, %ymm1, %ymm5
# CHECK-NEXT: 66.    1     1.0    1.0    0.0       vpandn	%ymm3, %ymm3, %ymm5
# CHECK-NEXT: 67.    1     1.0    1.0    0.0       xorps	%xmm0, %xmm0
# CHECK-NEXT: 68.    1     1.0    1.0    0.0       xorpd	%xmm1, %xmm1
# CHECK-NEXT: 69.    1     2.0    2.0    0.0       vxorps	%xmm2, %xmm2, %xmm2
# CHECK-NEXT: 70.    1     2.0    2.0    0.0       vxorpd	%xmm1, %xmm1, %xmm1
# CHECK-NEXT: 71.    1     1.0    1.0    0.0       vxorps	%ymm2, %ymm2, %ymm2
# CHECK-NEXT: 72.    1     1.0    1.0    0.0       vxorpd	%ymm1, %ymm1, %ymm1
# CHECK-NEXT: 73.    1     1.0    1.0    0.0       pxor	%mm2, %mm2
# CHECK-NEXT: 74.    1     1.0    1.0    0.0       pxor	%xmm2, %xmm2
# CHECK-NEXT: 75.    1     2.0    2.0    0.0       vpxor	%xmm3, %xmm3, %xmm3
# CHECK-NEXT: 76.    1     1.0    1.0    0.0       vpxor	%ymm3, %ymm3, %ymm3
# CHECK-NEXT: 77.    1     1.0    1.0    0.0       vxorps	%xmm4, %xmm4, %xmm5
# CHECK-NEXT: 78.    1     1.0    1.0    0.0       vxorpd	%xmm1, %xmm1, %xmm3
# CHECK-NEXT: 79.    1     1.0    1.0    0.0       vxorps	%ymm4, %ymm4, %ymm5
# CHECK-NEXT: 80.    1     1.0    1.0    0.0       vxorpd	%ymm1, %ymm1, %ymm3
# CHECK-NEXT: 81.    1     1.0    1.0    0.0       vpxor	%xmm3, %xmm3, %xmm5
# CHECK-NEXT: 82.    1     1.0    1.0    0.0       vpxor	%ymm3, %ymm3, %ymm5
# CHECK-NEXT:        1     1.2    1.2    0.0       <total>
