/*
 This source file is part of the Swift.org open source project

 Copyright (c) 2021 Apple Inc. and the Swift project authors
 Licensed under Apache License v2.0 with Runtime Library Exception

 See https://swift.org/LICENSE.txt for license information
 See https://swift.org/CONTRIBUTORS.txt for Swift project authors
*/

import Foundation

import XCTest
@testable import SwiftDocC

class VersionTripletTest: XCTestCase {
    func testComparable() {
        XCTAssertLessThan(VersionTriplet(0,0,0), VersionTriplet(0,0,1))
        XCTAssertLessThan(VersionTriplet(1,0,0), VersionTriplet(1,0,1))
        XCTAssertLessThan(VersionTriplet(1,1,0), VersionTriplet(1,2,1))
        XCTAssertLessThan(VersionTriplet(1,1,0), VersionTriplet(1,1,2))
        XCTAssertLessThan(VersionTriplet(1,1,1), VersionTriplet(1,1,2))
        XCTAssertLessThan(VersionTriplet(5,0,0), VersionTriplet(10,0,1))
        
        // Test the autogenerated equality conformance for coherence
        XCTAssertEqual(VersionTriplet(5,2,1), VersionTriplet(5,2,1))
    }
}
