<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
  xmlns="http://www.w3.org/TR/xhtml1/transitional"
  exclude-result-prefixes="#default">

  <xsl:import href="http://docbook.sourceforge.net/release/xsl/current/epub/docbook.xsl"/>

  <!-- import common customizations -->
  <xsl:import href="tex-refs-common.xsl"/>

  <xsl:output method="html"
    encoding="ISO-8859-1"
    indent="no"/>

  <!-- insert customization here -->

  <xsl:param name="section.autolabel" select="1"/>
  <xsl:param name="html.stylesheet" select="'tex-refs.css'"/>

  <!-- override bridgehead to pass down a class "attribute" -->
  <xsl:template match="bridgehead">
    <xsl:variable name="hlevel">
      <xsl:choose>
        <xsl:when test="@renderas = 'sect1'">1</xsl:when>
        <xsl:when test="@renderas = 'sect2'">2</xsl:when>
        <xsl:when test="@renderas = 'sect3'">3</xsl:when>
        <xsl:when test="@renderas = 'sect4'">4</xsl:when>
        <xsl:when test="@renderas = 'sect5'">5</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="5"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:element name="h{$hlevel}" namespace="http://www.w3.org/1999/xhtml">
      <xsl:attribute name="class"><xsl:text>title</xsl:text></xsl:attribute>
      <xsl:call-template name="anchor">
        <xsl:with-param name="conditional" select="0"/>
      </xsl:call-template>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>

</xsl:stylesheet>

