(*
    Tux Commander - UTranslation_CHS - Simplified Chinese Localization constants
    Copyright (C) 2008 Kend <kendling@21cn.com>
    Check for updates on tuxcmd.sourceforge.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)
unit UTranslation_CHS;

(***************************************************************************
 * Info for translators:
     - please use UTF-8 encoding when making translations, the whole GTK+ 2
       is using it to display non-ASCII characters properly
     - please change the few lines at the bottom of this file to your
       locale string (e.g. en_US for English translation)
***************************************************************************)

interface

implementation

uses ULocale;

const LANGchsF2Button_Caption = 'F2 - 重命名';
      LANGchsF3Button_Caption = 'F3 - 查看';
      LANGchsF4Button_Caption = 'F4 - 编辑';
      LANGchsF5Button_Caption = 'F5 - 复制';
      LANGchsF6Button_Caption = 'F6 - 移动';
      LANGchsF7Button_Caption = 'F7 - 新建目录';
      LANGchsF8Button_Caption = 'F8 - 删除';

      LANGchsmnuFile_Caption = '文件(_F)';
      LANGchsmnuMark_Caption = '标记_M)';
      LANGchsmnuCommands_Caption = '命令(_C)';
      LANGchsmnuHelp_Caption = '帮助(_H)';
      LANGchsmiExit_Caption = '退出(_X)';
      LANGchsmiSelectGroup_Caption = '选择组(_G)...';
      LANGchsmiUnselectGroup_Caption = '取消选择组(_U)...';
      LANGchsmiSelectAll_Caption = '全选(_S)';
      LANGchsmiUnselectAll_Caption = '取消全选(_N)';
      LANGchsmiInvertSelection_Caption = '反选(_I)';
      LANGchsmiRefresh_Caption = '刷新(_R)';
      LANGchsmiAbout_Caption = '关于(_A)...';

      LANGchsColumn1_Caption = '名称';
      LANGchsColumn2_Caption = '扩展名';
      LANGchsColumn3_Caption = '大小';
      LANGchsColumn4_Caption = '日期';
      LANGchsColumn5_Caption = '属性';

      LANGchsExpandSelection = '扩大选择';
      LANGchsShrinkSelection = '收缩选择';
      LANGchsNoMatchesFound = '没有找到匹配项';
      LANGchsNoFilesSelected = '没有文件被选择!';
      LANGchsSelectedFilesDirectories = '%d 文件/目录被选择';
      LANGchsDirectoryS = '目录 %s';
      LANGchsFileS = '文件 %s';
      LANGchsDoYouReallyWantToDeleteTheS = '你真的想删除 %s ?';
      LANGchsDoYouReallyWantToDeleteTheSS = '你真的想删除 %s ?'#10'%s';
      LANGchsCopyFiles = '复制文件';
      LANGchsMoveRenameFiles = '移动/重命名文件';
      LANGchsCopyDFileDirectoriesTo = '复制 %d 文件/目录到';
      LANGchsMoveRenameDFileDirectoriesTo = '移动/重命名 %d 文件/目录到';
      LANGchsCopySC = '复制:';
      LANGchsMoveRenameSC = '移动/重命名:';

      LANGchsQuickFind = '  快速查找:';

      LANGchsAboutString = 'Tux Commander'#10'版本 %s'#10'建立日期: %s'#10#10'版权所有 (c) 2008 Tomas Bzatek'#10'E-mail: tbzatek@users.sourceforge.net'#10'Website: http://tuxcmd.sourceforge.net/'#10'汉化: Kend [kendling@21cn.com]';
      LANGchsAboutStringGnome = '版本 %s'#10'建立日期: %s'#10'网站: http://tuxcmd.sourceforge.net/';
      LANGchsDiskStatFmt = '%s 空闲,共 %s';
      LANGchsDiskStatVolNameFmt = '[%s] %s 空闲,共 %s';
      LANGchsStatusLineFmt = '%s 共 %s 在 %d 共 %d 文件被选择';
      LANGchsPanelStrings : array[boolean] of string = ('right', 'left');

      LANGchsDIR = '<DIR>';
      LANGchsErrorGettingListingForSPanel = '获取 %s 面板的列表时出错:'#10'    %s'#10#10'路径 = ''%s''';
      LANGchsErrorGettingListingForSPanelNoPath = '获取 %s 面板的列表时出错:'#10'    %s';
      LANGchsErrorCreatingNewDirectorySInSPanel = '新建目录 ''%s'' 在 %s 面板时出错:'#10'    %s';
      LANGchsErrorCreatingNewDirectorySInSPanelNoPath = '新建目录在 %s 面板时出错:'#10'    %s';
      LANGchsTheFileDirectory = '文件/目录';
      LANGchsCouldNotBeDeleted = '不能删除';
      LANGchsCouldNotBeDeletedS = '不能删除:  %s';
      LANGchsUserCancelled = '用户已取消!';
      LANGchsTheDirectorySIsNotEmpty = '目录 %s 不为空!';
      LANGchsCannotCopyFile = '不能复制文件';
      LANGchsCopyError = '复制错误';
      LANGchsMoveError = '移动错误';
      LANGchsOverwriteS = '复盖: %s';
      LANGchsWithFileS = '为文件: %s';
      LANGchsOvewriteSBytesS = '%s 字节, %s';
      LANGchsTheFile = '文件';
      LANGchsCopy = '复制';
      LANGchsMove = '移动';
      LANGchsTheDirectory = '目录';
      LANGchsTheSymbolicLink = '符号连接';
      LANGchsCannotMoveFile = '不能移动文件';
      LANGchsCouldNotBeCreated = '不能创建';
      LANGchsCouldNotBeCreatedS = '不能创建创:  %s';
      LANGchsFromS = '从: %s';
      LANGchsToS = '到: %s';
      LANGchsCannotCopyFileToItself = '不能复制文件到自身';
      LANGchsMemoryAllocationFailed = '内存分配失败:';
      LANGchsCannotOpenSourceFile = '不能打开源文件';
      LANGchsCannotOpenDestinationFile = '不能打开目标文件';
      LANGchsCannotCloseDestinationFile = '不能关闭目标文件';
      LANGchsCannotCloseSourceFile = '不能关闭源文件';
      LANGchsCannotReadFromSourceFile = '不能从源文件读取';
      LANGchsCannotWriteToDestinationFile = '不能写到目标文件';

      LANGchsUnknownException = '未知异常';
      LANGchsNoAccess = '没有访问';
      LANGchsUnknownError = '未知错误';

      LANGchsCreateANewDirectory = '创建新目录';
      LANGchsEnterDirectoryName = '输入目录名(_D):';

      LANGchsOverwriteQuestion = '复盖提示';
      LANGchsOverwriteButton_Caption = '复盖(_O)';
      LANGchsOverwriteAllButton_Caption = '复盖所有(_A)';
      LANGchsSkipButton_Caption = '跳过(_S)';
      LANGchsOverwriteAllOlderButton_Caption = '复盖旧文件(_D)';
      LANGchsSkipAllButton_Caption = '全部跳过(_K)';
      LANGchsRenameButton_Caption = '重命名(_R)';
      LANGchsAppendButton_Caption = '附加(_P)';
      LANGchsRename = '重命名';
      LANGchsRenameFile = '重命名文件 ''%s'' 到';
      LANGchsIgnoreButton_Caption = '忽略(_I)';

      LANGchsProgress = '进度';
      LANGchsCancel = '取消(_C)';
      LANGchsDelete = '删除:';

      LANGchsSpecifyFileType = '指定文件类型(_S):';

      LANGchsRemoveDirectory = '删除目录';
      LANGchsDoYouWantToDeleteItWithAllItsFilesAndSubdirectories = '你确定删除该目录以及里面的所有文件和子目录?';
      LANGchsRetry = '重试(_R)';
      LANGchsDeleteButton_Caption = '删除(_D)';
      LANGchsAll = '全部(_A)';

      LANGchsCopyFilesSC = '复制文件:';
      LANGchsAppendQuestion = '你确定要附加文件 ''%s'' 到 ''%s''?';
      LANGchsPreparingList = '正在准备列表...';

      LANGchsYouMustSelectAValidFile = '你必需选择一个有效的文件!';
      LANGchsmiVerifyChecksums = '检验校验和(_V)';
      LANGchsVerifyChecksumsCaption = '检验校验和';
      LANGchsCheckButtonCaptionCheck = '检查(_C)';
      LANGchsCheckButtonCaptionStop = '停止(_S)';
      LANGchsFileListTooltip = '[?] - 没有选择'#10'[OK] - 校验和正确'#10'[BAD] - 校验和失败'#10'[N/A] - 文件不可用';
      LANGchsFilenameColumnCaption = '文件名';
      LANGchsTheFileSYouAreTryingToOpenIsQuiteBig = '你尝试打开的文件 ''%s'' 太大 (%s 字节). 它可能不是一个有效的校验和文件.'#10#10'你是否想加载它?';
      LANGchsAnErrorOccuredWhileInitializingMemoryBlock = '初始化内存块时发生错误. 请关闭一些程序后再试.';
      LANGchsAnErrorOccuredWhileOpeningFileSS = '打开文件 ''%s'' 时发生错误:'#10'  %s';
      LANGchsAnErrorOccuredWhileReadingFileSS = '读取文件 ''%s'' 时发生错误:'#10'  %s';
      LANGchsChecksumNotChecked = '<span weight="bold">状态:</span> 没有选择';
      LANGchsChecksumChecking = '<span weight="bold">状态:</span> 正在检验...';
      LANGchsChecksumInterrupted = '<span weight="bold">状态:</span> 中断';
      LANGchsChecksumDOK = '<span weight="bold">状态:</span> %d%% 正确';

      LANGchsmiCreateChecksumsCaption = '创建校验和(_C)...';
      LANGchsYouMustSelectAtLeastOneFileToCalculateChecksum = '你必须选择一个或多个文件进行校验和计算!';
      LANGchsCreateChecksumsCaption = '创建校验和';
      LANGchsCCHKSUMPage1Text = '你正在为选择的文件创建校验和文件.'#10'如果你没有选择文件,'#10'请关闭并重新选择文件.';
      LANGchsCCHKSUMPage4Text = '你已经准备好为选择的文件创建校验和.'#10'这个操作可能需要几分钟时间.'#10'单击前进继续.';
      LANGchsCCHKSUMPage6Text = '创建校验和时发生以下错误:';
      LANGchsCCHKSUMPage7Text = '校验和创建完成.'#10#10'单击 "完成" 按钮退出.';
      LANGchsCCHKSUMPage1Title = '<span size="xx-large" weight="ultrabold">为校验和准备文件</span>';
      LANGchsCCHKSUMPage2Title = '<span size="xx-large" weight="ultrabold">选择校验和文件类型</span>';
      LANGchsCCHKSUMPage3Title = '<span size="xx-large" weight="ultrabold">选择文件名</span>';
      LANGchsCCHKSUMPage4Title = '<span size="xx-large" weight="ultrabold">准备检验</span>';
      LANGchsCCHKSUMPage5Title = '<span size="xx-large" weight="ultrabold">正在检验...</span>';
      LANGchsCCHKSUMPage6Title = '<span size="xx-large" weight="ultrabold">错误!</span>';
      LANGchsCCHKSUMPage7Title = '<span size="xx-large" weight="ultrabold">完成</span>';
      LANGchsCCHKSUMSFVFile = 'SFV 文件';
      LANGchsCCHKSUMMD5sumFile = 'MD5sum 文件';
      LANGchsCCHKSUMFileName = '文件名(_N):';
      LANGchsCCHKSUMCreateSeparateChecksumFiles = '为每个文件独立创建校验和文件(_S)';
      LANGchsCCHKSUMNowProcessingFileS = '正在处理文件: %s';
      LANGchsCCHKSUMFinishCaption = '完成(_F)';
      LANGchsCCHKSUMAreYouSureYouWantToAbortTheProcessing = '你确定要中断当前操作?';
      LANGchsCCHKSUMAnErrorOccuredWhileOpeningFileSS = '打开文件 ''%s'' 时发生一个错误: %s'#10;
      LANGchsCCHKSUMAnErrorOccuredWhileReadingFileSS = '读取文件 ''%s'' 时发生一个错误: %s'#10;
      LANGchsCCHKSUMAnErrorOccuredWhileWritingFileSS = '写入文件 ''%s'' 时发生一个错误: %s'#10;

      LANGchsAnErrorOccuredWhileWritingFileSS = '写入文件 ''%s'' 时发生一个错误:'#10'  %s';
      LANGchsTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt = '目标文件 ''%s'' 已经存在. 你是否要复盖它?';
      LANGchsTheTargetFileSCannotBeRemovedS = '目标文件 ''%s'' 不能创建: %s';
      LANGchsMergeCaption = '合并';
      LANGchsPleaseInsertNextDiskOrGiveDifferentLocation = '请插入下一个磁盘, 或选择其他路径:';
      LANGchsMergeOfSSucceeded = '合并 ''%s'' 成功 (CRC 校验和正确).';
      LANGchsWarningCreatedFileFailsCRCCheck = '警告: 创建文件失败 CRC 检查!';
      LANGchsMergeOfSSucceeded_NoCRCFileAvailable = '合并 ''%s'' 成功 (没有 CRC 文件可用).';
      LANGchsMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory = '以字母顺序合并 ''%s'' 和所有文件到以下目录:';
      LANGchsMergeSC = '合并:';
      LANGchsmiSplitFileCaption = '拆分文件(_S)...';
      LANGchsmiMergeFilesCaption = '合并文件(_M)...';

      LANGchsSplitTheFileSToDirectory = '拆分文件 ''%s'' 到目录(_S):';
      LANGchsSplitSC = '拆分:';
      LANGchsSplitFile = '拆分文件';
      LANGchsBytesPerFile = '每个文件字节数(_B):';
      LANGchsAutomatic = '自动';
      LANGchsDeleteFilesOnTargetDisk = '在目标磁盘删除文件(_D) (仅可移动媒体)';
      LANGchsSplitCaption = '拆分';
      LANGchsCannotOpenFileS = '不能打开文件 ''%s''';
      LANGchsCannotSplitTheFileToMoreThan999Parts = '不能把文件拆分为 999 部份以上!';
      LANGchsThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem = '某些文件已经在目标目录存在:'#10'%s'#10'是否删除这些文件?';
      LANGchsThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem = '%d 文件在目标目录中. 是否删除这些文件?';
      LANGchsAnErrorOccuredWhileOperationS = '执行操作时发生下一个错误: %s';
      LANGchsSplitOfSSucceeded = '拆分 ''%s'' 成功.';
      LANGchsSplitOfSFailed = '拆分 ''%s'' 失败!';

      LANGchsmnuShow_Caption = '显示(_W)';
      LANGchsmiShowDotFiles_Caption = '显示以"."开头的文件(_D)(隐藏文件)';
      LANGchsTheFileYouAreTryingToOpenIsQuiteBig = '你尝试打开的文件太大. 在外部程序(可能为 gedit)中加载可能导致系统缓慢.'#10'是否继续?';
      LANGchsCannotExecuteSPleaseCheckTheConfiguration = '不能执行 ''%s''. 请检查配置或设置文件可执行属性是否正常.';
      LANGchsEdit = '编辑';
      LANGchsEnterFilenameToEdit = '输入要编辑的文件名(_E):';

      LANGchsmnuSettings_Caption = '设置(_T)';
      LANGchsmiFileTypes_Caption = '文件类型(_T)...';
      LANGchsThereIsNoApplicationAssociatedWithS = '没有程序关联到 "%s".'#10#10'你可以配置 Tux Commander 关联到该文件类型. 是否现在关联该文件类型到一个程序?';
      LANGchsErrorExecutingCommand = '执行命令错误!';
      LANGchsEditFileTypesCaption = '编辑文件类型';
      LANGchsTitleLabel_Caption = '<span size="x-large" weight="ultrabold">文件类型配置</span>';
      LANGchsExtensionsColumn = '扩展名';
      LANGchsDescriptionColumn = '描述';
      LANGchsFileTypesList = '文件类型列表';
      LANGchsActionName = '运作名称';
      LANGchsCommand = '命令';
      LANGchsSetDefaultActionButton_Caption = '设为缺省(_S)';
      LANGchsRunInTerminalCheckBox_Caption = '在终端中运行(_T)';
      LANGchsAutodetectCheckBox_Caption = '自动检测 _GUI 程序';
      LANGchsBrowseButton_Caption = '浏览(_B)...';
      LANGchsCommandLabel_Caption = '命令(_M):';
      LANGchsDescriptionLabel_Caption = '描述(_E):';
      LANGchsFNameExtLabel_Caption = '添加扩展名(_D):';
      LANGchsNotebookPageExtensions = '文件类型';
      LANGchsNotebookPageActions = '运作';
      LANGchsDefault = ' (缺省)';
      LANGchsCannotSaveFileTypeAssociationsBecauseOtherProcess = '不能保存文件类型关联, 因为该程序的另一个实例已经更新.';

      LANGchsDefaultColor = '缺省颜色(_F)';
      LANGchsIcon = '图标(_I):';
      LANGchsBrowseForIcon = '浏览图标';
      LANGchsSelectFileTypeColor = '选择文件类型颜色';
      LANGchsColor = '颜色(_L):';

      LANGchsmiChangePermissions_Caption = '更改权限(_M)...';
      LANGchsmiChangeOwner_Caption = '更改所有者/组...';
      LANGchsmiCreateSymlink_Caption = '创建符号连接(_L)...';
      LANGchsmiEditSymlink_Caption = '编辑符号连接(_E)...';
      LANGchsChmodProgress = '更改权限:';
      LANGchsChownProgress = '更改所有者:';
      LANGchsYouMustSelectAValidSymbolicLink = '你必需选择一个有效的符号为连接!';
      LANGchsPopupRunS = '执行(_X) %s';
      LANGchsPopupOpenS = '打开(_P) %s';
      LANGchsPopupGoUp = '上一级(_G)';
      LANGchsPopupOpenWithS = '打开为 %s';
      LANGchsPopupDefault = ' (缺省)';
      LANGchsPopupOpenWith = '打开为(_P)...';
      LANGchsPopupViewFile = '查看文件(_V)';
      LANGchsPopupEditFile = '编辑文件(_I))';
      LANGchsPopupMakeSymlink = '创建符号连接(_S)';
      LANGchsPopupRename = '重命名(_R)';
      LANGchsPopupDelete = '删除(_D)';
      LANGchsDialogChangePermissions = '更改仅限';
      LANGchsCouldNotBeChmoddedS = '不能更改权限:  %s';
      LANGchsDialogChangeOwner = '更改所有者';
      LANGchsCouldNotBeChownedS = '不能更改所有者:  %s';
      LANGchsDialogMakeSymlink = '创建符号连接';
      LANGchsDialogEditSymlink = '编辑符号连接';
      LANGchsFEditSymlink_Caption = '编辑符号连接';
      LANGchsFEditSymlink_SymbolicLinkFilename = '编辑符号连接文件名(_S):';
      LANGchsFEditSymlink_SymbolicLinkPointsTo = '符号连接到(_T):';

      LANGchsFChmod_Caption = '访问权限';
      LANGchsFChmod_PermissionFrame = '';
      LANGchsFChmod_FileFrame = '文件';
      LANGchsFChmod_ApplyRecursivelyFor = '应用到子文件和目录(_R)';
      LANGchsFChmod_miAllFiles = '所有文件和目录';
      LANGchsFChmod_miDirectories = '仅目录';
      LANGchsFChmod_OctalLabel = '八进制(_O):';
      LANGchsFChmod_SUID = 'SUID - 运行时设置用户 ID';
      LANGchsFChmod_SGID = 'SGID - 运行时设置组 ID';
      LANGchsFChmod_Sticky = '粘贴位';
      LANGchsFChmod_RUSR = 'RUSR - 以所有者读';
      LANGchsFChmod_WUSR = 'WUSR - 以所有者写';
      LANGchsFChmod_XUSR = 'XUSR - 以所有者执行/搜索';
      LANGchsFChmod_RGRP = 'RGRP - 以组读';
      LANGchsFChmod_WGRP = 'WGRP - 以组写';
      LANGchsFChmod_XGRP = 'XGRP - 以组执行/搜索';
      LANGchsFChmod_ROTH = 'ROTH - 以其他读';
      LANGchsFChmod_WOTH = 'WOTH - 以其他写';
      LANGchsFChmod_XOTH = 'XOTH - 以其他执行/搜索';
      LANGchsFChmod_TextLabel = '<span weight="ultrabold">文本:</span>  %s';
      LANGchsFChmod_FileLabel = '<span weight="ultrabold">文件:</span> %s'#10'<span weight="ultrabold">文本:</span> %s'#10 +
                               '<span weight="ultrabold">八进制:</span> %d'#10'<span weight="ultrabold">所有者:</span> %s'#10 +
                               '<span weight="ultrabold">组:</span> %s';

      LANGchsFChown_Caption = '更改 所有者/组';
      LANGchsFChown_OwnerFrame = '用户名';
      LANGchsFChown_GroupFrame = '组名';
      LANGchsFChown_FileFrame = '文件';
      LANGchsFChown_ApplyRecursively = '应用到子文件和目录(_R)';

      LANGchsFSymlink_Caption = '创建符号连接';
      LANGchsFSymlink_ExistingFilename = '已存在文件名(_E) (符号连接到的文件名):';
      LANGchsFSymlink_SymlinkFilename = '符号连接文件名(_S):';

      LANGchsmnuBookmarks_Caption = '书签(_B)';
      LANGchsmiAddBookmark_Caption = '添加添加';
      LANGchsmiEditBookmarks_Caption = '编辑编辑';
      LANGchsBookmarkPopupDelete_Caption = '删除(_D)';
      LANGchsmiPreferences_Caption = '参数(_P)...';
      LANGchsTheCurrentDirectoryAlreadyExistsInTheBookmarksList = '当前目录已经在书签中';
      LANGchsSomeOtherInstanceChanged = '其他 Tux Commander 实例已经更改配置. 是否应到新新设置?'#10#10'警告: 如果你点击"否", 当前配置将会复盖最新设置'' 退出!';
      
      LANGchsPreferences_Caption = '参数';
      LANGchsPreferences_TitleLabel_Caption = '<span size="x-large" weight="ultrabold">程序参数</span>';
      LANGchsPreferences_GeneralPage = '常规';
      LANGchsPreferences_FontsPage = '字体';
      LANGchsPreferences_ColorsPage = '颜色';
      LANGchsPreferences_RowHeight = '行高度(_H):';
      LANGchsPreferences_NumHistoryItems = '命令行历史项目数(_M):';
      LANGchsPreferences_Default = '缺省(_D)';
      LANGchsPreferences_ClearReadonlyAttribute = '从 CD-ROM 复制文件晨清除只读属性(_R)';
      LANGchsPreferences_DisableMouseRenaming = '禁用鼠标重命名(_M)';
      LANGchsPreferences_ShowFiletypeIconsInList = '显示文件类型图标(_F)';
      LANGchsPreferences_ExternalAppsLabel = '<span weight="ultrabold">外部程序</span>';
      LANGchsPreferences_Viewer = '查看器(_V):';
      LANGchsPreferences_Editor = '编辑器(_E):';
      LANGchsPreferences_Terminal = '终端(_T):';
      LANGchsPreferences_ListFont = '列表字体:';
      LANGchsPreferences_Change = '更改...';
      LANGchsPreferences_UseDefaultFont = '使用缺省字体(_D)';
      LANGchsPreferences_Foreground = '前景';
      LANGchsPreferences_Background = '背景';
      LANGchsPreferences_NormalItem = '缺省项:';
      LANGchsPreferences_SetToDefaultToUseGTKThemeColors = '设置缺省为 GTK 主题颜色';
      LANGchsPreferences_Cursor = '颜色:';
      LANGchsPreferences_InactiveItem = '不激动项:';
      LANGchsPreferences_SelectedItem = '已选择项:';
      LANGchsPreferences_LinkItem = '符号连接:';
      LANGchsPreferences_LinkItemHint = '设置缺省为显示符号连接颜色使用正常项颜色';
      LANGchsPreferences_DotFileItem = '以"."开头的文件:';
      LANGchsPreferences_DotFileItemHint = '设置缺省为显示以"."开头的文件使用正常项颜色';
      LANGchsPreferences_BrowseForApplication = '浏览应用程序';
      LANGchsPreferences_DefaultS = '缺省: %s';
      LANGchsPreferences_SelectFont = '选择字体';

  (***************  STRINGS ADDED TO v0.4.101  **********************************************************************************)
      LANGchsBookmarkButton_Tooltip = '显示书签';
      LANGchsUpButton_Tooltip = '转到上一层目录';
      LANGchsRootButton_Tooltip = '转到根目录 (/)';
      LANGchsHomeButton_Tooltip = '转到用户目录 (/home/user)';
      LANGchsLeftEqualButton_Tooltip = '切换右面板到相同目录';
      LANGchsRightEqualButton_Tooltip = '切换左面板到相同目录';
      LANGchsmiShowDirectorySizes_Caption = '显示目录大小(_I)';
      LANGchsmiTargetSource_Caption = '目标 = 源(_O)';
      LANGchsFileTypeDirectory = '目录';
      LANGchsFileTypeFile = '文件';
      LANGchsFileTypeMetafile = '这是一个公用媒体项';
      LANGchsPreferencesPanelsPage = '面板';
      LANGchsPreferencesApplicationsPage = '应用程序';
      LANGchsPreferencesExperimentalPage = '实验项';
      LANGchsPreferencesSelectAllDirectoriesCheckBox_Caption = '全选时包括目录(_A)';
      LANGchsPreferencesNewStyleAltOCheckBox_Caption = '新样式(_N) Alt+O';
      LANGchsPreferencesNewStyleAltOCheckBox_Tooltip = '按 Ctrl/Alt+O 切换目标面板的目录时停留在相同的目录';
      LANGchsPreferencesShowFuncButtonsCheckBox_Caption = '显示功能按钮(_K)';
      LANGchsPreferencesSizeFormatLabel_Caption = '大小格式(_S):';
      LANGchsPreferencesmiSizeFormat1 = '系统';
      LANGchsPreferencesmiSizeFormat6 = '组';
      LANGchsPreferencesAutodetectXApp = '自动检测 X 程序';
      LANGchsPreferencesAlwaysRunInTerminal = '总是在终端中运行';
      LANGchsPreferencesNeverRunInTerminal = '永不在终端中运行';
      LANGchsPreferencesCmdLineBehaviourLabel_Caption = '从命令行执行(_E):';
      LANGchsPreferencesFeatures = '功能';
      LANGchsPreferencesDisableMouseRename_Tooltip = '你仍然可以通过 Shift+F6 快速重命名';
      LANGchsPreferencesDisableFileTipsCheckBox_Caption = '禁用文件提示(_T)';
      LANGchsPreferencesDisableFileTipsCheckBox_Tooltip = '面板中的文字被截断时不显示提示';
      LANGchsPreferencesShow = '显示';
      LANGchsPreferencesDirsInBoldCheckBox_Caption = '目录使用粗体(_B)';
      LANGchsPreferencesDisableDirectoryBracketsCheckBox_Caption = '隐藏目录的方括号(_R)';
      LANGchsPreferencesOctalPermissionsCheckBox_Caption = '显示八进制权限(_O)';
      LANGchsPreferencesOctalPermissionsCheckBox_Tooltip = '以数字格式显示文件/目录权限，默认以 (-rw-rw-rw-) 格式';
      LANGchsPreferencesMovement = 'Movement';
      LANGchsPreferencesLynxLikeMotionCheckBox_Caption = '_Lynx-like motion';
      LANGchsPreferencesInsertMovesDownCheckBox_Caption = '按 _Insert 光标下移';
      LANGchsPreferencesSpaceMovesDownCheckBox_Caption = '按空格光标下移(_S)';
      LANGchsPreferencesViewer = '查看器';
      LANGchsPreferencesCommandSC = '命令:';
      LANGchsPreferencesUseInternalViewer = '使用内置查看器(_I)';
      LANGchsPreferencesEditor = '编辑器';
      LANGchsPreferencesTerminal = '终端';
      LANGchsPreferencesExperimentalFeatures = '体验功能';
      LANGchsPreferencesExperimentalWarningLabel_Caption = '<span weight="ultrabold">警告:</span> 这些功能当前还在开发阶段, 可能并不能正常工作. 使用他们你将自行承担风险!';
      LANGchsPreferencesFocusRefreshCheckBox_Caption = '窗口获取焦点时进行刷新(_R)';
      LANGchsPreferencesFocusRefreshCheckBox_Tooltip = '这时候面板刷新非常慢';
      LANGchsPreferencesWMCompatModeCheckBox_Caption = '_WM 兼容模式';
      LANGchsPreferencesWMCompatModeCheckBox_Tooltip = '当你使用一些窗口管理器时可以使用此选项(例如 IceWM 不能使窗口正常最大化)';
      LANGchsPreferencesCompatUseLibcSystemCheckBox_Caption = '使用 libc _system() 执行程序';
      LANGchsPreferencesCompatUseLibcSystemCheckBox_Tooltip = '执行外部程序时发生错误时使用';

  (***************  STRINGS ADDED TO v0.5.70  **********************************************************************************)
      LANGchsmiSearchCaption2 = '正在搜索(_S)...';
      LANGchsmiNoMounterBarCaption = '不显示驱动器工具栏';
      LANGchsmiShowOneMounterBarCaption = '显示一个驱动器工具栏(_O)';
      LANGchsmiShowTwoMounterBarCaption = '显示两个驱动器工具栏(_T)';
      LANGchsmnuNetworkCaption = '网络(_E)';
      LANGchsmiConnectionsCaption = '连接(_C)...';
      LANGchsmiOpenConnectionCaption = '打开连接(_Open)...';
      LANGchsmiQuickConnectCaption = '快速连接(_Q)...';
      LANGchsmnuPluginsCaption = '插件(_U)';
      LANGchsmiTestPluginCaption = '测试插件(_T)...';
      LANGchsmiMounterSettingsCaption = '驱动器设置(_M)...';
      LANGchsmiColumnsCaption = '面板列(_A)...';
      LANGchsmiSavePositionCaption = '保存位置(_S)';
      LANGchsmiMountCaption = '加载(_M)';
      LANGchsmiUmountCaption = '卸载(_U)';
      LANGchsmiEjectCaption = '弹出(_E)';
      LANGchsmiDuplicateTabCaption = '复制当前标签';
      LANGchsmiCloseTabCaption = '关闭当前标签';
      LANGchsmiCloseAllTabsCaption = '关闭所有标签';
      LANGchsCannotDetermineDestinationEngine = '不能确定目标引擎. 请输入正确的路径重试.';
      LANGchsCannotLoadFile = '不能加载文件 ''%s''. 请检查权限.';
      LANGchsMountPointDevice = '加载点: %s'#10'设备: %s';
      LANGchsMountSC = '加载:';
      LANGchsNoPluginsFound = '没有找到插件';
      LANGchsPluginAbout = '关于...';
      LANGchsCouldntOpenURI = '不能打开指定的URI. 请检查资源标识的一致性和访问权限.';
      LANGchsPluginAboutInside = '插件: %s'#10#10'%s'#10'%s';
      LANGchsAreYouSureCloseAllTabs = '确定要关闭所有非活动的标签?';
      LANGchsCouldntOpenURIArchive = '不能打开文档. 请检查一致性和访问权限.';
      LANGchsThereIsNoModuleAvailable = '没有可用的 VFS 模块能处理当前连接';
      LANGchsIgnoreError = '确定要忽略这个错误? 源文件将会被删除';
      LANGchsErrorMount = '加载设备 ''%s'' 时发生错误:'#10#10;
      LANGchsErrorUmount = '卸载 ''%s'' 时发生错误:'#10#10;
      LANGchsErrorEject = '弹出 ''%s'' 时发生错误:'#10#10;

      LANGchsMounterPrefs_Caption = '驱动器设置';
      LANGchsMounterPrefs_TitleLabelCaption = '驱动器设置';
      LANGchsMounterPrefs_ListViewFrameCaption = '驱动器';
      LANGchsMounterPrefs_MountName = '加载名称';
      LANGchsMounterPrefs_MountPoint = '加载点';
      LANGchsMounterPrefs_Device = '设备';
      LANGchsMounterPrefs_MoveUpButtonTooltip = '上移项目';
      LANGchsMounterPrefs_MoveDownButtonTooltip = '下移项目';
      LANGchsMounterPrefs_UseFSTabDefaultsCheckBox = '使用 _fstab 缺省项目';
      LANGchsMounterPrefs_UseFSTabDefaultsCheckBoxTooltip = '选中时, 驱动器工具栏将会在 /etc/fstab (系统加载列表文件) 文件中查找驱动器';
      LANGchsMounterPrefs_ToggleModeCheckBox = '加载完成后保持按钮按下';
      LANGchsMounterPrefs_ToggleModeCheckBoxTooltip = '选中时, 当设备加载完成后加载按钮将保持按下状态; 再点击将会卸载它们 (可能是弹出)';
      LANGchsMounterPrefs_PropertiesFrameCaption = '驱动器属性';
      LANGchsMounterPrefs_DisplayTextLabelCaption = '显示文本(_T):';
      LANGchsMounterPrefs_MountPointLabelCaption = '加载点(_P):';
      LANGchsMounterPrefs_MountDeviceLabelCaption = '设备(_D):';
      LANGchsMounterPrefs_DeviceTypeLabelCaption = '设备类型(_Y):';
      LANGchsMounterPrefs_miLocalDiskCaption = '本地磁盘';
      LANGchsMounterPrefs_miRemovableCaption = '可移动磁盘';
      LANGchsMounterPrefs_miCDCaption = 'CD/DVD 驱动器';
      LANGchsMounterPrefs_miFloppyCaption = '软盘驱动器';
      LANGchsMounterPrefs_miNetworkCaption = '网络';
      LANGchsMounterPrefs_MountCommandLabelCaption = '加载命令(_C):';
      LANGchsMounterPrefs_UmountCommandLabelCaption = '卸载命令(_O):';
      LANGchsMounterPrefs_MountCommandEntryTooltip = '语法: 使用 %dev 代替设备和 %dir 的加载点或者空白使用缺省加载'#10'注意: 谨防交互式命令, tuxcmd 将会假死!'#10'例子: smbmount %dev %dir -o username=netuser,password=somepass';
      LANGchsMounterPrefs_UmountCommandEntryTooltip = '语法: ｜ %dev 代替设备和 %dir 的加载点或者空白使用缺省卸载'#10'例子: smbumount $dir';
      LANGchsMounterPrefs_IconLabelCaption = '图标(_I):';

      LANGchsConnMgr_Caption = '打开新连接';
      LANGchsConnMgr_ConnectButton = '连接(_N)';
      LANGchsConnMgr_OpenConnection = '打开连接';
      LANGchsConnMgr_NameColumn = '名称';
      LANGchsConnMgr_URIColumn = 'URI';
      LANGchsConnMgr_AddConnectionButtonCaption = '添加站点(_A)...';
      LANGchsConnMgr_AddConnectionButtonTooltip = '添加新连接';
      LANGchsConnMgr_EditButtonCaption = '编辑(_E)...';
      LANGchsConnMgr_EditButtonTooltip = '编辑选择的连接';
      LANGchsConnMgr_RemoveButtonCaption = '删除站点(_R)';
      LANGchsConnMgr_RemoveButtonTooltip = '删除选择的连接';
      LANGchsConnMgr_DoYouWantDelete = '确定要删除这个连接 ''%s''?';

      LANGchsConnProp_FTP = 'FTP';
      LANGchsConnProp_SFTP = 'SFTP (ssh 子系统)';
      LANGchsConnProp_SMB = 'Windows 共享 (SMB)';
      LANGchsConnProp_HTTP = 'WebDAV (HTTP)';
      LANGchsConnProp_HTTPS = '安装 WebDAV (HTTPS)';
      LANGchsConnProp_Other = '其他 <span style="italic">(在 URI 中指定)</span>';
      LANGchsConnProp_Caption = '连接属性';
      LANGchsConnProp_VFSModule = '_VFS 模块:';
      LANGchsConnProp_URI = '_URI:';
      LANGchsConnProp_URIEntryTooltip = '正确的 URI 必需包含服务类型前缀和服务器地址';
      LANGchsConnProp_DetailedInformations = '详细信息';
      LANGchsConnProp_Name = '名称(_N):';
      LANGchsConnProp_Server = '服务器[:端口](_V):';
      LANGchsConnProp_Username = '用户名(_M):';
      LANGchsConnProp_UserNameEntryTooltip = '空白时使用 anonymous 登录';
      LANGchsConnProp_Password = '密码(_P):';
      LANGchsConnProp_TargetDirectory = '目标目录(_D):';
      LANGchsConnProp_ServiceType = '服务类型(_S):';
      LANGchsConnProp_MaskPassword = '隐藏密码(_M)';
      LANGchsConnProp_MenuItemCaption = '缺省 <span style="italic">(所有适当的模块)</span>';

      LANGchsConnLogin_Caption = '必需授权';
      LANGchsConnLogin_Login = '登录';
      LANGchsConnLogin_ExperimentalWarningLabelCaption = '你必需登录后访问 %s';
      LANGchsConnLogin_Username = '用户名(_U):';
      LANGchsConnLogin_Password = '密码(_P):';
      LANGchsConnLogin_AnonymousCheckButton = '匿名(_A)';

      LANGchsColumns_Caption = '面板列设置';
      LANGchsColumns_Title = '面板列设置';
      LANGchsColumns_MoveUpButtonTooltip = '上移项目';
      LANGchsColumns_MoveDownButtonTooltip = '下移项目';
      LANGchsColumns_TitlesLongName = '名称';
      LANGchsColumns_TitlesLongNameExt = '名称 + 扩展名';
      LANGchsColumns_TitlesLongExt = '扩展名';
      LANGchsColumns_TitlesLongSize = '大小';
      LANGchsColumns_TitlesLongDateTime = '日期 + 时间';
      LANGchsColumns_TitlesLongDate = '日期';
      LANGchsColumns_TitlesLongTime = '时间';
      LANGchsColumns_TitlesLongUser = '用户';
      LANGchsColumns_TitlesLongGroup = '组';
      LANGchsColumns_TitlesLongAttr = '属性';
      LANGchsColumns_TitlesShortName = '名称';
      LANGchsColumns_TitlesShortNameExt = '名称';
      LANGchsColumns_TitlesShortExt = '扩展名';
      LANGchsColumns_TitlesShortSize = '大小';
      LANGchsColumns_TitlesShortDateTime = '日期';
      LANGchsColumns_TitlesShortDate = '日期';
      LANGchsColumns_TitlesShortTime = '时间';
      LANGchsColumns_TitlesShortUser = '用户';
      LANGchsColumns_TitlesShortGroup = '组';
      LANGchsColumns_TitlesShortAttr = '属性';

      LANGchsTestPlugin_Caption = '测试 VFS 插件';
      LANGchsTestPlugin_Title = '测试 VFS 插件';
      LANGchsTestPlugin_ExperimentalWarningLabelCaption = '<span weight="ultrabold">警告:</span> VFS 子系统和它的插件还在紧张开发中, 它可能还有 BUG. 使用这个功能你将自行承担风险!';
      LANGchsTestPlugin_Plugin = '插件(_P):';
      LANGchsTestPlugin_Command = '命令(_M):';
      LANGchsTestPlugin_Username = '用户名(_U):';
      LANGchsTestPlugin_Password = '密码(_P):';
      LANGchsTestPlugin_AnonymousCheckButton = '匿名登录(_A) (不调用 VFSLogin)';
      LANGchsTestPlugin_NoPluginsFound = '没有找到插件';

      LANGchsRemoteWait_Caption = '操作正在进行';
      LANGchsRemoteWait_OperationInProgress = '操作正在进行, 请稍后...';
      LANGchsRemoteWait_ItemsFound = '找到项目在: %d';

      LANGchsSearch_Bytes = '字节';
      LANGchsSearch_kB = 'kB';
      LANGchsSearch_MB = 'MB';
      LANGchsSearch_days = '日';
      LANGchsSearch_weeks = '周';
      LANGchsSearch_months = '月';
      LANGchsSearch_years = '年';
      LANGchsSearch_Caption = '找到文件';
      LANGchsSearch_General = '常规';
      LANGchsSearch_Advanced = '高级';
      LANGchsSearch_SearchResults = '搜索结果(_R):';
      LANGchsSearch_SearchFor = '搜索内容(_F):';
      LANGchsSearch_FileMaskEntryTooltip = '提示: 使用分号 (";") 指定多个查找项';
      LANGchsSearch_SearchIn = '搜索目录(_I):';
      LANGchsSearch_SearchArchivesCheckButton = '搜索文档(_A)';
      LANGchsSearch_FindText = '查找文本(_T):';
      LANGchsSearch_FindTextEntryTooltip = '空为不匹配文本'#10'请注意 GUI 部份 UTF-8';
      LANGchsSearch_CaseSensitiveCheckButton = '大小写敏感(_E)';
      LANGchsSearch_StayCurrentFSCheckButton = '包括其他文件系统(_Y)';
      LANGchsSearch_CaseSensitiveMatchCheckButton = '大小写敏感(_S)';
      LANGchsSearch_Size = '大小';
      LANGchsSearch_Date = '日期';
      LANGchsSearch_BiggerThan = '>大于(_B)';
      LANGchsSearch_SmallerThan = '<小于(_S)';
      LANGchsSearch_ModifiedBetweenRadioButton = '修改于(_M)';
      LANGchsSearch_NotModifiedAfterRadioButton = '没有修改之后(_N)';
      LANGchsSearch_ModifiedLastRadioButton = '最后修改于(_I)';
      LANGchsSearch_ModifiedNotLastRadionButton =  '没有修改于(_T)';
      LANGchsSearch_ModifiedBetweenEntry1 = '"请使用这个日期格式:" c';
      LANGchsSearch_ViewButtonCaption = '查看文件(_V)';
      LANGchsSearch_NewSearchButtonCaption = '新搜索(_N)';
      LANGchsSearch_GoToFileButtonCaption = '转到文件(_G)';
      LANGchsSearch_FeedToListboxButtonCaption = '填入文件列表(_L)';
      LANGchsSearch_StatusSC = '状态:';
      LANGchsSearch_Ready = '就绪.';
      LANGchsSearch_PreparingToSearch = '正在准备搜索.';
      LANGchsSearch_SearchInProgress = '正在搜索:';
      LANGchsSearch_UserCancelled = '用户取消.';
      LANGchsSearch_SearchFinished = '搜索完成';
      LANGchsSearch_FilesFound = '已找到 %d 文件';
      LANGchsSearch_And = '和';

  (***************  STRINGS ADDED TO v0.5.82  **********************************************************************************)
      LANGchsCloseOpenConnection = '你正在尝试在当前活动连中打开新连接. 如果继续, 当前的活动连接将会关闭并被新连接代替.'#10#10'是否继续?';
      LANGchsDuplicateTabWarning = '你正在尝试在新标签中打开远程目录. 但是引擎并不支持. 新标签将会转到本地文件系统.';
      LANGchsDontShowAgain = '不要再显示此消息(_D)';
      LANGchsSwitchOtherPanelWarning = '你正在尝试在目标面板中打开远程目录. 但是引擎并不支持. 目标目录还会被切换.';
      LANGchsOpenConnectionsWarning = '当前有一些活动的连接在面板中打开. 退出程序时这些连接将会被关闭.'#10#10'是否继续退出?';
      LANGchsmiDisconnect_Caption = '断开(_D)';
      LANGchsDisconnectButton_Tooltip = '断开活动的连接';
      LANGchsLeaveArchiveButton_Tooltip = '关闭当前文档';
      LANGchsOpenTerminalButton_Tooltip = '在当前目录打开一个新的终端窗口';
      LANGchsOpenTerminalButton_Caption = '打开终端(_R)';
      LANGchsShowTextUIDsCheckBox_Caption = '显示文本 _UIDs';
      LANGchsShowTextUIDsCheckBox_Tooltip = '以文本格式显示用户/组信息(UID/GID)';

  (***************  STRINGS ADDED TO v0.5.100  **********************************************************************************)
      LANGchsmiNewTab_Caption = '新目录标签(_T)';
      LANGchsFilePopupMenu_Properties = '属性(_P)';
      LANGchsCommandEntry_Tooltip = '使用 %s 作为文件/目录的占位符';
      LANGchsmiFiles_Caption = '仅文件';

  (***************  STRINGS ADDED TO v0.6.31  **********************************************************************************)
      LANGchsPasswordButton_Tooltip = '文档必需使用密码.'#10'点击设置';
      LANGchsHandleRunFromArchive_Bytes = '字节';
      LANGchsHandleRunFromArchive_FileTypeDesc_Unknown = '(未知)';
      LANGchsHandleRunFromArchive_NotAssociated = '(未关联)';
      LANGchsHandleRunFromArchive_SelfExecutable = '(自执行)';
      LANGchsHandleRunFromArchive_CouldntCreateTemporaryDirectory = '不能创建临时目录 "%s": %s.'#10#10'请检查临时目录设置并重试.';
      LANGchsFRunFromVFS_Caption = '打包文件属性';
      LANGchsFRunFromVFS_TitleLabel = '文件属性';
      LANGchsFRunFromVFS_FileNameLabel = '文件名:';
      LANGchsFRunFromVFS_FileTypeLabel = '文件类型:';
      LANGchsFRunFromVFS_SizeLabel = '大小:';
      LANGchsFRunFromVFS_PackedSizeLabel = '压缩后大小:';
      LANGchsFRunFromVFS_DateLabel = '修改日期:';
      LANGchsFRunFromVFS_InfoLabel = '不支持直接从文档中打开文件. 点击文件下面的按钮(所有文件独立)将会解压到临时目录. 临时文件将会在关闭 Tux Commander 时删除.';
      LANGchsFRunFromVFS_OpensWithLabel = '打开为:';
      LANGchsFRunFromVFS_ExecuteButton = '解压并打开(_X)';
      LANGchsFRunFromVFS_ExecuteAllButton = '解压所有并打开(_A)';
      LANGchsFSetPassword_Caption = '设置密码';
      LANGchsFSetPassword_Label1_Caption = '必需输入密码';
      LANGchsFSetPassword_Label2_Caption = '该文档已经加密, 你必需输入密码才能解压文档内的文件';
      LANGchsFSetPassword_ShowPasswordCheckButton = '显示密码(_M)';

  (***************  STRINGS ADDED TO v0.6.48  **********************************************************************************)
      LANGchsCopyFileNamesToClipboard = '复制文件名到剪贴板(_C)';
      LANGchsCopyFullPathNamesToClipboard = '复制文件全路径到剪贴板(_F)';
      LANGchsCopyPathToClipboard = '复制路径到剪贴板(_C)';
      LANGchsPreferences_DateFormatLabel_Caption = '日期格式(_F):';
      LANGchsPreferences_System = '系统';
      LANGchsPreferences_Custom = '自定义...';
      LANGchsPreferences_CustomDateFormatEntry_Tooltip = '输入自定义日期格式.'#10'格式语法请参考 "man strftime" 命令.';
      LANGchsPreferences_TimeFormatLabel_Caption = '时间格式(_T):';
      LANGchsPreferences_CustomTimeFormatEntry_Tooltip = '输入自定义时间格式.'#10'格式语法请参考 "man strftime" 命令.';
      LANGchsPreferences_DateTimeFormatLabel_Caption = '日期/时间排序(_O):';
      LANGchsPreferences_QuickRenameSkipExtCheckBox = '快速重命名时仅选择文件名';
      LANGchsPreferences_QuickRenameSkipExtCheckBox_Tooltip = '快速重命名时不选择扩展名';
      LANGchsPreferences_SortDirectoriesLikeFilesCheckBox = '目录排在文件列表上面(_E)';
      LANGchsPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip = '选中后目录永远排在文件列表上面.'#10'未选: 目录总是按目录名排序.';
      LANGchsPreferences_QuickSearchLabel_Caption = '快速搜索按键(_K):';
      LANGchsPreferences_QuickSearchOptionMenu_Tooltip = 'Ctrl+S/Alt+S 和 "/" 按钮永久可用, 并不受此设置影响.';
      LANGchsPreferences_QuickSearch_Option1 = '仅 Ctrl+S/Alt+S 和 "/"';
      LANGchsPreferences_QuickSearch_Option2 = 'Ctrl + Alt + 字母';
      LANGchsPreferences_QuickSearch_Option3 = 'Alt + 字母';
      LANGchsPreferences_QuickSearch_Option4 = '仅字母';
      LANGchsPreferences_TempPathLabel_Caption = '临时文件';
      LANGchsPreferences_VFSTempPathLabel_Caption = '_VFS 临时文件:';
      LANGchsPreferences_VFSTempPathEntry_Tooltip = 'VFS 子系统使用的临时文件路径, 例如. 当直接从压缩文档中打开文件时. 所有临时文件将在退出时删除.';

  (***************  STRINGS ADDED TO v0.6.67  **********************************************************************************)
      LANGchsPreferences_RightClickSelectCheckBox = 'Right mouse button selection mode';
      LANGchsPreferences_RightClickSelectCheckBox_Tooltip = 'Use right mouse button to select, like mc.';
      LANGchsGtkMountOperation_ConnectAnonymously = 'Connect _anonymously';
      LANGchsGtkMountOperation_ConnectAsUser = 'Connect as u_ser:';
      LANGchsGtkMountOperation_Username = '_Username:';
      LANGchsGtkMountOperation_Domain = '_Domain:';
      LANGchsGtkMountOperation_Password = '_Password:';
      LANGchsGtkMountOperation_DoNotSavePassword = 'Do not save password';
      LANGchsGtkMountOperation_ForgetPasswordImmediately = 'Forget password _immediately';
      LANGchsGtkMountOperation_RememberPasswordUntilYouLogout = 'Remember password until you _logout';
      LANGchsGtkMountOperation_SavePasswordInConnectionManager = '_Save password in Connection Manager';
      LANGchsGtkMountOperation_RememberForever = 'Remember _forever';
      LANGchsFSymlink_RelativePath = '_Relative path';
      LANGchsFConnectionManager_DuplicateButton_Caption = 'D_uplicate...';
      LANGchsFConnectionManager_DuplicateButton_Tooltip = 'Duplicate selected connection';
      LANGchsFConnectionManager_DoNotSavePasswordsCheckBox_Label = '_Do not store passwords internally (but still use gnome-keyring)';
      LANGchsFConnectionManager_DoNotSavePasswordsCheckBox_Tooltip = 'By checking this option on, Tux Commander will never save passwords into its connection list. Due to the GVFS nature, gnome-keyring will still be used to retrieve stored passwords from your desktop session.';
      LANGchsFConnectionManager_DoNotSynchronizeKeyringCheckBox_Label = 'Do not synchronize passwords to gnome-_keyring';
      LANGchsFConnectionManager_DoNotSynchronizeKeyringCheckBox_Tooltip = 'Don''t tell gnome-keyring to save any passwords.';
      LANGchsFConnectionManager_DuplicateMenuItem_Caption = 'D_uplicate...';
      LANGchsFQuickConnect_Caption = 'Quick connect';
      LANGchsFQuickConnect_TitleLabel_Caption = 'Quick connect';
      LANGchsFQuickConnect_ConnectToURILabel_Caption = 'C_onnect to URI:';
      LANGchsLinkToS = 'Link to %s';
      LANGchsOpenDirectoryInBackgroundTab = 'Open directory in _background tab';
      LANGchsTheActiveConnectionHasNotBeenSaved = 'The active connection has not been saved. Do you want to save it to Connection Manager?'#10#10'%s';
      LANGchsTheArchiveIsEncryptedAndRequiresPassword = 'The archive is encrypted and requires password';


(********************************************************************************************************************************)
procedure SetTranslation;
begin
  LANGF2Button_Caption := LANGchsF2Button_Caption;
  LANGF3Button_Caption := LANGchsF3Button_Caption;
  LANGF4Button_Caption := LANGchsF4Button_Caption;
  LANGF5Button_Caption := LANGchsF5Button_Caption;
  LANGF6Button_Caption := LANGchsF6Button_Caption;
  LANGF7Button_Caption := LANGchsF7Button_Caption;
  LANGF8Button_Caption := LANGchsF8Button_Caption;

  LANGmnuFile_Caption := LANGchsmnuFile_Caption;
  LANGmnuMark_Caption := LANGchsmnuMark_Caption;
  LANGmnuCommands_Caption := LANGchsmnuCommands_Caption;
  LANGmnuHelp_Caption := LANGchsmnuHelp_Caption;
  LANGmiExit_Caption := LANGchsmiExit_Caption;
  LANGmiSelectGroup_Caption := LANGchsmiSelectGroup_Caption;
  LANGmiUnselectGroup_Caption := LANGchsmiUnselectGroup_Caption;
  LANGmiSelectAll_Caption := LANGchsmiSelectAll_Caption;
  LANGmiUnselectAll_Caption := LANGchsmiUnselectAll_Caption;
  LANGmiInvertSelection_Caption := LANGchsmiInvertSelection_Caption;
  LANGmiRefresh_Caption := LANGchsmiRefresh_Caption;
  LANGmiAbout_Caption := LANGchsmiAbout_Caption;

  LANGColumn1_Caption := LANGchsColumn1_Caption;
  LANGColumn2_Caption := LANGchsColumn2_Caption;
  LANGColumn3_Caption := LANGchsColumn3_Caption;
  LANGColumn4_Caption := LANGchsColumn4_Caption;
  LANGColumn5_Caption := LANGchsColumn5_Caption;

  LANGExpandSelection := LANGchsExpandSelection;
  LANGShrinkSelection := LANGchsShrinkSelection;
  LANGNoMatchesFound := LANGchsNoMatchesFound;
  LANGNoFilesSelected := LANGchsNoFilesSelected;
  LANGSelectedFilesDirectories := LANGchsSelectedFilesDirectories;
  LANGDirectoryS := LANGchsDirectoryS;
  LANGFileS := LANGchsFileS;
  LANGDoYouReallyWantToDeleteTheS := LANGchsDoYouReallyWantToDeleteTheS;
  LANGDoYouReallyWantToDeleteTheSS := LANGchsDoYouReallyWantToDeleteTheSS;
  LANGCopyFiles := LANGchsCopyFiles;
  LANGMoveRenameFiles := LANGchsMoveRenameFiles;
  LANGCopyDFileDirectoriesTo := LANGchsCopyDFileDirectoriesTo;
  LANGMoveRenameDFileDirectoriesTo := LANGchsMoveRenameDFileDirectoriesTo;
  LANGCopySC := LANGchsCopySC;
  LANGMoveRenameSC := LANGchsMoveRenameSC;

  LANGQuickFind := LANGchsQuickFind;

  LANGAboutString := LANGchsAboutString;
  LANGAboutStringGnome := LANGchsAboutStringGnome;
  LANGDiskStatFmt := LANGchsDiskStatFmt;
  LANGDiskStatVolNameFmt := LANGchsDiskStatVolNameFmt;
  LANGStatusLineFmt := LANGchsStatusLineFmt;
  LANGPanelStrings[False] := LANGchsPanelStrings[False];
  LANGPanelStrings[True] := LANGchsPanelStrings[True];
  LANGDIR := LANGchsDIR;
  LANGErrorGettingListingForSPanel := LANGchsErrorGettingListingForSPanel;
  LANGErrorGettingListingForSPanelNoPath := LANGchsErrorGettingListingForSPanelNoPath;
  LANGErrorCreatingNewDirectorySInSPanel := LANGchsErrorCreatingNewDirectorySInSPanel;
  LANGErrorCreatingNewDirectorySInSPanelNoPath := LANGchsErrorCreatingNewDirectorySInSPanelNoPath;
  LANGTheFileDirectory := LANGchsTheFileDirectory;
  LANGCouldNotBeDeleted := LANGchsCouldNotBeDeleted;
  LANGCouldNotBeDeletedS := LANGchsCouldNotBeDeletedS;
  LANGUserCancelled := LANGchsUserCancelled;
  LANGTheDirectorySIsNotEmpty := LANGchsTheDirectorySIsNotEmpty;
  LANGCannotCopyFile := LANGchsCannotCopyFile;
  LANGCopyError := LANGchsCopyError;
  LANGMoveError := LANGchsMoveError;
  LANGOverwriteS := LANGchsOverwriteS;
  LANGWithFileS := LANGchsWithFileS;
  LANGOvewriteSBytesS := LANGchsOvewriteSBytesS;
  LANGTheFile := LANGchsTheFile;
  LANGCopy := LANGchsCopy;
  LANGMove := LANGchsMove;
  LANGTheDirectory := LANGchsTheDirectory;
  LANGTheSymbolicLink := LANGchsTheSymbolicLink;
  LANGCannotMoveFile := LANGchsCannotMoveFile;
  LANGCouldNotBeCreated := LANGchsCouldNotBeCreated;
  LANGCouldNotBeCreatedS := LANGchsCouldNotBeCreatedS;
  LANGFromS := LANGchsFromS;
  LANGToS := LANGchsToS;
  LANGCannotCopyFileToItself := LANGchsCannotCopyFileToItself;
  LANGMemoryAllocationFailed := LANGchsMemoryAllocationFailed;
  LANGCannotOpenSourceFile := LANGchsCannotOpenSourceFile;
  LANGCannotOpenDestinationFile := LANGchsCannotOpenDestinationFile;
  LANGCannotCloseDestinationFile := LANGchsCannotCloseDestinationFile;
  LANGCannotCloseSourceFile := LANGchsCannotCloseSourceFile;
  LANGCannotReadFromSourceFile := LANGchsCannotReadFromSourceFile;
  LANGCannotWriteToDestinationFile := LANGchsCannotWriteToDestinationFile;

  LANGUnknownException := LANGchsUnknownException;
  LANGNoAccess := LANGchsNoAccess;
  LANGUnknownError := LANGchsUnknownError;

  LANGCreateANewDirectory := LANGchsCreateANewDirectory;
  LANGEnterDirectoryName := LANGchsEnterDirectoryName;

  LANGOverwriteQuestion := LANGchsOverwriteQuestion;
  LANGOverwriteButton_Caption := LANGchsOverwriteButton_Caption;
  LANGOverwriteAllButton_Caption := LANGchsOverwriteAllButton_Caption;
  LANGSkipButton_Caption := LANGchsSkipButton_Caption;
  LANGOverwriteAllOlderButton_Caption := LANGchsOverwriteAllOlderButton_Caption;
  LANGSkipAllButton_Caption := LANGchsSkipAllButton_Caption;
  LANGRenameButton_Caption := LANGchsRenameButton_Caption;
  LANGAppendButton_Caption := LANGchsAppendButton_Caption;
  LANGRename := LANGchsRename;
  LANGRenameFile := LANGchsRenameFile;
  LANGIgnoreButton_Caption := LANGchsIgnoreButton_Caption;

  LANGProgress := LANGchsProgress;
  LANGCancel := LANGchsCancel;
  LANGDelete := LANGchsDelete;

  LANGSpecifyFileType := LANGchsSpecifyFileType;

  LANGRemoveDirectory := LANGchsRemoveDirectory;
  LANGDoYouWantToDeleteItWithAllItsFilesAndSubdirectories := LANGchsDoYouWantToDeleteItWithAllItsFilesAndSubdirectories;
  LANGRetry := LANGchsRetry;
  LANGDeleteButton_Caption := LANGchsDeleteButton_Caption;
  LANGAll := LANGchsAll;

  LANGCopyFilesSC := LANGchsCopyFilesSC;
  LANGAppendQuestion := LANGchsAppendQuestion;
  LANGPreparingList := LANGchsPreparingList;

  LANGYouMustSelectAValidFile := LANGchsYouMustSelectAValidFile;
  LANGmiVerifyChecksums := LANGchsmiVerifyChecksums;
  LANGVerifyChecksumsCaption := LANGchsVerifyChecksumsCaption;
  LANGCheckButtonCaptionCheck := LANGchsCheckButtonCaptionCheck;
  LANGCheckButtonCaptionStop := LANGchsCheckButtonCaptionStop;
  LANGFileListTooltip := LANGchsFileListTooltip;
  LANGFilenameColumnCaption := LANGchsFilenameColumnCaption;
  LANGTheFileSYouAreTryingToOpenIsQuiteBig := LANGchsTheFileSYouAreTryingToOpenIsQuiteBig;
  LANGAnErrorOccuredWhileInitializingMemoryBlock := LANGchsAnErrorOccuredWhileInitializingMemoryBlock;
  LANGAnErrorOccuredWhileOpeningFileSS := LANGchsAnErrorOccuredWhileOpeningFileSS;
  LANGAnErrorOccuredWhileReadingFileSS := LANGchsAnErrorOccuredWhileReadingFileSS;
  LANGChecksumNotChecked := LANGchsChecksumNotChecked;
  LANGChecksumChecking := LANGchsChecksumChecking;
  LANGChecksumInterrupted := LANGchsChecksumInterrupted;
  LANGChecksumDOK := LANGchsChecksumDOK;

  LANGmiCreateChecksumsCaption := LANGchsmiCreateChecksumsCaption;
  LANGYouMustSelectAtLeastOneFileToCalculateChecksum := LANGchsYouMustSelectAtLeastOneFileToCalculateChecksum;
  LANGCreateChecksumsCaption := LANGchsCreateChecksumsCaption;
  LANGCCHKSUMPage1Text := LANGchsCCHKSUMPage1Text;
  LANGCCHKSUMPage4Text := LANGchsCCHKSUMPage4Text;
  LANGCCHKSUMPage6Text := LANGchsCCHKSUMPage6Text;
  LANGCCHKSUMPage7Text := LANGchsCCHKSUMPage7Text;
  LANGCCHKSUMPage1Title := LANGchsCCHKSUMPage1Title;
  LANGCCHKSUMPage2Title := LANGchsCCHKSUMPage2Title;
  LANGCCHKSUMPage3Title := LANGchsCCHKSUMPage3Title;
  LANGCCHKSUMPage4Title := LANGchsCCHKSUMPage4Title;
  LANGCCHKSUMPage5Title := LANGchsCCHKSUMPage5Title;
  LANGCCHKSUMPage6Title := LANGchsCCHKSUMPage6Title;
  LANGCCHKSUMPage7Title := LANGchsCCHKSUMPage7Title;
  LANGCCHKSUMSFVFile := LANGchsCCHKSUMSFVFile;
  LANGCCHKSUMMD5sumFile := LANGchsCCHKSUMMD5sumFile;
  LANGCCHKSUMFileName := LANGchsCCHKSUMFileName;
  LANGCCHKSUMCreateSeparateChecksumFiles := LANGchsCCHKSUMCreateSeparateChecksumFiles;
  LANGCCHKSUMNowProcessingFileS := LANGchsCCHKSUMNowProcessingFileS;
  LANGCCHKSUMFinishCaption := LANGchsCCHKSUMFinishCaption;
  LANGCCHKSUMAreYouSureYouWantToAbortTheProcessing := LANGchsCCHKSUMAreYouSureYouWantToAbortTheProcessing;
  LANGCCHKSUMAnErrorOccuredWhileOpeningFileSS := LANGchsCCHKSUMAnErrorOccuredWhileOpeningFileSS;
  LANGCCHKSUMAnErrorOccuredWhileReadingFileSS := LANGchsCCHKSUMAnErrorOccuredWhileReadingFileSS;
  LANGCCHKSUMAnErrorOccuredWhileWritingFileSS := LANGchsCCHKSUMAnErrorOccuredWhileWritingFileSS;

  LANGAnErrorOccuredWhileWritingFileSS := LANGchsAnErrorOccuredWhileWritingFileSS;
  LANGTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt := LANGchsTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt;
  LANGTheTargetFileSCannotBeRemovedS := LANGchsTheTargetFileSCannotBeRemovedS;
  LANGMergeCaption := LANGchsMergeCaption;
  LANGPleaseInsertNextDiskOrGiveDifferentLocation := LANGchsPleaseInsertNextDiskOrGiveDifferentLocation;
  LANGMergeOfSSucceeded := LANGchsMergeOfSSucceeded;
  LANGWarningCreatedFileFailsCRCCheck := LANGchsWarningCreatedFileFailsCRCCheck;
  LANGMergeOfSSucceeded_NoCRCFileAvailable := LANGchsMergeOfSSucceeded_NoCRCFileAvailable;
  LANGMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory := LANGchsMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory;
  LANGMergeSC := LANGchsMergeSC;
  LANGmiSplitFileCaption := LANGchsmiSplitFileCaption;
  LANGmiMergeFilesCaption := LANGchsmiMergeFilesCaption;

  LANGSplitTheFileSToDirectory := LANGchsSplitTheFileSToDirectory;
  LANGSplitSC := LANGchsSplitSC;
  LANGSplitFile := LANGchsSplitFile;
  LANGBytesPerFile := LANGchsBytesPerFile;
  LANGAutomatic := LANGchsAutomatic;
  LANGDeleteFilesOnTargetDisk := LANGchsDeleteFilesOnTargetDisk;
  LANGSplitCaption := LANGchsSplitCaption;
  LANGCannotOpenFileS := LANGchsCannotOpenFileS;
  LANGCannotSplitTheFileToMoreThan999Parts := LANGchsCannotSplitTheFileToMoreThan999Parts;
  LANGThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem := LANGchsThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem;
  LANGThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem := LANGchsThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem;
  LANGAnErrorOccuredWhileOperationS := LANGchsAnErrorOccuredWhileOperationS;
  LANGSplitOfSSucceeded := LANGchsSplitOfSSucceeded;
  LANGSplitOfSFailed := LANGchsSplitOfSFailed;

  LANGmnuShow_Caption := LANGchsmnuShow_Caption;
  LANGmiShowDotFiles_Caption := LANGchsmiShowDotFiles_Caption;
  LANGTheFileYouAreTryingToOpenIsQuiteBig := LANGchsTheFileYouAreTryingToOpenIsQuiteBig;
  LANGCannotExecuteSPleaseCheckTheConfiguration := LANGchsCannotExecuteSPleaseCheckTheConfiguration;
  LANGEdit := LANGchsEdit;
  LANGEnterFilenameToEdit := LANGchsEnterFilenameToEdit;

  LANGmnuSettings_Caption := LANGchsmnuSettings_Caption;
  LANGmiFileTypes_Caption := LANGchsmiFileTypes_Caption;
  LANGThereIsNoApplicationAssociatedWithS := LANGchsThereIsNoApplicationAssociatedWithS;
  LANGErrorExecutingCommand := LANGchsErrorExecutingCommand;
  LANGEditFileTypesCaption := LANGchsEditFileTypesCaption;
  LANGTitleLabel_Caption := LANGchsTitleLabel_Caption;
  LANGExtensionsColumn := LANGchsExtensionsColumn;
  LANGDescriptionColumn := LANGchsDescriptionColumn;
  LANGFileTypesList := LANGchsFileTypesList;
  LANGActionName := LANGchsActionName;
  LANGCommand := LANGchsCommand;
  LANGSetDefaultActionButton_Caption := LANGchsSetDefaultActionButton_Caption;
  LANGRunInTerminalCheckBox_Caption := LANGchsRunInTerminalCheckBox_Caption;
  LANGAutodetectCheckBox_Caption := LANGchsAutodetectCheckBox_Caption;
  LANGBrowseButton_Caption := LANGchsBrowseButton_Caption;
  LANGCommandLabel_Caption := LANGchsCommandLabel_Caption;
  LANGDescriptionLabel_Caption := LANGchsDescriptionLabel_Caption;
  LANGFNameExtLabel_Caption := LANGchsFNameExtLabel_Caption;
  LANGNotebookPageExtensions := LANGchsNotebookPageExtensions;
  LANGNotebookPageActions := LANGchsNotebookPageActions;
  LANGDefault := LANGchsDefault;
  LANGCannotSaveFileTypeAssociationsBecauseOtherProcess := LANGchsCannotSaveFileTypeAssociationsBecauseOtherProcess;

  LANGDefaultColor := LANGchsDefaultColor;
  LANGIcon := LANGchsIcon;
  LANGBrowseForIcon := LANGchsBrowseForIcon;
  LANGSelectFileTypeColor := LANGchsSelectFileTypeColor;
  LANGColor := LANGchsColor;

  LANGmiChangePermissions_Caption := LANGchsmiChangePermissions_Caption;
  LANGmiChangeOwner_Caption := LANGchsmiChangeOwner_Caption;
  LANGmiCreateSymlink_Caption := LANGchsmiCreateSymlink_Caption;
  LANGmiEditSymlink_Caption := LANGchsmiEditSymlink_Caption;
  LANGChmodProgress := LANGchsChmodProgress;
  LANGChownProgress := LANGchsChownProgress;
  LANGYouMustSelectAValidSymbolicLink := LANGchsYouMustSelectAValidSymbolicLink;
  LANGPopupRunS := LANGchsPopupRunS;
  LANGPopupOpenS := LANGchsPopupOpenS;
  LANGPopupGoUp := LANGchsPopupGoUp;
  LANGPopupOpenWithS := LANGchsPopupOpenWithS;
  LANGPopupDefault := LANGchsPopupDefault;
  LANGPopupOpenWith := LANGchsPopupOpenWith;
  LANGPopupViewFile := LANGchsPopupViewFile;
  LANGPopupEditFile := LANGchsPopupEditFile;
  LANGPopupMakeSymlink := LANGchsPopupMakeSymlink;
  LANGPopupRename := LANGchsPopupRename;
  LANGPopupDelete := LANGchsPopupDelete;
  LANGDialogChangePermissions := LANGchsDialogChangePermissions;
  LANGCouldNotBeChmoddedS := LANGchsCouldNotBeChmoddedS;
  LANGDialogChangeOwner := LANGchsDialogChangeOwner;
  LANGCouldNotBeChownedS := LANGchsCouldNotBeChownedS;
  LANGDialogMakeSymlink := LANGchsDialogMakeSymlink;
  LANGDialogEditSymlink := LANGchsDialogEditSymlink;
  LANGFEditSymlink_Caption := LANGchsFEditSymlink_Caption;
  LANGFEditSymlink_SymbolicLinkFilename := LANGchsFEditSymlink_SymbolicLinkFilename;
  LANGFEditSymlink_SymbolicLinkPointsTo := LANGchsFEditSymlink_SymbolicLinkPointsTo;

  LANGFChmod_Caption := LANGchsFChmod_Caption;
  LANGFChmod_PermissionFrame := LANGchsFChmod_PermissionFrame;
  LANGFChmod_FileFrame := LANGchsFChmod_FileFrame;
  LANGFChmod_ApplyRecursivelyFor := LANGchsFChmod_ApplyRecursivelyFor;
  LANGFChmod_miAllFiles := LANGchsFChmod_miAllFiles;
  LANGFChmod_miDirectories := LANGchsFChmod_miDirectories;
  LANGFChmod_OctalLabel := LANGchsFChmod_OctalLabel;
  LANGFChmod_SUID := LANGchsFChmod_SUID;
  LANGFChmod_SGID := LANGchsFChmod_SGID;
  LANGFChmod_Sticky := LANGchsFChmod_Sticky;
  LANGFChmod_RUSR := LANGchsFChmod_RUSR;
  LANGFChmod_WUSR := LANGchsFChmod_WUSR;
  LANGFChmod_XUSR := LANGchsFChmod_XUSR;
  LANGFChmod_RGRP := LANGchsFChmod_RGRP;
  LANGFChmod_WGRP := LANGchsFChmod_WGRP;
  LANGFChmod_XGRP := LANGchsFChmod_XGRP;
  LANGFChmod_ROTH := LANGchsFChmod_ROTH;
  LANGFChmod_WOTH := LANGchsFChmod_WOTH;
  LANGFChmod_XOTH := LANGchsFChmod_XOTH;
  LANGFChmod_TextLabel := LANGchsFChmod_TextLabel;
  LANGFChmod_FileLabel := LANGchsFChmod_FileLabel;
  LANGFChown_Caption := LANGchsFChown_Caption;
  LANGFChown_OwnerFrame := LANGchsFChown_OwnerFrame;
  LANGFChown_GroupFrame := LANGchsFChown_GroupFrame;
  LANGFChown_FileFrame := LANGchsFChown_FileFrame;
  LANGFChown_ApplyRecursively := LANGchsFChown_ApplyRecursively;

  LANGFSymlink_Caption := LANGchsFSymlink_Caption;
  LANGFSymlink_ExistingFilename := LANGchsFSymlink_ExistingFilename;
  LANGFSymlink_SymlinkFilename := LANGchsFSymlink_SymlinkFilename;

  LANGmnuBookmarks_Caption := LANGchsmnuBookmarks_Caption;
  LANGmiAddBookmark_Caption := LANGchsmiAddBookmark_Caption;
  LANGmiEditBookmarks_Caption := LANGchsmiEditBookmarks_Caption;
  LANGBookmarkPopupDelete_Caption := LANGchsBookmarkPopupDelete_Caption;
  LANGmiPreferences_Caption := LANGchsmiPreferences_Caption;
  LANGTheCurrentDirectoryAlreadyExistsInTheBookmarksList := LANGchsTheCurrentDirectoryAlreadyExistsInTheBookmarksList;
  LANGSomeOtherInstanceChanged := LANGchsSomeOtherInstanceChanged;

  LANGPreferences_Caption := LANGchsPreferences_Caption;
  LANGPreferences_TitleLabel_Caption := LANGchsPreferences_TitleLabel_Caption;
  LANGPreferences_GeneralPage := LANGchsPreferences_GeneralPage;
  LANGPreferences_FontsPage := LANGchsPreferences_FontsPage;
  LANGPreferences_ColorsPage := LANGchsPreferences_ColorsPage;
  LANGPreferences_RowHeight := LANGchsPreferences_RowHeight;
  LANGPreferences_NumHistoryItems := LANGchsPreferences_NumHistoryItems;
  LANGPreferences_Default := LANGchsPreferences_Default;
  LANGPreferences_ClearReadonlyAttribute := LANGchsPreferences_ClearReadonlyAttribute;
  LANGPreferences_DisableMouseRenaming := LANGchsPreferences_DisableMouseRenaming;
  LANGPreferences_ShowFiletypeIconsInList := LANGchsPreferences_ShowFiletypeIconsInList;
  LANGPreferences_ExternalAppsLabel := LANGchsPreferences_ExternalAppsLabel;
  LANGPreferences_Viewer := LANGchsPreferences_Viewer;
  LANGPreferences_Editor := LANGchsPreferences_Editor;
  LANGPreferences_Terminal := LANGchsPreferences_Terminal;
  LANGPreferences_ListFont := LANGchsPreferences_ListFont;
  LANGPreferences_Change := LANGchsPreferences_Change;
  LANGPreferences_UseDefaultFont := LANGchsPreferences_UseDefaultFont;
  LANGPreferences_Foreground := LANGchsPreferences_Foreground;
  LANGPreferences_Background := LANGchsPreferences_Background;
  LANGPreferences_NormalItem := LANGchsPreferences_NormalItem;
  LANGPreferences_SetToDefaultToUseGTKThemeColors := LANGchsPreferences_SetToDefaultToUseGTKThemeColors;
  LANGPreferences_Cursor := LANGchsPreferences_Cursor;
  LANGPreferences_InactiveItem := LANGchsPreferences_InactiveItem;
  LANGPreferences_SelectedItem := LANGchsPreferences_SelectedItem;
  LANGPreferences_LinkItem := LANGchsPreferences_LinkItem;
  LANGPreferences_LinkItemHint := LANGchsPreferences_LinkItemHint;
  LANGPreferences_DotFileItem := LANGchsPreferences_DotFileItem;
  LANGPreferences_DotFileItemHint := LANGchsPreferences_DotFileItemHint;
  LANGPreferences_BrowseForApplication := LANGchsPreferences_BrowseForApplication;
  LANGPreferences_DefaultS := LANGchsPreferences_DefaultS;
  LANGPreferences_SelectFont := LANGchsPreferences_SelectFont;

  LANGBookmarkButton_Tooltip := LANGchsBookmarkButton_Tooltip;
  LANGUpButton_Tooltip := LANGchsUpButton_Tooltip;
  LANGRootButton_Tooltip := LANGchsRootButton_Tooltip;
  LANGHomeButton_Tooltip := LANGchsHomeButton_Tooltip;
  LANGLeftEqualButton_Tooltip := LANGchsLeftEqualButton_Tooltip;
  LANGRightEqualButton_Tooltip := LANGchsRightEqualButton_Tooltip;
  LANGmiShowDirectorySizes_Caption := LANGchsmiShowDirectorySizes_Caption;
  LANGmiTargetSource_Caption := LANGchsmiTargetSource_Caption;
  LANGFileTypeDirectory := LANGchsFileTypeDirectory;
  LANGFileTypeFile := LANGchsFileTypeFile;
  LANGFileTypeMetafile := LANGchsFileTypeMetafile;
  LANGPreferencesPanelsPage := LANGchsPreferencesPanelsPage;
  LANGPreferencesApplicationsPage := LANGchsPreferencesApplicationsPage;
  LANGPreferencesExperimentalPage := LANGchsPreferencesExperimentalPage;
  LANGPreferencesSelectAllDirectoriesCheckBox_Caption := LANGchsPreferencesSelectAllDirectoriesCheckBox_Caption;
  LANGPreferencesNewStyleAltOCheckBox_Caption := LANGchsPreferencesNewStyleAltOCheckBox_Caption;
  LANGPreferencesNewStyleAltOCheckBox_Tooltip := LANGchsPreferencesNewStyleAltOCheckBox_Tooltip;
  LANGPreferencesShowFuncButtonsCheckBox_Caption := LANGchsPreferencesShowFuncButtonsCheckBox_Caption;
  LANGPreferencesSizeFormatLabel_Caption := LANGchsPreferencesSizeFormatLabel_Caption;
  LANGPreferencesmiSizeFormat1 := LANGchsPreferencesmiSizeFormat1;
  LANGPreferencesmiSizeFormat6 := LANGchsPreferencesmiSizeFormat6;
  LANGPreferencesAutodetectXApp := LANGchsPreferencesAutodetectXApp;
  LANGPreferencesAlwaysRunInTerminal := LANGchsPreferencesAlwaysRunInTerminal;
  LANGPreferencesNeverRunInTerminal := LANGchsPreferencesNeverRunInTerminal;
  LANGPreferencesCmdLineBehaviourLabel_Caption := LANGchsPreferencesCmdLineBehaviourLabel_Caption;
  LANGPreferencesFeatures := LANGchsPreferencesFeatures;
  LANGPreferencesDisableMouseRename_Tooltip := LANGchsPreferencesDisableMouseRename_Tooltip;
  LANGPreferencesDisableFileTipsCheckBox_Caption := LANGchsPreferencesDisableFileTipsCheckBox_Caption;
  LANGPreferencesDisableFileTipsCheckBox_Tooltip := LANGchsPreferencesDisableFileTipsCheckBox_Tooltip;
  LANGPreferencesShow := LANGchsPreferencesShow;
  LANGPreferencesDirsInBoldCheckBox_Caption := LANGchsPreferencesDirsInBoldCheckBox_Caption;
  LANGPreferencesDisableDirectoryBracketsCheckBox_Caption := LANGchsPreferencesDisableDirectoryBracketsCheckBox_Caption;
  LANGPreferencesOctalPermissionsCheckBox_Caption := LANGchsPreferencesOctalPermissionsCheckBox_Caption;
  LANGPreferencesOctalPermissionsCheckBox_Tooltip := LANGchsPreferencesOctalPermissionsCheckBox_Tooltip;
  LANGPreferencesMovement := LANGchsPreferencesMovement;
  LANGPreferencesLynxLikeMotionCheckBox_Caption := LANGchsPreferencesLynxLikeMotionCheckBox_Caption;
  LANGPreferencesInsertMovesDownCheckBox_Caption := LANGchsPreferencesInsertMovesDownCheckBox_Caption;
  LANGPreferencesSpaceMovesDownCheckBox_Caption := LANGchsPreferencesSpaceMovesDownCheckBox_Caption;
  LANGPreferencesViewer := LANGchsPreferencesViewer;
  LANGPreferencesCommandSC := LANGchsPreferencesCommandSC;
  LANGPreferencesUseInternalViewer := LANGchsPreferencesUseInternalViewer;
  LANGPreferencesEditor := LANGchsPreferencesEditor;
  LANGPreferencesTerminal := LANGchsPreferencesTerminal;
  LANGPreferencesExperimentalFeatures := LANGchsPreferencesExperimentalFeatures;
  LANGPreferencesExperimentalWarningLabel_Caption := LANGchsPreferencesExperimentalWarningLabel_Caption;
  LANGPreferencesFocusRefreshCheckBox_Caption := LANGchsPreferencesFocusRefreshCheckBox_Caption;
  LANGPreferencesFocusRefreshCheckBox_Tooltip := LANGchsPreferencesFocusRefreshCheckBox_Tooltip;
  LANGPreferencesWMCompatModeCheckBox_Caption := LANGchsPreferencesWMCompatModeCheckBox_Caption;
  LANGPreferencesWMCompatModeCheckBox_Tooltip := LANGchsPreferencesWMCompatModeCheckBox_Tooltip;
  LANGPreferencesCompatUseLibcSystemCheckBox_Caption := LANGchsPreferencesCompatUseLibcSystemCheckBox_Caption;
  LANGPreferencesCompatUseLibcSystemCheckBox_Tooltip := LANGchsPreferencesCompatUseLibcSystemCheckBox_Tooltip;

  LANGmiSearchCaption2 := LANGchsmiSearchCaption2;
  LANGmiNoMounterBarCaption := LANGchsmiNoMounterBarCaption;
  LANGmiShowOneMounterBarCaption := LANGchsmiShowOneMounterBarCaption;
  LANGmiShowTwoMounterBarCaption := LANGchsmiShowTwoMounterBarCaption;
  LANGmnuNetworkCaption := LANGchsmnuNetworkCaption;
  LANGmiConnectionsCaption := LANGchsmiConnectionsCaption;
  LANGmiOpenConnectionCaption := LANGchsmiOpenConnectionCaption;
  LANGmiQuickConnectCaption := LANGchsmiQuickConnectCaption;
  LANGmnuPluginsCaption := LANGchsmnuPluginsCaption;
  LANGmiTestPluginCaption := LANGchsmiTestPluginCaption;
  LANGmiMounterSettingsCaption := LANGchsmiMounterSettingsCaption;
  LANGmiColumnsCaption := LANGchsmiColumnsCaption;
  LANGmiSavePositionCaption := LANGchsmiSavePositionCaption;
  LANGmiMountCaption := LANGchsmiMountCaption;
  LANGmiUmountCaption := LANGchsmiUmountCaption;
  LANGmiEjectCaption := LANGchsmiEjectCaption;
  LANGmiDuplicateTabCaption := LANGchsmiDuplicateTabCaption;
  LANGmiCloseTabCaption := LANGchsmiCloseTabCaption;
  LANGmiCloseAllTabsCaption := LANGchsmiCloseAllTabsCaption;
  LANGCannotDetermineDestinationEngine := LANGchsCannotDetermineDestinationEngine;
  LANGCannotLoadFile := LANGchsCannotLoadFile;
  LANGMountPointDevice := LANGchsMountPointDevice;
  LANGMountSC := LANGchsMountSC;
  LANGNoPluginsFound := LANGchsNoPluginsFound;
  LANGPluginAbout := LANGchsPluginAbout;
  LANGCouldntOpenURI := LANGchsCouldntOpenURI;
  LANGPluginAboutInside := LANGchsPluginAboutInside;
  LANGAreYouSureCloseAllTabs := LANGchsAreYouSureCloseAllTabs;
  LANGCouldntOpenURIArchive := LANGchsCouldntOpenURIArchive;
  LANGThereIsNoModuleAvailable := LANGchsThereIsNoModuleAvailable;
  LANGIgnoreError := LANGchsIgnoreError;
  LANGErrorMount := LANGchsErrorMount;
  LANGErrorUmount := LANGchsErrorUmount;
  LANGErrorEject := LANGchsErrorEject;

  LANGMounterPrefs_Caption := LANGchsMounterPrefs_Caption;
  LANGMounterPrefs_TitleLabelCaption := LANGchsMounterPrefs_TitleLabelCaption;
  LANGMounterPrefs_ListViewFrameCaption := LANGchsMounterPrefs_ListViewFrameCaption;
  LANGMounterPrefs_MountName := LANGchsMounterPrefs_MountName;
  LANGMounterPrefs_MountPoint := LANGchsMounterPrefs_MountPoint;
  LANGMounterPrefs_Device := LANGchsMounterPrefs_Device;
  LANGMounterPrefs_MoveUpButtonTooltip := LANGchsMounterPrefs_MoveUpButtonTooltip;
  LANGMounterPrefs_MoveDownButtonTooltip := LANGchsMounterPrefs_MoveDownButtonTooltip;
  LANGMounterPrefs_UseFSTabDefaultsCheckBox := LANGchsMounterPrefs_UseFSTabDefaultsCheckBox;
  LANGMounterPrefs_UseFSTabDefaultsCheckBoxTooltip := LANGchsMounterPrefs_UseFSTabDefaultsCheckBoxTooltip;
  LANGMounterPrefs_ToggleModeCheckBox := LANGchsMounterPrefs_ToggleModeCheckBox;
  LANGMounterPrefs_ToggleModeCheckBoxTooltip := LANGchsMounterPrefs_ToggleModeCheckBoxTooltip;
  LANGMounterPrefs_PropertiesFrameCaption := LANGchsMounterPrefs_PropertiesFrameCaption;
  LANGMounterPrefs_DisplayTextLabelCaption := LANGchsMounterPrefs_DisplayTextLabelCaption;
  LANGMounterPrefs_MountPointLabelCaption := LANGchsMounterPrefs_MountPointLabelCaption;
  LANGMounterPrefs_MountDeviceLabelCaption := LANGchsMounterPrefs_MountDeviceLabelCaption;
  LANGMounterPrefs_DeviceTypeLabelCaption := LANGchsMounterPrefs_DeviceTypeLabelCaption;
  LANGMounterPrefs_miLocalDiskCaption := LANGchsMounterPrefs_miLocalDiskCaption;
  LANGMounterPrefs_miRemovableCaption := LANGchsMounterPrefs_miRemovableCaption;
  LANGMounterPrefs_miCDCaption := LANGchsMounterPrefs_miCDCaption;
  LANGMounterPrefs_miFloppyCaption := LANGchsMounterPrefs_miFloppyCaption;
  LANGMounterPrefs_miNetworkCaption := LANGchsMounterPrefs_miNetworkCaption;
  LANGMounterPrefs_MountCommandLabelCaption := LANGchsMounterPrefs_MountCommandLabelCaption;
  LANGMounterPrefs_UmountCommandLabelCaption := LANGchsMounterPrefs_UmountCommandLabelCaption;
  LANGMounterPrefs_MountCommandEntryTooltip := LANGchsMounterPrefs_MountCommandEntryTooltip;
  LANGMounterPrefs_UmountCommandEntryTooltip := LANGchsMounterPrefs_UmountCommandEntryTooltip;
  LANGMounterPrefs_IconLabelCaption := LANGchsMounterPrefs_IconLabelCaption;

  LANGConnMgr_Caption := LANGchsConnMgr_Caption;
  LANGConnMgr_ConnectButton := LANGchsConnMgr_ConnectButton;
  LANGConnMgr_OpenConnection := LANGchsConnMgr_OpenConnection;
  LANGConnMgr_NameColumn := LANGchsConnMgr_NameColumn;
  LANGConnMgr_URIColumn := LANGchsConnMgr_URIColumn;
  LANGConnMgr_AddConnectionButtonCaption := LANGchsConnMgr_AddConnectionButtonCaption;
  LANGConnMgr_AddConnectionButtonTooltip := LANGchsConnMgr_AddConnectionButtonTooltip;
  LANGConnMgr_EditButtonCaption := LANGchsConnMgr_EditButtonCaption;
  LANGConnMgr_EditButtonTooltip := LANGchsConnMgr_EditButtonTooltip;
  LANGConnMgr_RemoveButtonCaption := LANGchsConnMgr_RemoveButtonCaption;
  LANGConnMgr_RemoveButtonTooltip := LANGchsConnMgr_RemoveButtonTooltip;
  LANGConnMgr_DoYouWantDelete := LANGchsConnMgr_DoYouWantDelete;

  LANGConnProp_FTP := LANGchsConnProp_FTP;
  LANGConnProp_SFTP := LANGchsConnProp_SFTP;
  LANGConnProp_SMB := LANGchsConnProp_SMB;
  LANGConnProp_HTTP := LANGchsConnProp_HTTP;
  LANGConnProp_HTTPS := LANGchsConnProp_HTTPS;
  LANGConnProp_Other := LANGchsConnProp_Other;
  LANGConnProp_Caption := LANGchsConnProp_Caption;
  LANGConnProp_VFSModule := LANGchsConnProp_VFSModule;
  LANGConnProp_URI := LANGchsConnProp_URI;
  LANGConnProp_URIEntryTooltip := LANGchsConnProp_URIEntryTooltip;
  LANGConnProp_DetailedInformations := LANGchsConnProp_DetailedInformations;
  LANGConnProp_Name := LANGchsConnProp_Name;
  LANGConnProp_Server := LANGchsConnProp_Server;
  LANGConnProp_Username := LANGchsConnProp_Username;
  LANGConnProp_UserNameEntryTooltip := LANGchsConnProp_UserNameEntryTooltip;
  LANGConnProp_Password := LANGchsConnProp_Password;
  LANGConnProp_TargetDirectory := LANGchsConnProp_TargetDirectory;
  LANGConnProp_ServiceType := LANGchsConnProp_ServiceType;
  LANGConnProp_MaskPassword := LANGchsConnProp_MaskPassword;
  LANGConnProp_MenuItemCaption := LANGchsConnProp_MenuItemCaption;

  LANGConnLogin_Caption := LANGchsConnLogin_Caption;
  LANGConnLogin_Login := LANGchsConnLogin_Login;
  LANGConnLogin_ExperimentalWarningLabelCaption := LANGchsConnLogin_ExperimentalWarningLabelCaption;
  LANGConnLogin_Username := LANGchsConnLogin_Username;
  LANGConnLogin_Password := LANGchsConnLogin_Password;
  LANGConnLogin_AnonymousCheckButton := LANGchsConnLogin_AnonymousCheckButton;

  LANGColumns_Caption := LANGchsColumns_Caption;
  LANGColumns_Title := LANGchsColumns_Title;
  LANGColumns_MoveUpButtonTooltip := LANGchsColumns_MoveUpButtonTooltip;
  LANGColumns_MoveDownButtonTooltip := LANGchsColumns_MoveDownButtonTooltip;
  LANGColumns_TitlesLongName := LANGchsColumns_TitlesLongName;
  LANGColumns_TitlesLongNameExt := LANGchsColumns_TitlesLongNameExt;
  LANGColumns_TitlesLongExt := LANGchsColumns_TitlesLongExt;
  LANGColumns_TitlesLongSize := LANGchsColumns_TitlesLongSize;
  LANGColumns_TitlesLongDateTime := LANGchsColumns_TitlesLongDateTime;
  LANGColumns_TitlesLongDate := LANGchsColumns_TitlesLongDate;
  LANGColumns_TitlesLongTime := LANGchsColumns_TitlesLongTime;
  LANGColumns_TitlesLongUser := LANGchsColumns_TitlesLongUser;
  LANGColumns_TitlesLongGroup := LANGchsColumns_TitlesLongGroup;
  LANGColumns_TitlesLongAttr := LANGchsColumns_TitlesLongAttr;
  LANGColumns_TitlesShortName := LANGchsColumns_TitlesShortName;
  LANGColumns_TitlesShortNameExt := LANGchsColumns_TitlesShortNameExt;
  LANGColumns_TitlesShortExt := LANGchsColumns_TitlesShortExt;
  LANGColumns_TitlesShortSize := LANGchsColumns_TitlesShortSize;
  LANGColumns_TitlesShortDateTime := LANGchsColumns_TitlesShortDateTime;
  LANGColumns_TitlesShortDate := LANGchsColumns_TitlesShortDate;
  LANGColumns_TitlesShortTime := LANGchsColumns_TitlesShortTime;
  LANGColumns_TitlesShortUser := LANGchsColumns_TitlesShortUser;
  LANGColumns_TitlesShortGroup := LANGchsColumns_TitlesShortGroup;
  LANGColumns_TitlesShortAttr := LANGchsColumns_TitlesShortAttr;

  LANGTestPlugin_Caption := LANGchsTestPlugin_Caption;
  LANGTestPlugin_Title := LANGchsTestPlugin_Title;
  LANGTestPlugin_ExperimentalWarningLabelCaption := LANGchsTestPlugin_ExperimentalWarningLabelCaption;
  LANGTestPlugin_Plugin := LANGchsTestPlugin_Plugin;
  LANGTestPlugin_Command := LANGchsTestPlugin_Command;
  LANGTestPlugin_Username := LANGchsTestPlugin_Username;
  LANGTestPlugin_Password := LANGchsTestPlugin_Password;
  LANGTestPlugin_AnonymousCheckButton := LANGchsTestPlugin_AnonymousCheckButton;
  LANGTestPlugin_NoPluginsFound := LANGchsTestPlugin_NoPluginsFound;

  LANGRemoteWait_Caption := LANGchsRemoteWait_Caption;
  LANGRemoteWait_OperationInProgress := LANGchsRemoteWait_OperationInProgress;
  LANGRemoteWait_ItemsFound := LANGchsRemoteWait_ItemsFound;

  LANGSearch_Bytes := LANGchsSearch_Bytes;
  LANGSearch_kB := LANGchsSearch_kB;
  LANGSearch_MB := LANGchsSearch_MB;
  LANGSearch_days := LANGchsSearch_days;
  LANGSearch_weeks := LANGchsSearch_weeks;
  LANGSearch_months := LANGchsSearch_months;
  LANGSearch_years := LANGchsSearch_years;
  LANGSearch_Caption := LANGchsSearch_Caption;
  LANGSearch_General := LANGchsSearch_General;
  LANGSearch_Advanced := LANGchsSearch_Advanced;
  LANGSearch_SearchResults := LANGchsSearch_SearchResults;
  LANGSearch_SearchFor := LANGchsSearch_SearchFor;
  LANGSearch_FileMaskEntryTooltip := LANGchsSearch_FileMaskEntryTooltip;
  LANGSearch_SearchIn := LANGchsSearch_SearchIn;
  LANGSearch_SearchArchivesCheckButton := LANGchsSearch_SearchArchivesCheckButton;
  LANGSearch_FindText := LANGchsSearch_FindText;
  LANGSearch_FindTextEntryTooltip := LANGchsSearch_FindTextEntryTooltip;
  LANGSearch_CaseSensitiveCheckButton := LANGchsSearch_CaseSensitiveCheckButton;
  LANGSearch_StayCurrentFSCheckButton := LANGchsSearch_StayCurrentFSCheckButton;
  LANGSearch_CaseSensitiveMatchCheckButton := LANGchsSearch_CaseSensitiveMatchCheckButton;
  LANGSearch_Size := LANGchsSearch_Size;
  LANGSearch_Date := LANGchsSearch_Date;
  LANGSearch_BiggerThan := LANGchsSearch_BiggerThan;
  LANGSearch_SmallerThan := LANGchsSearch_SmallerThan;
  LANGSearch_ModifiedBetweenRadioButton := LANGchsSearch_ModifiedBetweenRadioButton;
  LANGSearch_NotModifiedAfterRadioButton := LANGchsSearch_NotModifiedAfterRadioButton;
  LANGSearch_ModifiedLastRadioButton := LANGchsSearch_ModifiedLastRadioButton;
  LANGSearch_ModifiedNotLastRadionButton := LANGchsSearch_ModifiedNotLastRadionButton;
  LANGSearch_ModifiedBetweenEntry1 := LANGchsSearch_ModifiedBetweenEntry1;
  LANGSearch_ViewButtonCaption := LANGchsSearch_ViewButtonCaption;
  LANGSearch_NewSearchButtonCaption := LANGchsSearch_NewSearchButtonCaption;
  LANGSearch_GoToFileButtonCaption := LANGchsSearch_GoToFileButtonCaption;
  LANGSearch_FeedToListboxButtonCaption := LANGchsSearch_FeedToListboxButtonCaption;
  LANGSearch_StatusSC := LANGchsSearch_StatusSC;
  LANGSearch_Ready := LANGchsSearch_Ready;
  LANGSearch_PreparingToSearch := LANGchsSearch_PreparingToSearch;
  LANGSearch_SearchInProgress := LANGchsSearch_SearchInProgress;
  LANGSearch_UserCancelled := LANGchsSearch_UserCancelled;
  LANGSearch_SearchFinished := LANGchsSearch_SearchFinished;
  LANGSearch_FilesFound := LANGchsSearch_FilesFound;
  LANGSearch_And := LANGchsSearch_And;
  
  LANGCloseOpenConnection := LANGchsCloseOpenConnection;
  LANGDuplicateTabWarning := LANGchsDuplicateTabWarning;
  LANGDontShowAgain := LANGchsDontShowAgain;
  LANGSwitchOtherPanelWarning := LANGchsSwitchOtherPanelWarning;
  LANGOpenConnectionsWarning := LANGchsOpenConnectionsWarning;
  LANGmiDisconnect_Caption := LANGchsmiDisconnect_Caption;
  LANGDisconnectButton_Tooltip := LANGchsDisconnectButton_Tooltip;
  LANGLeaveArchiveButton_Tooltip := LANGchsLeaveArchiveButton_Tooltip;
  LANGOpenTerminalButton_Tooltip := LANGchsOpenTerminalButton_Tooltip;
  LANGOpenTerminalButton_Caption := LANGchsOpenTerminalButton_Caption;
  LANGShowTextUIDsCheckBox_Caption := LANGchsShowTextUIDsCheckBox_Caption;
  LANGShowTextUIDsCheckBox_Tooltip := LANGchsShowTextUIDsCheckBox_Tooltip;
  
  LANGmiNewTab_Caption := LANGchsmiNewTab_Caption;
  LANGFilePopupMenu_Properties := LANGchsFilePopupMenu_Properties;
  LANGCommandEntry_Tooltip := LANGchsCommandEntry_Tooltip;
  LANGmiFiles_Caption := LANGchsmiFiles_Caption;

  LANGPasswordButton_Tooltip := LANGchsPasswordButton_Tooltip;
  LANGHandleRunFromArchive_Bytes := LANGchsHandleRunFromArchive_Bytes;
  LANGHandleRunFromArchive_FileTypeDesc_Unknown := LANGchsHandleRunFromArchive_FileTypeDesc_Unknown;
  LANGHandleRunFromArchive_NotAssociated := LANGchsHandleRunFromArchive_NotAssociated;
  LANGHandleRunFromArchive_SelfExecutable := LANGchsHandleRunFromArchive_SelfExecutable;
  LANGHandleRunFromArchive_CouldntCreateTemporaryDirectory := LANGchsHandleRunFromArchive_CouldntCreateTemporaryDirectory;
  LANGFRunFromVFS_Caption := LANGchsFRunFromVFS_Caption;
  LANGFRunFromVFS_TitleLabel := LANGchsFRunFromVFS_TitleLabel;
  LANGFRunFromVFS_FileNameLabel := LANGchsFRunFromVFS_FileNameLabel;
  LANGFRunFromVFS_FileTypeLabel := LANGchsFRunFromVFS_FileTypeLabel;
  LANGFRunFromVFS_SizeLabel := LANGchsFRunFromVFS_SizeLabel;
  LANGFRunFromVFS_PackedSizeLabel := LANGchsFRunFromVFS_PackedSizeLabel;
  LANGFRunFromVFS_DateLabel := LANGchsFRunFromVFS_DateLabel;
  LANGFRunFromVFS_InfoLabel := LANGchsFRunFromVFS_InfoLabel;
  LANGFRunFromVFS_OpensWithLabel := LANGchsFRunFromVFS_OpensWithLabel;
  LANGFRunFromVFS_ExecuteButton := LANGchsFRunFromVFS_ExecuteButton;
  LANGFRunFromVFS_ExecuteAllButton := LANGchsFRunFromVFS_ExecuteAllButton;
  LANGFSetPassword_Caption := LANGchsFSetPassword_Caption;
  LANGFSetPassword_Label1_Caption := LANGchsFSetPassword_Label1_Caption;
  LANGFSetPassword_Label2_Caption := LANGchsFSetPassword_Label2_Caption;
  LANGFSetPassword_ShowPasswordCheckButton := LANGchsFSetPassword_ShowPasswordCheckButton;

  LANGCopyFileNamesToClipboard := LANGchsCopyFileNamesToClipboard;
  LANGCopyFullPathNamesToClipboard := LANGchsCopyFullPathNamesToClipboard;
  LANGCopyPathToClipboard := LANGchsCopyPathToClipboard;
  LANGPreferences_DateFormatLabel_Caption := LANGchsPreferences_DateFormatLabel_Caption;
  LANGPreferences_System := LANGchsPreferences_System;
  LANGPreferences_Custom := LANGchsPreferences_Custom;
  LANGPreferences_CustomDateFormatEntry_Tooltip := LANGchsPreferences_CustomDateFormatEntry_Tooltip;
  LANGPreferences_TimeFormatLabel_Caption := LANGchsPreferences_TimeFormatLabel_Caption;
  LANGPreferences_CustomTimeFormatEntry_Tooltip := LANGchsPreferences_CustomTimeFormatEntry_Tooltip;
  LANGPreferences_DateTimeFormatLabel_Caption := LANGchsPreferences_DateTimeFormatLabel_Caption;
  LANGPreferences_QuickRenameSkipExtCheckBox := LANGchsPreferences_QuickRenameSkipExtCheckBox;
  LANGPreferences_QuickRenameSkipExtCheckBox_Tooltip := LANGchsPreferences_QuickRenameSkipExtCheckBox_Tooltip;
  LANGPreferences_SortDirectoriesLikeFilesCheckBox := LANGchsPreferences_SortDirectoriesLikeFilesCheckBox;
  LANGPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip := LANGchsPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip;
  LANGPreferences_QuickSearchLabel_Caption := LANGchsPreferences_QuickSearchLabel_Caption;
  LANGPreferences_QuickSearchOptionMenu_Tooltip := LANGchsPreferences_QuickSearchOptionMenu_Tooltip;
  LANGPreferences_QuickSearch_Option1 := LANGchsPreferences_QuickSearch_Option1;
  LANGPreferences_QuickSearch_Option2 := LANGchsPreferences_QuickSearch_Option2;
  LANGPreferences_QuickSearch_Option3 := LANGchsPreferences_QuickSearch_Option3;
  LANGPreferences_QuickSearch_Option4 := LANGchsPreferences_QuickSearch_Option4;
  LANGPreferences_TempPathLabel_Caption := LANGchsPreferences_TempPathLabel_Caption;
  LANGPreferences_VFSTempPathLabel_Caption := LANGchsPreferences_VFSTempPathLabel_Caption;
  LANGPreferences_VFSTempPathEntry_Tooltip := LANGchsPreferences_VFSTempPathEntry_Tooltip;

  LANGPreferences_RightClickSelectCheckBox := LANGchsPreferences_RightClickSelectCheckBox;
  LANGPreferences_RightClickSelectCheckBox_Tooltip := LANGchsPreferences_RightClickSelectCheckBox_Tooltip;
  LANGGtkMountOperation_ConnectAnonymously := LANGchsGtkMountOperation_ConnectAnonymously;
  LANGGtkMountOperation_ConnectAsUser := LANGchsGtkMountOperation_ConnectAsUser;
  LANGGtkMountOperation_Username := LANGchsGtkMountOperation_Username;
  LANGGtkMountOperation_Domain := LANGchsGtkMountOperation_Domain;
  LANGGtkMountOperation_Password := LANGchsGtkMountOperation_Password;
  LANGGtkMountOperation_DoNotSavePassword :=  LANGchsGtkMountOperation_DoNotSavePassword;
  LANGGtkMountOperation_ForgetPasswordImmediately := LANGchsGtkMountOperation_ForgetPasswordImmediately;
  LANGGtkMountOperation_RememberPasswordUntilYouLogout := LANGchsGtkMountOperation_RememberPasswordUntilYouLogout;
  LANGGtkMountOperation_SavePasswordInConnectionManager := LANGchsGtkMountOperation_SavePasswordInConnectionManager;
  LANGGtkMountOperation_RememberForever := LANGchsGtkMountOperation_RememberForever;
  LANGFSymlink_RelativePath := LANGchsFSymlink_RelativePath;
  LANGFConnectionManager_DuplicateButton_Caption := LANGchsFConnectionManager_DuplicateButton_Caption;
  LANGFConnectionManager_DuplicateButton_Tooltip := LANGchsFConnectionManager_DuplicateButton_Tooltip;
  LANGFConnectionManager_DoNotSavePasswordsCheckBox_Label := LANGchsFConnectionManager_DoNotSavePasswordsCheckBox_Label;
  LANGFConnectionManager_DoNotSavePasswordsCheckBox_Tooltip := LANGchsFConnectionManager_DoNotSavePasswordsCheckBox_Tooltip;
  LANGFConnectionManager_DoNotSynchronizeKeyringCheckBox_Label := LANGchsFConnectionManager_DoNotSynchronizeKeyringCheckBox_Label;
  LANGFConnectionManager_DoNotSynchronizeKeyringCheckBox_Tooltip := LANGchsFConnectionManager_DoNotSynchronizeKeyringCheckBox_Tooltip;
  LANGFConnectionManager_DuplicateMenuItem_Caption := LANGchsFConnectionManager_DuplicateMenuItem_Caption;
  LANGFQuickConnect_Caption := LANGchsFQuickConnect_Caption;
  LANGFQuickConnect_TitleLabel_Caption := LANGchsFQuickConnect_TitleLabel_Caption;
  LANGFQuickConnect_ConnectToURILabel_Caption := LANGchsFQuickConnect_ConnectToURILabel_Caption;
  LANGLinkToS := LANGchsLinkToS;
  LANGOpenDirectoryInBackgroundTab := LANGchsOpenDirectoryInBackgroundTab;
  LANGTheActiveConnectionHasNotBeenSaved := LANGchsTheActiveConnectionHasNotBeenSaved;
  LANGTheArchiveIsEncryptedAndRequiresPassword := LANGchsTheArchiveIsEncryptedAndRequiresPassword;
end;

initialization
  AddTranslation('ZH', @SetTranslation);
  AddTranslation('CN', @SetTranslation);
  AddTranslation('zh_CN', @SetTranslation);
end.
