package org.herac.tuxguitar.graphics.control.painters;

import org.herac.tuxguitar.graphics.command.TGCubicTo;
import org.herac.tuxguitar.graphics.command.TGLineTo;
import org.herac.tuxguitar.graphics.command.TGMoveTo;
import org.herac.tuxguitar.graphics.command.TGPaintCommand;
import org.herac.tuxguitar.graphics.command.TGPaintModel;
import org.herac.tuxguitar.ui.resource.UIPainter;

public class TGKeySignaturePainter {
	
	private static final TGPaintCommand SHARP_MODEL = new TGPaintModel(
		new TGMoveTo(0.4330491f, -0.79610115f),
		new TGCubicTo(0.44892004f, -0.80517024f, 0.47386006f, -0.7983684f, 0.48292914f, -0.7779629f),
		new TGCubicTo(0.48746368f, -0.76889384f, 0.48746368f, -0.76209205f, 0.48746368f, -0.60338295f),
		new TGCubicTo(0.48746368f, -0.51042473f, 0.48746368f, -0.43560475f, 0.48973095f, -0.43560475f),
		new TGCubicTo(0.48973095f, -0.43560475f, 0.51013637f, -0.44467384f, 0.5350764f, -0.45374292f),
		new TGCubicTo(0.5872237f, -0.47414836f, 0.5940255f, -0.47641566f, 0.6076291f, -0.46507928f),
		new TGCubicTo(0.62350005f, -0.45374292f, 0.62350005f, -0.45147565f, 0.62350005f, -0.36078474f),
		new TGCubicTo(0.62350005f, -0.2836975f, 0.62350005f, -0.27689564f, 0.6189655f, -0.2700938f),
		new TGCubicTo(0.6166982f, -0.26555926f, 0.61216366f, -0.2610247f, 0.6098964f, -0.25875747f),
		new TGCubicTo(0.6053619f, -0.25649017f, 0.5781546f, -0.24288653f, 0.54641277f, -0.2315502f),
		new TGLineTo(0.48973095f, -0.20661019f),
		new TGLineTo(0.48746368f, -0.022961069f),
		new TGCubicTo(0.48746368f, 0.07679899f, 0.48746368f, 0.16068806f, 0.48973095f, 0.16068806f),
		new TGCubicTo(0.48973095f, 0.16068806f, 0.51013637f, 0.15161897f, 0.5350764f, 0.14254989f),
		new TGCubicTo(0.5872237f, 0.12214436f, 0.5940255f, 0.119877115f, 0.6076291f, 0.13121344f),
		new TGCubicTo(0.62350005f, 0.14254989f, 0.62350005f, 0.14481713f, 0.62350005f, 0.23550804f),
		new TGCubicTo(0.62350005f, 0.31259543f, 0.62350005f, 0.31939715f, 0.6189655f, 0.326199f),
		new TGCubicTo(0.6166982f, 0.3307336f, 0.61216366f, 0.33526808f, 0.6098964f, 0.33753532f),
		new TGCubicTo(0.6053619f, 0.33980268f, 0.5781546f, 0.35340625f, 0.54641277f, 0.36474258f),
		new TGLineTo(0.48973095f, 0.3896826f),
		new TGLineTo(0.48746368f, 0.5801335f),
		new TGCubicTo(0.48746368f, 0.75244635f, 0.4851964f, 0.77285165f, 0.48292914f, 0.7796536f),
		new TGCubicTo(0.4670582f, 0.806861f, 0.42851457f, 0.806861f, 0.4126437f, 0.7796536f),
		new TGCubicTo(0.41037643f, 0.77285165f, 0.40810916f, 0.7547135f, 0.40810916f, 0.5960044f),
		new TGLineTo(0.40810916f, 0.42142445f),
		new TGLineTo(0.31061637f, 0.45996803f),
		new TGLineTo(0.21539094f, 0.49851173f),
		new TGLineTo(0.21539094f, 0.6821607f),
		new TGCubicTo(0.21539094f, 0.8771464f, 0.21539094f, 0.8726117f, 0.20405458f, 0.88394815f),
		new TGCubicTo(0.19952002f, 0.89075f, 0.18364911f, 0.8975517f, 0.1768473f, 0.8975517f),
		new TGCubicTo(0.1677782f, 0.8975517f, 0.15190728f, 0.89075f, 0.14737274f, 0.88394815f),
		new TGCubicTo(0.13603638f, 0.8726117f, 0.13603638f, 0.8771464f, 0.13603638f, 0.70029896f),
		new TGCubicTo(0.13603638f, 0.6073409f, 0.13603638f, 0.53252083f, 0.1337691f, 0.53252083f),
		new TGCubicTo(0.1337691f, 0.53252083f, 0.113363646f, 0.5415899f, 0.08842365f, 0.550659f),
		new TGCubicTo(0.036276367f, 0.5710644f, 0.029474549f, 0.5733318f, 0.01587091f, 0.5619953f),
		new TGCubicTo(0.0f, 0.550659f, 0.0f, 0.54839164f, 0.0f, 0.4577008f),
		new TGCubicTo(0.0f, 0.3806135f, 0.0f, 0.37381178f, 0.004534546f, 0.36700982f),
		new TGCubicTo(0.0068018185f, 0.36247534f, 0.011336365f, 0.35794073f, 0.013603637f, 0.3556735f),
		new TGCubicTo(0.018138183f, 0.35340625f, 0.04534546f, 0.33980268f, 0.07708728f, 0.32846624f),
		new TGLineTo(0.13603638f, 0.30352622f),
		new TGLineTo(0.13603638f, 0.119877115f),
		new TGCubicTo(0.13603638f, 0.020117175f, 0.13603638f, -0.06377195f, 0.1337691f, -0.06377195f),
		new TGCubicTo(0.1337691f, -0.06377195f, 0.113363646f, -0.054702807f, 0.08842365f, -0.045633722f),
		new TGCubicTo(0.036276367f, -0.02522831f, 0.029474549f, -0.022961069f, 0.01587091f, -0.034297395f),
		new TGCubicTo(0.0f, -0.045633722f, 0.0f, -0.047901023f, 0.0f, -0.13859199f),
		new TGCubicTo(0.0f, -0.21567927f, 0.0f, -0.22248112f, 0.004534546f, -0.2292829f),
		new TGCubicTo(0.0068018185f, -0.23381744f, 0.011336365f, -0.23835205f, 0.013603637f, -0.24061923f),
		new TGCubicTo(0.018138183f, -0.24288653f, 0.04534546f, -0.25649017f, 0.07708728f, -0.26782656f),
		new TGLineTo(0.13603638f, -0.29276657f),
		new TGLineTo(0.13603638f, -0.48321748f),
		new TGCubicTo(0.13603638f, -0.6555302f, 0.13830365f, -0.6759357f, 0.14057092f, -0.68273747f),
		new TGCubicTo(0.15644182f, -0.7099448f, 0.19498548f, -0.7099448f, 0.2108564f, -0.68273747f),
		new TGCubicTo(0.21312366f, -0.6759357f, 0.21539094f, -0.6577975f, 0.21539094f, -0.49908838f),
		new TGLineTo(0.21765819f, -0.32450837f),
		new TGLineTo(0.31288365f, -0.363052f),
		new TGLineTo(0.40810916f, -0.40159562f),
		new TGLineTo(0.40810916f, -0.5852448f),
		new TGCubicTo(0.40810916f, -0.7575575f, 0.40810916f, -0.76889384f, 0.4126437f, -0.7779629f),
		new TGCubicTo(0.41717824f, -0.78703207f, 0.4217128f, -0.7915666f, 0.4330491f, -0.79610115f),
		new TGMoveTo(0.40810916f, 0.00878073f),
		new TGLineTo(0.40810916f, -0.17486833f),
		new TGLineTo(0.31061637f, -0.13632469f),
		new TGLineTo(0.21539094f, -0.09778105f),
		new TGLineTo(0.21539094f, 0.08813532f),
		new TGLineTo(0.21539094f, 0.27178437f),
		new TGLineTo(0.22219275f, 0.26951712f),
		new TGCubicTo(0.22672729f, 0.26724988f, 0.26980546f, 0.24911173f, 0.3196855f, 0.23097356f),
		new TGLineTo(0.40810916f, 0.19469716f),
		new TGLineTo(0.40810916f, 0.00878073f)
	);
	
	private static final TGPaintCommand FLAT_MODEL = new TGPaintModel(
		new TGMoveTo(0.036081146f, -1.227901f),
		new TGCubicTo(0.066563375f, -1.2334433f, 0.11644338f, -1.227901f, 0.13584116f, -1.2140454f),
		new TGCubicTo(0.14138338f, -1.2112744f, 0.14138338f, -1.1807921f, 0.13307005f, -0.72910094f),
		new TGCubicTo(0.12752782f, -0.46584538f, 0.12475671f, -0.24969868f, 0.12475671f, -0.24969868f),
		new TGCubicTo(0.12475671f, -0.2469276f, 0.13584116f, -0.2524698f, 0.1469256f, -0.2607831f),
		new TGCubicTo(0.20511894f, -0.2995787f, 0.27716786f, -0.32174757f, 0.34921673f, -0.3272898f),
		new TGCubicTo(0.42403674f, -0.330061f, 0.4850012f, -0.30789205f, 0.53765225f, -0.2552409f),
		new TGCubicTo(0.5903034f, -0.20536087f, 0.6180146f, -0.13885425f, 0.6235568f, -0.06680534f),
		new TGCubicTo(0.6263279f, -0.014154296f, 0.61524343f, 0.03295471f, 0.5903034f, 0.082834624f),
		new TGCubicTo(0.55150783f, 0.15765466f, 0.49608564f, 0.21030582f, 0.32981896f, 0.32392135f),
		new TGCubicTo(0.2245167f, 0.39597037f, 0.19680561f, 0.41813925f, 0.16355227f, 0.45693472f),
		new TGCubicTo(0.1469256f, 0.47356132f, 0.12752782f, 0.49295917f, 0.12198559f, 0.4957303f),
		new TGCubicTo(0.0970456f, 0.5123569f, 0.06933448f, 0.50958586f, 0.04716559f, 0.49018803f),
		new TGCubicTo(0.04162337f, 0.48187473f, 0.036081146f, 0.47356132f, 0.033310037f, 0.46524814f),
		new TGCubicTo(0.030538924f, 0.45970586f, 0.024996702f, 0.16319682f, 0.016683366f, -0.30512092f),
		new TGCubicTo(0.0083700325f, -0.7235587f, 0.00282781f, -1.0976588f, 5.669861E-5f, -1.1392255f),
		new TGLineTo(5.669861E-5f, -1.2112744f),
		new TGLineTo(0.011141145f, -1.2168165f),
		new TGCubicTo(0.016683366f, -1.2195877f, 0.027767813f, -1.22513f, 0.036081146f, -1.227901f),
		new TGMoveTo(0.32981896f, -0.21090315f),
		new TGCubicTo(0.31042117f, -0.22198771f, 0.27993897f, -0.22475873f, 0.25499895f, -0.21644543f),
		new TGCubicTo(0.20511894f, -0.20258985f, 0.16355227f, -0.15825199f, 0.1469256f, -0.10005865f),
		new TGCubicTo(0.14138338f, -0.07234762f, 0.13584116f, 0.16596796f, 0.14138338f, 0.25741473f),
		new TGCubicTo(0.14415449f, 0.29621032f, 0.14415449f, 0.33223465f, 0.1469256f, 0.34054795f),
		new TGLineTo(0.14969671f, 0.3516325f),
		new TGLineTo(0.19126338f, 0.31560805f),
		new TGCubicTo(0.24945672f, 0.26572803f, 0.30765006f, 0.20753469f, 0.33536118f, 0.1687391f),
		new TGCubicTo(0.36307228f, 0.12994362f, 0.39078343f, 0.077292465f, 0.40186784f, 0.03849699f),
		new TGCubicTo(0.41849452f, -0.025238734f, 0.41018116f, -0.09728751f, 0.38524118f, -0.15270983f),
		new TGCubicTo(0.37138563f, -0.18042086f, 0.35475895f, -0.1998186f, 0.32981896f, -0.21090315f)
	);
	
	private static final TGPaintCommand NATURAL_MODEL = new TGPaintModel(
		new TGMoveTo(0.038880464f, -0.9978458f),
		new TGCubicTo(0.061049357f, -1.003388f, 0.11092936f, -0.9978458f, 0.13032715f, -0.98399025f),
		new TGCubicTo(0.13309824f, -0.9812192f, 0.13309824f, -0.9396525f, 0.13032715f, -0.7429036f),
		new TGCubicTo(0.12755603f, -0.6098902f, 0.12755603f, -0.50181687f, 0.12755603f, -0.50181687f),
		new TGCubicTo(0.12755603f, -0.4990458f, 0.1968338f, -0.5101303f, 0.28273827f, -0.52398574f),
		new TGCubicTo(0.37141383f, -0.54061246f, 0.4406916f, -0.54892576f, 0.44346273f, -0.54892576f),
		new TGCubicTo(0.4573183f, -0.5461546f, 0.4684027f, -0.5350702f, 0.47671604f, -0.52121466f),
		new TGLineTo(0.48225826f, -0.5101303f),
		new TGLineTo(0.49057162f, 0.29072094f),
		new TGCubicTo(0.49888495f, 0.9336188f, 0.50165606f, 1.0915723f, 0.49888495f, 1.0915723f),
		new TGCubicTo(0.49611384f, 1.0943432f, 0.48780048f, 1.0971143f, 0.47948715f, 1.0998855f),
		new TGCubicTo(0.4573183f, 1.1081989f, 0.4129805f, 1.1081989f, 0.3908116f, 1.0998855f),
		new TGCubicTo(0.3824983f, 1.0971143f, 0.37418494f, 1.0943432f, 0.37141383f, 1.0915723f),
		new TGCubicTo(0.36864272f, 1.0888011f, 0.36864272f, 1.0472345f, 0.37141383f, 0.85048544f),
		new TGCubicTo(0.37418494f, 0.7174721f, 0.37418494f, 0.6093987f, 0.37418494f, 0.6093987f),
		new TGCubicTo(0.37418494f, 0.6066277f, 0.30490717f, 0.61771214f, 0.21900271f, 0.6315676f),
		new TGCubicTo(0.13032715f, 0.6481943f, 0.061049357f, 0.65650773f, 0.058278244f, 0.65650773f),
		new TGCubicTo(0.044422686f, 0.6537366f, 0.033338238f, 0.64265203f, 0.025024906f, 0.6287966f),
		new TGLineTo(0.019482683f, 0.614941f),
		new TGLineTo(0.011169349f, -0.08060795f),
		new TGCubicTo(0.005627127f, -0.46302134f, 0.002856015f, -0.8232658f, 8.490361E-5f, -0.8814592f),
		new TGLineTo(8.490361E-5f, -0.98399025f),
		new TGLineTo(0.01394046f, -0.9895325f),
		new TGCubicTo(0.022253795f, -0.9923036f, 0.033338238f, -0.9950747f, 0.038880464f, -0.9978458f),
		new TGMoveTo(0.38526937f, -0.22193468f),
		new TGCubicTo(0.38526937f, -0.25241685f, 0.38526937f, -0.2607302f, 0.3824983f, -0.2607302f),
		new TGCubicTo(0.37141383f, -0.2607302f, 0.12478492f, -0.21916354f, 0.12478492f, -0.2163924f),
		new TGCubicTo(0.12201381f, -0.2163924f, 0.11647158f, 0.36554098f, 0.11647158f, 0.36831212f),
		new TGCubicTo(0.1192427f, 0.36831212f, 0.37418494f, 0.3267454f, 0.37695605f, 0.32397425f),
		new TGCubicTo(0.37695605f, 0.32397425f, 0.38526937f, -0.09446347f, 0.38526937f, -0.22193468f)
	);
	
	public static void paintSharp(UIPainter painter, float x, float y,float scale){
		SHARP_MODEL.paint(painter, x, y, scale);
	}
	
	public static void paintFlat(UIPainter painter, float x, float y,float scale){
		FLAT_MODEL.paint(painter, x, y, scale);
	}
	
	public static void paintNatural(UIPainter painter, float x, float y,float scale){
		NATURAL_MODEL.paint(painter, x, y, scale);
	}
}
