/*
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jonathan@daria.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <vdk/vdk.h>
#include <stdlib.h>
#include <sys/types.h>
#include "vdk/vdkinchannel.h"
#ifdef VDK2
#define VDKLabelButton VDKCustomButton
#define VDKText VDKTextView 
#endif

class MyApp: public VDKApplication
{
  protected:
    static void reaper(int);
    static void plumber(int);
    static MyApp *me;    
  public:
    char **args;
    MyApp(int* argc, char** argv):
        VDKApplication(argc,argv), args(argv+1) {}
    ~MyApp() {}
    void Setup();
}; 

class MyForm: public VDKForm
{
  private:
    VDKLabelButton *quit;
    VDKText *text;
    VDKEntry *entry;
    VDKTimer *timer;
    
    pid_t  pid;
    int xmit;
    
    bool Quit(VDKObject*);
    bool runcmd (VDKObject*);
    bool DoIO (VDKObject*);
    bool Stop (VDKObject*);    
    bool CanClose(void);
    bool Mourn(VDKObject*);
    bool sendstuff(VDKObject*);    
    
  public:
    MyForm(VDKApplication* app, gchar* title):
        VDKForm(app,title),  timer(0), pid(0), xmit(-1) {}
    ~MyForm() { }
    void Setup(void); 
    inline int Pid() {return pid;}
    inline void Pid(int p) {pid=p;}
    inline  VDKText * Text() {return text;}
    void ShowInfanticide();
    
    DECLARE_SIGNAL_MAP(MyForm);  
    DECLARE_SIGNAL_LIST(MyForm);
};
