// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UQADD_4S_TRACE_AARCH64_H_
#define VIXL_SIM_UQADD_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_uqadd_4S[] = {
  0x0000fc00, 0x0000fe00, 0x00fffa00, 0x00000000,
  0x0000fd00, 0x00807c00, 0x007ffd00, 0x00000001,
  0x00807b00, 0x00007f00, 0x007ffd01, 0x00000002,
  0x00007e00, 0x00007f01, 0x007ffd02, 0x00000020,
  0x00007e01, 0x00007f02, 0x007ffd20, 0x0000007d,
  0x00007e02, 0x00007f20, 0x007ffd7d, 0x0000007e,
  0x00007e20, 0x00007f7d, 0x007ffd7e, 0x0000007f,
  0x00007e7d, 0x00007f7e, 0x007ffd7f, 0x00007ffd,
  0x00007e7e, 0x00007f7f, 0x00807cfd, 0x00007ffe,
  0x00007e7f, 0x0000fefd, 0x00807cfe, 0x00007fff,
  0x0000fdfd, 0x0000fefe, 0x00807cff, 0x33333333,
  0x0000fdfe, 0x0000feff, 0x33b33033, 0x55555555,
  0x0000fdff, 0x3333b233, 0x55d55255, 0x7ffffffd,
  0x3333b133, 0x5555d455, 0x807ffcfd, 0x7ffffffe,
  0x5555d355, 0x80007efd, 0x807ffcfe, 0x7fffffff,
  0x80007dfd, 0x80007efe, 0x807ffcff, 0x80000000,
  0x80007dfe, 0x80007eff, 0x807ffd00, 0x80000001,
  0x80007dff, 0x80007f00, 0x807ffd01, 0xaaaaaaaa,
  0x80007e00, 0x80007f01, 0xab2aa7aa, 0xcccccccc,
  0x80007e01, 0xaaab29aa, 0xcd4cc9cc, 0xffff8000,
  0xaaab28aa, 0xcccd4bcc, 0xffffffff, 0xffff8001,
  0xcccd4acc, 0xffffff00, 0xffffffff, 0xffff8002,
  0xfffffe00, 0xffffff01, 0xffffffff, 0xffff8003,
  0xfffffe01, 0xffffff02, 0xffffffff, 0xffffff80,
  0xfffffe02, 0xffffff03, 0xffffffff, 0xffffff81,
  0xfffffe03, 0xffffffff, 0xffffffff, 0xffffff82,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffff83,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffe0,
  0xffffffff, 0xffffffff, 0xffffffff, 0xfffffffd,
  0xffffffff, 0xffffffff, 0xffffffff, 0xfffffffe,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x00000001,
  0xffffffff, 0xffffffff, 0x00000000, 0x00000002,
  0xffffffff, 0x007ffd00, 0x00000001, 0x00000003,
  0x00007f00, 0x007ffd01, 0x00000002, 0x00000021,
  0x00007f01, 0x007ffd02, 0x00000020, 0x0000007e,
  0x00007f02, 0x007ffd20, 0x0000007d, 0x0000007f,
  0x00007f20, 0x007ffd7d, 0x0000007e, 0x00000080,
  0x00007f7d, 0x007ffd7e, 0x0000007f, 0x00007ffe,
  0x00007f7e, 0x007ffd7f, 0x00007ffd, 0x00007fff,
  0x00007f7f, 0x00807cfd, 0x00007ffe, 0x00008000,
  0x0000fefd, 0x00807cfe, 0x00007fff, 0x33333334,
  0x0000fefe, 0x00807cff, 0x33333333, 0x55555556,
  0x0000feff, 0x33b33033, 0x55555555, 0x7ffffffe,
  0x3333b233, 0x55d55255, 0x7ffffffd, 0x7fffffff,
  0x5555d455, 0x807ffcfd, 0x7ffffffe, 0x80000000,
  0x80007efd, 0x807ffcfe, 0x7fffffff, 0x80000001,
  0x80007efe, 0x807ffcff, 0x80000000, 0x80000002,
  0x80007eff, 0x807ffd00, 0x80000001, 0xaaaaaaab,
  0x80007f00, 0x807ffd01, 0xaaaaaaaa, 0xcccccccd,
  0x80007f01, 0xab2aa7aa, 0xcccccccc, 0xffff8001,
  0xaaab29aa, 0xcd4cc9cc, 0xffff8000, 0xffff8002,
  0xcccd4bcc, 0xffffffff, 0xffff8001, 0xffff8003,
  0xffffff00, 0xffffffff, 0xffff8002, 0xffff8004,
  0xffffff01, 0xffffffff, 0xffff8003, 0xffffff81,
  0xffffff02, 0xffffffff, 0xffffff80, 0xffffff82,
  0xffffff03, 0xffffffff, 0xffffff81, 0xffffff83,
  0xffffffff, 0xffffffff, 0xffffff82, 0xffffff84,
  0xffffffff, 0xffffffff, 0xffffff83, 0xffffffe1,
  0xffffffff, 0xffffffff, 0xffffffe0, 0xfffffffe,
  0xffffffff, 0xffffffff, 0xfffffffd, 0xffffffff,
  0xffffffff, 0xffffffff, 0xfffffffe, 0xffffffff,
  0xffffffff, 0xfffffffe, 0xffffffff, 0x00000002,
  0xffffffff, 0xffffffff, 0x00000001, 0x00000003,
  0xffffffff, 0x00000000, 0x00000002, 0x00000004,
  0x007ffd00, 0x00000001, 0x00000003, 0x00000022,
  0x007ffd01, 0x00000002, 0x00000021, 0x0000007f,
  0x007ffd02, 0x00000020, 0x0000007e, 0x00000080,
  0x007ffd20, 0x0000007d, 0x0000007f, 0x00000081,
  0x007ffd7d, 0x0000007e, 0x00000080, 0x00007fff,
  0x007ffd7e, 0x0000007f, 0x00007ffe, 0x00008000,
  0x007ffd7f, 0x00007ffd, 0x00007fff, 0x00008001,
  0x00807cfd, 0x00007ffe, 0x00008000, 0x33333335,
  0x00807cfe, 0x00007fff, 0x33333334, 0x55555557,
  0x00807cff, 0x33333333, 0x55555556, 0x7fffffff,
  0x33b33033, 0x55555555, 0x7ffffffe, 0x80000000,
  0x55d55255, 0x7ffffffd, 0x7fffffff, 0x80000001,
  0x807ffcfd, 0x7ffffffe, 0x80000000, 0x80000002,
  0x807ffcfe, 0x7fffffff, 0x80000001, 0x80000003,
  0x807ffcff, 0x80000000, 0x80000002, 0xaaaaaaac,
  0x807ffd00, 0x80000001, 0xaaaaaaab, 0xccccccce,
  0x807ffd01, 0xaaaaaaaa, 0xcccccccd, 0xffff8002,
  0xab2aa7aa, 0xcccccccc, 0xffff8001, 0xffff8003,
  0xcd4cc9cc, 0xffff8000, 0xffff8002, 0xffff8004,
  0xffffffff, 0xffff8001, 0xffff8003, 0xffff8005,
  0xffffffff, 0xffff8002, 0xffff8004, 0xffffff82,
  0xffffffff, 0xffff8003, 0xffffff81, 0xffffff83,
  0xffffffff, 0xffffff80, 0xffffff82, 0xffffff84,
  0xffffffff, 0xffffff81, 0xffffff83, 0xffffff85,
  0xffffffff, 0xffffff82, 0xffffff84, 0xffffffe2,
  0xffffffff, 0xffffff83, 0xffffffe1, 0xffffffff,
  0xffffffff, 0xffffffe0, 0xfffffffe, 0xffffffff,
  0xffffffff, 0xfffffffd, 0xffffffff, 0xffffffff,
  0xfffffffd, 0xffffffff, 0xffffffff, 0x00000020,
  0xfffffffe, 0xffffffff, 0x00000002, 0x00000021,
  0xffffffff, 0x00000001, 0x00000003, 0x00000022,
  0x00000000, 0x00000002, 0x00000004, 0x00000040,
  0x00000001, 0x00000003, 0x00000022, 0x0000009d,
  0x00000002, 0x00000021, 0x0000007f, 0x0000009e,
  0x00000020, 0x0000007e, 0x00000080, 0x0000009f,
  0x0000007d, 0x0000007f, 0x00000081, 0x0000801d,
  0x0000007e, 0x00000080, 0x00007fff, 0x0000801e,
  0x0000007f, 0x00007ffe, 0x00008000, 0x0000801f,
  0x00007ffd, 0x00007fff, 0x00008001, 0x33333353,
  0x00007ffe, 0x00008000, 0x33333335, 0x55555575,
  0x00007fff, 0x33333334, 0x55555557, 0x8000001d,
  0x33333333, 0x55555556, 0x7fffffff, 0x8000001e,
  0x55555555, 0x7ffffffe, 0x80000000, 0x8000001f,
  0x7ffffffd, 0x7fffffff, 0x80000001, 0x80000020,
  0x7ffffffe, 0x80000000, 0x80000002, 0x80000021,
  0x7fffffff, 0x80000001, 0x80000003, 0xaaaaaaca,
  0x80000000, 0x80000002, 0xaaaaaaac, 0xccccccec,
  0x80000001, 0xaaaaaaab, 0xccccccce, 0xffff8020,
  0xaaaaaaaa, 0xcccccccd, 0xffff8002, 0xffff8021,
  0xcccccccc, 0xffff8001, 0xffff8003, 0xffff8022,
  0xffff8000, 0xffff8002, 0xffff8004, 0xffff8023,
  0xffff8001, 0xffff8003, 0xffff8005, 0xffffffa0,
  0xffff8002, 0xffff8004, 0xffffff82, 0xffffffa1,
  0xffff8003, 0xffffff81, 0xffffff83, 0xffffffa2,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffffa3,
  0xffffff81, 0xffffff83, 0xffffff85, 0xffffffff,
  0xffffff82, 0xffffff84, 0xffffffe2, 0xffffffff,
  0xffffff83, 0xffffffe1, 0xffffffff, 0xffffffff,
  0xffffffe0, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0x0000007d,
  0xffffffff, 0xffffffff, 0x00000020, 0x0000007e,
  0xffffffff, 0x00000002, 0x00000021, 0x0000007f,
  0x00000001, 0x00000003, 0x00000022, 0x0000009d,
  0x00000002, 0x00000004, 0x00000040, 0x000000fa,
  0x00000003, 0x00000022, 0x0000009d, 0x000000fb,
  0x00000021, 0x0000007f, 0x0000009e, 0x000000fc,
  0x0000007e, 0x00000080, 0x0000009f, 0x0000807a,
  0x0000007f, 0x00000081, 0x0000801d, 0x0000807b,
  0x00000080, 0x00007fff, 0x0000801e, 0x0000807c,
  0x00007ffe, 0x00008000, 0x0000801f, 0x333333b0,
  0x00007fff, 0x00008001, 0x33333353, 0x555555d2,
  0x00008000, 0x33333335, 0x55555575, 0x8000007a,
  0x33333334, 0x55555557, 0x8000001d, 0x8000007b,
  0x55555556, 0x7fffffff, 0x8000001e, 0x8000007c,
  0x7ffffffe, 0x80000000, 0x8000001f, 0x8000007d,
  0x7fffffff, 0x80000001, 0x80000020, 0x8000007e,
  0x80000000, 0x80000002, 0x80000021, 0xaaaaab27,
  0x80000001, 0x80000003, 0xaaaaaaca, 0xcccccd49,
  0x80000002, 0xaaaaaaac, 0xccccccec, 0xffff807d,
  0xaaaaaaab, 0xccccccce, 0xffff8020, 0xffff807e,
  0xcccccccd, 0xffff8002, 0xffff8021, 0xffff807f,
  0xffff8001, 0xffff8003, 0xffff8022, 0xffff8080,
  0xffff8002, 0xffff8004, 0xffff8023, 0xfffffffd,
  0xffff8003, 0xffff8005, 0xffffffa0, 0xfffffffe,
  0xffff8004, 0xffffff82, 0xffffffa1, 0xffffffff,
  0xffffff81, 0xffffff83, 0xffffffa2, 0xffffffff,
  0xffffff82, 0xffffff84, 0xffffffa3, 0xffffffff,
  0xffffff83, 0xffffff85, 0xffffffff, 0xffffffff,
  0xffffff84, 0xffffffe2, 0xffffffff, 0xffffffff,
  0xffffffe1, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x0000007e,
  0xffffffff, 0xffffffff, 0x0000007d, 0x0000007f,
  0xffffffff, 0x00000020, 0x0000007e, 0x00000080,
  0x00000002, 0x00000021, 0x0000007f, 0x0000009e,
  0x00000003, 0x00000022, 0x0000009d, 0x000000fb,
  0x00000004, 0x00000040, 0x000000fa, 0x000000fc,
  0x00000022, 0x0000009d, 0x000000fb, 0x000000fd,
  0x0000007f, 0x0000009e, 0x000000fc, 0x0000807b,
  0x00000080, 0x0000009f, 0x0000807a, 0x0000807c,
  0x00000081, 0x0000801d, 0x0000807b, 0x0000807d,
  0x00007fff, 0x0000801e, 0x0000807c, 0x333333b1,
  0x00008000, 0x0000801f, 0x333333b0, 0x555555d3,
  0x00008001, 0x33333353, 0x555555d2, 0x8000007b,
  0x33333335, 0x55555575, 0x8000007a, 0x8000007c,
  0x55555557, 0x8000001d, 0x8000007b, 0x8000007d,
  0x7fffffff, 0x8000001e, 0x8000007c, 0x8000007e,
  0x80000000, 0x8000001f, 0x8000007d, 0x8000007f,
  0x80000001, 0x80000020, 0x8000007e, 0xaaaaab28,
  0x80000002, 0x80000021, 0xaaaaab27, 0xcccccd4a,
  0x80000003, 0xaaaaaaca, 0xcccccd49, 0xffff807e,
  0xaaaaaaac, 0xccccccec, 0xffff807d, 0xffff807f,
  0xccccccce, 0xffff8020, 0xffff807e, 0xffff8080,
  0xffff8002, 0xffff8021, 0xffff807f, 0xffff8081,
  0xffff8003, 0xffff8022, 0xffff8080, 0xfffffffe,
  0xffff8004, 0xffff8023, 0xfffffffd, 0xffffffff,
  0xffff8005, 0xffffffa0, 0xfffffffe, 0xffffffff,
  0xffffff82, 0xffffffa1, 0xffffffff, 0xffffffff,
  0xffffff83, 0xffffffa2, 0xffffffff, 0xffffffff,
  0xffffff84, 0xffffffa3, 0xffffffff, 0xffffffff,
  0xffffff85, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffe2, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x0000007f,
  0xffffffff, 0xffffffff, 0x0000007e, 0x00000080,
  0xffffffff, 0x0000007d, 0x0000007f, 0x00000081,
  0x00000020, 0x0000007e, 0x00000080, 0x0000009f,
  0x00000021, 0x0000007f, 0x0000009e, 0x000000fc,
  0x00000022, 0x0000009d, 0x000000fb, 0x000000fd,
  0x00000040, 0x000000fa, 0x000000fc, 0x000000fe,
  0x0000009d, 0x000000fb, 0x000000fd, 0x0000807c,
  0x0000009e, 0x000000fc, 0x0000807b, 0x0000807d,
  0x0000009f, 0x0000807a, 0x0000807c, 0x0000807e,
  0x0000801d, 0x0000807b, 0x0000807d, 0x333333b2,
  0x0000801e, 0x0000807c, 0x333333b1, 0x555555d4,
  0x0000801f, 0x333333b0, 0x555555d3, 0x8000007c,
  0x33333353, 0x555555d2, 0x8000007b, 0x8000007d,
  0x55555575, 0x8000007a, 0x8000007c, 0x8000007e,
  0x8000001d, 0x8000007b, 0x8000007d, 0x8000007f,
  0x8000001e, 0x8000007c, 0x8000007e, 0x80000080,
  0x8000001f, 0x8000007d, 0x8000007f, 0xaaaaab29,
  0x80000020, 0x8000007e, 0xaaaaab28, 0xcccccd4b,
  0x80000021, 0xaaaaab27, 0xcccccd4a, 0xffff807f,
  0xaaaaaaca, 0xcccccd49, 0xffff807e, 0xffff8080,
  0xccccccec, 0xffff807d, 0xffff807f, 0xffff8081,
  0xffff8020, 0xffff807e, 0xffff8080, 0xffff8082,
  0xffff8021, 0xffff807f, 0xffff8081, 0xffffffff,
  0xffff8022, 0xffff8080, 0xfffffffe, 0xffffffff,
  0xffff8023, 0xfffffffd, 0xffffffff, 0xffffffff,
  0xffffffa0, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xffffffa1, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffa2, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffa3, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x00007ffd,
  0xffffffff, 0xffffffff, 0x0000007f, 0x00007ffe,
  0xffffffff, 0x0000007e, 0x00000080, 0x00007fff,
  0x0000007d, 0x0000007f, 0x00000081, 0x0000801d,
  0x0000007e, 0x00000080, 0x0000009f, 0x0000807a,
  0x0000007f, 0x0000009e, 0x000000fc, 0x0000807b,
  0x0000009d, 0x000000fb, 0x000000fd, 0x0000807c,
  0x000000fa, 0x000000fc, 0x000000fe, 0x0000fffa,
  0x000000fb, 0x000000fd, 0x0000807c, 0x0000fffb,
  0x000000fc, 0x0000807b, 0x0000807d, 0x0000fffc,
  0x0000807a, 0x0000807c, 0x0000807e, 0x3333b330,
  0x0000807b, 0x0000807d, 0x333333b2, 0x5555d552,
  0x0000807c, 0x333333b1, 0x555555d4, 0x80007ffa,
  0x333333b0, 0x555555d3, 0x8000007c, 0x80007ffb,
  0x555555d2, 0x8000007b, 0x8000007d, 0x80007ffc,
  0x8000007a, 0x8000007c, 0x8000007e, 0x80007ffd,
  0x8000007b, 0x8000007d, 0x8000007f, 0x80007ffe,
  0x8000007c, 0x8000007e, 0x80000080, 0xaaab2aa7,
  0x8000007d, 0x8000007f, 0xaaaaab29, 0xcccd4cc9,
  0x8000007e, 0xaaaaab28, 0xcccccd4b, 0xfffffffd,
  0xaaaaab27, 0xcccccd4a, 0xffff807f, 0xfffffffe,
  0xcccccd49, 0xffff807e, 0xffff8080, 0xffffffff,
  0xffff807d, 0xffff807f, 0xffff8081, 0xffffffff,
  0xffff807e, 0xffff8080, 0xffff8082, 0xffffffff,
  0xffff807f, 0xffff8081, 0xffffffff, 0xffffffff,
  0xffff8080, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xfffffffd, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x00007ffe,
  0xffffffff, 0xffffffff, 0x00007ffd, 0x00007fff,
  0xffffffff, 0x0000007f, 0x00007ffe, 0x00008000,
  0x0000007e, 0x00000080, 0x00007fff, 0x0000801e,
  0x0000007f, 0x00000081, 0x0000801d, 0x0000807b,
  0x00000080, 0x0000009f, 0x0000807a, 0x0000807c,
  0x0000009e, 0x000000fc, 0x0000807b, 0x0000807d,
  0x000000fb, 0x000000fd, 0x0000807c, 0x0000fffb,
  0x000000fc, 0x000000fe, 0x0000fffa, 0x0000fffc,
  0x000000fd, 0x0000807c, 0x0000fffb, 0x0000fffd,
  0x0000807b, 0x0000807d, 0x0000fffc, 0x3333b331,
  0x0000807c, 0x0000807e, 0x3333b330, 0x5555d553,
  0x0000807d, 0x333333b2, 0x5555d552, 0x80007ffb,
  0x333333b1, 0x555555d4, 0x80007ffa, 0x80007ffc,
  0x555555d3, 0x8000007c, 0x80007ffb, 0x80007ffd,
  0x8000007b, 0x8000007d, 0x80007ffc, 0x80007ffe,
  0x8000007c, 0x8000007e, 0x80007ffd, 0x80007fff,
  0x8000007d, 0x8000007f, 0x80007ffe, 0xaaab2aa8,
  0x8000007e, 0x80000080, 0xaaab2aa7, 0xcccd4cca,
  0x8000007f, 0xaaaaab29, 0xcccd4cc9, 0xfffffffe,
  0xaaaaab28, 0xcccccd4b, 0xfffffffd, 0xffffffff,
  0xcccccd4a, 0xffff807f, 0xfffffffe, 0xffffffff,
  0xffff807e, 0xffff8080, 0xffffffff, 0xffffffff,
  0xffff807f, 0xffff8081, 0xffffffff, 0xffffffff,
  0xffff8080, 0xffff8082, 0xffffffff, 0xffffffff,
  0xffff8081, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x00007fff,
  0xffffffff, 0xffffffff, 0x00007ffe, 0x00008000,
  0xffffffff, 0x00007ffd, 0x00007fff, 0x00008001,
  0x0000007f, 0x00007ffe, 0x00008000, 0x0000801f,
  0x00000080, 0x00007fff, 0x0000801e, 0x0000807c,
  0x00000081, 0x0000801d, 0x0000807b, 0x0000807d,
  0x0000009f, 0x0000807a, 0x0000807c, 0x0000807e,
  0x000000fc, 0x0000807b, 0x0000807d, 0x0000fffc,
  0x000000fd, 0x0000807c, 0x0000fffb, 0x0000fffd,
  0x000000fe, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x0000807c, 0x0000fffb, 0x0000fffd, 0x3333b332,
  0x0000807d, 0x0000fffc, 0x3333b331, 0x5555d554,
  0x0000807e, 0x3333b330, 0x5555d553, 0x80007ffc,
  0x333333b2, 0x5555d552, 0x80007ffb, 0x80007ffd,
  0x555555d4, 0x80007ffa, 0x80007ffc, 0x80007ffe,
  0x8000007c, 0x80007ffb, 0x80007ffd, 0x80007fff,
  0x8000007d, 0x80007ffc, 0x80007ffe, 0x80008000,
  0x8000007e, 0x80007ffd, 0x80007fff, 0xaaab2aa9,
  0x8000007f, 0x80007ffe, 0xaaab2aa8, 0xcccd4ccb,
  0x80000080, 0xaaab2aa7, 0xcccd4cca, 0xffffffff,
  0xaaaaab29, 0xcccd4cc9, 0xfffffffe, 0xffffffff,
  0xcccccd4b, 0xfffffffd, 0xffffffff, 0xffffffff,
  0xffff807f, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xffff8080, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffff8081, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffff8082, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x33333333,
  0xffffffff, 0xffffffff, 0x00007fff, 0x33333334,
  0xffffffff, 0x00007ffe, 0x00008000, 0x33333335,
  0x00007ffd, 0x00007fff, 0x00008001, 0x33333353,
  0x00007ffe, 0x00008000, 0x0000801f, 0x333333b0,
  0x00007fff, 0x0000801e, 0x0000807c, 0x333333b1,
  0x0000801d, 0x0000807b, 0x0000807d, 0x333333b2,
  0x0000807a, 0x0000807c, 0x0000807e, 0x3333b330,
  0x0000807b, 0x0000807d, 0x0000fffc, 0x3333b331,
  0x0000807c, 0x0000fffb, 0x0000fffd, 0x3333b332,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x66666666,
  0x0000fffb, 0x0000fffd, 0x3333b332, 0x88888888,
  0x0000fffc, 0x3333b331, 0x5555d554, 0xb3333330,
  0x3333b330, 0x5555d553, 0x80007ffc, 0xb3333331,
  0x5555d552, 0x80007ffb, 0x80007ffd, 0xb3333332,
  0x80007ffa, 0x80007ffc, 0x80007ffe, 0xb3333333,
  0x80007ffb, 0x80007ffd, 0x80007fff, 0xb3333334,
  0x80007ffc, 0x80007ffe, 0x80008000, 0xdddddddd,
  0x80007ffd, 0x80007fff, 0xaaab2aa9, 0xffffffff,
  0x80007ffe, 0xaaab2aa8, 0xcccd4ccb, 0xffffffff,
  0xaaab2aa7, 0xcccd4cca, 0xffffffff, 0xffffffff,
  0xcccd4cc9, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xfffffffd, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x55555555,
  0xffffffff, 0xffffffff, 0x33333333, 0x55555556,
  0xffffffff, 0x00007fff, 0x33333334, 0x55555557,
  0x00007ffe, 0x00008000, 0x33333335, 0x55555575,
  0x00007fff, 0x00008001, 0x33333353, 0x555555d2,
  0x00008000, 0x0000801f, 0x333333b0, 0x555555d3,
  0x0000801e, 0x0000807c, 0x333333b1, 0x555555d4,
  0x0000807b, 0x0000807d, 0x333333b2, 0x5555d552,
  0x0000807c, 0x0000807e, 0x3333b330, 0x5555d553,
  0x0000807d, 0x0000fffc, 0x3333b331, 0x5555d554,
  0x0000fffb, 0x0000fffd, 0x3333b332, 0x88888888,
  0x0000fffc, 0x0000fffe, 0x66666666, 0xaaaaaaaa,
  0x0000fffd, 0x3333b332, 0x88888888, 0xd5555552,
  0x3333b331, 0x5555d554, 0xb3333330, 0xd5555553,
  0x5555d553, 0x80007ffc, 0xb3333331, 0xd5555554,
  0x80007ffb, 0x80007ffd, 0xb3333332, 0xd5555555,
  0x80007ffc, 0x80007ffe, 0xb3333333, 0xd5555556,
  0x80007ffd, 0x80007fff, 0xb3333334, 0xffffffff,
  0x80007ffe, 0x80008000, 0xdddddddd, 0xffffffff,
  0x80007fff, 0xaaab2aa9, 0xffffffff, 0xffffffff,
  0xaaab2aa8, 0xcccd4ccb, 0xffffffff, 0xffffffff,
  0xcccd4cca, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x7ffffffd,
  0xffffffff, 0xffffffff, 0x55555555, 0x7ffffffe,
  0xffffffff, 0x33333333, 0x55555556, 0x7fffffff,
  0x00007fff, 0x33333334, 0x55555557, 0x8000001d,
  0x00008000, 0x33333335, 0x55555575, 0x8000007a,
  0x00008001, 0x33333353, 0x555555d2, 0x8000007b,
  0x0000801f, 0x333333b0, 0x555555d3, 0x8000007c,
  0x0000807c, 0x333333b1, 0x555555d4, 0x80007ffa,
  0x0000807d, 0x333333b2, 0x5555d552, 0x80007ffb,
  0x0000807e, 0x3333b330, 0x5555d553, 0x80007ffc,
  0x0000fffc, 0x3333b331, 0x5555d554, 0xb3333330,
  0x0000fffd, 0x3333b332, 0x88888888, 0xd5555552,
  0x0000fffe, 0x66666666, 0xaaaaaaaa, 0xfffffffa,
  0x3333b332, 0x88888888, 0xd5555552, 0xfffffffb,
  0x5555d554, 0xb3333330, 0xd5555553, 0xfffffffc,
  0x80007ffc, 0xb3333331, 0xd5555554, 0xfffffffd,
  0x80007ffd, 0xb3333332, 0xd5555555, 0xfffffffe,
  0x80007ffe, 0xb3333333, 0xd5555556, 0xffffffff,
  0x80007fff, 0xb3333334, 0xffffffff, 0xffffffff,
  0x80008000, 0xdddddddd, 0xffffffff, 0xffffffff,
  0xaaab2aa9, 0xffffffff, 0xffffffff, 0xffffffff,
  0xcccd4ccb, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x7ffffffe,
  0xffffffff, 0xffffffff, 0x7ffffffd, 0x7fffffff,
  0xffffffff, 0x55555555, 0x7ffffffe, 0x80000000,
  0x33333333, 0x55555556, 0x7fffffff, 0x8000001e,
  0x33333334, 0x55555557, 0x8000001d, 0x8000007b,
  0x33333335, 0x55555575, 0x8000007a, 0x8000007c,
  0x33333353, 0x555555d2, 0x8000007b, 0x8000007d,
  0x333333b0, 0x555555d3, 0x8000007c, 0x80007ffb,
  0x333333b1, 0x555555d4, 0x80007ffa, 0x80007ffc,
  0x333333b2, 0x5555d552, 0x80007ffb, 0x80007ffd,
  0x3333b330, 0x5555d553, 0x80007ffc, 0xb3333331,
  0x3333b331, 0x5555d554, 0xb3333330, 0xd5555553,
  0x3333b332, 0x88888888, 0xd5555552, 0xfffffffb,
  0x66666666, 0xaaaaaaaa, 0xfffffffa, 0xfffffffc,
  0x88888888, 0xd5555552, 0xfffffffb, 0xfffffffd,
  0xb3333330, 0xd5555553, 0xfffffffc, 0xfffffffe,
  0xb3333331, 0xd5555554, 0xfffffffd, 0xffffffff,
  0xb3333332, 0xd5555555, 0xfffffffe, 0xffffffff,
  0xb3333333, 0xd5555556, 0xffffffff, 0xffffffff,
  0xb3333334, 0xffffffff, 0xffffffff, 0xffffffff,
  0xdddddddd, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x7fffffff,
  0xffffffff, 0xffffffff, 0x7ffffffe, 0x80000000,
  0xffffffff, 0x7ffffffd, 0x7fffffff, 0x80000001,
  0x55555555, 0x7ffffffe, 0x80000000, 0x8000001f,
  0x55555556, 0x7fffffff, 0x8000001e, 0x8000007c,
  0x55555557, 0x8000001d, 0x8000007b, 0x8000007d,
  0x55555575, 0x8000007a, 0x8000007c, 0x8000007e,
  0x555555d2, 0x8000007b, 0x8000007d, 0x80007ffc,
  0x555555d3, 0x8000007c, 0x80007ffb, 0x80007ffd,
  0x555555d4, 0x80007ffa, 0x80007ffc, 0x80007ffe,
  0x5555d552, 0x80007ffb, 0x80007ffd, 0xb3333332,
  0x5555d553, 0x80007ffc, 0xb3333331, 0xd5555554,
  0x5555d554, 0xb3333330, 0xd5555553, 0xfffffffc,
  0x88888888, 0xd5555552, 0xfffffffb, 0xfffffffd,
  0xaaaaaaaa, 0xfffffffa, 0xfffffffc, 0xfffffffe,
  0xd5555552, 0xfffffffb, 0xfffffffd, 0xffffffff,
  0xd5555553, 0xfffffffc, 0xfffffffe, 0xffffffff,
  0xd5555554, 0xfffffffd, 0xffffffff, 0xffffffff,
  0xd5555555, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xd5555556, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x80000000,
  0xffffffff, 0xffffffff, 0x7fffffff, 0x80000001,
  0xffffffff, 0x7ffffffe, 0x80000000, 0x80000002,
  0x7ffffffd, 0x7fffffff, 0x80000001, 0x80000020,
  0x7ffffffe, 0x80000000, 0x8000001f, 0x8000007d,
  0x7fffffff, 0x8000001e, 0x8000007c, 0x8000007e,
  0x8000001d, 0x8000007b, 0x8000007d, 0x8000007f,
  0x8000007a, 0x8000007c, 0x8000007e, 0x80007ffd,
  0x8000007b, 0x8000007d, 0x80007ffc, 0x80007ffe,
  0x8000007c, 0x80007ffb, 0x80007ffd, 0x80007fff,
  0x80007ffa, 0x80007ffc, 0x80007ffe, 0xb3333333,
  0x80007ffb, 0x80007ffd, 0xb3333332, 0xd5555555,
  0x80007ffc, 0xb3333331, 0xd5555554, 0xfffffffd,
  0xb3333330, 0xd5555553, 0xfffffffc, 0xfffffffe,
  0xd5555552, 0xfffffffb, 0xfffffffd, 0xffffffff,
  0xfffffffa, 0xfffffffc, 0xfffffffe, 0xffffffff,
  0xfffffffb, 0xfffffffd, 0xffffffff, 0xffffffff,
  0xfffffffc, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xfffffffd, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0x80000001,
  0xffffffff, 0xffffffff, 0x80000000, 0x80000002,
  0xffffffff, 0x7fffffff, 0x80000001, 0x80000003,
  0x7ffffffe, 0x80000000, 0x80000002, 0x80000021,
  0x7fffffff, 0x80000001, 0x80000020, 0x8000007e,
  0x80000000, 0x8000001f, 0x8000007d, 0x8000007f,
  0x8000001e, 0x8000007c, 0x8000007e, 0x80000080,
  0x8000007b, 0x8000007d, 0x8000007f, 0x80007ffe,
  0x8000007c, 0x8000007e, 0x80007ffd, 0x80007fff,
  0x8000007d, 0x80007ffc, 0x80007ffe, 0x80008000,
  0x80007ffb, 0x80007ffd, 0x80007fff, 0xb3333334,
  0x80007ffc, 0x80007ffe, 0xb3333333, 0xd5555556,
  0x80007ffd, 0xb3333332, 0xd5555555, 0xfffffffe,
  0xb3333331, 0xd5555554, 0xfffffffd, 0xffffffff,
  0xd5555553, 0xfffffffc, 0xfffffffe, 0xffffffff,
  0xfffffffb, 0xfffffffd, 0xffffffff, 0xffffffff,
  0xfffffffc, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xfffffffd, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xaaaaaaaa,
  0xffffffff, 0xffffffff, 0x80000001, 0xaaaaaaab,
  0xffffffff, 0x80000000, 0x80000002, 0xaaaaaaac,
  0x7fffffff, 0x80000001, 0x80000003, 0xaaaaaaca,
  0x80000000, 0x80000002, 0x80000021, 0xaaaaab27,
  0x80000001, 0x80000020, 0x8000007e, 0xaaaaab28,
  0x8000001f, 0x8000007d, 0x8000007f, 0xaaaaab29,
  0x8000007c, 0x8000007e, 0x80000080, 0xaaab2aa7,
  0x8000007d, 0x8000007f, 0x80007ffe, 0xaaab2aa8,
  0x8000007e, 0x80007ffd, 0x80007fff, 0xaaab2aa9,
  0x80007ffc, 0x80007ffe, 0x80008000, 0xdddddddd,
  0x80007ffd, 0x80007fff, 0xb3333334, 0xffffffff,
  0x80007ffe, 0xb3333333, 0xd5555556, 0xffffffff,
  0xb3333332, 0xd5555555, 0xfffffffe, 0xffffffff,
  0xd5555554, 0xfffffffd, 0xffffffff, 0xffffffff,
  0xfffffffc, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xfffffffd, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xcccccccc,
  0xffffffff, 0xffffffff, 0xaaaaaaaa, 0xcccccccd,
  0xffffffff, 0x80000001, 0xaaaaaaab, 0xccccccce,
  0x80000000, 0x80000002, 0xaaaaaaac, 0xccccccec,
  0x80000001, 0x80000003, 0xaaaaaaca, 0xcccccd49,
  0x80000002, 0x80000021, 0xaaaaab27, 0xcccccd4a,
  0x80000020, 0x8000007e, 0xaaaaab28, 0xcccccd4b,
  0x8000007d, 0x8000007f, 0xaaaaab29, 0xcccd4cc9,
  0x8000007e, 0x80000080, 0xaaab2aa7, 0xcccd4cca,
  0x8000007f, 0x80007ffe, 0xaaab2aa8, 0xcccd4ccb,
  0x80007ffd, 0x80007fff, 0xaaab2aa9, 0xffffffff,
  0x80007ffe, 0x80008000, 0xdddddddd, 0xffffffff,
  0x80007fff, 0xb3333334, 0xffffffff, 0xffffffff,
  0xb3333333, 0xd5555556, 0xffffffff, 0xffffffff,
  0xd5555555, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xfffffffd, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffff8000,
  0xffffffff, 0xffffffff, 0xcccccccc, 0xffff8001,
  0xffffffff, 0xaaaaaaaa, 0xcccccccd, 0xffff8002,
  0x80000001, 0xaaaaaaab, 0xccccccce, 0xffff8020,
  0x80000002, 0xaaaaaaac, 0xccccccec, 0xffff807d,
  0x80000003, 0xaaaaaaca, 0xcccccd49, 0xffff807e,
  0x80000021, 0xaaaaab27, 0xcccccd4a, 0xffff807f,
  0x8000007e, 0xaaaaab28, 0xcccccd4b, 0xfffffffd,
  0x8000007f, 0xaaaaab29, 0xcccd4cc9, 0xfffffffe,
  0x80000080, 0xaaab2aa7, 0xcccd4cca, 0xffffffff,
  0x80007ffe, 0xaaab2aa8, 0xcccd4ccb, 0xffffffff,
  0x80007fff, 0xaaab2aa9, 0xffffffff, 0xffffffff,
  0x80008000, 0xdddddddd, 0xffffffff, 0xffffffff,
  0xb3333334, 0xffffffff, 0xffffffff, 0xffffffff,
  0xd5555556, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffff8001,
  0xffffffff, 0xffffffff, 0xffff8000, 0xffff8002,
  0xffffffff, 0xcccccccc, 0xffff8001, 0xffff8003,
  0xaaaaaaaa, 0xcccccccd, 0xffff8002, 0xffff8021,
  0xaaaaaaab, 0xccccccce, 0xffff8020, 0xffff807e,
  0xaaaaaaac, 0xccccccec, 0xffff807d, 0xffff807f,
  0xaaaaaaca, 0xcccccd49, 0xffff807e, 0xffff8080,
  0xaaaaab27, 0xcccccd4a, 0xffff807f, 0xfffffffe,
  0xaaaaab28, 0xcccccd4b, 0xfffffffd, 0xffffffff,
  0xaaaaab29, 0xcccd4cc9, 0xfffffffe, 0xffffffff,
  0xaaab2aa7, 0xcccd4cca, 0xffffffff, 0xffffffff,
  0xaaab2aa8, 0xcccd4ccb, 0xffffffff, 0xffffffff,
  0xaaab2aa9, 0xffffffff, 0xffffffff, 0xffffffff,
  0xdddddddd, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffff8002,
  0xffffffff, 0xffffffff, 0xffff8001, 0xffff8003,
  0xffffffff, 0xffff8000, 0xffff8002, 0xffff8004,
  0xcccccccc, 0xffff8001, 0xffff8003, 0xffff8022,
  0xcccccccd, 0xffff8002, 0xffff8021, 0xffff807f,
  0xccccccce, 0xffff8020, 0xffff807e, 0xffff8080,
  0xccccccec, 0xffff807d, 0xffff807f, 0xffff8081,
  0xcccccd49, 0xffff807e, 0xffff8080, 0xffffffff,
  0xcccccd4a, 0xffff807f, 0xfffffffe, 0xffffffff,
  0xcccccd4b, 0xfffffffd, 0xffffffff, 0xffffffff,
  0xcccd4cc9, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xcccd4cca, 0xffffffff, 0xffffffff, 0xffffffff,
  0xcccd4ccb, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffff8003,
  0xffffffff, 0xffffffff, 0xffff8002, 0xffff8004,
  0xffffffff, 0xffff8001, 0xffff8003, 0xffff8005,
  0xffff8000, 0xffff8002, 0xffff8004, 0xffff8023,
  0xffff8001, 0xffff8003, 0xffff8022, 0xffff8080,
  0xffff8002, 0xffff8021, 0xffff807f, 0xffff8081,
  0xffff8020, 0xffff807e, 0xffff8080, 0xffff8082,
  0xffff807d, 0xffff807f, 0xffff8081, 0xffffffff,
  0xffff807e, 0xffff8080, 0xffffffff, 0xffffffff,
  0xffff807f, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xfffffffd, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffff80,
  0xffffffff, 0xffffffff, 0xffff8003, 0xffffff81,
  0xffffffff, 0xffff8002, 0xffff8004, 0xffffff82,
  0xffff8001, 0xffff8003, 0xffff8005, 0xffffffa0,
  0xffff8002, 0xffff8004, 0xffff8023, 0xfffffffd,
  0xffff8003, 0xffff8022, 0xffff8080, 0xfffffffe,
  0xffff8021, 0xffff807f, 0xffff8081, 0xffffffff,
  0xffff807e, 0xffff8080, 0xffff8082, 0xffffffff,
  0xffff807f, 0xffff8081, 0xffffffff, 0xffffffff,
  0xffff8080, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffff81,
  0xffffffff, 0xffffffff, 0xffffff80, 0xffffff82,
  0xffffffff, 0xffff8003, 0xffffff81, 0xffffff83,
  0xffff8002, 0xffff8004, 0xffffff82, 0xffffffa1,
  0xffff8003, 0xffff8005, 0xffffffa0, 0xfffffffe,
  0xffff8004, 0xffff8023, 0xfffffffd, 0xffffffff,
  0xffff8022, 0xffff8080, 0xfffffffe, 0xffffffff,
  0xffff807f, 0xffff8081, 0xffffffff, 0xffffffff,
  0xffff8080, 0xffff8082, 0xffffffff, 0xffffffff,
  0xffff8081, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffff82,
  0xffffffff, 0xffffffff, 0xffffff81, 0xffffff83,
  0xffffffff, 0xffffff80, 0xffffff82, 0xffffff84,
  0xffff8003, 0xffffff81, 0xffffff83, 0xffffffa2,
  0xffff8004, 0xffffff82, 0xffffffa1, 0xffffffff,
  0xffff8005, 0xffffffa0, 0xfffffffe, 0xffffffff,
  0xffff8023, 0xfffffffd, 0xffffffff, 0xffffffff,
  0xffff8080, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xffff8081, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffff8082, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffff83,
  0xffffffff, 0xffffffff, 0xffffff82, 0xffffff84,
  0xffffffff, 0xffffff81, 0xffffff83, 0xffffff85,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffffa3,
  0xffffff81, 0xffffff83, 0xffffffa2, 0xffffffff,
  0xffffff82, 0xffffffa1, 0xffffffff, 0xffffffff,
  0xffffffa0, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xfffffffd, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffe0,
  0xffffffff, 0xffffffff, 0xffffff83, 0xffffffe1,
  0xffffffff, 0xffffff82, 0xffffff84, 0xffffffe2,
  0xffffff81, 0xffffff83, 0xffffff85, 0xffffffff,
  0xffffff82, 0xffffff84, 0xffffffa3, 0xffffffff,
  0xffffff83, 0xffffffa2, 0xffffffff, 0xffffffff,
  0xffffffa1, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffffe, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xfffffffd,
  0xffffffff, 0xffffffff, 0xffffffe0, 0xfffffffe,
  0xffffffff, 0xffffff83, 0xffffffe1, 0xffffffff,
  0xffffff82, 0xffffff84, 0xffffffe2, 0xffffffff,
  0xffffff83, 0xffffff85, 0xffffffff, 0xffffffff,
  0xffffff84, 0xffffffa3, 0xffffffff, 0xffffffff,
  0xffffffa2, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xfffffffe,
  0xffffffff, 0xffffffff, 0xfffffffd, 0xffffffff,
  0xffffffff, 0xffffffe0, 0xfffffffe, 0xffffffff,
  0xffffff83, 0xffffffe1, 0xffffffff, 0xffffffff,
  0xffffff84, 0xffffffe2, 0xffffffff, 0xffffffff,
  0xffffff85, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffa3, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xfffffffe, 0xffffffff,
  0xffffffff, 0xfffffffd, 0xffffffff, 0xffffffff,
  0xffffffe0, 0xfffffffe, 0xffffffff, 0xffffffff,
  0xffffffe1, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffe2, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
};
const unsigned kExpectedCount_NEON_uqadd_4S = 961;

#endif  // VIXL_SIM_UQADD_4S_TRACE_AARCH64_H_
