(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)
Require Export jessie_why.

(*Why type*) Inductive mode : Set :=
  | nearest_even : mode
  | to_zero : mode
  | up : mode
  | down : mode
  | nearest_away : mode.

(*Why type*) Definition double: Set.
Admitted.

(*Why logic*) Definition round_double : mode -> R -> R.
Admitted.

(*Why logic*) Definition round_double_logic : mode -> R -> double.
Admitted.

(*Why logic*) Definition double_value : double -> R.
Admitted.

(*Why logic*) Definition double_exact : double -> R.
Admitted.

(*Why logic*) Definition double_model : double -> R.
Admitted.

(*Why function*) Definition double_round_error  (x:double)
  := (Rabs (Rminus (double_value x) (double_exact x))).

(*Why function*) Definition double_total_error  (x:double)
  := (Rabs (Rminus (double_value x) (double_model x))).

(*Why function*) Definition max_double  
  := (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R.

(*Why predicate*) Definition no_overflow_double  (m:mode) (x:R)
  := (Rle (Rabs (round_double m x)) max_double).

(*Why axiom*) Lemma bounded_real_no_overflow_double :
  (forall (m:mode),
   (forall (x:R), ((Rle (Rabs x) max_double) -> (no_overflow_double m x)))).
Admitted.
Dp_hint bounded_real_no_overflow_double.

(*Why axiom*) Lemma round_double_monotonic :
  (forall (x:R),
   (forall (y:R),
    (forall (m:mode),
     ((Rle x y) -> (Rle (round_double m x) (round_double m y)))))).
Admitted.
Dp_hint round_double_monotonic.

(*Why axiom*) Lemma exact_round_double_for_integers :
  (forall (i:Z),
   (forall (m:mode),
    ((-9007199254740992) <= i /\ i <= 9007199254740992 ->
     (eq (round_double m (IZR i)) (IZR i))))).
Admitted.
Dp_hint exact_round_double_for_integers.

(*Why axiom*) Lemma exact_round_double_for_doubles :
  (forall (x:double),
   (forall (m:mode), (eq (round_double m (double_value x)) (double_value x)))).
Admitted.
Dp_hint exact_round_double_for_doubles.

(*Why axiom*) Lemma round_double_idempotent :
  (forall (m1:mode),
   (forall (m2:mode),
    (forall (x:R),
     (eq (round_double m1 (round_double m2 x)) (round_double m2 x))))).
Admitted.
Dp_hint round_double_idempotent.

(*Why axiom*) Lemma round_down_double_neg :
  (forall (x:R), (eq (round_double down (Ropp x)) (Ropp (round_double up x)))).
Admitted.
Dp_hint round_down_double_neg.

(*Why axiom*) Lemma round_up_double_neg :
  (forall (x:R), (eq (round_double up (Ropp x)) (Ropp (round_double down x)))).
Admitted.
Dp_hint round_up_double_neg.

(*Why axiom*) Lemma round_double_down_le :
  (forall (x:R), (Rle (round_double down x) x)).
Admitted.
Dp_hint round_double_down_le.

(*Why axiom*) Lemma round_up_double_ge :
  (forall (x:R), (Rge (round_double up x) x)).
Admitted.
Dp_hint round_up_double_ge.

(*Why type*) Definition single: Set.
Admitted.

(*Why logic*) Definition round_single : mode -> R -> R.
Admitted.

(*Why logic*) Definition round_single_logic : mode -> R -> single.
Admitted.

(*Why logic*) Definition single_value : single -> R.
Admitted.

(*Why logic*) Definition single_exact : single -> R.
Admitted.

(*Why logic*) Definition single_model : single -> R.
Admitted.

(*Why function*) Definition single_round_error  (x:single)
  := (Rabs (Rminus (single_value x) (single_exact x))).

(*Why function*) Definition single_total_error  (x:single)
  := (Rabs (Rminus (single_value x) (single_model x))).

(*Why function*) Definition max_single  
  := (33554430 * 10141204801825835211973625643008)%R.

(*Why predicate*) Definition no_overflow_single  (m:mode) (x:R)
  := (Rle (Rabs (round_single m x)) max_single).

(*Why axiom*) Lemma bounded_real_no_overflow_single :
  (forall (m:mode),
   (forall (x:R), ((Rle (Rabs x) max_single) -> (no_overflow_single m x)))).
Admitted.
Dp_hint bounded_real_no_overflow_single.

(*Why axiom*) Lemma round_single_monotonic :
  (forall (x:R),
   (forall (y:R),
    (forall (m:mode),
     ((Rle x y) -> (Rle (round_single m x) (round_single m y)))))).
Admitted.
Dp_hint round_single_monotonic.

(*Why axiom*) Lemma exact_round_single_for_integers :
  (forall (i:Z),
   (forall (m:mode),
    ((-16777216) <= i /\ i <= 16777216 ->
     (eq (round_single m (IZR i)) (IZR i))))).
Admitted.
Dp_hint exact_round_single_for_integers.

(*Why axiom*) Lemma exact_round_single_for_singles :
  (forall (x:single),
   (forall (m:mode), (eq (round_single m (single_value x)) (single_value x)))).
Admitted.
Dp_hint exact_round_single_for_singles.

(*Why axiom*) Lemma round_single_idempotent :
  (forall (m1:mode),
   (forall (m2:mode),
    (forall (x:R),
     (eq (round_single m1 (round_single m2 x)) (round_single m2 x))))).
Admitted.
Dp_hint round_single_idempotent.

(*Why axiom*) Lemma round_down_single_neg :
  (forall (x:R), (eq (round_single down (Ropp x)) (Ropp (round_single up x)))).
Admitted.
Dp_hint round_down_single_neg.

(*Why axiom*) Lemma round_up_single_neg :
  (forall (x:R), (eq (round_single up (Ropp x)) (Ropp (round_single down x)))).
Admitted.
Dp_hint round_up_single_neg.

(*Why axiom*) Lemma round_single_down_le :
  (forall (x:R), (Rle (round_single down x) x)).
Admitted.
Dp_hint round_single_down_le.

(*Why axiom*) Lemma round_up_single_ge :
  (forall (x:R), (Rge (round_single up x) x)).
Admitted.
Dp_hint round_up_single_ge.

(*Why axiom*) Lemma single_value_is_bounded :
  (forall (x:single), (Rle (Rabs (single_value x)) max_single)).
Admitted.
Dp_hint single_value_is_bounded.

(*Why axiom*) Lemma double_value_is_bounded :
  (forall (x:double), (Rle (Rabs (double_value x)) max_double)).
Admitted.
Dp_hint double_value_is_bounded.

(*Why predicate*) Definition single_of_real_post  (m:mode) (x:R) (res:single)
  := (eq (single_value res) (round_single m x)) /\
     (eq (single_exact res) x) /\ (eq (single_model res) x).

(*Why predicate*) Definition single_of_double_post  (m:mode) (x:double) (res:single)
  := (eq (single_value res) (round_single m (double_value x))) /\
     (eq (single_exact res) (double_exact x)) /\
     (eq (single_model res) (double_model x)).

(*Why predicate*) Definition add_single_post  (m:mode) (x:single) (y:single) (res:single)
  := (eq (single_value res) (round_single
                             m (Rplus (single_value x) (single_value y)))) /\
     (eq (single_exact res) (Rplus (single_exact x) (single_exact y))) /\
     (eq (single_model res) (Rplus (single_model x) (single_model y))).

(*Why predicate*) Definition sub_single_post  (m:mode) (x:single) (y:single) (res:single)
  := (eq (single_value res) (round_single
                             m (Rminus (single_value x) (single_value y)))) /\
     (eq (single_exact res) (Rminus (single_exact x) (single_exact y))) /\
     (eq (single_model res) (Rminus (single_model x) (single_model y))).

(*Why predicate*) Definition mul_single_post  (m:mode) (x:single) (y:single) (res:single)
  := (eq (single_value res) (round_single
                             m (Rmult (single_value x) (single_value y)))) /\
     (eq (single_exact res) (Rmult (single_exact x) (single_exact y))) /\
     (eq (single_model res) (Rmult (single_model x) (single_model y))).

(*Why predicate*) Definition div_single_post  (m:mode) (x:single) (y:single) (res:single)
  := (eq (single_value res) (round_single
                             m (Rdiv (single_value x) (single_value y)))) /\
     (eq (single_exact res) (Rdiv (single_exact x) (single_exact y))) /\
     (eq (single_model res) (Rdiv (single_model x) (single_model y))).

(*Why predicate*) Definition sqrt_single_post  (m:mode) (x:single) (res:single)
  := (eq (single_value res) (round_single m (sqrt (single_value x)))) /\
     (eq (single_exact res) (sqrt (single_exact x))) /\
     (eq (single_model res) (sqrt (single_model x))).

(*Why predicate*) Definition neg_single_post  (x:single) (res:single)
  := (eq (single_value res) (Ropp (single_value x))) /\
     (eq (single_exact res) (Ropp (single_exact x))) /\
     (eq (single_model res) (Ropp (single_model x))).

(*Why predicate*) Definition abs_single_post  (x:single) (res:single)
  := (eq (single_value res) (Rabs (single_value x))) /\
     (eq (single_exact res) (Rabs (single_exact x))) /\
     (eq (single_model res) (Rabs (single_model x))).

(*Why predicate*) Definition double_of_real_post  (m:mode) (x:R) (res:double)
  := (eq (double_value res) (round_double m x)) /\
     (eq (double_exact res) x) /\ (eq (double_model res) x).

(*Why predicate*) Definition double_of_single_post  (x:single) (res:double)
  := (eq (double_value res) (single_value x)) /\
     (eq (double_exact res) (single_exact x)) /\
     (eq (double_model res) (single_model x)).

(*Why predicate*) Definition add_double_post  (m:mode) (x:double) (y:double) (res:double)
  := (eq (double_value res) (round_double
                             m (Rplus (double_value x) (double_value y)))) /\
     (eq (double_exact res) (Rplus (double_exact x) (double_exact y))) /\
     (eq (double_model res) (Rplus (double_model x) (double_model y))).

(*Why predicate*) Definition sub_double_post  (m:mode) (x:double) (y:double) (res:double)
  := (eq (double_value res) (round_double
                             m (Rminus (double_value x) (double_value y)))) /\
     (eq (double_exact res) (Rminus (double_exact x) (double_exact y))) /\
     (eq (double_model res) (Rminus (double_model x) (double_model y))).

(*Why predicate*) Definition mul_double_post  (m:mode) (x:double) (y:double) (res:double)
  := (eq (double_value res) (round_double
                             m (Rmult (double_value x) (double_value y)))) /\
     (eq (double_exact res) (Rmult (double_exact x) (double_exact y))) /\
     (eq (double_model res) (Rmult (double_model x) (double_model y))).

(*Why predicate*) Definition div_double_post  (m:mode) (x:double) (y:double) (res:double)
  := (eq (double_value res) (round_double
                             m (Rdiv (double_value x) (double_value y)))) /\
     (eq (double_exact res) (Rdiv (double_exact x) (double_exact y))) /\
     (eq (double_model res) (Rdiv (double_model x) (double_model y))).

(*Why predicate*) Definition sqrt_double_post  (m:mode) (x:double) (res:double)
  := (eq (double_value res) (round_double m (sqrt (double_value x)))) /\
     (eq (double_exact res) (sqrt (double_exact x))) /\
     (eq (double_model res) (sqrt (double_model x))).

(*Why predicate*) Definition neg_double_post  (x:double) (res:double)
  := (eq (double_value res) (Ropp (double_value x))) /\
     (eq (double_exact res) (Ropp (double_exact x))) /\
     (eq (double_model res) (Ropp (double_model x))).

(*Why predicate*) Definition abs_double_post  (x:double) (res:double)
  := (eq (double_value res) (Rabs (double_value x))) /\
     (eq (double_exact res) (Rabs (double_exact x))) /\
     (eq (double_model res) (Rabs (double_model x))).

