/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.DisplayLabel;
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.functions.SummationParser;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;

public class Evaluator
extends Applet
implements ActionListener {
    private Frame frame;
    private String frameTitle;
    private Button launchButton;
    private String launchButtonName;
    private String[] colorNames = new String[]{"black", "red", "blue", "green", "yellow", "cyan", "magenta", "gray", "darkgray", "lightgray", "pink", "orange", "white"};
    private Color[] colors = new Color[]{Color.black, Color.red, Color.blue, Color.green, Color.yellow, Color.cyan, Color.magenta, Color.gray, Color.darkGray, Color.lightGray, Color.pink, Color.orange, Color.white};

    public void init() {
        int n;
        this.frameTitle = this.getParameter("FrameTitle");
        if (this.frameTitle == null) {
            this.frameTitle = "Calculator";
            n = this.frameTitle.lastIndexOf(46);
            if (n > -1) {
                this.frameTitle = this.frameTitle.substring(n + 1);
            }
        }
        this.setLayout(new BorderLayout());
        n = this.getSize().height;
        this.launchButtonName = this.getParameter("LaunchButtonName");
        if (n > 0 && n <= 35 || this.launchButtonName != null) {
            if (this.launchButtonName == null) {
                this.launchButtonName = "Launch " + this.frameTitle;
            }
            this.launchButton = new Button(this.launchButtonName);
            this.add((Component)this.launchButton, "Center");
            this.launchButton.addActionListener(this);
        } else {
            this.add((Component)this.makeMainPanel(), "Center");
        }
    }

    public JCMPanel makeMainPanel() {
        Label label;
        String string;
        Color color = this.getColorParam("BackgroundColor", Color.gray);
        Color color2 = this.getColorParam("LabelBackground", new Color(225, 225, 225));
        Color color3 = this.getColorParam("LabelForeground", new Color(0, 0, 200));
        Color color4 = this.getColorParam("AnswerBackground", color2);
        Color color5 = this.getColorParam("AnswerForeground", Color.red);
        Color color6 = this.getColorParam("InputBackground", Color.white);
        Color color7 = this.getColorParam("InputForeground", Color.black);
        JCMPanel jCMPanel = new JCMPanel(5);
        jCMPanel.setBackground(color);
        jCMPanel.setInsetGap(3);
        this.setLayout(new BorderLayout());
        this.add((Component)jCMPanel, "Center");
        JCMPanel jCMPanel2 = new JCMPanel(0, 1, 3);
        jCMPanel.add((Component)jCMPanel2, "Center");
        JCMPanel jCMPanel3 = new JCMPanel(0, 1, 3);
        jCMPanel.add((Component)jCMPanel3, "East");
        Parser parser = new Parser();
        parser.addOptions(64);
        parser.add(new SummationParser());
        int n = 0;
        String string2 = this.getParameter("Variable");
        if (string2 == null) {
            string2 = this.getParameter("Variable1");
            if (string2 == null) {
                string2 = "x";
            } else {
                n = 1;
            }
        }
        String string3 = string2;
        while (string2 != null) {
            string = "0";
            int n2 = (string2 = string2.trim()).indexOf(" ");
            if (n2 > 0) {
                string = string2.substring(n2 + 1).trim();
                string2 = string2.substring(0, n2);
            }
            label = new Label(" Input:  " + string2 + " =  ", 2);
            label.setBackground(color2);
            label.setForeground(color3);
            jCMPanel2.add(label);
            VariableInput variableInput = new VariableInput(string2, string, parser);
            variableInput.setBackground(color6);
            variableInput.setForeground(color7);
            variableInput.setThrowErrors(false);
            variableInput.setOnTextChange(jCMPanel.getController());
            variableInput.setOnUserAction(jCMPanel.getController());
            jCMPanel3.add(variableInput);
            string2 = this.getParameter("Variable" + ++n);
        }
        n = 0;
        string = this.getParameter("Expression");
        if (string == null) {
            string = this.getParameter("Expression1");
            if (string == null) {
                string = "log2(" + string3 + ")";
            } else {
                n = 1;
            }
        }
        while (string != null) {
            Label label2 = new Label(" " + string + " =  ", 2);
            label2.setBackground(color2);
            label2.setForeground(color3);
            jCMPanel2.add(label2);
            try {
                label = new DisplayLabel("#", parser.parse(string));
                label.setBackground(color4);
                label.setForeground(color5);
                label.setAlignment(1);
                jCMPanel3.add(label);
            }
            catch (ParseError parseError) {
                jCMPanel3.add(new Label("invalid function"));
            }
            string = this.getParameter("Expression" + ++n);
        }
        return jCMPanel;
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.launchButton && this.launchButton != null) {
            this.launchButton.setEnabled(false);
            if (this.frame == null) {
                this.frame = new Frame(this.frameTitle);
                this.frame.add(this.makeMainPanel());
                this.frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        Evaluator.this.frame.dispose();
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        Evaluator.this.frameClosed();
                    }
                });
                this.frame.pack();
                this.frame.setLocation(50, 50);
                this.frame.setVisible(true);
                this.launchButton.setLabel("Close Window");
                this.launchButton.setEnabled(true);
            } else {
                this.frame.dispose();
            }
        }
    }

    private synchronized void frameClosed() {
        this.frame = null;
        this.launchButton.setLabel(this.launchButtonName);
        this.launchButton.setEnabled(true);
    }

    protected Color getColorParam(String string, Color color) {
        String string2 = this.getParameter(string);
        if (string2 == null || string2.trim().length() == 0) {
            return color;
        }
        if (Character.isLetter((string2 = string2.trim()).charAt(0))) {
            for (int i = 0; i < this.colorNames.length; ++i) {
                if (!string2.equalsIgnoreCase(this.colorNames[i])) continue;
                return this.colors[i];
            }
            return color;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,;");
        int n = stringTokenizer.countTokens();
        if (n < 3) {
            return color;
        }
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            try {
                Double d = new Double(stringTokenizer.nextToken());
                dArray[i] = d;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return color;
            }
        }
        if (dArray[0] < 0.0 || dArray[0] > 255.0 || dArray[1] < 0.0 || dArray[1] > 255.0 || dArray[2] < 0.0 || dArray[2] > 255.0) {
            return color;
        }
        return new Color((int)Math.round(dArray[0]), (int)Math.round(dArray[1]), (int)Math.round(dArray[2]));
    }
}

